/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.dsi.core.utilities.impl.future;

import com.cloudera.hiveserver1.dsi.core.utilities.future.IntervalConverter;
import com.cloudera.hiveserver1.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.cloudera.hiveserver1.dsi.core.utilities.impl.future.ArrayJDBCDataSourceAdapter;
import com.cloudera.hiveserver1.dsi.core.utilities.impl.future.BinaryJDBCDataSourceAdapter;
import com.cloudera.hiveserver1.dsi.core.utilities.impl.future.BitBooleanJDBCDataSourceAdapter;
import com.cloudera.hiveserver1.dsi.core.utilities.impl.future.DateJDBCDataSourceAdapter;
import com.cloudera.hiveserver1.dsi.core.utilities.impl.future.DecimalJDBCDataSourceAdapter;
import com.cloudera.hiveserver1.dsi.core.utilities.impl.future.DoubleJDBCDataSourceAdapter;
import com.cloudera.hiveserver1.dsi.core.utilities.impl.future.FloatJDBCDataSourceAdapter;
import com.cloudera.hiveserver1.dsi.core.utilities.impl.future.GuidJDBCDataSourceAdapter;
import com.cloudera.hiveserver1.dsi.core.utilities.impl.future.MonthSpanJDBCDataSourceAdapter;
import com.cloudera.hiveserver1.dsi.core.utilities.impl.future.SignedBigIntJDBCDataSourceAdapter;
import com.cloudera.hiveserver1.dsi.core.utilities.impl.future.SignedIntJDBCDataSourceAdapter;
import com.cloudera.hiveserver1.dsi.core.utilities.impl.future.SignedSmallIntJDBCDataSourceAdapter;
import com.cloudera.hiveserver1.dsi.core.utilities.impl.future.SignedTinyIntJDBCDataSourceAdapter;
import com.cloudera.hiveserver1.dsi.core.utilities.impl.future.StringJDBCDataSourceAdapter;
import com.cloudera.hiveserver1.dsi.core.utilities.impl.future.TimeJDBCDataSourceAdapter;
import com.cloudera.hiveserver1.dsi.core.utilities.impl.future.TimeSpanJDBCDataSourceAdapter;
import com.cloudera.hiveserver1.dsi.core.utilities.impl.future.TimestampJDBCDataSourceAdapter;
import com.cloudera.hiveserver1.dsi.core.utilities.impl.future.UnsignedBigIntJDBCDataSourceAdapter;
import com.cloudera.hiveserver1.dsi.core.utilities.impl.future.UnsignedIntJDBCDataSourceAdapter;
import com.cloudera.hiveserver1.dsi.core.utilities.impl.future.UnsignedSmallIntJDBCDataSourceAdapter;
import com.cloudera.hiveserver1.dsi.core.utilities.impl.future.UnsignedTinyIntJDBCDataSourceAdapter;
import com.cloudera.hiveserver1.dsi.dataengine.interfaces.IArray;
import com.cloudera.hiveserver1.dsi.dataengine.interfaces.future.IJDBCDataSource;
import com.cloudera.hiveserver1.dsi.dataengine.interfaces.future.IJDBCExecution;
import com.cloudera.hiveserver1.dsi.dataengine.interfaces.future.ISqlDataSource;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.DSIMonthSpan;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.DSITimeSpan;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.SqlTypeWrapper;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.hiveserver1.dsi.exceptions.ConversionFailed;
import com.cloudera.hiveserver1.dsi.exceptions.IncorrectTypeException;
import com.cloudera.hiveserver1.dsi.exceptions.future.UnsupportedException;
import com.cloudera.hiveserver1.support.IWarningListener;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.UUID;

public abstract class ConvertingJDBCDataSource
implements IJDBCDataSource {
    protected static final Charset s_asciiCharSet = Charset.forName("US-ASCII");
    protected static final Charset s_utf16CharSet = Charset.forName("UTF-16");
    private static final Map<Class<?>, Getter> s_objectGetterMap = new IdentityHashMap();
    private boolean m_wasNull = false;
    private final IWarningListener m_warningListener;
    private GregorianCalendar m_tempCalendar = null;
    private final NonTrivialJDBCConversions.SimpleListener m_listener = new NonTrivialJDBCConversions.SimpleListener();

    public static IJDBCDataSource wrapSqlDataSourceIfNecessary(ISqlDataSource iSqlDataSource, TypeMetadata typeMetadata, IWarningListener iWarningListener) throws UnsupportedException {
        if (iSqlDataSource == null) {
            throw null;
        }
        if (iSqlDataSource instanceof IJDBCDataSource) {
            return (IJDBCDataSource)iSqlDataSource;
        }
        switch (typeMetadata.getType()) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                return new StringJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
            }
            case 2003: {
                return new ArrayJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
            }
            case -4: 
            case -3: 
            case -2: {
                return new BinaryJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
            }
            case -7: 
            case 16: {
                return new BitBooleanJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
            }
            case -11: {
                return new GuidJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
            }
            case -6: {
                if (typeMetadata.isSigned()) {
                    return new SignedTinyIntJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
                }
                return new UnsignedTinyIntJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
            }
            case 91: {
                return new DateJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
            }
            case 92: {
                return new TimeJDBCDataSourceAdapter(iSqlDataSource, typeMetadata, iWarningListener);
            }
            case 93: {
                return new TimestampJDBCDataSourceAdapter(iSqlDataSource, typeMetadata, iWarningListener);
            }
            case -5: {
                if (typeMetadata.isSigned()) {
                    return new SignedBigIntJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
                }
                return new UnsignedBigIntJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
            }
            case 6: 
            case 8: {
                return new DoubleJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
            }
            case 7: {
                return new FloatJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
            }
            case 5: {
                if (typeMetadata.isSigned()) {
                    return new SignedSmallIntJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
                }
                return new UnsignedSmallIntJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
            }
            case 4: {
                if (typeMetadata.isSigned()) {
                    return new SignedIntJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
                }
                return new UnsignedIntJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
            }
            case 2: 
            case 3: {
                return new DecimalJDBCDataSourceAdapter(iSqlDataSource, iWarningListener);
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return new TimeSpanJDBCDataSourceAdapter(iSqlDataSource, typeMetadata, iWarningListener);
            }
            case 101: 
            case 102: 
            case 107: {
                return new MonthSpanJDBCDataSourceAdapter(iSqlDataSource, typeMetadata, iWarningListener);
            }
        }
        throw new UnsupportedException();
    }

    public ConvertingJDBCDataSource(IWarningListener iWarningListener) {
        if (iWarningListener == null) {
            throw null;
        }
        this.m_warningListener = iWarningListener;
    }

    protected final IWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    protected final GregorianCalendar getLocalCalendarForConversions() {
        if (this.m_tempCalendar == null) {
            this.m_tempCalendar = new GregorianCalendar();
        }
        return this.m_tempCalendar;
    }

    protected final NonTrivialJDBCConversions.SimpleListener getListener() {
        return this.m_listener;
    }

    protected final NonTrivialJDBCConversions.SimpleListener getAndClearListener() {
        this.m_listener.clearStatus();
        return this.m_listener;
    }

    protected void onOverflow(Object object, String string) throws ConversionFailed {
    }

    protected void onFractionalTruncation(Object object, int n, String string) {
    }

    protected final void setWasNull(boolean bl) {
        this.m_wasNull = bl;
    }

    protected final <T> T returnObject(T t) {
        this.setWasNull(t == null);
        return t;
    }

    protected Integer getSqlTypeFromRegistration(IJDBCExecution.OutputParameterRegistration outputParameterRegistration) {
        if (outputParameterRegistration.getSqlType() instanceof Integer) {
            return (Integer)outputParameterRegistration.getSqlType();
        }
        SqlTypeWrapper sqlTypeWrapper = new SqlTypeWrapper(outputParameterRegistration.getSqlType());
        if (sqlTypeWrapper.getVendor().equals("com.cloudera.jdbc.jdbc42.utilities")) {
            return sqlTypeWrapper.getVendorTypeNumber();
        }
        return null;
    }

    protected final boolean isCharType(int n) {
        switch (n) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    protected final boolean isBinaryType(int n) {
        switch (n) {
            case -4: 
            case -3: 
            case -2: {
                return true;
            }
        }
        return false;
    }

    protected final boolean isNumericType(int n) {
        switch (n) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    protected boolean registeredTypeIsSupported(IJDBCExecution.OutputParameterRegistration outputParameterRegistration) {
        Integer n = this.getSqlTypeFromRegistration(outputParameterRegistration);
        if (n == null) {
            return false;
        }
        switch (n) {
            case -11: 
            case -7: 
            case 16: 
            case 91: 
            case 92: 
            case 93: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 1111: 
            case 2000: 
            case 2003: {
                return true;
            }
        }
        return this.isCharType(n) || this.isBinaryType(n) || this.isNumericType(n);
    }

    public IJDBCExecution.RegistrationResult supportsRegistration(IJDBCExecution.OutputParameterRegistration outputParameterRegistration) {
        if (!this.registeredTypeIsSupported(outputParameterRegistration)) {
            return IJDBCExecution.RegistrationResult.REGISTERED_TYPE_NOT_SUPPORTED;
        }
        if (!this.supportsConversionToRegisteredType(outputParameterRegistration)) {
            return IJDBCExecution.RegistrationResult.CONVERSION_TO_REGISTERED_TYPE_NOT_SUPPORTED;
        }
        return IJDBCExecution.RegistrationResult.REGISTRATION_SUCEEDED;
    }

    protected abstract boolean supportsConversionToRegisteredType(IJDBCExecution.OutputParameterRegistration var1);

    @Override
    public Reader getAsReader() throws IncorrectTypeException, ConversionFailed, ErrorException {
        throw new IncorrectTypeException();
    }

    @Override
    public InputStream getAsInputStream() throws IncorrectTypeException, ConversionFailed, ErrorException {
        throw new IncorrectTypeException();
    }

    @Override
    public boolean wasNull() throws ErrorException, SQLException {
        return this.m_wasNull;
    }

    @Override
    public String getString() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        throw new IncorrectTypeException();
    }

    @Override
    public boolean getBoolean() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        throw new IncorrectTypeException();
    }

    @Override
    public byte getByte() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        throw new IncorrectTypeException();
    }

    @Override
    public short getShort() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        throw new IncorrectTypeException();
    }

    @Override
    public int getInt() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        throw new IncorrectTypeException();
    }

    @Override
    public long getLong() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        throw new IncorrectTypeException();
    }

    @Override
    public float getFloat() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        throw new IncorrectTypeException();
    }

    @Override
    public double getDouble() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        throw new IncorrectTypeException();
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        BigDecimal bigDecimal = this.getBigDecimal();
        if (bigDecimal == null) {
            return null;
        }
        BigDecimal bigDecimal2 = bigDecimal.setScale(n, RoundingMode.DOWN);
        if (!bigDecimal2.equals(bigDecimal)) {
            this.onFractionalTruncation(bigDecimal, n, "getBigDecimal");
        }
        return bigDecimal2;
    }

    @Override
    public byte[] getBytes() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        throw new IncorrectTypeException();
    }

    @Override
    public Date getDate() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        return this.getDate(this.getLocalCalendarForConversions());
    }

    @Override
    public Time getTime() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        return this.getTime(this.getLocalCalendarForConversions());
    }

    @Override
    public Timestamp getTimestamp() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        return this.getTimestamp(this.getLocalCalendarForConversions());
    }

    @Override
    public InputStream getAsciiStream() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException, UnsupportedException {
        Reader reader = this.getAsReader();
        if (reader == null) {
            return null;
        }
        return new ReaderInputStream(reader, s_asciiCharSet);
    }

    @Override
    public InputStream getUnicodeStream() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException, UnsupportedException {
        Reader reader = this.getAsReader();
        if (reader == null) {
            return null;
        }
        return new ReaderInputStream(reader, s_utf16CharSet);
    }

    @Override
    public InputStream getBinaryStream() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException, UnsupportedException {
        return this.getAsInputStream();
    }

    @Override
    public Object getObject() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        return this.get();
    }

    @Override
    public Reader getCharacterStream() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException, UnsupportedException {
        return this.getAsReader();
    }

    @Override
    public BigDecimal getBigDecimal() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        throw new IncorrectTypeException();
    }

    @Override
    public Object getObject(Map<String, Class<?>> map) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public Ref getRef() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public Blob getBlob() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public Clob getClob() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public IArray getArray() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public Date getDate(Calendar calendar) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        throw new IncorrectTypeException();
    }

    @Override
    public Time getTime(Calendar calendar) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        throw new IncorrectTypeException();
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        throw new IncorrectTypeException();
    }

    @Override
    public URL getURL() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public RowId getRowId() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public NClob getNClob() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public SQLXML getSQLXML() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public String getNString() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public Reader getNCharacterStream() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    protected BigInteger getBigInt() throws IncorrectTypeException, ConversionFailed, ErrorException, SQLException {
        Object object = this.getObject();
        assert (object == null == this.wasNull());
        if (this.wasNull()) {
            return null;
        }
        Number number = NonTrivialJDBCConversions.objectToBigInt(object, this.getAndClearListener());
        BigInteger bigInteger = number instanceof Long ? BigInteger.valueOf((Long)number) : (BigInteger)number;
        switch (this.m_listener.getStatus()) {
            case SUCCESS: {
                break;
            }
            case FRACTIONAL_TRUNCATION: {
                this.onFractionalTruncation(object, 0, "getObject");
                break;
            }
            case OVERFLOW: {
                this.onOverflow(object, "getObject");
            }
        }
        return bigInteger;
    }

    @Override
    public <T> T getObject(Class<T> clazz) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException, UnsupportedException {
        assert (clazz != null);
        Getter getter = s_objectGetterMap.get(clazz);
        if (getter == null) {
            throw new UnsupportedException(clazz.getName());
        }
        return clazz.cast(getter.get(this));
    }

    static {
        s_objectGetterMap.put(Boolean.class, new Getter(){

            @Override
            public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
                boolean bl = convertingJDBCDataSource.getBoolean();
                return convertingJDBCDataSource.wasNull() ? null : Boolean.valueOf(bl);
            }
        });
        s_objectGetterMap.put(Boolean.TYPE, s_objectGetterMap.get(Boolean.class));
        s_objectGetterMap.put(Byte.class, new Getter(){

            @Override
            public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
                byte by = convertingJDBCDataSource.getByte();
                return convertingJDBCDataSource.wasNull() ? null : Byte.valueOf(by);
            }
        });
        s_objectGetterMap.put(Byte.TYPE, s_objectGetterMap.get(Byte.class));
        s_objectGetterMap.put(Short.class, new Getter(){

            @Override
            public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
                short s = convertingJDBCDataSource.getShort();
                return convertingJDBCDataSource.wasNull() ? null : Short.valueOf(s);
            }
        });
        s_objectGetterMap.put(Short.TYPE, s_objectGetterMap.get(Short.class));
        s_objectGetterMap.put(Integer.class, new Getter(){

            @Override
            public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
                int n = convertingJDBCDataSource.getInt();
                return convertingJDBCDataSource.wasNull() ? null : Integer.valueOf(n);
            }
        });
        s_objectGetterMap.put(Integer.TYPE, s_objectGetterMap.get(Integer.class));
        s_objectGetterMap.put(Long.class, new Getter(){

            @Override
            public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
                long l = convertingJDBCDataSource.getLong();
                return convertingJDBCDataSource.wasNull() ? null : Long.valueOf(l);
            }
        });
        s_objectGetterMap.put(Long.TYPE, s_objectGetterMap.get(Long.class));
        s_objectGetterMap.put(Float.class, new Getter(){

            @Override
            public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
                float f = convertingJDBCDataSource.getFloat();
                return convertingJDBCDataSource.wasNull() ? null : Float.valueOf(f);
            }
        });
        s_objectGetterMap.put(Float.TYPE, s_objectGetterMap.get(Float.class));
        s_objectGetterMap.put(Double.class, new Getter(){

            @Override
            public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
                double d = convertingJDBCDataSource.getDouble();
                return convertingJDBCDataSource.wasNull() ? null : Double.valueOf(d);
            }
        });
        s_objectGetterMap.put(Double.TYPE, s_objectGetterMap.get(Double.class));
        s_objectGetterMap.put(BigInteger.class, new Getter(){

            @Override
            public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
                return convertingJDBCDataSource.getBigDecimal().toBigInteger();
            }
        });
        s_objectGetterMap.put(BigDecimal.class, new Getter(){

            @Override
            public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
                return convertingJDBCDataSource.getBigDecimal();
            }
        });
        s_objectGetterMap.put(byte[].class, new Getter(){

            @Override
            public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
                return convertingJDBCDataSource.getBytes();
            }
        });
        s_objectGetterMap.put(String.class, new Getter(){

            @Override
            public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
                return convertingJDBCDataSource.getString();
            }
        });
        s_objectGetterMap.put(Date.class, new Getter(){

            @Override
            public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
                return convertingJDBCDataSource.getDate();
            }
        });
        s_objectGetterMap.put(Time.class, new Getter(){

            @Override
            public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
                return convertingJDBCDataSource.getTime();
            }
        });
        s_objectGetterMap.put(Timestamp.class, new Getter(){

            @Override
            public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
                return convertingJDBCDataSource.getTimestamp();
            }
        });
        s_objectGetterMap.put(Object.class, new Getter(){

            @Override
            public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
                return convertingJDBCDataSource.getObject();
            }
        });
        s_objectGetterMap.put(Array.class, new Getter(){

            @Override
            public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, UnsupportedException, SQLException {
                return convertingJDBCDataSource.getArray();
            }
        });
        s_objectGetterMap.put(Blob.class, new Getter(){

            @Override
            public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, UnsupportedException, SQLException {
                return convertingJDBCDataSource.getBlob();
            }
        });
        s_objectGetterMap.put(Clob.class, new Getter(){

            @Override
            public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, UnsupportedException, SQLException {
                return convertingJDBCDataSource.getClob();
            }
        });
        s_objectGetterMap.put(Array.class, new Getter(){

            @Override
            public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, UnsupportedException, SQLException {
                return convertingJDBCDataSource.getArray();
            }
        });
        s_objectGetterMap.put(Ref.class, new Getter(){

            @Override
            public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, UnsupportedException, SQLException {
                return convertingJDBCDataSource.getRef();
            }
        });
        s_objectGetterMap.put(URL.class, new Getter(){

            @Override
            public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, UnsupportedException, SQLException {
                return convertingJDBCDataSource.getURL();
            }
        });
        s_objectGetterMap.put(NClob.class, new Getter(){

            @Override
            public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, UnsupportedException, SQLException {
                return convertingJDBCDataSource.getNClob();
            }
        });
        s_objectGetterMap.put(RowId.class, new Getter(){

            @Override
            public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, UnsupportedException, SQLException {
                return convertingJDBCDataSource.getRowId();
            }
        });
        s_objectGetterMap.put(SQLXML.class, new Getter(){

            @Override
            public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, UnsupportedException, SQLException {
                return convertingJDBCDataSource.getSQLXML();
            }
        });
        try {
            final Class<?> clazz = Class.forName("java.time.ZoneId");
            final Class<?> clazz2 = Class.forName("java.time.Instant");
            Class<?> clazz3 = Class.forName("java.time.LocalDate");
            Class<?> clazz4 = Class.forName("java.time.LocalTime");
            Class<?> clazz5 = Class.forName("java.time.LocalDateTime");
            final Class<?> clazz6 = Class.forName("java.time.OffsetDateTime");
            Class<?> clazz7 = Class.forName("java.time.ZonedDateTime");
            s_objectGetterMap.put(clazz2, new Getter(){
                final Method m_toInstant = Timestamp.class.getDeclaredMethod("toInstant", new Class[0]);

                @Override
                public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, UnsupportedException, SQLException {
                    Timestamp timestamp = convertingJDBCDataSource.getTimestamp();
                    try {
                        return timestamp == null ? null : this.m_toInstant.invoke((Object)timestamp, new Object[0]);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
            });
            s_objectGetterMap.put(clazz3, new Getter(){
                final Method m_toLocalDate = Date.class.getDeclaredMethod("toLocalDate", new Class[0]);

                @Override
                public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, UnsupportedException, SQLException {
                    Date date = convertingJDBCDataSource.getDate();
                    try {
                        return date == null ? null : this.m_toLocalDate.invoke((Object)date, new Object[0]);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
            });
            s_objectGetterMap.put(clazz4, new Getter(){
                private final Method m_toLocalTime = Time.class.getDeclaredMethod("toLocalTime", new Class[0]);

                @Override
                public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, UnsupportedException, SQLException {
                    Time time = convertingJDBCDataSource.getTime();
                    try {
                        return time == null ? null : this.m_toLocalTime.invoke((Object)time, new Object[0]);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
            });
            s_objectGetterMap.put(clazz5, new Getter(){
                final Method m_toLocalDateTime = Timestamp.class.getDeclaredMethod("toLocalDateTime", new Class[0]);

                @Override
                public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, UnsupportedException, SQLException {
                    Timestamp timestamp = convertingJDBCDataSource.getTimestamp();
                    try {
                        return timestamp == null ? null : this.m_toLocalDateTime.invoke((Object)timestamp, new Object[0]);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
            });
            final Getter getter = s_objectGetterMap.get(clazz2);
            final Object object = clazz.getDeclaredMethod("of", String.class).invoke(null, "UTC");
            s_objectGetterMap.put(clazz6, new Getter(){
                private final Method m_ofInstant;
                {
                    this.m_ofInstant = clazz6.getDeclaredMethod("ofInstant", clazz2, clazz);
                }

                @Override
                public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, UnsupportedException, SQLException {
                    Object object2 = getter.get(convertingJDBCDataSource);
                    try {
                        return object2 == null ? null : this.m_ofInstant.invoke(null, object2, object);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
            });
            s_objectGetterMap.put(clazz7, new Getter(){
                private final Method m_atZone;
                {
                    this.m_atZone = clazz2.getDeclaredMethod("atZone", clazz);
                }

                @Override
                public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, UnsupportedException, SQLException {
                    Object object2 = getter.get(convertingJDBCDataSource);
                    try {
                        return object2 == null ? null : this.m_atZone.invoke(object2, object);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof RuntimeException) {
                throw (RuntimeException)invocationTargetException.getCause();
            }
            throw new RuntimeException(invocationTargetException.getCause());
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        s_objectGetterMap.put(UUID.class, new Getter(){

            @Override
            public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
                Object object = convertingJDBCDataSource.getObject();
                return object == null ? null : NonTrivialJDBCConversions.objectToGUID(object);
            }
        });
        s_objectGetterMap.put(DSIMonthSpan.class, new Getter(){
            private final IntervalConverter m_intervalConverter = new IntervalConverter(false);

            @Override
            public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
                Object object = convertingJDBCDataSource.getObject();
                return object == null ? null : NonTrivialJDBCConversions.objectToMonthSpan(object, 107, this.m_intervalConverter, convertingJDBCDataSource.getWarningListener(), convertingJDBCDataSource.getAndClearListener());
            }
        });
        s_objectGetterMap.put(DSITimeSpan.class, new Getter(){
            private final IntervalConverter m_intervalConverter = new IntervalConverter(false);

            @Override
            public Object get(ConvertingJDBCDataSource convertingJDBCDataSource) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
                Object object = convertingJDBCDataSource.getObject();
                return object == null ? null : NonTrivialJDBCConversions.objectToTimeSpan(object, 110, this.m_intervalConverter, convertingJDBCDataSource.getWarningListener(), convertingJDBCDataSource.getAndClearListener());
            }
        });
    }

    public static class ReaderInputStream
    extends InputStream {
        private Reader m_wrapped;
        private final ByteBuffer m_byteBuf = ByteBuffer.allocate(1024);
        private final CharBuffer m_charBuf = CharBuffer.allocate(512);
        private final CharsetEncoder m_encoder;
        private boolean m_readerHasMore = true;
        private boolean m_decoderFinished = false;

        public ReaderInputStream(Reader reader, Charset charset) {
            if (reader == null) {
                throw null;
            }
            this.m_wrapped = reader;
            this.m_encoder = charset.newEncoder();
            this.m_byteBuf.flip();
            this.m_charBuf.flip();
            if (s_utf16CharSet.equals(charset)) {
                try {
                    this.getMoreConvertedData();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                if (this.m_byteBuf.remaining() >= 2) {
                    byte by = this.m_byteBuf.get(this.m_byteBuf.position());
                    byte by2 = this.m_byteBuf.get(this.m_byteBuf.position() + 1);
                    if (by == -1 && by2 == -2 || by == -2 && by2 == -1) {
                        this.m_byteBuf.position(this.m_byteBuf.position() + 2);
                    }
                }
            }
        }

        private void checkIfClosed() throws IOException {
            if (this.m_wrapped == null) {
                throw new IOException("Stream is closed!");
            }
        }

        private void getMoreConvertedData() throws IOException {
            assert (!this.m_byteBuf.hasRemaining());
            if (this.m_decoderFinished) {
                return;
            }
            if (!this.m_charBuf.hasRemaining() && this.m_readerHasMore) {
                this.m_charBuf.limit(this.m_charBuf.capacity());
                this.m_charBuf.rewind();
                if (-1 == this.m_wrapped.read(this.m_charBuf)) {
                    this.m_readerHasMore = false;
                }
                this.m_charBuf.flip();
            }
            this.m_byteBuf.limit(this.m_byteBuf.capacity());
            this.m_byteBuf.rewind();
            CoderResult coderResult = this.m_encoder.encode(this.m_charBuf, this.m_byteBuf, !this.m_readerHasMore);
            if (coderResult.isError()) {
                coderResult.throwException();
            }
            this.m_byteBuf.flip();
            if (!this.m_charBuf.hasRemaining() && !this.m_readerHasMore) {
                this.m_encoder.flush(this.m_byteBuf);
                this.m_decoderFinished = true;
            }
        }

        private int byteToInt(byte n) {
            return n >= 0 ? n : n + 256;
        }

        private boolean hasMoreToReturn() throws IOException {
            if (!this.m_byteBuf.hasRemaining()) {
                this.getMoreConvertedData();
                if (!this.m_byteBuf.hasRemaining()) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public int read() throws IOException {
            this.checkIfClosed();
            if (!this.hasMoreToReturn()) {
                return -1;
            }
            return this.byteToInt(this.m_byteBuf.get());
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            assert (byArray != null);
            assert (n >= 0);
            assert (n2 >= 0);
            assert (n + n2 <= byArray.length);
            this.checkIfClosed();
            if (n2 == 0) {
                return 0;
            }
            if (!this.hasMoreToReturn()) {
                return -1;
            }
            int n3 = Math.min(this.m_byteBuf.remaining(), n2);
            this.m_byteBuf.get(byArray, n, n3);
            return n3;
        }

        @Override
        public void close() throws IOException {
            if (this.m_wrapped != null) {
                this.m_wrapped.close();
                this.m_wrapped = null;
            }
        }
    }

    public static interface Getter {
        public Object get(ConvertingJDBCDataSource var1) throws ErrorException, IncorrectTypeException, ConversionFailed, UnsupportedException, SQLException;
    }
}

