/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.dsi.core.utilities.impl.future;

import com.cloudera.hiveserver1.dsi.core.utilities.future.IntervalConverter;
import com.cloudera.hiveserver1.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.cloudera.hiveserver1.dsi.core.utilities.impl.future.ConvertingJDBCDataSource;
import com.cloudera.hiveserver1.dsi.dataengine.interfaces.future.IJDBCExecution;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.DSITimeSpan;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.hiveserver1.dsi.exceptions.ConversionFailed;
import com.cloudera.hiveserver1.dsi.exceptions.IncorrectTypeException;
import com.cloudera.hiveserver1.support.IWarningListener;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.sql.SQLException;

public abstract class TimeSpanJDBCDataSource
extends ConvertingJDBCDataSource {
    private final int m_sqlType;
    private final int m_leadingFieldPrecision;
    private final int m_fractionalSecondsPrecision;

    public TimeSpanJDBCDataSource(IWarningListener iWarningListener, TypeMetadata typeMetadata) {
        super(iWarningListener);
        this.m_sqlType = typeMetadata.getType();
        switch (this.m_sqlType) {
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected SQL type " + this.m_sqlType);
            }
        }
        this.m_leadingFieldPrecision = typeMetadata.getIntervalPrecision();
        assert (this.m_leadingFieldPrecision > 0);
        assert (this.m_leadingFieldPrecision <= 9);
        this.m_fractionalSecondsPrecision = typeMetadata.getPrecision();
        assert (this.m_fractionalSecondsPrecision >= 0);
        assert (this.m_fractionalSecondsPrecision <= 9);
    }

    protected final int getSqlType() {
        return this.m_sqlType;
    }

    protected final int getLeadingFieldPrecision() {
        return this.m_leadingFieldPrecision;
    }

    protected final int getFractionalSecondsPrecision() {
        return this.m_fractionalSecondsPrecision;
    }

    protected IntervalConverter getIntervalConverter() {
        return IntervalConverter.INSTANCE;
    }

    @Override
    public abstract DSITimeSpan get() throws ErrorException;

    @Override
    public String getString() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        DSITimeSpan dSITimeSpan = this.get();
        if (dSITimeSpan == null) {
            return null;
        }
        return NonTrivialJDBCConversions.timeSpanToString(dSITimeSpan, this.m_sqlType, this.getIntervalConverter(), this.m_leadingFieldPrecision, this.m_fractionalSecondsPrecision);
    }

    @Override
    protected boolean supportsConversionToRegisteredType(IJDBCExecution.OutputParameterRegistration outputParameterRegistration) {
        int n = this.getSqlTypeFromRegistration(outputParameterRegistration);
        switch (n) {
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 2000: {
                return true;
            }
        }
        return this.isCharType(n);
    }
}

