/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.hivecommon.api;

import com.cloudera.hive.jdbc42.internal.apache.http.client.CookieStore;
import com.cloudera.hive.jdbc42.internal.apache.http.impl.client.BasicCookieStore;
import com.cloudera.hive.jdbc42.internal.apache.thrift.protocol.TBinaryProtocol;
import com.cloudera.hive.jdbc42.internal.apache.thrift.protocol.TProtocol;
import com.cloudera.hive.jdbc42.internal.apache.thrift.transport.TTransport;
import com.cloudera.hiveserver1.hivecommon.AuthMech;
import com.cloudera.hiveserver1.hivecommon.HiveJDBCSettings;
import com.cloudera.hiveserver1.hivecommon.api.HS2Client;
import com.cloudera.hiveserver1.hivecommon.api.HS2ClientWrapper;
import com.cloudera.hiveserver1.hivecommon.api.HiveMultiSocketFetchClientContext;
import com.cloudera.hiveserver1.hivecommon.api.HiveMultiSocketFetchContext;
import com.cloudera.hiveserver1.hivecommon.api.HiveMultiSocketFetchHandler;
import com.cloudera.hiveserver1.hivecommon.api.HiveOperationContext;
import com.cloudera.hiveserver1.hivecommon.api.HiveServer2BaseBuffer;
import com.cloudera.hiveserver1.hivecommon.api.HiveServer2ClientFactory;
import com.cloudera.hiveserver1.hivecommon.api.RowsetBuffer;
import com.cloudera.hiveserver1.hivecommon.api.TETHttpClient;
import com.cloudera.hiveserver1.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hiveserver1.hivecommon.core.ThreadPoolExecutorExt;
import com.cloudera.hiveserver1.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.hiveserver1.hivecommon.utils.HiveHS2ClientUtils;
import com.cloudera.hiveserver1.support.ILogger;
import com.cloudera.hiveserver1.support.IWarningListener;
import com.cloudera.hiveserver1.support.LogUtilities;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;

public class HS2MultiSocketFetchClient
extends HS2Client {
    private ExecutorService m_threadPool;
    private HiveMultiSocketFetchClientContext m_clientCtx;
    private final long THREAD_POOL_TERMINATION_TIMEOUT_SECONDS = 60L;
    private final int INITIAL_NUM_FETCH_REQUESTS = 2;

    public HS2MultiSocketFetchClient(HiveJDBCSettings hiveJDBCSettings, TProtocol tProtocol, ILogger iLogger, IWarningListener iWarningListener) throws ErrorException {
        super(hiveJDBCSettings, tProtocol, iLogger, iWarningListener);
        if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        }
        this.m_clientCtx = new HiveMultiSocketFetchClientContext();
        this.m_threadPool = new ThreadPoolExecutorExt(0, Integer.MAX_VALUE, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleFetchResultsRequest(RowsetBuffer<HiveServer2BaseBuffer> rowsetBuffer, HiveOperationContext hiveOperationContext) throws Throwable {
        HiveMultiSocketFetchContext hiveMultiSocketFetchContext;
        Object object;
        if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        }
        HiveMultiSocketFetchContext hiveMultiSocketFetchContext2 = hiveOperationContext.m_multiSocketFetchCtx;
        if (this.attemptToSubmitMoreFetchRequests(hiveOperationContext)) {
            this.assignBuffer(rowsetBuffer, hiveMultiSocketFetchContext2.m_hs2BufferWithError);
            return;
        }
        Object object2 = this.m_clientCtx;
        synchronized (object2) {
            HiveMultiSocketFetchContext hiveMultiSocketFetchContext3 = hiveMultiSocketFetchContext2;
            synchronized (hiveMultiSocketFetchContext3) {
                if (hiveMultiSocketFetchContext2.m_orderedRowset.isEmpty()) {
                    if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                        LogUtilities.logDebug("The row set cache is currently empty.", this.m_logger);
                        HiveHS2ClientUtils.logOperationHandle(hiveOperationContext, this.m_logger);
                    }
                    if (0 == hiveMultiSocketFetchContext2.m_numPendingFetchRequests) {
                        if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                            LogUtilities.logDebug("There are no more pending fetch requests.", this.m_logger);
                            HiveHS2ClientUtils.logOperationHandle(hiveOperationContext, this.m_logger);
                        }
                        if (null != hiveMultiSocketFetchContext2.m_lastRowset) {
                            if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                                LogUtilities.logDebug("The end of the result set has been reached. Returning the last row set.", this.m_logger);
                                HiveHS2ClientUtils.logOperationHandle(hiveOperationContext, this.m_logger);
                            }
                            this.assignBuffer(rowsetBuffer, hiveMultiSocketFetchContext2.m_lastRowset);
                            return;
                        }
                        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), "There are no more pending fetch requests, but the last row set has not been reached.");
                        if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                            LogUtilities.logError(errorException, this.m_logger);
                            HiveHS2ClientUtils.logOperationHandle(hiveOperationContext, this.m_logger);
                        }
                        if (null == hiveMultiSocketFetchContext2.m_fetchException) {
                            hiveMultiSocketFetchContext2.m_fetchException = errorException;
                        }
                        this.m_clientCtx.removeAllTasks(hiveOperationContext);
                        throw errorException;
                    }
                }
            }
        }
        object2 = null;
        boolean bl = true;
        int n = this.m_settings.m_numMultiSocketFetchConsumerAttemptsBeforeBackOff;
        long l = 0L;
        boolean bl2 = true;
        while (bl) {
            if (bl2) {
                bl2 = false;
            } else if (0 < this.m_settings.m_maxMultiSocketFetchConsumerWaitTimeMS) {
                if (0 < n) {
                    --n;
                } else {
                    if (0L == l) {
                        l = 1L;
                    } else if (l > (long)this.m_settings.m_maxMultiSocketFetchConsumerWaitTimeMS) {
                        l = this.m_settings.m_maxMultiSocketFetchConsumerWaitTimeMS;
                    } else if (l < (long)this.m_settings.m_maxMultiSocketFetchConsumerWaitTimeMS && (l *= 2L) > (long)this.m_settings.m_maxMultiSocketFetchConsumerWaitTimeMS) {
                        l = this.m_settings.m_maxMultiSocketFetchConsumerWaitTimeMS;
                    }
                    Thread.sleep(l);
                }
            }
            if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                LogUtilities.logDebug("Started waiting for one or more pending fetch requests to complete.", this.m_logger);
                HiveHS2ClientUtils.logOperationHandle(hiveOperationContext, this.m_logger);
            }
            object = this.m_clientCtx;
            synchronized (object) {
                hiveMultiSocketFetchContext = hiveMultiSocketFetchContext2;
                synchronized (hiveMultiSocketFetchContext) {
                    if (this.handleFetchError(hiveMultiSocketFetchContext2)) {
                        this.assignBuffer(rowsetBuffer, hiveMultiSocketFetchContext2.m_hs2BufferWithError);
                        return;
                    }
                    if (hiveMultiSocketFetchContext2.m_orderedRowset.isEmpty()) {
                        if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                            LogUtilities.logDebug("The row set cache is currently empty.", this.m_logger);
                            HiveHS2ClientUtils.logOperationHandle(hiveOperationContext, this.m_logger);
                        }
                        if (0 == hiveMultiSocketFetchContext2.m_numPendingFetchRequests) {
                            if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                                LogUtilities.logDebug("There are no more pending fetch requests.", this.m_logger);
                            }
                            if (null != hiveMultiSocketFetchContext2.m_lastRowset) {
                                if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                                    LogUtilities.logDebug("The end of the result set has been reached. Returning the last row set.", this.m_logger);
                                    HiveHS2ClientUtils.logOperationHandle(hiveOperationContext, this.m_logger);
                                }
                                this.assignBuffer(rowsetBuffer, hiveMultiSocketFetchContext2.m_lastRowset);
                                return;
                            }
                            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), "There are no more pending fetch requests, but the last row set has not been reached.");
                            if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                                LogUtilities.logError(errorException, this.m_logger);
                                HiveHS2ClientUtils.logOperationHandle(hiveOperationContext, this.m_logger);
                            }
                            if (null == hiveMultiSocketFetchContext2.m_fetchException) {
                                hiveMultiSocketFetchContext2.m_fetchException = errorException;
                            }
                            this.m_clientCtx.removeAllTasks(hiveOperationContext);
                            throw errorException;
                        }
                        if (hiveMultiSocketFetchContext2.m_numPendingFetchRequests > 0) {
                            if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                                LogUtilities.logDebug("Will wait for more results to be fetched. Pending requests: " + String.valueOf(hiveMultiSocketFetchContext2.m_numPendingFetchRequests), this.m_logger);
                                HiveHS2ClientUtils.logOperationHandle(hiveOperationContext, this.m_logger);
                            }
                            continue;
                        }
                        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), "Pending requests is less than zero.");
                        if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                            LogUtilities.logError(errorException, this.m_logger);
                            HiveHS2ClientUtils.logOperationHandle(hiveOperationContext, this.m_logger);
                        }
                        if (null == hiveMultiSocketFetchContext2.m_fetchException) {
                            hiveMultiSocketFetchContext2.m_fetchException = errorException;
                        }
                        this.m_clientCtx.removeAllTasks(hiveOperationContext);
                        throw errorException;
                    }
                    if (hiveMultiSocketFetchContext2.m_nextStartRowOffset == hiveMultiSocketFetchContext2.m_orderedRowset.get(0).getHiveServer2Buffer().getResults().getStartRowOffset()) {
                        object2 = hiveMultiSocketFetchContext2.m_orderedRowset.remove(0);
                        hiveMultiSocketFetchContext2.m_nextStartRowOffset += (long)HiveHS2ClientUtils.getNumRows(((HiveServer2BaseBuffer)object2).getHiveServer2Buffer().getResults(), this.m_logger);
                        bl = false;
                        if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                            LogUtilities.logDebug("The next row set has been retreived and will be returned." + String.valueOf(hiveMultiSocketFetchContext2.m_numPendingFetchRequests), this.m_logger);
                            HiveHS2ClientUtils.logOperationHandle(hiveOperationContext, this.m_logger);
                        }
                    } else {
                        if (0 == hiveMultiSocketFetchContext2.m_numPendingFetchRequests) {
                            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), "There are no more pending fetch requests, but the next row set has not been reached.");
                            if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                                LogUtilities.logError(errorException, this.m_logger);
                                HiveHS2ClientUtils.logOperationHandle(hiveOperationContext, this.m_logger);
                            }
                            if (null == hiveMultiSocketFetchContext2.m_fetchException) {
                                hiveMultiSocketFetchContext2.m_fetchException = errorException;
                            }
                            this.m_clientCtx.removeAllTasks(hiveOperationContext);
                            throw errorException;
                        }
                        if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                            LogUtilities.logDebug("Will wait for the next row to be fetched. Pending requests: " + String.valueOf(hiveMultiSocketFetchContext2.m_numPendingFetchRequests), this.m_logger);
                            HiveHS2ClientUtils.logOperationHandle(hiveOperationContext, this.m_logger);
                        }
                    }
                }
            }
        }
        if (null == object2) {
            object = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), "There should have been a TFetchResultsResp, but none is available.");
            if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                LogUtilities.logError((ErrorException)object, this.m_logger);
                HiveHS2ClientUtils.logOperationHandle(hiveOperationContext, this.m_logger);
            }
            hiveMultiSocketFetchContext = hiveMultiSocketFetchContext2;
            synchronized (hiveMultiSocketFetchContext) {
                if (null == hiveMultiSocketFetchContext2.m_fetchException) {
                    hiveMultiSocketFetchContext2.m_fetchException = object;
                }
            }
            this.m_clientCtx.removeAllTasks(hiveOperationContext);
            throw object;
        }
        if (this.attemptToSubmitMoreFetchRequests(hiveOperationContext)) {
            this.assignBuffer(rowsetBuffer, hiveMultiSocketFetchContext2.m_hs2BufferWithError);
            return;
        }
        this.assignBuffer(rowsetBuffer, (HiveServer2BaseBuffer)object2);
    }

    private boolean handleFetchError(HiveMultiSocketFetchContext hiveMultiSocketFetchContext) throws Throwable {
        if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        }
        if (null != hiveMultiSocketFetchContext.m_fetchException) {
            throw hiveMultiSocketFetchContext.m_fetchException;
        }
        return null != hiveMultiSocketFetchContext.m_hs2BufferWithError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean attemptToSubmitMoreFetchRequests(HiveOperationContext hiveOperationContext) throws Throwable {
        if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        }
        HiveMultiSocketFetchClientContext hiveMultiSocketFetchClientContext = this.m_clientCtx;
        synchronized (hiveMultiSocketFetchClientContext) {
            HiveMultiSocketFetchContext hiveMultiSocketFetchContext;
            HiveMultiSocketFetchContext hiveMultiSocketFetchContext2 = hiveMultiSocketFetchContext = hiveOperationContext.m_multiSocketFetchCtx;
            synchronized (hiveMultiSocketFetchContext2) {
                if (this.handleFetchError(hiveMultiSocketFetchContext)) {
                    return true;
                }
                if (null == hiveMultiSocketFetchContext.m_lastRowset) {
                    int n;
                    int n2;
                    int n3 = this.m_settings.m_maxNumMultiSocketFetchRowsetPerOperation - hiveMultiSocketFetchContext.m_numPendingFetchRequests - hiveMultiSocketFetchContext.m_orderedRowset.size();
                    if (0 > n3) {
                        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), "Number of fetch tasks to request is negative.");
                        if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                            LogUtilities.logError(errorException, this.m_logger);
                            HiveHS2ClientUtils.logOperationHandle(hiveOperationContext, this.m_logger);
                        }
                        this.m_clientCtx.removeAllTasks(hiveOperationContext);
                        throw errorException;
                    }
                    if (!hiveMultiSocketFetchContext.m_isFirstFetchRequestSent) {
                        n3 = Math.min(2, n3);
                        hiveMultiSocketFetchContext.m_isFirstFetchRequestSent = true;
                    }
                    if (0 > (n2 = Math.min(n3, this.m_settings.m_maxNumMultiSocketFetchHandlers - this.m_clientCtx.m_numFetchers))) {
                        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), "Number of handlers to spawn is negative.");
                        if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                            LogUtilities.logError(errorException, this.m_logger);
                            HiveHS2ClientUtils.logOperationHandle(hiveOperationContext, this.m_logger);
                        }
                        this.m_clientCtx.removeAllTasks(hiveOperationContext);
                        throw errorException;
                    }
                    TTransport tTransport = this.m_client.getOutputProtocol().getTransport();
                    CookieStore cookieStore = new BasicCookieStore();
                    if (tTransport instanceof TETHttpClient) {
                        cookieStore = ((TETHttpClient)tTransport).getCookieStore();
                    }
                    for (n = 0; n2 > n; ++n) {
                        this.m_threadPool.submit(new HiveMultiSocketFetchHandler(this.m_settings, this.m_clientCtx, this.createHS2ClientWrapper(new TBinaryProtocol(HiveServer2ClientFactory.createTransport(this.m_settings, this.m_warningListener.getMessageSource(), this.m_warningListener.getLocale(), this.m_logger, cookieStore))), this, this.m_logger));
                    }
                    if (hiveOperationContext.m_fetchResultsReq.isSetStartRowOffset()) {
                        hiveOperationContext.m_fetchResultsReq.unsetStartRowOffset();
                    }
                    for (n = 0; n3 > n; ++n) {
                        this.m_clientCtx.m_fetchTasks.add(hiveOperationContext);
                        this.m_clientCtx.m_idleHandlerSemaphore.release();
                    }
                    if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                        LogUtilities.logDebug("Fetch to request: " + String.valueOf(n3) + " Handlers created: " + String.valueOf(n2), this.m_logger);
                        HiveHS2ClientUtils.logOperationHandle(hiveOperationContext, this.m_logger);
                    }
                    hiveMultiSocketFetchContext.m_numPendingFetchRequests += n3;
                    this.m_clientCtx.m_numFetchers += n2;
                }
                return false;
            }
        }
    }

    @Override
    protected HS2ClientWrapper createHS2ClientWrapper(TProtocol tProtocol) throws ErrorException {
        if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        }
        if (this.m_settings.m_authMech == AuthMech.OAUTH_2 || this.m_settings.m_authMech == AuthMech.SAML_2_0) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), "Multi-socket fetch feature does not support OAuth and SAML connections.");
            if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                LogUtilities.logError(errorException, this.m_logger);
            }
            throw errorException;
        }
        return super.createHS2ClientWrapper(tProtocol);
    }

    @Override
    public void disconnect() throws ErrorException {
        if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        }
        super.disconnect();
        this.m_threadPool.shutdownNow();
        try {
            if (!this.m_threadPool.awaitTermination(60L, TimeUnit.SECONDS)) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), "Thread pool did not terminate gracefully within timeout. There might be some hanging connections.");
                if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                    LogUtilities.logError(errorException, this.m_logger);
                }
                throw errorException;
            }
        }
        catch (InterruptedException interruptedException) {
            this.m_threadPool.shutdownNow();
            Thread.currentThread().interrupt();
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), "Fetch client has been interrupted. There might be some hanging connections.");
            if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                LogUtilities.logError(errorException, this.m_logger);
            }
            throw errorException;
        }
    }

    private void assignBuffer(RowsetBuffer<HiveServer2BaseBuffer> rowsetBuffer, HiveServer2BaseBuffer hiveServer2BaseBuffer) {
        if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        }
        if (hiveServer2BaseBuffer != rowsetBuffer.m_buffer) {
            if (null != rowsetBuffer.m_buffer) {
                ((HiveServer2BaseBuffer)rowsetBuffer.m_buffer).close();
            }
            rowsetBuffer.m_buffer = hiveServer2BaseBuffer;
        }
    }
}

