/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.hivecommon.api;

import com.cloudera.hive.jdbc42.internal.apache.commons.codec.binary.Base64;
import com.cloudera.hive.jdbc42.internal.apache.http.client.CookieStore;
import com.cloudera.hive.jdbc42.internal.apache.http.conn.DnsResolver;
import com.cloudera.hive.jdbc42.internal.apache.http.impl.NoConnectionReuseStrategy;
import com.cloudera.hive.jdbc42.internal.apache.http.impl.client.BasicCookieStore;
import com.cloudera.hive.jdbc42.internal.apache.http.impl.client.HttpClientBuilder;
import com.cloudera.hive.jdbc42.internal.apache.thrift.protocol.TBinaryProtocol;
import com.cloudera.hive.jdbc42.internal.apache.thrift.transport.TSaslClientTransport;
import com.cloudera.hive.jdbc42.internal.apache.thrift.transport.TSocket;
import com.cloudera.hive.jdbc42.internal.apache.thrift.transport.TTransport;
import com.cloudera.hive.jdbc42.internal.apache.thrift.transport.TTransportException;
import com.cloudera.hiveserver1.dsi.core.impl.DSIDriverSingleton;
import com.cloudera.hiveserver1.hivecommon.AuthMech;
import com.cloudera.hiveserver1.hivecommon.HiveJDBCSettings;
import com.cloudera.hiveserver1.hivecommon.KrbAuthType;
import com.cloudera.hiveserver1.hivecommon.ServiceDiscoveryMode;
import com.cloudera.hiveserver1.hivecommon.TransportMode;
import com.cloudera.hiveserver1.hivecommon.api.DelegationToken;
import com.cloudera.hiveserver1.hivecommon.api.HS2Client;
import com.cloudera.hiveserver1.hivecommon.api.HS2MultiSocketFetchClient;
import com.cloudera.hiveserver1.hivecommon.api.HiveServerPrivilegedAction;
import com.cloudera.hiveserver1.hivecommon.api.IHiveClient;
import com.cloudera.hiveserver1.hivecommon.api.IHiveClientFactory;
import com.cloudera.hiveserver1.hivecommon.api.IHiveServerBuffer;
import com.cloudera.hiveserver1.hivecommon.api.SSOSAMLTHttpClient;
import com.cloudera.hiveserver1.hivecommon.api.SaslCallbackHandler;
import com.cloudera.hiveserver1.hivecommon.api.TETHttpClient;
import com.cloudera.hiveserver1.hivecommon.api.TETSSLTransportFactory;
import com.cloudera.hiveserver1.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hiveserver1.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.hiveserver1.hivecommon.utils.kerberos.KerberosHttpInterceptor;
import com.cloudera.hiveserver1.jdbc.common.SSLTransportParameters;
import com.cloudera.hiveserver1.jdbc.http.extention.ExtendedHttpClient;
import com.cloudera.hiveserver1.jdbc.kerberos.Kerberos;
import com.cloudera.hiveserver1.jdbc.rpc.CustomDnsResolverLoader;
import com.cloudera.hiveserver1.jdbc.rpc.HttpClientFactory;
import com.cloudera.hiveserver1.jdbc.utils.rpc.CustomNetworkHooks;
import com.cloudera.hiveserver1.support.ILogger;
import com.cloudera.hiveserver1.support.IMessageSource;
import com.cloudera.hiveserver1.support.IWarningListener;
import com.cloudera.hiveserver1.support.LogUtilities;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import org.apache.hadoop.security.UserGroupInformation;

public class HiveServer2ClientFactory
implements IHiveClientFactory {
    public static final String MAPR_SECURITY = "MAPR-SECURITY";
    public static final String MAPR_SASL_PROVIDER_IMPLIMENTATION = "com.mapr.security.maprsasl.MaprSaslProvider";

    @Override
    public IHiveClient<? extends IHiveServerBuffer> createClient(HiveJDBCSettings hiveJDBCSettings, ILogger iLogger, IWarningListener iWarningListener) throws ErrorException {
        TTransport tTransport = hiveJDBCSettings.m_isEnableMultiSocketFetch != false ? HiveServer2ClientFactory.createTransport(hiveJDBCSettings, iWarningListener.getMessageSource(), iWarningListener.getLocale(), iLogger, new BasicCookieStore()) : HiveServer2ClientFactory.createTransport(hiveJDBCSettings, iWarningListener.getMessageSource(), iWarningListener.getLocale(), iLogger);
        try {
            if (hiveJDBCSettings.m_isEnableMultiSocketFetch.booleanValue()) {
                return new HS2MultiSocketFetchClient(hiveJDBCSettings, new TBinaryProtocol(tTransport), iLogger, iWarningListener);
            }
            return new HS2Client(hiveJDBCSettings, new TBinaryProtocol(tTransport), iLogger, iWarningListener);
        }
        catch (Throwable throwable) {
            tTransport.close();
            throw throwable;
        }
    }

    @Override
    public boolean supportServiceDiscoveryMode(ServiceDiscoveryMode serviceDiscoveryMode, ILogger iLogger) {
        LogUtilities.logFunctionEntrance(iLogger, new Object[]{serviceDiscoveryMode, iLogger});
        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SERVICE_DISCOVERY_MODE_NOT_SUPPORTED.name(), new String[]{serviceDiscoveryMode.name(), "Platform does not support Service discovery, defaulting to NoServiceDiscovery"});
        errorException.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
        LogUtilities.logWarning(errorException, iLogger);
        return false;
    }

    protected static void applyIdleHttpConnectionExpiry(HiveJDBCSettings hiveJDBCSettings, HttpClientBuilder httpClientBuilder) {
        if (hiveJDBCSettings.m_enableIdleHttpConnectionExpiry.booleanValue()) {
            if (hiveJDBCSettings.m_idleHttpConnectionExpiry == 0) {
                httpClientBuilder.setConnectionReuseStrategy(new NoConnectionReuseStrategy());
            } else {
                httpClientBuilder.evictIdleConnections(hiveJDBCSettings.m_idleHttpConnectionExpiry, TimeUnit.SECONDS);
            }
        }
    }

    protected static TTransport createTransport(HiveJDBCSettings hiveJDBCSettings, IMessageSource iMessageSource, Locale locale, ILogger iLogger) throws ErrorException {
        return HiveServer2ClientFactory.createTransport(hiveJDBCSettings, iMessageSource, locale, iLogger, null);
    }

    protected static TTransport createTransport(HiveJDBCSettings hiveJDBCSettings, IMessageSource iMessageSource, Locale locale, ILogger iLogger, CookieStore cookieStore) throws ErrorException {
        Object object = null;
        TSocket tSocket = null;
        HttpClientBuilder httpClientBuilder = null;
        SocketFactory socketFactory = CustomNetworkHooks.getCustomSocketFactory(hiveJDBCSettings.m_customNetworkHooksSettings, iLogger);
        DnsResolver dnsResolver = CustomDnsResolverLoader.getDnsResolver(hiveJDBCSettings.m_customNetworkHooksSettings, iLogger);
        hiveJDBCSettings.m_customNetworkHooksSettings.m_resolvedHost = CustomDnsResolverLoader.getResolvedHost(dnsResolver, hiveJDBCSettings.m_host, iLogger);
        try {
            Object object2;
            Object object3;
            if (TransportMode.HTTP != hiveJDBCSettings.m_transportMode) {
                object3 = null;
                if (hiveJDBCSettings.m_proxySettings.m_useProxy && !hiveJDBCSettings.m_proxySettings.m_isHostInProxyIgnoreList.booleanValue()) {
                    object3 = HttpClientFactory.getSocketFromHTTPProxyTunnel(hiveJDBCSettings.m_customNetworkHooksSettings.m_resolvedHost, hiveJDBCSettings.m_port, hiveJDBCSettings.m_proxySettings, iLogger);
                }
                if (hiveJDBCSettings.m_serverSSLSettings.m_enableSSL) {
                    object2 = HiveServer2ClientFactory.createTETSSLTransportParams(hiveJDBCSettings);
                    tSocket = TETSSLTransportFactory.getClientSocket(hiveJDBCSettings, (SSLTransportParameters)object2, socketFactory, (Socket)object3, iLogger);
                } else {
                    if (null == socketFactory) {
                        socketFactory = SocketFactory.getDefault();
                    }
                    if (null != object3) {
                        object2 = object3;
                    } else {
                        object2 = socketFactory.createSocket();
                        ((Socket)object2).connect(new InetSocketAddress(hiveJDBCSettings.m_customNetworkHooksSettings.m_resolvedHost, hiveJDBCSettings.m_port), hiveJDBCSettings.m_timeout);
                    }
                    tSocket = new TSocket((Socket)object2);
                    tSocket.setTimeout(hiveJDBCSettings.m_timeout);
                }
            } else {
                if (null == hiveJDBCSettings.m_httpPath || 0 == hiveJDBCSettings.m_httpPath.length()) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_HTTP_PATH_ERR.name());
                    throw errorException;
                }
                if (hiveJDBCSettings.m_serverSSLSettings.m_enableSSL) {
                    object3 = HiveServer2ClientFactory.createTETSSLTransportParams(hiveJDBCSettings);
                    httpClientBuilder = TETSSLTransportFactory.getHttpsClient(hiveJDBCSettings, (SSLTransportParameters)object3, socketFactory, dnsResolver, iLogger);
                } else {
                    httpClientBuilder = HttpClientFactory.createHttpClient(socketFactory, dnsResolver, hiveJDBCSettings.m_proxySettings, hiveJDBCSettings.m_timeout, iLogger);
                }
                httpClientBuilder.setDnsResolver(dnsResolver);
                HiveServer2ClientFactory.applyIdleHttpConnectionExpiry(hiveJDBCSettings, httpClientBuilder);
            }
            switch (hiveJDBCSettings.m_authMech) {
                case MAPRSASL: {
                    Object object4;
                    Security.addProvider((Provider)Class.forName(MAPR_SASL_PROVIDER_IMPLIMENTATION).getConstructor(new Class[0]).newInstance(new Object[0]));
                    object3 = Sasl.getSaslClientFactories();
                    object2 = null;
                    while (object3.hasMoreElements()) {
                        object4 = (SaslClientFactory)object3.nextElement();
                        for (String string : object4.getMechanismNames(null)) {
                            UserGroupInformation userGroupInformation;
                            if (!string.endsWith(MAPR_SECURITY) || null != (object2 = (SaslClient)(userGroupInformation = UserGroupInformation.getCurrentUser()).doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<SaslClient>((SaslClientFactory)object4){
                                final /* synthetic */ SaslClientFactory val$factory;
                                {
                                    this.val$factory = saslClientFactory;
                                }

                                @Override
                                public SaslClient run() throws Exception {
                                    SaslClient saslClient = this.val$factory.createSaslClient(new String[]{HiveServer2ClientFactory.MAPR_SECURITY}, null, null, null, null, null);
                                    return saslClient;
                                }
                            }))) continue;
                            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.MAPSASL_CLIENT_ERROR.name(), "Failed to get MaprSASL client");
                            throw errorException;
                        }
                    }
                    if (null == object2) {
                        object4 = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_AUTHENTICATION_FAILED, "Failed to get MaprSASL client");
                        throw object4;
                    }
                    object = new TSaslClientTransport((SaslClient)object2, tSocket);
                    break;
                }
                case NOAUTH: {
                    if (hiveJDBCSettings.m_transportMode == TransportMode.HTTP && hiveJDBCSettings.m_platformVersionUtils.supportsHttp(hiveJDBCSettings.m_authMech)) {
                        HiveServer2ClientFactory.applyIdleHttpConnectionExpiry(hiveJDBCSettings, httpClientBuilder);
                        object3 = HiveServer2ClientFactory.getTETHTTPClient(hiveJDBCSettings, httpClientBuilder, iLogger);
                        if (null != hiveJDBCSettings.m_username) {
                            HiveServer2ClientFactory.addCredentialsToHeader(hiveJDBCSettings, (TETHttpClient)object3);
                        }
                        object = object3;
                        break;
                    }
                    object = tSocket;
                    break;
                }
                case DELEGATION_TOKEN: {
                    object3 = null;
                    if (hiveJDBCSettings.m_delegationToken != null) {
                        try {
                            object3 = DelegationToken.decodeToken(hiveJDBCSettings.m_delegationToken);
                        }
                        catch (Exception exception) {
                            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DELEGATION_TOKEN_DECODE_FAILED.name());
                            errorException.initCause(exception);
                            errorException.loadMessage(iMessageSource, locale);
                            ErrorException errorException2 = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DELEGATION_TOKEN_FAILED.name(), errorException.getMessage());
                            errorException2.initCause(errorException);
                            throw errorException2;
                        }
                        try {
                            object = new TSaslClientTransport("DIGEST-MD5", null, null, "default", null, new SaslCallbackHandler((DelegationToken)object3), tSocket);
                            break;
                        }
                        catch (Exception exception) {
                            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DELEGATION_TOKEN_FAILED.name(), exception.getMessage());
                            errorException.initCause(exception);
                            throw errorException;
                        }
                    }
                    object2 = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DELEGATION_TOKEN_FAILED.name(), "Unable to obtain the token from the connection string");
                    throw object2;
                }
                case SASL_KERBEROS: {
                    object3 = null;
                    if (KrbAuthType.JAAS == hiveJDBCSettings.m_krbAuthType) {
                        try {
                            object3 = Kerberos.getSubjectViaEnvJAASConfig(iLogger);
                        }
                        catch (LoginException loginException) {
                            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_KERBEROS_AUTHENTICATION_ERROR_GET_JAASCONFIGURE.name(), loginException.getMessage());
                            errorException.initCause(loginException);
                            throw errorException;
                        }
                        if (iLogger.isEnabled() && null != object3) {
                            LogUtilities.logDebug("Kerberos subject retrieved via JAAS config", iLogger);
                        }
                    } else if (KrbAuthType.TICKET_CACHE == hiveJDBCSettings.m_krbAuthType) {
                        try {
                            object3 = Kerberos.getSubjectViaTicketCache(iLogger);
                        }
                        catch (LoginException loginException) {
                            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_KERBEROS_AUTHENTICATION_ERROR_GET_TICKETCACHE.name(), loginException.getMessage());
                            errorException.initCause(loginException);
                            throw errorException;
                        }
                        if (iLogger.isEnabled() && null != object3) {
                            LogUtilities.logDebug("Kerberos subject retrieved via ticket cache lookup", iLogger);
                        }
                    } else if (KrbAuthType.NATIVE_GSSAPI == hiveJDBCSettings.m_krbAuthType) {
                        object3 = Kerberos.getSubjectViaAccessControlContext(iLogger);
                        System.setProperty("sun.security.jgss.native", "true");
                    } else {
                        object3 = Kerberos.getSubjectViaAccessControlContext(iLogger);
                        if (iLogger.isEnabled() && null != object3) {
                            LogUtilities.logDebug("Kerberos subject retrieved via AccessControlContext", iLogger);
                        }
                        if (null == object3) {
                            boolean bl = false;
                            try {
                                object3 = Kerberos.getSubjectViaEnvJAASConfig(iLogger);
                            }
                            catch (LoginException loginException) {
                                LogUtilities.logWarning(loginException, iLogger);
                                bl = true;
                            }
                            if (iLogger.isEnabled() && null != object3) {
                                LogUtilities.logDebug("Kerberos subject retrieved via JAAS config", iLogger);
                            }
                            if (null == object3 || bl) {
                                try {
                                    object3 = Kerberos.getSubjectViaTicketCache(iLogger);
                                }
                                catch (LoginException loginException) {
                                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_KERBEROS_AUTHENTICATION_ERROR_GET_TICKETCACHE.name(), loginException.getMessage());
                                    errorException.initCause(loginException);
                                    throw errorException;
                                }
                                if (iLogger.isEnabled() && null != object3) {
                                    LogUtilities.logDebug("Kerberos subject retrieved via ticket cache lookup", iLogger);
                                }
                            }
                        }
                    }
                    if (null == object3 && KrbAuthType.NATIVE_GSSAPI != hiveJDBCSettings.m_krbAuthType) {
                        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SASL_KERSEROS_ERR.name(), "Cannot setup Kerberos authentication");
                        throw errorException;
                    }
                    if (null == hiveJDBCSettings.m_krbServiceName || null == hiveJDBCSettings.m_krbHostFQDN) {
                        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SASL_KERSEROS_ERR.name(), "Kerberos service name error");
                        throw errorException;
                    }
                    if (TransportMode.HTTP != hiveJDBCSettings.m_transportMode) {
                        HiveServerPrivilegedAction hiveServerPrivilegedAction = new HiveServerPrivilegedAction(null, tSocket, hiveJDBCSettings.m_krbServiceName, hiveJDBCSettings.m_krbHostFQDN, iMessageSource, locale, hiveJDBCSettings.m_userGSSCredential);
                        if (null == object3) {
                            hiveServerPrivilegedAction.run();
                        } else {
                            Subject.doAs((Subject)object3, hiveServerPrivilegedAction);
                        }
                        return hiveServerPrivilegedAction.getTransKerberos();
                    }
                    httpClientBuilder.addInterceptorLast(new KerberosHttpInterceptor(hiveJDBCSettings.m_krbServiceName, hiveJDBCSettings.m_krbHostFQDN, (Subject)object3));
                    HiveServer2ClientFactory.applyIdleHttpConnectionExpiry(hiveJDBCSettings, httpClientBuilder);
                    TETHttpClient tETHttpClient = HiveServer2ClientFactory.getTETHTTPClient(hiveJDBCSettings, httpClientBuilder, iLogger);
                    object = tETHttpClient;
                    break;
                }
                case SASL_PLAIN_UID: {
                    object = new TSaslClientTransport("PLAIN", null, null, null, null, new SaslCallbackHandler(hiveJDBCSettings), tSocket);
                    break;
                }
                case UIDPWD: {
                    if (TransportMode.HTTP == hiveJDBCSettings.m_transportMode) {
                        HiveServer2ClientFactory.applyIdleHttpConnectionExpiry(hiveJDBCSettings, httpClientBuilder);
                        object3 = cookieStore != null ? HiveServer2ClientFactory.getTETHTTPClient(hiveJDBCSettings, httpClientBuilder, cookieStore, iLogger) : HiveServer2ClientFactory.getTETHTTPClient(hiveJDBCSettings, httpClientBuilder, iLogger);
                        HiveServer2ClientFactory.addCredentialsToHeader(hiveJDBCSettings, (TETHttpClient)object3);
                        object = object3;
                        break;
                    }
                    if (TransportMode.BINARY == hiveJDBCSettings.m_transportMode) {
                        object = tSocket;
                        break;
                    }
                    object = new TSaslClientTransport("PLAIN", null, null, null, null, new SaslCallbackHandler(hiveJDBCSettings), tSocket);
                    break;
                }
                case OAUTH_2: 
                case JWT: {
                    HiveServer2ClientFactory.applyIdleHttpConnectionExpiry(hiveJDBCSettings, httpClientBuilder);
                    object = object3 = HiveServer2ClientFactory.getTETHTTPClient(hiveJDBCSettings, httpClientBuilder, iLogger);
                    break;
                }
                case SAML_2_0: {
                    HiveServer2ClientFactory.applyIdleHttpConnectionExpiry(hiveJDBCSettings, httpClientBuilder);
                    object = object3 = HiveServer2ClientFactory.getSSOSAMLTHTTPClient(hiveJDBCSettings, httpClientBuilder, new BasicCookieStore(), iLogger);
                    break;
                }
                default: {
                    object3 = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CREATE_AUTHENTICATION_TRANSPORT_ERR.name(), "Unexpected authentication mechanism selected!");
                    throw object3;
                }
            }
            if (!(hiveJDBCSettings.m_transportMode == TransportMode.BINARY && hiveJDBCSettings.m_serverSSLSettings.m_enableSSL || ((TTransport)object).isOpen())) {
                ((TTransport)object).open();
            }
        }
        catch (Exception exception) {
            if (object != null) {
                ((TTransport)object).close();
            }
            if (tSocket != null) {
                tSocket.close();
            }
            if (exception instanceof TTransportException && exception.getCause() != null && exception.getCause() instanceof SocketTimeoutException) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_HS2_CLIENT_SOCKET_ERR.name());
                errorException.initCause(exception);
                throw errorException;
            }
            if (exception instanceof ErrorException) {
                throw (ErrorException)exception;
            }
            if (AuthMech.DELEGATION_TOKEN == hiveJDBCSettings.m_authMech) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DELEGATION_TOKEN_FAILED.name(), exception.getMessage());
                errorException.initCause(exception);
                throw errorException;
            }
            String string = exception.getMessage();
            if (null == string) {
                string = iMessageSource.loadMessage(locale, 101, HiveJDBCMessageKey.CONN_AUTHENTICATION_FAILED.name());
            }
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CREATE_AUTHENTICATION_TRANSPORT_ERR.name(), string);
            errorException.initCause(exception);
            throw errorException;
        }
        return object;
    }

    protected static SSOSAMLTHttpClient getSSOSAMLTHTTPClient(HiveJDBCSettings hiveJDBCSettings, HttpClientBuilder httpClientBuilder, CookieStore cookieStore, ILogger iLogger) throws TTransportException {
        httpClientBuilder.setDefaultCookieStore(cookieStore);
        return new SSOSAMLTHttpClient(HiveServer2ClientFactory.getFullHttpPath(hiveJDBCSettings), new ExtendedHttpClient(httpClientBuilder.build()), hiveJDBCSettings.m_thriftHTTPSettings, hiveJDBCSettings.m_ssoSettings, cookieStore, iLogger);
    }

    protected static TETHttpClient getTETHTTPClient(HiveJDBCSettings hiveJDBCSettings, HttpClientBuilder httpClientBuilder, ILogger iLogger) throws TTransportException {
        return new TETHttpClient(HiveServer2ClientFactory.getFullHttpPath(hiveJDBCSettings), new ExtendedHttpClient(httpClientBuilder.build()), hiveJDBCSettings.m_thriftHTTPSettings, iLogger);
    }

    protected static TETHttpClient getTETHTTPClient(HiveJDBCSettings hiveJDBCSettings, HttpClientBuilder httpClientBuilder, CookieStore cookieStore, ILogger iLogger) throws TTransportException {
        httpClientBuilder.setDefaultCookieStore(cookieStore);
        return new TETHttpClient(HiveServer2ClientFactory.getFullHttpPath(hiveJDBCSettings), new ExtendedHttpClient(httpClientBuilder.build()), hiveJDBCSettings.m_thriftHTTPSettings, cookieStore, iLogger);
    }

    private static void addCredentialsToHeader(HiveJDBCSettings hiveJDBCSettings, TETHttpClient tETHttpClient) {
        byte[] byArray = Base64.encodeBase64((hiveJDBCSettings.m_username + ":" + hiveJDBCSettings.m_password).getBytes());
        tETHttpClient.setCustomHeader("Authorization", "Basic " + new String(byArray));
    }

    private static SSLTransportParameters createTETSSLTransportParams(HiveJDBCSettings hiveJDBCSettings) {
        SSLTransportParameters sSLTransportParameters = new SSLTransportParameters();
        if (null != hiveJDBCSettings.m_serverSSLSettings.m_sslKeyStore) {
            sSLTransportParameters.setKeyStore(hiveJDBCSettings.m_serverSSLSettings.m_sslKeyStore, hiveJDBCSettings.m_serverSSLSettings.m_sslKeyStorePwd, null, hiveJDBCSettings.m_serverSSLSettings.m_sslKeyStoreType, hiveJDBCSettings.m_serverSSLSettings.m_sslKeyStoreProvider);
        }
        if (null != hiveJDBCSettings.m_serverSSLSettings.m_sslTrustStore) {
            sSLTransportParameters.setTrustStore(hiveJDBCSettings.m_serverSSLSettings.m_sslTrustStore, hiveJDBCSettings.m_serverSSLSettings.m_sslTrustStorePwd, null, hiveJDBCSettings.m_serverSSLSettings.m_sslTrustStoreType, hiveJDBCSettings.m_serverSSLSettings.m_sslTrustStoreProvider);
        }
        sSLTransportParameters.requireClientAuth(false);
        sSLTransportParameters.allowSelfSigned(hiveJDBCSettings.m_serverSSLSettings.m_allowSelfSigned);
        sSLTransportParameters.certNamesMismatch(hiveJDBCSettings.m_serverSSLSettings.m_certNamesMismatch);
        sSLTransportParameters.hostNameInSAN(hiveJDBCSettings.m_serverSSLSettings.m_hostNameInSAN);
        return sSLTransportParameters;
    }

    private static String getFullHttpPath(HiveJDBCSettings hiveJDBCSettings) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(hiveJDBCSettings.m_serverSSLSettings.m_enableSSL ? "https://" : "http://");
        if (hiveJDBCSettings.m_useResolvedHostname) {
            stringBuilder.append(hiveJDBCSettings.m_customNetworkHooksSettings.m_resolvedHost);
        } else {
            stringBuilder.append(hiveJDBCSettings.m_host);
        }
        stringBuilder.append(":");
        stringBuilder.append(hiveJDBCSettings.m_port);
        stringBuilder.append(hiveJDBCSettings.m_httpPath.startsWith("/") ? "" : "/");
        stringBuilder.append(hiveJDBCSettings.m_httpPath);
        return stringBuilder.toString();
    }
}

