/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.hivecommon.api;

import com.cloudera.hiveserver1.hivecommon.HiveJDBCSettings;
import com.cloudera.hiveserver1.hivecommon.api.HiveJDBCBrowserServerResponse;
import com.cloudera.hiveserver1.hivecommon.api.WebConnection;
import com.cloudera.hiveserver1.hivecommon.api.WebServer;
import com.cloudera.hiveserver1.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hiveserver1.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.hiveserver1.support.ILogger;
import com.cloudera.hiveserver1.support.LogUtilities;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.awt.Desktop;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class WebBrowserClient {
    public static final int BUSY_WAIT_MILLIS = 250;
    public static final long MILLI_TO_NANO = 1000000L;
    public static final int SEC_TO_MILLI = 1000;
    public static final int SERVER_SOCKET_TIMEOUT = 100;
    protected ILogger m_logger;
    private AtomicBoolean m_continueFlag = new AtomicBoolean(true);
    private final ExecutorService m_executorService = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = Executors.defaultThreadFactory().newThread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    });
    protected HiveJDBCBrowserServerResponse m_serverResponse = null;
    protected ServerSocket m_serverSocket = null;
    protected HiveJDBCSettings m_settings;
    private URI m_ssoUri = null;
    protected int m_browserTimeout = 0;

    public WebBrowserClient(HiveJDBCSettings hiveJDBCSettings, ILogger iLogger) throws ErrorException {
        this.m_settings = hiveJDBCSettings;
        this.m_logger = iLogger;
        this.m_serverSocket = this.getServerSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doBrowserSSO() throws ErrorException {
        Object object;
        if (this.m_settings.m_oAuthSettings != null && this.m_settings.m_oAuthSettings.m_OAuthWebServerTimeoutTakesPrecedence.booleanValue()) {
            this.m_browserTimeout = this.m_settings.m_oAuthSettings.m_OAuthWebServerTimeout * 1000;
        }
        long l = System.nanoTime() + (long)this.m_browserTimeout * 1000000L;
        this.openBrowserWindow(this.m_ssoUri);
        this.m_serverResponse = null;
        this.m_continueFlag.getAndSet(true);
        this.startListeningForResponses();
        boolean bl = false;
        while (!(bl || 0 != this.m_browserTimeout && System.nanoTime() >= l)) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            object = this;
            synchronized (object) {
                bl = null != this.m_serverResponse;
            }
        }
        this.cleanBrowserSocket();
        this.m_continueFlag.getAndSet(false);
        if (this.m_settings.m_ssoSettings.m_ssoLogSensitiveInfoForDebug) {
            LogUtilities.logTrace(this.getSensitiveInfoLogMessage(), this.m_logger);
        }
        if (null == this.m_serverResponse) {
            object = this.getResponseException();
            throw object;
        }
        LogUtilities.logDebug("A server response was found.", this.m_logger);
    }

    public void cleanBrowserSocket() throws ErrorException {
        if (!this.m_serverSocket.isClosed()) {
            try {
                this.m_serverSocket.close();
            }
            catch (IOException iOException) {
                ErrorException errorException = this.getResponseException();
                throw errorException;
            }
        }
    }

    abstract ErrorException getResponseException();

    abstract String getSensitiveInfoLogMessage();

    public OsType getMatchingOs(String string) {
        if ((string = string.toLowerCase()).contains("win")) {
            return OsType.WINDOWS;
        }
        if (string.contains("mac")) {
            return OsType.MAC;
        }
        if (string.contains("nix") || string.contains("nux") || string.contains("aix")) {
            return OsType.UNIX;
        }
        return OsType.UNKNOWN;
    }

    public OsType getOperatingSystem() {
        String string = System.getProperty("os.name");
        return this.getMatchingOs(string);
    }

    public int getPort() {
        return this.m_serverSocket.getLocalPort();
    }

    public synchronized boolean hasResponse() {
        return null != this.m_serverResponse;
    }

    public synchronized boolean isSuccess() {
        return null == this.m_serverResponse ? false : this.m_serverResponse.isSuccessful();
    }

    protected synchronized void setServerResponse(HiveJDBCBrowserServerResponse hiveJDBCBrowserServerResponse) {
        this.m_serverResponse = hiveJDBCBrowserServerResponse;
    }

    public void setSSOUri(URI uRI) {
        this.m_ssoUri = uRI;
    }

    public void setTimeout(int n) {
        this.m_browserTimeout = n;
    }

    protected abstract ServerSocket getServerSocket() throws ErrorException;

    private void openBrowserWindow(URI uRI) throws ErrorException {
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(uRI);
            } else {
                OsType osType = this.getOperatingSystem();
                switch (osType) {
                    case WINDOWS: {
                        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + uRI.toString());
                        break;
                    }
                    case MAC: {
                        Runtime.getRuntime().exec("open " + uRI.toString());
                        break;
                    }
                    case UNIX: {
                        Runtime.getRuntime().exec("xdg-open " + uRI.toString());
                        break;
                    }
                    default: {
                        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SSO_OPEN_BROWSER_UNSUPPORTED_OS.name(), System.getProperty("os.name"));
                        throw errorException;
                    }
                }
            }
        }
        catch (IOException iOException) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SSO_OPEN_BROWSER_ERR.name(), iOException.getMessage());
            throw errorException;
        }
    }

    private void startListeningForResponses() {
        WebConnection.SetValueFunction setValueFunction = new WebConnection.SetValueFunction(){

            @Override
            public void setValue(HiveJDBCBrowserServerResponse hiveJDBCBrowserServerResponse) {
                if (WebBrowserClient.this.m_continueFlag.get()) {
                    WebBrowserClient.this.setServerResponse(hiveJDBCBrowserServerResponse);
                }
            }
        };
        this.m_executorService.submit(new WebServer(this.m_serverSocket, this.m_executorService, setValueFunction, this.m_continueFlag, this.m_logger, this.m_settings));
    }

    public static enum OsType {
        WINDOWS,
        MAC,
        UNIX,
        UNKNOWN;

    }
}

