/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.jdbc.classloader;

import com.cloudera.hiveserver1.jdbc.classloader.JarInJarStreamHandlerFactory;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.List;

public class JarInJarClassLoader
extends URLClassLoader {
    public JarInJarClassLoader(List<String> list) {
        super(new URL[0], JarInJarClassLoader.class.getClassLoader());
        try {
            for (String string : list) {
                this.addURL(new URL("sbprotocol:/" + string));
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }

    @Override
    public Class<?> loadClass(String string) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(string);
        if (null == clazz) {
            try {
                clazz = this.findClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ClassLoader classLoader = this.getParent();
                clazz = null == classLoader ? JarInJarClassLoader.getSystemClassLoader().loadClass(string) : classLoader.loadClass(string);
            }
        }
        return clazz;
    }

    static {
        try {
            Field field = URL.class.getDeclaredField("factory");
            field.setAccessible(true);
            Object object = field.get(null);
            if (object instanceof URLStreamHandlerFactory) {
                field.set(null, new JarInJarStreamHandlerFactory((URLStreamHandlerFactory)object));
            } else if (object == null) {
                URL.setURLStreamHandlerFactory(new JarInJarStreamHandlerFactory());
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            System.err.println(noSuchFieldException.getLocalizedMessage());
        }
        catch (SecurityException securityException) {
            System.err.println(securityException.getLocalizedMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getLocalizedMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println(illegalAccessException.getLocalizedMessage());
        }
    }
}

