/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.jdbc.rpc;

import com.cloudera.hive.jdbc42.internal.apache.http.HttpHost;
import com.cloudera.hive.jdbc42.internal.apache.http.auth.AuthScope;
import com.cloudera.hive.jdbc42.internal.apache.http.auth.UsernamePasswordCredentials;
import com.cloudera.hive.jdbc42.internal.apache.http.client.config.RequestConfig;
import com.cloudera.hive.jdbc42.internal.apache.http.config.Registry;
import com.cloudera.hive.jdbc42.internal.apache.http.config.RegistryBuilder;
import com.cloudera.hive.jdbc42.internal.apache.http.conn.DnsResolver;
import com.cloudera.hive.jdbc42.internal.apache.http.conn.socket.ConnectionSocketFactory;
import com.cloudera.hive.jdbc42.internal.apache.http.conn.socket.PlainConnectionSocketFactory;
import com.cloudera.hive.jdbc42.internal.apache.http.conn.ssl.NoopHostnameVerifier;
import com.cloudera.hive.jdbc42.internal.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.cloudera.hive.jdbc42.internal.apache.http.impl.client.BasicCredentialsProvider;
import com.cloudera.hive.jdbc42.internal.apache.http.impl.client.HttpClientBuilder;
import com.cloudera.hive.jdbc42.internal.apache.http.impl.client.HttpClients;
import com.cloudera.hive.jdbc42.internal.apache.http.impl.client.ProxyClient;
import com.cloudera.hive.jdbc42.internal.apache.http.impl.conn.BasicHttpClientConnectionManager;
import com.cloudera.hive.jdbc42.internal.apache.http.impl.conn.DefaultSchemePortResolver;
import com.cloudera.hive.jdbc42.internal.apache.http.impl.conn.ManagedHttpClientConnectionFactory;
import com.cloudera.hiveserver1.jdbc.common.ProxySettings;
import com.cloudera.hiveserver1.jdbc.core.DSDriver;
import com.cloudera.hiveserver1.jdbc.exceptions.CommonJDBCMessageKey;
import com.cloudera.hiveserver1.jdbc.http.extention.ExtendedPlainConnectionSocketFactory;
import com.cloudera.hiveserver1.jdbc.http.extention.ExtentedSSLConnectionSocketFactory;
import com.cloudera.hiveserver1.jdbc.http.extention.SocksPlainConnectionSocketFactory;
import com.cloudera.hiveserver1.jdbc.http.extention.SocksSSLConnectionSocketFactory;
import com.cloudera.hiveserver1.support.ILogger;
import com.cloudera.hiveserver1.support.LogUtilities;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;

public class HttpClientFactory {
    private static final String HTTP_SCHEME = "http";
    private static final String HTTPS_SCHEME = "https";

    public static HttpClientBuilder createHttpsClient(SocketFactory socketFactory, SSLContext sSLContext, DnsResolver dnsResolver, boolean bl, int n, ILogger iLogger) throws ErrorException {
        return HttpClientFactory.createHttpClientBuilder(socketFactory, sSLContext, dnsResolver, bl, null, n, iLogger);
    }

    public static HttpClientBuilder createHttpClient(SocketFactory socketFactory, DnsResolver dnsResolver, int n, ILogger iLogger) throws ErrorException {
        return HttpClientFactory.createHttpClientBuilder(socketFactory, null, dnsResolver, false, null, n, iLogger);
    }

    public static HttpClientBuilder createHttpClient(SocketFactory socketFactory, DnsResolver dnsResolver, ProxySettings proxySettings, int n, ILogger iLogger) throws ErrorException {
        return HttpClientFactory.createHttpClientBuilder(socketFactory, null, dnsResolver, false, proxySettings, n, iLogger);
    }

    public static HttpClientBuilder createHttpClientBuilder(SocketFactory socketFactory, SSLContext sSLContext, DnsResolver dnsResolver, boolean bl, ProxySettings proxySettings, int n, ILogger iLogger) throws ErrorException {
        Object object;
        LogUtilities.logFunctionEntrance(iLogger, socketFactory, sSLContext, dnsResolver, bl, proxySettings);
        HttpClientBuilder httpClientBuilder = null;
        if (null == sSLContext) {
            if (null == socketFactory) {
                socketFactory = SocketFactory.getDefault();
            }
            object = null;
            object = null != proxySettings && proxySettings.m_useProxy && proxySettings.m_isHostInProxyIgnoreList == false && proxySettings.m_proxyType.equals((Object)ProxySettings.ProxyType.DS_PT_SOCKS) ? new SocksPlainConnectionSocketFactory(iLogger) : new ExtendedPlainConnectionSocketFactory(socketFactory, iLogger);
            Registry<ConnectionSocketFactory> registry = HttpClientFactory.createSocketFactoryRegistry((ConnectionSocketFactory)object, null, HTTP_SCHEME, iLogger);
            BasicHttpClientConnectionManager basicHttpClientConnectionManager = new BasicHttpClientConnectionManager(registry, ManagedHttpClientConnectionFactory.INSTANCE, DefaultSchemePortResolver.INSTANCE, dnsResolver);
            httpClientBuilder = HttpClients.custom().setConnectionManager(basicHttpClientConnectionManager);
        } else {
            object = null;
            if (null == socketFactory) {
                socketFactory = sSLContext.getSocketFactory();
            }
            object = null != proxySettings && proxySettings.m_useProxy && !proxySettings.m_isHostInProxyIgnoreList.booleanValue() && proxySettings.m_proxyType.equals((Object)ProxySettings.ProxyType.DS_PT_SOCKS) ? (bl ? new SocksSSLConnectionSocketFactory(sSLContext, NoopHostnameVerifier.INSTANCE, iLogger) : new SocksSSLConnectionSocketFactory(sSLContext, iLogger)) : (bl ? new ExtentedSSLConnectionSocketFactory(sSLContext, NoopHostnameVerifier.INSTANCE, socketFactory, iLogger) : new ExtentedSSLConnectionSocketFactory(sSLContext, socketFactory, iLogger));
            Registry<ConnectionSocketFactory> registry = HttpClientFactory.createSocketFactoryRegistry((ConnectionSocketFactory)object, proxySettings, HTTPS_SCHEME, iLogger);
            BasicHttpClientConnectionManager basicHttpClientConnectionManager = new BasicHttpClientConnectionManager(registry, ManagedHttpClientConnectionFactory.INSTANCE, DefaultSchemePortResolver.INSTANCE, dnsResolver);
            httpClientBuilder = HttpClientBuilder.create().setConnectionManager(basicHttpClientConnectionManager).setSSLSocketFactory((SSLConnectionSocketFactory)object);
        }
        object = RequestConfig.custom().setConnectTimeout(n).setConnectionRequestTimeout(n).setSocketTimeout(n).build();
        httpClientBuilder.setDefaultRequestConfig((RequestConfig)object);
        HttpClientFactory.setProxySettings(httpClientBuilder, proxySettings, iLogger);
        return httpClientBuilder;
    }

    public static Socket getSocketFromHTTPProxyTunnel(String string, int n, ProxySettings proxySettings, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, string, n, proxySettings);
        try {
            HttpHost httpHost = new HttpHost(string, n);
            HttpHost httpHost2 = new HttpHost(proxySettings.m_proxyHost, proxySettings.m_proxyPort);
            ProxyClient proxyClient = new ProxyClient();
            UsernamePasswordCredentials usernamePasswordCredentials = null;
            usernamePasswordCredentials = ProxySettings.ProxyAuthentication.BASIC == proxySettings.m_proxyAuth ? new UsernamePasswordCredentials(proxySettings.m_proxyUid, proxySettings.m_proxyPwd) : new UsernamePasswordCredentials("", null);
            return proxyClient.tunnel(httpHost2, httpHost, usernamePasswordCredentials);
        }
        catch (Exception exception) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_PROXY_TUNNEL_ERR, exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
    }

    private static void setProxySettings(HttpClientBuilder httpClientBuilder, ProxySettings proxySettings, ILogger iLogger) {
        LogUtilities.logFunctionEntrance(iLogger, httpClientBuilder, proxySettings);
        if (null != proxySettings && proxySettings.m_useProxy && !proxySettings.m_isHostInProxyIgnoreList.booleanValue() && proxySettings.m_proxyType.equals((Object)ProxySettings.ProxyType.DS_PT_HTTP)) {
            HttpHost httpHost = new HttpHost(proxySettings.m_proxyHost, proxySettings.m_proxyPort);
            LogUtilities.logDebug("ProxyAuth is set to " + (Object)((Object)proxySettings.m_proxyAuth) + " with ProxyHost and ProxyPort values as " + proxySettings.m_proxyHost + " and " + proxySettings.m_proxyPort, iLogger);
            if (proxySettings.m_proxyAuth.equals((Object)ProxySettings.ProxyAuthentication.BASIC)) {
                LogUtilities.logDebug("Set ProxyUid and ProxyPwd values for Basic proxy authentication", iLogger);
                BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
                basicCredentialsProvider.setCredentials(new AuthScope(proxySettings.m_proxyHost, proxySettings.m_proxyPort), new UsernamePasswordCredentials(proxySettings.m_proxyUid, proxySettings.m_proxyPwd));
                httpClientBuilder.setDefaultCredentialsProvider(basicCredentialsProvider);
            }
            httpClientBuilder.setProxy(httpHost);
        }
    }

    private static Registry<ConnectionSocketFactory> createSocketFactoryRegistry(ConnectionSocketFactory connectionSocketFactory, ProxySettings proxySettings, String string, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, connectionSocketFactory, proxySettings, string);
        Registry<ConnectionSocketFactory> registry = null;
        if (null != proxySettings && proxySettings.m_useProxy && !proxySettings.m_isHostInProxyIgnoreList.booleanValue() && string.equals(HTTPS_SCHEME)) {
            if (proxySettings.m_proxyType.equals((Object)ProxySettings.ProxyType.DS_PT_HTTP)) {
                registry = RegistryBuilder.create().register(HTTP_SCHEME, new PlainConnectionSocketFactory()).register(HTTPS_SCHEME, (PlainConnectionSocketFactory)connectionSocketFactory).build();
            } else if (proxySettings.m_proxyType.equals((Object)ProxySettings.ProxyType.DS_PT_SOCKS)) {
                registry = RegistryBuilder.create().register(HTTP_SCHEME, new SocksPlainConnectionSocketFactory(iLogger)).register(HTTPS_SCHEME, (SocksPlainConnectionSocketFactory)connectionSocketFactory).build();
            }
        } else if (string.equals(HTTPS_SCHEME)) {
            registry = RegistryBuilder.create().register(HTTPS_SCHEME, connectionSocketFactory).build();
        } else if (string.equals(HTTP_SCHEME)) {
            registry = RegistryBuilder.create().register(HTTP_SCHEME, connectionSocketFactory).build();
        }
        return registry;
    }
}

