/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.aeprocessor.aebuilder.value;

import com.cloudera.hiveserver1.sqlengine.aeprocessor.aebuilder.AEBuilderBase;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aebuilder.AEBuilderCheck;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aebuilder.relation.AERelationalExprBuilder;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aebuilder.value.AEAggrFnBuilder;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aebuilder.value.AECaseExprBuilder;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aebuilder.value.AEColumnReferenceBuilder;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aebuilder.value.AEScalarFnBuilder;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.bool.AENot;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.bool.AEValueAsBooleanExpr;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AEAdd;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AEBooleanValueExpr;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AEConcat;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AEDefault;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AEDefaultParameter;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AEDivide;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AELiteral;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AEMultiply;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AENegate;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AENull;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AEParameter;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AESubtract;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AEValueSubQuery;
import com.cloudera.hiveserver1.sqlengine.dsiext.dataengine.ICoercionHandler;
import com.cloudera.hiveserver1.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.cloudera.hiveserver1.sqlengine.exceptions.SQLEngineException;
import com.cloudera.hiveserver1.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver1.sqlengine.parser.parsetree.IPTNode;
import com.cloudera.hiveserver1.sqlengine.parser.parsetree.PTDefaultParameterNode;
import com.cloudera.hiveserver1.sqlengine.parser.parsetree.PTDynamicParameterNode;
import com.cloudera.hiveserver1.sqlengine.parser.parsetree.PTFlagNode;
import com.cloudera.hiveserver1.sqlengine.parser.parsetree.PTLiteralNode;
import com.cloudera.hiveserver1.sqlengine.parser.parsetree.PTNonterminalNode;
import com.cloudera.hiveserver1.sqlengine.parser.type.PTLiteralType;
import com.cloudera.hiveserver1.sqlengine.parser.type.PTPositionalType;
import com.cloudera.hiveserver1.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.hiveserver1.support.exceptions.DiagState;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;

public class AEValueExprBuilder
extends AEBuilderBase<AEValueExpr> {
    public AEValueExprBuilder(AEQueryScope aEQueryScope) {
        super(aEQueryScope);
    }

    @Override
    public AEValueExpr visit(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        switch (pTNonterminalNode.getNonterminalType()) {
            case COLUMN_REFERENCE: {
                return new AEColumnReferenceBuilder(this.getQueryScope()).visit(pTNonterminalNode);
            }
            case BINARY_PLUS_SIGN: 
            case BINARY_MINUS_SIGN: 
            case MULTIPLICATION_SIGN: 
            case DIVISION_SIGN: 
            case CONCAT_SIGN: {
                return this.buildBinaryArithmetic(pTNonterminalNode);
            }
            case UNARY_MINUS_SIGN: {
                return this.buildUnaryMinusSign(pTNonterminalNode);
            }
            case FUNC: {
                return new AEScalarFnBuilder(this.getQueryScope()).visit(pTNonterminalNode);
            }
            case COUNT: 
            case AVG: 
            case SUM: 
            case MIN: 
            case MAX: {
                return new AEAggrFnBuilder(this.getQueryScope()).visit(pTNonterminalNode);
            }
            case SEARCHED_CASE: 
            case SIMPLE_CASE: 
            case COALESCE: 
            case NULLIF: {
                return new AECaseExprBuilder(this.getQueryScope()).visit(pTNonterminalNode);
            }
            case SUBQUERY: {
                return this.buildValueSubQuery(pTNonterminalNode);
            }
            case NOT: {
                return this.buildBooleanValueFromNotExpression(pTNonterminalNode);
            }
        }
        throw SQLEngineExceptionFactory.featureNotImplementedException("Unsupported value expression.");
    }

    @Override
    public AEValueExpr visit(PTLiteralNode pTLiteralNode) throws ErrorException {
        if (null == pTLiteralNode) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        if (pTLiteralNode.getLiteralType() == PTLiteralType.NULL) {
            return new AENull();
        }
        return new AELiteral(pTLiteralNode.getStringValue(), pTLiteralNode.getLiteralType(), this.getQueryScope().getDataEngine().getContext());
    }

    @Override
    public AEValueExpr visit(PTDefaultParameterNode pTDefaultParameterNode) throws ErrorException {
        return new AEDefaultParameter();
    }

    @Override
    public AEValueExpr visit(PTDynamicParameterNode pTDynamicParameterNode) throws ErrorException {
        SqlDataEngineContext sqlDataEngineContext = this.getQueryScope().getDataEngine().getContext();
        return new AEParameter(pTDynamicParameterNode.getIndex(), sqlDataEngineContext);
    }

    @Override
    public AEValueExpr visit(PTFlagNode pTFlagNode) throws ErrorException {
        switch (pTFlagNode.getFlagType()) {
            case DEFAULT: {
                return new AEDefault();
            }
        }
        throw SQLEngineExceptionFactory.invalidParseTreeException();
    }

    private AEValueSubQuery buildValueSubQuery(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        IPTNode iPTNode = pTNonterminalNode.getChild(PTPositionalType.SINGLE_CHILD);
        if (1 != pTNonterminalNode.numChildren() || null == iPTNode) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        AERelationalExprBuilder aERelationalExprBuilder = new AERelationalExprBuilder(this.getQueryScope(), true);
        AERelationalExpr aERelationalExpr = (AERelationalExpr)aERelationalExprBuilder.build(iPTNode);
        if (1 != aERelationalExpr.getColumnCount()) {
            throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.MULTI_EXPR_IN_SUB_QUERY.name());
        }
        return new AEValueSubQuery(aERelationalExpr, aERelationalExprBuilder.isQueryCorrelated());
    }

    private AENegate buildUnaryMinusSign(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        return new AENegate(pTNonterminalNode.getChild(PTPositionalType.SINGLE_CHILD).acceptVisitor(this), this.getQueryScope().getDataEngine().getContext());
    }

    private AEValueExpr buildBinaryArithmetic(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        AEBuilderCheck.checkThat(pTNonterminalNode, AEBuilderCheck.nonTerminal().withExactChildren(PTPositionalType.BINARY_LEFT, AEBuilderCheck.nonEmpty(), PTPositionalType.BINARY_RIGHT, AEBuilderCheck.nonEmpty()));
        AEValueExpr aEValueExpr = (AEValueExpr)new AEValueExprBuilder(this.getQueryScope()).build(pTNonterminalNode.getChild(PTPositionalType.BINARY_LEFT));
        AEValueExpr aEValueExpr2 = (AEValueExpr)new AEValueExprBuilder(this.getQueryScope()).build(pTNonterminalNode.getChild(PTPositionalType.BINARY_RIGHT));
        ICoercionHandler iCoercionHandler = this.getQueryScope().getDataEngine().createCoercionHandler();
        switch (pTNonterminalNode.getNonterminalType()) {
            case BINARY_PLUS_SIGN: {
                return new AEAdd(iCoercionHandler, aEValueExpr, aEValueExpr2);
            }
            case CONCAT_SIGN: {
                return new AEConcat(iCoercionHandler, aEValueExpr, aEValueExpr2);
            }
            case BINARY_MINUS_SIGN: {
                return new AESubtract(iCoercionHandler, aEValueExpr, aEValueExpr2);
            }
            case MULTIPLICATION_SIGN: {
                return new AEMultiply(iCoercionHandler, aEValueExpr, aEValueExpr2);
            }
            case DIVISION_SIGN: {
                return new AEDivide(iCoercionHandler, aEValueExpr, aEValueExpr2);
            }
        }
        throw SQLEngineExceptionFactory.invalidParseTreeException();
    }

    private AEBooleanValueExpr buildBooleanValueFromNotExpression(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        IPTNode iPTNode = pTNonterminalNode.getChild(PTPositionalType.VALUE_EXPRESSION);
        if (1 != pTNonterminalNode.numChildren() || null == iPTNode) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        AEValueExpr aEValueExpr = (AEValueExpr)new AEValueExprBuilder(this.getQueryScope()).build(iPTNode);
        AENot aENot = new AENot(new AEValueAsBooleanExpr(aEValueExpr));
        return new AEBooleanValueExpr(aENot);
    }
}

