/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value;

import com.cloudera.hiveserver1.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.metadatautil.AECoercionColumnInfo;
import com.cloudera.hiveserver1.sqlengine.dsiext.dataengine.CustomScalarFunction;
import com.cloudera.hiveserver1.sqlengine.dsiext.dataengine.IColumnInfo;
import com.cloudera.hiveserver1.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class AECustomScalarFn
extends AEValueExpr {
    private CustomScalarFunction m_customScalarFn;
    private AEValueExprList m_arguments;

    public AECustomScalarFn(CustomScalarFunction customScalarFunction, AEValueExprList aEValueExprList) throws ErrorException {
        if (null == customScalarFunction) {
            throw new NullPointerException();
        }
        this.m_customScalarFn = customScalarFunction;
        this.m_arguments = aEValueExprList;
        aEValueExprList.setParent(this);
        this.initializeColumn(true);
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    @Override
    public AECustomScalarFn copy() {
        try {
            return new AECustomScalarFn(this.m_customScalarFn, this.m_arguments.copy());
        }
        catch (ErrorException errorException) {
            throw new AssertionError();
        }
    }

    public AEValueExprList getArguments() {
        return this.m_arguments;
    }

    @Override
    public Iterator<? extends IAENode> getChildItr() {
        return new AbstractList<AEValueExprList>(){

            @Override
            public AEValueExprList get(int n) {
                if (0 == n) {
                    return AECustomScalarFn.this.getArguments();
                }
                throw new IndexOutOfBoundsException("" + n);
            }

            @Override
            public int size() {
                return 1;
            }
        }.iterator();
    }

    @Override
    public IColumn getColumn() {
        IColumn iColumn = this.m_customScalarFn.getOutputMetadata();
        assert (null != iColumn);
        return iColumn;
    }

    public CustomScalarFunction getDSICustomScalarFn() {
        return this.m_customScalarFn;
    }

    public List<IColumn> getInputMetadata() {
        List<IColumn> list = this.m_customScalarFn.getInputMetadata();
        assert (null != list);
        return list;
    }

    @Override
    public String getLogString() {
        return "AECustomScalarFn: " + this.m_customScalarFn.getName();
    }

    @Override
    public int getNumChildren() {
        return 1;
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        if (this == iAENode) {
            return true;
        }
        if (!(iAENode instanceof AECustomScalarFn)) {
            return false;
        }
        AECustomScalarFn aECustomScalarFn = (AECustomScalarFn)iAENode;
        return this.m_customScalarFn == aECustomScalarFn.m_customScalarFn && this.m_arguments.isEquivalent(aECustomScalarFn.m_arguments);
    }

    @Override
    public void updateColumn() throws ErrorException {
        this.initializeColumn(false);
    }

    private void initializeColumn(boolean bl) throws ErrorException {
        int n = this.m_arguments.getNumChildren();
        List<IColumnInfo> list = this.columnInfoFromArguments();
        this.m_customScalarFn.updateMetadata(list, bl);
        List<IColumn> list2 = this.m_customScalarFn.getInputMetadata();
        if (null == list2 || n != list2.size()) {
            throw SQLEngineExceptionFactory.invalidCustomScalarFnMetadataException(this.m_customScalarFn.getName());
        }
        for (int i = 0; i < n; ++i) {
            if (null != list2.get(i)) continue;
            throw SQLEngineExceptionFactory.invalidCustomScalarFnMetadataException(this.m_customScalarFn.getName());
        }
        IColumn iColumn = this.m_customScalarFn.getOutputMetadata();
        if (null == iColumn) {
            throw SQLEngineExceptionFactory.invalidCustomScalarFnMetadataException(this.m_customScalarFn.getName());
        }
    }

    private List<IColumnInfo> columnInfoFromArguments() {
        int n = this.m_arguments.getNumChildren();
        ArrayList<IColumnInfo> arrayList = new ArrayList<IColumnInfo>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new AECoercionColumnInfo((AEValueExpr)this.m_arguments.getChild(i)));
        }
        return arrayList;
    }
}

