/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.aeprocessor.metadatautil;

import com.cloudera.hiveserver1.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.util.HashMap;
import java.util.Map;

public enum SqlTypes {
    SQL_BINARY(-2){

        @Override
        public boolean isBinary() {
            return true;
        }
    }
    ,
    SQL_VARBINARY(-3){

        @Override
        public boolean isBinary() {
            return true;
        }
    }
    ,
    SQL_LONGVARBINARY(-4){

        @Override
        public boolean isBinary() {
            return true;
        }
    }
    ,
    SQL_CHAR(1){

        @Override
        public boolean isChar() {
            return true;
        }
    }
    ,
    SQL_VARCHAR(12){

        @Override
        public boolean isChar() {
            return true;
        }
    }
    ,
    SQL_LONGVARCHAR(-1){

        @Override
        public boolean isChar() {
            return true;
        }
    }
    ,
    SQL_WCHAR(-8){

        @Override
        public boolean isWChar() {
            return true;
        }
    }
    ,
    SQL_WVARCHAR(-9){

        @Override
        public boolean isWChar() {
            return true;
        }
    }
    ,
    SQL_WLONGVARCHAR(-10){

        @Override
        public boolean isWChar() {
            return true;
        }
    }
    ,
    SQL_BIT(-7){

        @Override
        public boolean isNumber() {
            return true;
        }
    }
    ,
    SQL_TINYINT(-6){

        @Override
        public boolean isNumber() {
            return true;
        }

        @Override
        public boolean isInteger() {
            return true;
        }
    }
    ,
    SQL_SMALLINT(5){

        @Override
        public boolean isNumber() {
            return true;
        }

        @Override
        public boolean isInteger() {
            return true;
        }
    }
    ,
    SQL_INTEGER(4){

        @Override
        public boolean isNumber() {
            return true;
        }

        @Override
        public boolean isInteger() {
            return true;
        }
    }
    ,
    SQL_BIGINT(-5){

        @Override
        public boolean isNumber() {
            return true;
        }

        @Override
        public boolean isInteger() {
            return true;
        }
    }
    ,
    SQL_NUMERIC(2){

        @Override
        public boolean isNumber() {
            return true;
        }

        @Override
        public boolean isExactNum() {
            return true;
        }
    }
    ,
    SQL_DECIMAL(3){

        @Override
        public boolean isNumber() {
            return true;
        }

        @Override
        public boolean isExactNum() {
            return true;
        }
    }
    ,
    SQL_REAL(7){

        @Override
        public boolean isNumber() {
            return true;
        }

        @Override
        public boolean isApproximateNum() {
            return true;
        }
    }
    ,
    SQL_FLOAT(6){

        @Override
        public boolean isNumber() {
            return true;
        }

        @Override
        public boolean isApproximateNum() {
            return true;
        }
    }
    ,
    SQL_DOUBLE(8){

        @Override
        public boolean isNumber() {
            return true;
        }

        @Override
        public boolean isApproximateNum() {
            return true;
        }
    }
    ,
    SQL_DATE(91){

        @Override
        public boolean isDateTime() {
            return true;
        }
    }
    ,
    SQL_TIMESTAMP(93){

        @Override
        public boolean isDateTime() {
            return true;
        }
    }
    ,
    SQL_TIME(92){

        @Override
        public boolean isDateTime() {
            return true;
        }
    }
    ,
    SQL_BOOLEAN(16),
    SQL_NULL(0),
    SQL_GUID(-11),
    SQL_ARRAY(2003);

    private static Map<Integer, SqlTypes> s_sqlTypeToValue;
    private final int m_sqlType;

    private SqlTypes(int n2) {
        this.m_sqlType = n2;
    }

    public int getSqlType() {
        return this.m_sqlType;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isExactNum() {
        return false;
    }

    public boolean isInterval() {
        return false;
    }

    public boolean isInteger() {
        return false;
    }

    public boolean isChar() {
        return false;
    }

    public boolean isWChar() {
        return false;
    }

    public boolean isBinary() {
        return false;
    }

    public boolean isDateTime() {
        return false;
    }

    public boolean isApproximateNum() {
        return false;
    }

    public static SqlTypes getValueOf(int n) throws ErrorException {
        if (!s_sqlTypeToValue.containsKey(n)) {
            throw SQLEngineExceptionFactory.unsupportedTypesException("" + n);
        }
        return s_sqlTypeToValue.get(n);
    }

    static {
        s_sqlTypeToValue = new HashMap<Integer, SqlTypes>();
        for (SqlTypes sqlTypes : SqlTypes.values()) {
            s_sqlTypeToValue.put(sqlTypes.getSqlType(), sqlTypes);
        }
    }
}

