/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.dsiext.dataengine;

import com.cloudera.hiveserver1.dsi.dataengine.utilities.ExecutionContext;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.ExecutionContexts;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.ExecutionResult;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.ExecutionResults;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.ParameterInputValue;
import com.cloudera.hiveserver1.sqlengine.dsiext.dataengine.IExecutionContext;
import com.cloudera.hiveserver1.sqlengine.executor.IStatementExecutor;
import com.cloudera.hiveserver1.sqlengine.executor.etree.ETCancelState;
import com.cloudera.hiveserver1.support.IWarningListener;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

abstract class AbstractExecutionContext
implements IExecutionContext {
    protected final ExecutionContexts m_contexts;
    protected final Map<Integer, ParameterInputValue[]> m_pushedParams;
    protected final List<IExecutionContext.Listener> m_listeners = new ArrayList<IExecutionContext.Listener>();
    private final ETCancelState m_cancelState;

    public AbstractExecutionContext(ExecutionContexts executionContexts, Map<Integer, ParameterInputValue[]> map, ETCancelState eTCancelState) {
        this.m_contexts = executionContexts;
        this.m_pushedParams = map;
        this.m_cancelState = eTCancelState;
    }

    protected boolean isCanceled() {
        return this.m_cancelState.isCanceled();
    }

    public abstract ExecutionResults execute(IWarningListener var1) throws ErrorException;

    protected ExecutionResult executeOne(IStatementExecutor iStatementExecutor, ExecutionContext executionContext, long l) throws ErrorException {
        ParameterInputValue[] parameterInputValueArray;
        if (this.m_pushedParams != null && (parameterInputValueArray = this.m_pushedParams.get((int)l)) != null) {
            for (int i = 1; i < parameterInputValueArray.length; ++i) {
                if (parameterInputValueArray[i] == null) continue;
                executionContext.setInputParam(i - 1, parameterInputValueArray[i]);
            }
        }
        return iStatementExecutor.execute(executionContext);
    }

    protected void notifyStartingParameterSet(long l) {
        for (IExecutionContext.Listener listener : this.m_listeners) {
            listener.onNewParameterSet(l);
        }
    }

    protected void notifyFinishedParameterSet(long l) {
        for (IExecutionContext.Listener listener : this.m_listeners) {
            listener.onParameterSetComplete(l);
        }
    }

    protected void notifyParameterSetFailed(long l) {
        for (IExecutionContext.Listener listener : this.m_listeners) {
            listener.onParameterSetFailed(l);
        }
    }

    @Override
    public long getParameterSetCount() {
        return this.m_contexts.getCount();
    }

    @Override
    public void registerListener(IExecutionContext.Listener listener) {
        if (listener == null) {
            throw null;
        }
        this.m_listeners.add(listener);
    }
}

