/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.executor.etree.bool;

import com.cloudera.hiveserver1.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver1.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.hiveserver1.sqlengine.executor.etree.ETBoolean;
import com.cloudera.hiveserver1.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.hiveserver1.sqlengine.executor.etree.IETNode;
import com.cloudera.hiveserver1.sqlengine.executor.etree.IETNodeVisitor;
import com.cloudera.hiveserver1.sqlengine.executor.etree.bool.ETBooleanExpr;
import com.cloudera.hiveserver1.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;

public class ETValueAsBooleanExpr
extends ETBooleanExpr {
    private ETValueExpr m_operand;
    private IColumn m_srcMeta;

    public ETValueAsBooleanExpr(ETValueExpr eTValueExpr, IColumn iColumn) throws ErrorException {
        this.m_operand = eTValueExpr;
        this.m_srcMeta = iColumn;
    }

    @Override
    public void close(boolean bl) {
        this.m_operand.close(bl);
    }

    @Override
    public boolean isOpen() {
        return this.m_operand.isOpen();
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public void reset() throws ErrorException {
        this.m_operand.reset();
    }

    @Override
    public int getNumChildren() {
        return 1;
    }

    @Override
    public void open() throws ErrorException {
        this.m_operand.open();
    }

    @Override
    public ETBoolean evaluate() throws ErrorException {
        ETDataRequest eTDataRequest = new ETDataRequest(this.m_srcMeta);
        eTDataRequest.setMaxBytes(-1L);
        eTDataRequest.setOffset(0L);
        this.m_operand.retrieveData(eTDataRequest);
        ISqlDataWrapper iSqlDataWrapper = eTDataRequest.getData();
        assert (iSqlDataWrapper.getType() == 16 || iSqlDataWrapper.getType() == -7);
        return ETBoolean.fromBoolean(iSqlDataWrapper.isNull() ? null : new Boolean(iSqlDataWrapper.getBoolean()));
    }

    @Override
    protected IETNode getChild(int n) throws IndexOutOfBoundsException {
        if (0 == n) {
            return this.m_operand;
        }
        throw new IndexOutOfBoundsException();
    }
}

