/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.executor.etree.relation.join;

import com.cloudera.hiveserver1.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.CursorType;
import com.cloudera.hiveserver1.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver1.sqlengine.executor.IWarningSource;
import com.cloudera.hiveserver1.sqlengine.executor.conversions.ConversionUtil;
import com.cloudera.hiveserver1.sqlengine.executor.conversions.ISqlConverter;
import com.cloudera.hiveserver1.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.hiveserver1.sqlengine.executor.etree.IETNode;
import com.cloudera.hiveserver1.sqlengine.executor.etree.IETNodeVisitor;
import com.cloudera.hiveserver1.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.cloudera.hiveserver1.support.IWarningListener;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;

class ETConvertColRelation
extends ETRelationalExpr
implements IWarningSource {
    private final ETRelationalExpr m_wrapped;
    private final ISqlConverter[] m_converters;
    private final Integer[] m_extraColMap;
    private final int m_colCount;
    private final IColumn[] m_extraCols;
    private IWarningListener m_warningListener;
    private final ETDataRequest[] m_convertDR;

    public ETConvertColRelation(ETRelationalExpr eTRelationalExpr, IColumn[] iColumnArray, Integer[] integerArray, ISqlConverter[] iSqlConverterArray, boolean[] blArray) {
        super(blArray);
        assert (blArray.length == iColumnArray.length + eTRelationalExpr.getColumnCount());
        this.m_wrapped = eTRelationalExpr;
        this.m_extraColMap = integerArray;
        this.m_converters = iSqlConverterArray;
        this.m_extraCols = iColumnArray;
        this.m_colCount = this.m_wrapped.getColumnCount() + this.m_extraColMap.length;
        this.m_convertDR = new ETDataRequest[this.m_extraColMap.length];
        for (int i = 0; i < this.m_convertDR.length; ++i) {
            assert (null != this.m_converters[i]);
            this.m_convertDR[i] = new ETDataRequest(this.m_wrapped.getColumn(this.m_extraColMap[i]));
        }
    }

    @Override
    public void close(boolean bl) {
        this.m_wrapped.close(bl);
    }

    @Override
    public boolean isOpen() {
        return this.m_wrapped.isOpen();
    }

    @Override
    public void reset() throws ErrorException {
        this.m_wrapped.reset();
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        throw new IllegalStateException("Cannot visit ETConvertColRelation because it is not part of the ETree.");
    }

    @Override
    public int getNumChildren() {
        return 0;
    }

    @Override
    public IColumn getColumn(int n) {
        if (n < this.m_wrapped.getColumnCount()) {
            return this.m_wrapped.getColumn(n);
        }
        return this.m_extraCols[n - this.m_wrapped.getColumnCount()];
    }

    @Override
    public int getColumnCount() {
        return this.m_colCount;
    }

    @Override
    public boolean getDataNeeded(int n) {
        assert (n >= 0 && n < this.m_colCount);
        if (n < this.m_wrapped.getColumnCount()) {
            return super.getDataNeeded(n);
        }
        return true;
    }

    @Override
    public long getRowCount() throws ErrorException {
        return this.m_wrapped.getRowCount();
    }

    @Override
    public void open(CursorType cursorType) throws ErrorException {
        this.m_wrapped.open(cursorType);
    }

    @Override
    public boolean retrieveData(int n, ETDataRequest eTDataRequest) throws ErrorException {
        if (n < this.m_wrapped.getColumnCount()) {
            return this.m_wrapped.retrieveData(n, eTDataRequest);
        }
        int n2 = n - this.m_wrapped.getColumnCount();
        ETDataRequest eTDataRequest2 = this.m_convertDR[n2];
        boolean bl = this.m_wrapped.retrieveData(this.m_extraColMap[n2], eTDataRequest2);
        if (bl) {
            throw SQLEngineExceptionFactory.joinOnLongData(n);
        }
        return ConversionUtil.doConvert(eTDataRequest, eTDataRequest2.getData(), this.m_converters[n2], this.m_warningListener, false);
    }

    @Override
    protected IETNode getChild(int n) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException();
    }

    @Override
    protected boolean doMove() throws ErrorException {
        return this.m_wrapped.move();
    }

    @Override
    public void registerWarningListener(IWarningListener iWarningListener) {
        this.m_warningListener = iWarningListener;
    }
}

