/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.executor.etree.value.scalar;

import com.cloudera.hiveserver1.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver1.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.hiveserver1.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.hiveserver1.sqlengine.executor.etree.util.DataRetrievalUtil;
import com.cloudera.hiveserver1.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.hiveserver1.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.text.DateFormatSymbols;
import java.util.List;

public final class ETMonthNameFn
extends ETScalarFn {
    private final int m_columnLength;
    private String[] m_monthNames;

    public ETMonthNameFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        if (1 != list.size() || 1 != list2.size()) {
            throw new IllegalArgumentException("Invalid Number of arguments for MONTHNAME scalar function.");
        }
        short s = list2.get(0).getTypeMetadata().getType();
        if (91 != s) {
            throw new IllegalArgumentException();
        }
        this.m_columnLength = (int)Math.min(Integer.MAX_VALUE, iColumn.getColumnLength());
    }

    @Override
    public String getLogString() {
        return "ETMonthNameFn";
    }

    @Override
    public void open() throws ErrorException {
        super.open();
        this.m_monthNames = new DateFormatSymbols().getMonths();
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0);
        if (!iSqlDataWrapper.isNull()) {
            String[] stringArray = this.m_monthNames;
            String string = stringArray[iSqlDataWrapper.getDate().getMonth()];
            eTDataRequest.getData().setChar(string);
            return DataRetrievalUtil.retrieveCharData(eTDataRequest.getData(), eTDataRequest.getOffset(), eTDataRequest.getMaxSize(), this.m_columnLength, this.getWarningListener());
        }
        eTDataRequest.getData().setNull();
        return false;
    }
}

