/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.utilities;

import com.cloudera.hiveserver1.dsi.core.impl.DSIDriverSingleton;
import com.cloudera.hiveserver1.dsi.core.interfaces.IDriver;
import com.cloudera.hiveserver1.dsi.core.utilities.Variant;
import com.cloudera.hiveserver1.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver1.dsi.exceptions.IncorrectTypeException;
import com.cloudera.hiveserver1.dsi.exceptions.NumericOverflowException;
import com.cloudera.hiveserver1.sqlengine.dsiext.dataengine.SqlDataEngine;
import com.cloudera.hiveserver1.sqlengine.dsiext.dataengine.mem.MemoryManager;
import com.cloudera.hiveserver1.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver1.sqlengine.executor.etree.ETResourceManager;
import com.cloudera.hiveserver1.sqlengine.executor.etree.ETTempFolderResource;
import com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.cloudera.hiveserver1.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.hiveserver1.support.ILogger;
import com.cloudera.hiveserver1.support.IWarningListener;
import com.cloudera.hiveserver1.support.Warning;
import com.cloudera.hiveserver1.support.WarningCode;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.io.File;
import java.io.IOException;

public class ExternalAlgorithmUtil {
    private static final String PACKAGE_NAME = "com.cloudera.sqlengine.utilities";
    private static final String CLASS_NAME = "ExternalAlgorithmUtil";

    public static ExternalAlgorithmProperties createProperties(SqlDataEngine sqlDataEngine, ILogger iLogger, IWarningListener iWarningListener, ETResourceManager eTResourceManager) throws ErrorException {
        int n = 0;
        long l = 0L;
        long l2 = MemoryManager.getInstance().getTotalMemory();
        int n2 = 0;
        try {
            n = sqlDataEngine.getProperty(14).getInt();
            l = sqlDataEngine.getProperty(13).getLong();
            n2 = sqlDataEngine.getProperty(16).getInt();
        }
        catch (NumericOverflowException numericOverflowException) {
            throw SQLEngineExceptionFactory.invalidConfiguration(numericOverflowException);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw SQLEngineExceptionFactory.invalidConfiguration(incorrectTypeException);
        }
        if (l2 <= l) {
            if (null != iWarningListener) {
                iWarningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 7, SQLEngineMessageKey.INVALID_CONFIG.name()));
            }
            if (null != iLogger) {
                iLogger.logWarning(PACKAGE_NAME, CLASS_NAME, "createProperties", "Recommended block size is larger that total available memory.");
            }
            if (0L >= (l = l2 / 5L)) {
                throw SQLEngineExceptionFactory.invalidConfiguration();
            }
        }
        if ((long)n > l) {
            if (null != iWarningListener) {
                iWarningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 7, SQLEngineMessageKey.INVALID_CONFIG.name()));
            }
            if (null != iLogger) {
                iLogger.logWarning(PACKAGE_NAME, CLASS_NAME, "createProperties", "Max in-memory data size is larger than recommended block size.");
            }
            if (0 >= (n = (int)(l - 1L))) {
                throw SQLEngineExceptionFactory.invalidConfiguration();
            }
        }
        if (n2 < 4) {
            if (null != iWarningListener) {
                iWarningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 7, SQLEngineMessageKey.INVALID_CONFIG.name()));
            }
            if (null != iLogger) {
                iLogger.logWarning(PACKAGE_NAME, CLASS_NAME, "createProperties", "Invalid value (" + n2 + ") for maximum number of open files per node.");
            }
            n2 = 4;
        }
        return new ExternalAlgorithmProperties(n, l, n2, iLogger, eTResourceManager);
    }

    public static long calculateRowSize(Iterable<IColumn> iterable, boolean[] blArray, int n) {
        long l = 0L;
        int n2 = 0;
        for (IColumn iColumn : iterable) {
            l = (long)((double)l + Math.ceil(ColumnSizeCalculator.getColumnSizePerRow(iColumn, blArray[n2], n)));
            l = (long)((double)l + Math.ceil(ColumnSizeCalculator.getOverHeadPerRow(iColumn, blArray[n2], n)));
            ++n2;
        }
        return l;
    }

    public static File createTempFile(File file, ILogger iLogger) throws ErrorException {
        if (null == file || !file.isDirectory()) {
            throw new IllegalArgumentException("The File passed in is not a direcotry.");
        }
        String string = "Unknown";
        try {
            File file2 = File.createTempFile("sql_", null, file);
            string = file2.getAbsolutePath();
            if (!file2.canRead() || !file2.canWrite()) {
                if (null != iLogger) {
                    iLogger.logError(PACKAGE_NAME, CLASS_NAME, "RowFile", "Could not create temporary file.");
                }
                throw SQLEngineExceptionFactory.failedToCreateFile(string);
            }
            return file2;
        }
        catch (IOException iOException) {
            if (null != iLogger) {
                iLogger.logError(PACKAGE_NAME, CLASS_NAME, "RowFile", "Could not create temporary file.");
            }
            throw SQLEngineExceptionFactory.failedToCreateFile(string, iOException.getLocalizedMessage());
        }
    }

    private static void mkdir(File file) throws ErrorException {
        if (file.exists() && !file.isDirectory()) {
            file.delete();
        }
        file.mkdir();
        file.deleteOnExit();
        if (!(file.exists() && file.isDirectory() && file.canRead() && file.canWrite())) {
            throw SQLEngineExceptionFactory.failedToCreateFile(file.getAbsolutePath());
        }
    }

    private static class TmpFileDirHolder {
        private static File TEMP_DIR = TmpFileDirHolder.getTempFileDir();

        private TmpFileDirHolder() {
        }

        private static File getTempFileDir() {
            try {
                Object object;
                String string = null;
                IDriver iDriver = DSIDriverSingleton.getInstance();
                if (null != iDriver && null != (object = iDriver.getProperty(1006))) {
                    string = ((Variant)object).getString();
                }
                if (string == null || string.equals("")) {
                    string = System.getProperty("java.io.tmpdir");
                }
                assert (string != null);
                object = new File(string);
                ExternalAlgorithmUtil.mkdir((File)object);
                return object;
            }
            catch (Exception exception) {
                throw new ExceptionInInitializerError(exception);
            }
        }
    }

    public static class ExternalAlgorithmProperties {
        private final int m_cellMemoryLimit;
        private final long m_blockSize;
        private final int m_maxOpenFiles;
        private final ILogger m_logger;
        private File m_storageDir = null;
        private final ETResourceManager m_rManager;

        private ExternalAlgorithmProperties(int n, long l, int n2, ILogger iLogger, ETResourceManager eTResourceManager) {
            assert (n > 0);
            assert (l > 0L);
            this.m_cellMemoryLimit = n;
            this.m_blockSize = l;
            this.m_maxOpenFiles = n2;
            this.m_logger = iLogger;
            this.m_rManager = eTResourceManager;
        }

        public int getCellMemoryLimit() {
            return this.m_cellMemoryLimit;
        }

        public long getBlockSize() {
            return this.m_blockSize;
        }

        public File getStorageDir() throws ErrorException {
            if (null == this.m_storageDir) {
                File file = null;
                try {
                    file = TmpFileDirHolder.TEMP_DIR;
                }
                catch (ExceptionInInitializerError exceptionInInitializerError) {
                    throw SQLEngineExceptionFactory.failedToCreateFile("SQLENGINE_TEMP_FILE_DIRECTORY", exceptionInInitializerError.getLocalizedMessage());
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    throw SQLEngineExceptionFactory.failedToCreateFile("SQLENGINE_TEMP_FILE_DIRECTORY", noClassDefFoundError.getLocalizedMessage());
                }
                assert (file != null);
                File file2 = ExternalAlgorithmUtil.createTempFile(file, null);
                ExternalAlgorithmUtil.mkdir(file2);
                this.m_storageDir = file2;
                ETTempFolderResource eTTempFolderResource = new ETTempFolderResource(this.m_storageDir, this.m_logger);
                this.m_rManager.registerResource(eTTempFolderResource);
            }
            return this.m_storageDir;
        }

        public ILogger getLogger() {
            return this.m_logger;
        }

        public int getMaxNumOpenFiles() {
            return this.m_maxOpenFiles;
        }
    }
}

