/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.utilities.conversion;

import com.cloudera.hiveserver1.dsi.core.interfaces.IBlobFactory;
import com.cloudera.hiveserver1.dsi.core.interfaces.IClobFactory;
import com.cloudera.hiveserver1.dsi.core.interfaces.IConnection;
import com.cloudera.hiveserver1.dsi.dataengine.interfaces.IArray;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.DSIMonthSpan;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.DSITimeSpan;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.TimeTz;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.TimestampTz;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.TypeUtilities;
import com.cloudera.hiveserver1.dsi.exceptions.IncorrectTypeException;
import com.cloudera.hiveserver1.dsi.utilities.CalendarSetter;
import com.cloudera.hiveserver1.dsi.utilities.StringConverter;
import com.cloudera.hiveserver1.exceptions.ExceptionConverter;
import com.cloudera.hiveserver1.exceptions.JDBCMessageKey;
import com.cloudera.hiveserver1.support.IWarningListener;
import com.cloudera.hiveserver1.support.Pair;
import com.cloudera.hiveserver1.support.Warning;
import com.cloudera.hiveserver1.support.WarningCode;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import com.cloudera.hiveserver1.support.exceptions.ExceptionType;
import com.cloudera.hiveserver1.utilities.TypeNames;
import com.cloudera.hiveserver1.utilities.conversion.IntervalConverter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;

public class TypeConverter {
    private static final int TWO_TO_8 = 256;
    private static final int TWO_TO_16 = 65536;
    private static final long TWO_TO_32 = 0x100000000L;
    private static final BigInteger TWO_TO_64;
    private static Map<Class<?>, Integer> CLASS_TO_TYPE_MAP;
    private static final Map<Integer, List<Integer>> TYPE_CONVERSION_MAP;
    private static final Map<String, String> NORMALIZE_DOUBLE_OR_FLOAT_MAP;
    private static final Map<Integer, List<Integer>> STREAM_FROM_CONVERSION_MAP;
    private static final Map<Integer, List<Integer>> STREAM_TO_CONVERSION_MAP;
    private static final char[] s_hexits;

    public static boolean canConvert(int n, int n2) {
        return TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, n, n2);
    }

    public static boolean canConvertStreamFrom(int n, int n2) {
        return TypeConverter.canConvertFrom(STREAM_FROM_CONVERSION_MAP, n, n2);
    }

    public static boolean canConvertStreamTo(int n, int n2) {
        return TypeConverter.canConvertFrom(STREAM_TO_CONVERSION_MAP, n, n2);
    }

    public static int getSqlType(Object object) {
        int n = 0;
        n = object instanceof DSIMonthSpan ? ((DSIMonthSpan)object).getIntervalType() : (object instanceof DSITimeSpan ? ((DSITimeSpan)object).getIntervalType() : (object instanceof Calendar ? CLASS_TO_TYPE_MAP.get(Calendar.class) : (object instanceof Struct ? 2002 : (object instanceof Blob ? 2004 : (object instanceof Clob ? 2005 : (CLASS_TO_TYPE_MAP.containsKey(object.getClass()) ? CLASS_TO_TYPE_MAP.get(object.getClass()) : 2000))))));
        return n;
    }

    public static BigDecimal toBigDecimal(DataWrapper dataWrapper, IWarningListener iWarningListener) throws IncorrectTypeException, SQLException {
        int n = dataWrapper.getType();
        if (TypeUtilities.isExactNumericType(n)) {
            if (dataWrapper.isNull()) {
                return null;
            }
            return (BigDecimal)dataWrapper.getObject();
        }
        if (!TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, dataWrapper, 3)) {
            throw new IncorrectTypeException();
        }
        if (dataWrapper.isNull()) {
            return null;
        }
        try {
            if (TypeUtilities.isBooleanType(n)) {
                return new BigDecimal(TypeConverter.toInt(dataWrapper, iWarningListener));
            }
            if (1 == n) {
                return new BigDecimal(TypeConverter.toString(dataWrapper, null).trim());
            }
            return new BigDecimal(TypeConverter.toString(dataWrapper, null));
        }
        catch (Throwable throwable) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, iWarningListener, ExceptionType.DATA, TypeNames.getTypeName(2));
        }
    }

    public static BigDecimal toBigDecimal(DataWrapper dataWrapper, TypeMetadata typeMetadata, IWarningListener iWarningListener) throws IncorrectTypeException, SQLException {
        int n = dataWrapper.getType();
        if (TypeUtilities.isExactNumericType(n)) {
            if (dataWrapper.isNull()) {
                return null;
            }
            return TypeConverter.rescaleBigDecimal((BigDecimal)dataWrapper.getObject(), typeMetadata.getScale(), iWarningListener);
        }
        if (!TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, dataWrapper, 3)) {
            throw new IncorrectTypeException();
        }
        if (dataWrapper.isNull()) {
            return null;
        }
        try {
            BigDecimal bigDecimal = null;
            bigDecimal = TypeUtilities.isBooleanType(n) ? new BigDecimal(TypeConverter.toInt(dataWrapper, iWarningListener)) : (TypeUtilities.isCharacterType(n) ? (1 == n ? new BigDecimal(((String)dataWrapper.getObject()).trim()) : new BigDecimal((String)dataWrapper.getObject())) : new BigDecimal(TypeConverter.toString(dataWrapper, typeMetadata)));
            return TypeConverter.rescaleBigDecimal(bigDecimal, typeMetadata.getScale(), iWarningListener);
        }
        catch (Throwable throwable) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, iWarningListener, ExceptionType.DATA, TypeNames.getTypeName(2));
        }
    }

    public static boolean toBoolean(DataWrapper dataWrapper, IWarningListener iWarningListener) throws IncorrectTypeException, SQLException {
        int n = dataWrapper.getType();
        if (-7 == n) {
            if (dataWrapper.isNull()) {
                return false;
            }
            return dataWrapper.getBit();
        }
        if (16 == n) {
            if (dataWrapper.isNull()) {
                return false;
            }
            return dataWrapper.getBoolean();
        }
        if (!TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, dataWrapper, -7)) {
            throw new IncorrectTypeException();
        }
        if (dataWrapper.isNull()) {
            return false;
        }
        try {
            if (TypeUtilities.isCharacterType(n)) {
                String string = (String)dataWrapper.getObject();
                if (1 == n) {
                    string = string.trim();
                }
                return !string.equalsIgnoreCase("false") && !string.equals("0") && !string.equals("0.0") && !string.equalsIgnoreCase("f");
            }
            return 0.0f != TypeConverter.toFloat(dataWrapper, iWarningListener);
        }
        catch (Throwable throwable) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, iWarningListener, ExceptionType.DATA, TypeNames.getTypeName(16));
        }
    }

    public static byte toByte(DataWrapper dataWrapper, IWarningListener iWarningListener) throws IncorrectTypeException, SQLException {
        int n = dataWrapper.getType();
        if (-6 == n) {
            if (dataWrapper.isNull()) {
                return 0;
            }
            return dataWrapper.getTinyInt().byteValue();
        }
        if (!TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, dataWrapper, -6)) {
            throw new IncorrectTypeException();
        }
        if (dataWrapper.isNull()) {
            return 0;
        }
        Object object = dataWrapper.getObject();
        try {
            switch (n) {
                case -7: 
                case 16: {
                    if (((Boolean)object).booleanValue()) {
                        return 1;
                    }
                    return 0;
                }
                case -8: 
                case 1: {
                    try {
                        return (byte)Long.parseLong(((String)object).trim());
                    }
                    catch (Exception exception) {
                        return (byte)Double.parseDouble(((String)object).trim());
                    }
                }
                case -10: 
                case -9: 
                case -1: 
                case 12: {
                    try {
                        return (byte)Long.parseLong((String)object);
                    }
                    catch (Exception exception) {
                        return (byte)Double.parseDouble((String)object);
                    }
                }
                case 2: 
                case 3: {
                    return ((BigDecimal)object).byteValue();
                }
            }
            return ((Number)object).byteValue();
        }
        catch (Throwable throwable) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, iWarningListener, ExceptionType.DATA, TypeNames.getTypeName(-6));
        }
    }

    public static byte[] toBytes(DataWrapper dataWrapper) throws IncorrectTypeException {
        int n = dataWrapper.getType();
        if (n == 0 && dataWrapper.isNull()) {
            return null;
        }
        if (TypeUtilities.isBinaryType(n)) {
            if (dataWrapper.isNull()) {
                return null;
            }
            switch (n) {
                case -2: {
                    return dataWrapper.getBinary();
                }
                case -3: {
                    return dataWrapper.getVarBinary();
                }
                case -4: {
                    return dataWrapper.getLongVarBinary();
                }
            }
        } else if (n == 2004) {
            Object object = dataWrapper.getObject();
            if (object == null) {
                return null;
            }
            if (object instanceof Blob) {
                try {
                    Blob blob = (Blob)object;
                    long l = blob.length();
                    if (l > Integer.MAX_VALUE) {
                        throw new OutOfMemoryError();
                    }
                    return ((Blob)object).getBytes(1L, (int)l);
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException);
                }
            }
            InputStream inputStream = (InputStream)object;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[32768];
            try {
                int n2;
                while ((n2 = inputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n2);
                }
                byteArrayOutputStream.flush();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            return byteArrayOutputStream.toByteArray();
        }
        throw new IncorrectTypeException();
    }

    private static Blob createNewBlob(IConnection iConnection, IWarningListener iWarningListener) throws SQLException {
        if (iConnection instanceof IBlobFactory) {
            return ((IBlobFactory)((Object)iConnection)).createBlob();
        }
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, iWarningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
    }

    private static Blob setBlobFromStream(Blob blob, InputStream inputStream) throws SQLException {
        try {
            int n;
            OutputStream outputStream = blob.setBinaryStream(1L);
            byte[] byArray = new byte[32768];
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            outputStream.flush();
            return blob;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static Blob toBlob(DataWrapper dataWrapper, IConnection iConnection, IWarningListener iWarningListener) throws IncorrectTypeException, SQLException, SQLFeatureNotSupportedException {
        switch (dataWrapper.getType()) {
            case 0: {
                return null;
            }
            case 2004: {
                Object object = dataWrapper.getBlob();
                if (object == null) {
                    return null;
                }
                if (object instanceof Blob) {
                    return (Blob)object;
                }
                return TypeConverter.setBlobFromStream(TypeConverter.createNewBlob(iConnection, iWarningListener), (InputStream)object);
            }
            case -4: 
            case -3: 
            case -2: {
                byte[] byArray = (byte[])dataWrapper.getObject();
                if (byArray == null) {
                    return null;
                }
                Blob blob = TypeConverter.createNewBlob(iConnection, iWarningListener);
                blob.setBytes(1L, byArray);
                return blob;
            }
        }
        throw new IncorrectTypeException();
    }

    private static Clob setClobFromReader(Clob clob, Reader reader) throws SQLException {
        assert (clob != null);
        Writer writer = clob.setCharacterStream(1L);
        char[] cArray = new char[32768];
        try {
            int n;
            while ((n = reader.read(cArray)) != -1) {
                writer.write(cArray, 0, n);
            }
            writer.flush();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return clob;
    }

    private static Clob createNewClob(IConnection iConnection, IWarningListener iWarningListener) throws SQLException {
        if (iConnection instanceof IClobFactory) {
            return ((IClobFactory)((Object)iConnection)).createClob();
        }
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, iWarningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
    }

    public static Clob toClob(DataWrapper dataWrapper, IConnection iConnection, IWarningListener iWarningListener) throws IncorrectTypeException, SQLException, SQLFeatureNotSupportedException {
        switch (dataWrapper.getType()) {
            case 0: {
                return null;
            }
            case 2005: {
                Object object = dataWrapper.getClob();
                if (object == null) {
                    return null;
                }
                if (object instanceof Clob) {
                    return (Clob)object;
                }
                return TypeConverter.setClobFromReader(TypeConverter.createNewClob(iConnection, iWarningListener), (Reader)object);
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                String string = (String)dataWrapper.getObject();
                if (string == null) {
                    return null;
                }
                Clob clob = TypeConverter.createNewClob(iConnection, iWarningListener);
                clob.setString(1L, string);
                return clob;
            }
        }
        throw new IncorrectTypeException();
    }

    public static Date toDate(DataWrapper dataWrapper, IWarningListener iWarningListener) throws IncorrectTypeException, SQLException {
        return TypeConverter.toDate(dataWrapper, null, iWarningListener);
    }

    public static Date toDate(DataWrapper dataWrapper, Calendar calendar, IWarningListener iWarningListener) throws IncorrectTypeException, SQLException {
        Object object;
        Date date = TypeConverter.convertToDate(dataWrapper, calendar, iWarningListener);
        if (!(null == date || (object = dataWrapper.getObject()) instanceof TimeTz || object instanceof TimestampTz || object instanceof String)) {
            date = CalendarSetter.getDate(date, calendar);
        }
        return date;
    }

    public static UUID toGUID(DataWrapper dataWrapper, IWarningListener iWarningListener) throws IncorrectTypeException, SQLException {
        int n = dataWrapper.getType();
        if (-11 == n) {
            return dataWrapper.getGuid();
        }
        if (!TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, dataWrapper, -11)) {
            throw new IncorrectTypeException();
        }
        if (dataWrapper.isNull()) {
            return null;
        }
        Object object = dataWrapper.getObject();
        try {
            return UUID.fromString((String)object);
        }
        catch (Throwable throwable) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, iWarningListener, ExceptionType.DATA, TypeNames.getTypeName(-11));
        }
    }

    public static double toDouble(DataWrapper dataWrapper, IWarningListener iWarningListener) throws IncorrectTypeException, SQLException {
        int n = dataWrapper.getType();
        if (8 == n) {
            if (dataWrapper.isNull()) {
                return 0.0;
            }
            return dataWrapper.getDouble();
        }
        if (!TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, dataWrapper, 8)) {
            throw new IncorrectTypeException();
        }
        if (dataWrapper.isNull()) {
            return 0.0;
        }
        Object object = dataWrapper.getObject();
        try {
            switch (n) {
                case -7: 
                case 16: {
                    if (((Boolean)object).booleanValue()) {
                        return 1.0;
                    }
                    return 0.0;
                }
                case -10: 
                case -9: 
                case -8: 
                case -1: 
                case 1: 
                case 12: {
                    return Double.parseDouble(TypeConverter.normalizeInfinityOrNaN((String)object));
                }
                case 2: 
                case 3: {
                    return ((BigDecimal)object).doubleValue();
                }
            }
            return ((Number)object).doubleValue();
        }
        catch (Throwable throwable) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, iWarningListener, ExceptionType.DATA, TypeNames.getTypeName(8));
        }
    }

    public static float toFloat(DataWrapper dataWrapper, IWarningListener iWarningListener) throws IncorrectTypeException, SQLException {
        int n = dataWrapper.getType();
        if (7 == n) {
            if (dataWrapper.isNull()) {
                return 0.0f;
            }
            return dataWrapper.getReal().floatValue();
        }
        if (!TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, dataWrapper, 7)) {
            throw new IncorrectTypeException();
        }
        if (dataWrapper.isNull()) {
            return 0.0f;
        }
        Object object = dataWrapper.getObject();
        try {
            switch (n) {
                case -7: 
                case 16: {
                    if (((Boolean)object).booleanValue()) {
                        return 1.0f;
                    }
                    return 0.0f;
                }
                case -10: 
                case -9: 
                case -8: 
                case -1: 
                case 1: 
                case 12: {
                    return Float.parseFloat(TypeConverter.normalizeInfinityOrNaN((String)object));
                }
                case 2: 
                case 3: {
                    return ((BigDecimal)object).floatValue();
                }
            }
            return ((Number)object).floatValue();
        }
        catch (Throwable throwable) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, iWarningListener, ExceptionType.DATA, TypeNames.getTypeName(7));
        }
    }

    public static int toInt(DataWrapper dataWrapper, IWarningListener iWarningListener) throws IncorrectTypeException, SQLException {
        int n = dataWrapper.getType();
        if (4 == n) {
            if (dataWrapper.isNull()) {
                return 0;
            }
            return dataWrapper.getInteger().intValue();
        }
        if (!TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, dataWrapper, 4)) {
            throw new IncorrectTypeException();
        }
        if (dataWrapper.isNull()) {
            return 0;
        }
        Object object = dataWrapper.getObject();
        try {
            switch (n) {
                case -7: 
                case 16: {
                    if (((Boolean)object).booleanValue()) {
                        return 1;
                    }
                    return 0;
                }
                case -8: 
                case 1: {
                    try {
                        return (int)Long.parseLong(((String)object).trim());
                    }
                    catch (Exception exception) {
                        return (int)Double.parseDouble(((String)object).trim());
                    }
                }
                case -10: 
                case -9: 
                case -1: 
                case 12: {
                    try {
                        return (int)Long.parseLong((String)object);
                    }
                    catch (Exception exception) {
                        return (int)Double.parseDouble((String)object);
                    }
                }
                case 2: 
                case 3: {
                    return ((BigDecimal)object).intValue();
                }
            }
            return ((Number)object).intValue();
        }
        catch (Throwable throwable) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, iWarningListener, ExceptionType.DATA, TypeNames.getTypeName(4));
        }
    }

    public static Object toInterval(DataWrapper dataWrapper, TypeMetadata typeMetadata, IWarningListener iWarningListener) throws IncorrectTypeException, SQLException {
        int n = dataWrapper.getType();
        short s = typeMetadata.getType();
        if (TypeUtilities.isIntervalType(n) && n == s) {
            if (dataWrapper.isNull()) {
                return null;
            }
            return dataWrapper.getObject();
        }
        if (!TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, dataWrapper, (int)s)) {
            throw new IncorrectTypeException();
        }
        if (dataWrapper.isNull()) {
            return null;
        }
        Object object = dataWrapper.getObject();
        try {
            switch (n) {
                case -1: 
                case 1: 
                case 12: {
                    return IntervalConverter.convertStringToInterval((String)object, typeMetadata, iWarningListener);
                }
            }
        }
        catch (Throwable throwable) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, iWarningListener, ExceptionType.DATA, TypeNames.getTypeName(4));
        }
        return null;
    }

    public static long toLong(DataWrapper dataWrapper, IWarningListener iWarningListener) throws IncorrectTypeException, SQLException {
        int n = dataWrapper.getType();
        if (-5 == n) {
            if (dataWrapper.isNull()) {
                return 0L;
            }
            return dataWrapper.getBigIntAsLong();
        }
        if (!TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, dataWrapper, -5)) {
            throw new IncorrectTypeException();
        }
        if (dataWrapper.isNull()) {
            return 0L;
        }
        Object object = dataWrapper.getObject();
        try {
            switch (n) {
                case -7: 
                case 16: {
                    if (((Boolean)object).booleanValue()) {
                        return 1L;
                    }
                    return 0L;
                }
                case -8: 
                case 1: {
                    return new BigDecimal(((String)object).trim()).longValue();
                }
                case -10: 
                case -9: 
                case -1: 
                case 12: {
                    return new BigDecimal((String)object).longValue();
                }
                case 2: 
                case 3: {
                    return ((BigDecimal)object).longValue();
                }
            }
            return ((Number)object).longValue();
        }
        catch (Throwable throwable) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, iWarningListener, ExceptionType.DATA, TypeNames.getTypeName(-5));
        }
    }

    public static BigInteger toBigInteger(DataWrapper dataWrapper, IWarningListener iWarningListener) throws IncorrectTypeException, SQLException {
        int n = dataWrapper.getType();
        if (-5 == n) {
            if (dataWrapper.isNull()) {
                return BigInteger.ZERO;
            }
            return dataWrapper.getBigInt();
        }
        if (!TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, dataWrapper, -5)) {
            throw new IncorrectTypeException();
        }
        if (dataWrapper.isNull()) {
            return BigInteger.ZERO;
        }
        Object object = dataWrapper.getObject();
        try {
            switch (n) {
                case -7: 
                case 16: {
                    if (((Boolean)object).booleanValue()) {
                        return BigInteger.ONE;
                    }
                    return BigInteger.ZERO;
                }
                case -8: 
                case 1: {
                    return new BigInteger(((String)object).trim());
                }
                case -10: 
                case -9: 
                case -1: 
                case 12: {
                    return new BigInteger((String)object);
                }
                case 2: 
                case 3: {
                    return ((BigDecimal)object).toBigInteger();
                }
            }
            return new BigInteger(((Number)object).toString());
        }
        catch (Throwable throwable) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, iWarningListener, ExceptionType.DATA, TypeNames.getTypeName(-5));
        }
    }

    @Deprecated
    public static Object toObject(DataWrapper dataWrapper, TypeMetadata typeMetadata, IWarningListener iWarningListener) throws IncorrectTypeException, SQLException {
        return TypeConverter.toObject(dataWrapper, typeMetadata, iWarningListener, null);
    }

    public static Object toObject(DataWrapper dataWrapper, TypeMetadata typeMetadata, IWarningListener iWarningListener, IConnection iConnection) throws IncorrectTypeException, SQLException {
        short s = typeMetadata.getType();
        if (!TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, s, 2000)) {
            throw new IncorrectTypeException();
        }
        if (dataWrapper.isNull()) {
            return null;
        }
        try {
            switch (s) {
                case 2004: {
                    if (iConnection == null) {
                        throw new RuntimeException("NULL parentConnection passed when converting to BLOB.");
                    }
                    return TypeConverter.toBlob(dataWrapper, iConnection, iWarningListener);
                }
                case 2005: {
                    if (iConnection == null) {
                        throw new RuntimeException("NULL parentConnection passed when converting to CLOB.");
                    }
                    return TypeConverter.toClob(dataWrapper, iConnection, iWarningListener);
                }
                case -10: 
                case -9: 
                case -8: 
                case -1: 
                case 1: 
                case 12: {
                    return TypeConverter.toString(dataWrapper, typeMetadata);
                }
                case -5: {
                    return TypeConverter.toLong(dataWrapper, iWarningListener);
                }
                case -6: 
                case 4: 
                case 5: {
                    return TypeConverter.toInt(dataWrapper, iWarningListener);
                }
                case 6: 
                case 8: {
                    return TypeConverter.toDouble(dataWrapper, iWarningListener);
                }
                case 7: {
                    return Float.valueOf(TypeConverter.toFloat(dataWrapper, iWarningListener));
                }
                case 2: 
                case 3: {
                    return TypeConverter.toBigDecimal(dataWrapper, iWarningListener);
                }
                case 91: {
                    return TypeConverter.toDate(dataWrapper, iWarningListener);
                }
                case 92: {
                    return TypeConverter.toTime(dataWrapper, typeMetadata, iWarningListener);
                }
                case 93: {
                    return TypeConverter.toTimestamp(dataWrapper, typeMetadata, iWarningListener);
                }
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: {
                    return TypeConverter.toInterval(dataWrapper, typeMetadata, iWarningListener);
                }
                case -11: {
                    return TypeConverter.toGUID(dataWrapper, iWarningListener);
                }
                case -7: 
                case 16: {
                    return TypeConverter.toBoolean(dataWrapper, iWarningListener);
                }
            }
            return dataWrapper.getObject();
        }
        catch (IncorrectTypeException incorrectTypeException) {
            return null;
        }
    }

    public static short toShort(DataWrapper dataWrapper, IWarningListener iWarningListener) throws IncorrectTypeException, SQLException {
        int n = dataWrapper.getType();
        if (5 == n) {
            if (dataWrapper.isNull()) {
                return 0;
            }
            return dataWrapper.getSmallInt().shortValue();
        }
        if (!TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, dataWrapper, 5)) {
            throw new IncorrectTypeException();
        }
        if (dataWrapper.isNull()) {
            return 0;
        }
        Object object = dataWrapper.getObject();
        try {
            switch (n) {
                default: {
                    return ((Number)object).shortValue();
                }
                case -7: 
                case 16: {
                    if (((Boolean)object).booleanValue()) {
                        return 1;
                    }
                    return 0;
                }
                case -8: 
                case 1: {
                    try {
                        return (short)Long.parseLong(((String)object).trim());
                    }
                    catch (Exception exception) {
                        return (short)Double.parseDouble(((String)object).trim());
                    }
                }
                case -10: 
                case -9: 
                case -1: 
                case 12: {
                    try {
                        return (short)Long.parseLong((String)object);
                    }
                    catch (Exception exception) {
                        return (short)Double.parseDouble((String)object);
                    }
                }
                case 2: 
                case 3: 
            }
            return ((BigDecimal)object).shortValue();
        }
        catch (Throwable throwable) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, iWarningListener, ExceptionType.DATA, TypeNames.getTypeName(5));
        }
    }

    private static void appendHexString(StringBuilder stringBuilder, byte[] byArray, int n) {
        stringBuilder.ensureCapacity(n * 2);
        for (int i = 0; i < n; ++i) {
            int n2 = 0xFF & byArray[i];
            stringBuilder.append(s_hexits[n2 >> 4]);
            stringBuilder.append(s_hexits[n2 & 0xF]);
        }
    }

    private static String toHexString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        TypeConverter.appendHexString(stringBuilder, byArray, byArray.length);
        return stringBuilder.toString();
    }

    public static String toString(DataWrapper dataWrapper, TypeMetadata typeMetadata) throws IncorrectTypeException, SQLException {
        int n = dataWrapper.getType();
        if (TypeUtilities.isCharacterType(n)) {
            if (dataWrapper.isNull()) {
                return null;
            }
            return (String)dataWrapper.getObject();
        }
        if (n > 1999 && n < 2007 && n != 2003 && n != 2002 && n != 2000 && n != 2004 && n != 2005 || 70 == n || n == 0 && !dataWrapper.isNull()) {
            throw new IncorrectTypeException();
        }
        if (dataWrapper.isNull()) {
            return null;
        }
        Object object = dataWrapper.getObject();
        switch (n) {
            case -7: 
            case 16: {
                if (((Boolean)object).booleanValue()) {
                    return "1";
                }
                return "0";
            }
            case 2004: {
                InputStream inputStream;
                Object object2;
                StringBuilder stringBuilder = new StringBuilder();
                if (object instanceof Blob) {
                    object2 = (Blob)object;
                    if (object2.length() > 0x3FFFFFFFL) {
                        throw new OutOfMemoryError();
                    }
                    stringBuilder.ensureCapacity(2 * (int)object2.length());
                    inputStream = object2.getBinaryStream();
                } else {
                    inputStream = (InputStream)object;
                }
                try {
                    int n2;
                    object2 = new byte[1024];
                    while ((n2 = inputStream.read((byte[])object2)) != -1) {
                        TypeConverter.appendHexString(stringBuilder, (byte[])object2, n2);
                    }
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                return stringBuilder.toString();
            }
            case 2005: {
                if (object instanceof Clob) {
                    Clob clob = (Clob)object;
                    long l = clob.length();
                    if (l > Integer.MAX_VALUE) {
                        throw new OutOfMemoryError();
                    }
                    return clob.getSubString(1L, (int)l);
                }
                Reader reader = (Reader)object;
                StringWriter stringWriter = new StringWriter();
                char[] cArray = new char[32768];
                try {
                    int n3;
                    while ((n3 = reader.read(cArray)) != -1) {
                        stringWriter.write(cArray, 0, n3);
                    }
                    stringWriter.flush();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                return stringWriter.toString();
            }
            case -4: 
            case -3: 
            case -2: {
                return TypeConverter.toHexString((byte[])object);
            }
            case 2: 
            case 3: {
                return ((BigDecimal)object).toPlainString();
            }
            case 91: {
                return TypeConverter.dateToStringLargeYear((Date)object);
            }
            case 92: {
                Time time;
                char[] cArray = new char[]{'0', '0', ':', '0', '0', ':', '0', '0'};
                Calendar calendar = null;
                if (object instanceof TimeTz) {
                    time = (TimeTz)object;
                    calendar = ((TimeTz)time).getTimezoneCalendar();
                    calendar.clear();
                    calendar.setTimeInMillis(time.getTime());
                    calendar.set(1970, 0, 1);
                    object = new Time(calendar.getTimeInMillis());
                    calendar.clear();
                }
                time = (Time)object;
                int n4 = time.getHours();
                int n5 = time.getMinutes();
                int n6 = time.getSeconds();
                cArray[0] = (char)(48 + n4 / 10);
                cArray[1] = (char)(48 + n4 % 10);
                cArray[3] = (char)(48 + n5 / 10);
                cArray[4] = (char)(48 + n5 % 10);
                cArray[6] = (char)(48 + n6 / 10);
                cArray[7] = (char)(48 + n6 % 10);
                int n7 = 0;
                if (typeMetadata.getType() == 93 || typeMetadata.getType() == 92) {
                    n7 = typeMetadata.getPrecision();
                }
                if (0 >= n7) {
                    return new String(cArray);
                }
                if (3 < n7) {
                    n7 = 3;
                }
                if (null == calendar) {
                    calendar = Calendar.getInstance();
                }
                calendar.setTimeInMillis(time.getTime());
                int n8 = calendar.get(14);
                StringBuilder stringBuilder = new StringBuilder(new String(cArray));
                stringBuilder.append(".000");
                for (int i = 11; i > 8; --i) {
                    stringBuilder.setCharAt(i, (char)(48 + n8 % 10));
                    n8 /= 10;
                }
                return stringBuilder.substring(0, 9 + n7);
            }
            case 93: {
                char[] cArray = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '-', '0', '0', '-', '0', '0', ' ', '0', '0', ':', '0', '0', ':', '0', '0', '.', '0', '0', '0', '0', '0', '0', '0', '0', '0'};
                Timestamp timestamp = (Timestamp)object;
                int n9 = timestamp.getYear() + 1900;
                int n10 = timestamp.getMonth() + 1;
                int n11 = timestamp.getDate();
                int n12 = timestamp.getHours();
                int n13 = timestamp.getMinutes();
                int n14 = timestamp.getSeconds();
                int n15 = 5;
                if (n9 > 99999999) {
                    n15 = 0;
                    cArray[0] = (char)(48 + n9 / 100000000 % 10);
                    cArray[1] = (char)(48 + n9 / 10000000 % 10);
                    cArray[2] = (char)(48 + n9 / 1000000 % 10);
                    cArray[3] = (char)(48 + n9 / 100000 % 10);
                    cArray[4] = (char)(48 + n9 / 10000 % 10);
                    cArray[5] = (char)(48 + n9 / 1000 % 10);
                } else if (n9 > 9999999) {
                    n15 = 1;
                    cArray[1] = (char)(48 + n9 / 10000000 % 10);
                    cArray[2] = (char)(48 + n9 / 1000000 % 10);
                    cArray[3] = (char)(48 + n9 / 100000 % 10);
                    cArray[4] = (char)(48 + n9 / 10000 % 10);
                    cArray[5] = (char)(48 + n9 / 1000 % 10);
                } else if (n9 > 999999) {
                    n15 = 2;
                    cArray[2] = (char)(48 + n9 / 1000000 % 10);
                    cArray[3] = (char)(48 + n9 / 100000 % 10);
                    cArray[4] = (char)(48 + n9 / 10000 % 10);
                    cArray[5] = (char)(48 + n9 / 1000 % 10);
                } else if (n9 > 99999) {
                    n15 = 3;
                    cArray[3] = (char)(48 + n9 / 100000 % 10);
                    cArray[4] = (char)(48 + n9 / 10000 % 10);
                    cArray[5] = (char)(48 + n9 / 1000 % 10);
                } else if (n9 > 9999) {
                    n15 = 4;
                    cArray[4] = (char)(48 + n9 / 10000 % 10);
                    cArray[5] = (char)(48 + n9 / 1000 % 10);
                } else {
                    cArray[5] = (char)(48 + n9 / 1000);
                }
                cArray[6] = (char)(48 + n9 / 100 % 10);
                cArray[7] = (char)(48 + n9 / 10 % 10);
                cArray[8] = (char)(48 + n9 % 10);
                cArray[10] = (char)(48 + n10 / 10);
                cArray[11] = (char)(48 + n10 % 10);
                cArray[13] = (char)(48 + n11 / 10);
                cArray[14] = (char)(48 + n11 % 10);
                cArray[16] = (char)(48 + n12 / 10);
                cArray[17] = (char)(48 + n12 % 10);
                cArray[19] = (char)(48 + n13 / 10);
                cArray[20] = (char)(48 + n13 % 10);
                cArray[22] = (char)(48 + n14 / 10);
                cArray[23] = (char)(48 + n14 % 10);
                short s = 0;
                if (93 == typeMetadata.getType() || 92 == typeMetadata.getType()) {
                    s = typeMetadata.getPrecision();
                }
                int n16 = 24 - n15;
                if (0 < s) {
                    int n17 = timestamp.getNanos();
                    cArray[25] = (char)(48 + n17 / 100000000);
                    cArray[26] = (char)(48 + n17 / 10000000 % 10);
                    cArray[27] = (char)(48 + n17 / 1000000 % 10);
                    cArray[28] = (char)(48 + n17 / 100000 % 10);
                    cArray[29] = (char)(48 + n17 / 10000 % 10);
                    cArray[30] = (char)(48 + n17 / 1000 % 10);
                    cArray[31] = (char)(48 + n17 / 100 % 10);
                    cArray[32] = (char)(48 + n17 / 10 % 10);
                    cArray[33] = (char)(48 + n17 % 10);
                    n16 = 25 + s - n15;
                }
                Calendar calendar = null;
                calendar = timestamp instanceof TimestampTz ? ((TimestampTz)timestamp).getTimezoneCalendar() : Calendar.getInstance();
                if (timestamp.getTime() < TypeConverter.getZeroTimeAD(calendar)) {
                    return '-' + new String(cArray, n15, n16);
                }
                return new String(cArray, n15, n16);
            }
            case 101: {
                return IntervalConverter.convertIntervalYearToString(object, typeMetadata);
            }
            case 102: {
                return IntervalConverter.convertIntervalMonthToString(object, typeMetadata);
            }
            case 103: {
                return IntervalConverter.convertIntervalDayToString(object, typeMetadata);
            }
            case 104: {
                return IntervalConverter.convertIntervalHourToString(object, typeMetadata);
            }
            case 105: {
                return IntervalConverter.convertIntervalMinuteToString(object, typeMetadata);
            }
            case 106: {
                return IntervalConverter.convertIntervalSecondToString(object, typeMetadata);
            }
            case 107: {
                return IntervalConverter.convertIntervalYearToMonthToString(object, typeMetadata);
            }
            case 108: {
                return IntervalConverter.convertIntervalDayToHourToString(object, typeMetadata);
            }
            case 109: {
                return IntervalConverter.convertIntervalDayToMinuteToString(object, typeMetadata);
            }
            case 110: {
                return IntervalConverter.convertIntervalDayToSecondToString(object, typeMetadata);
            }
            case 111: {
                return IntervalConverter.convertIntervalHourToMinuteToString(object, typeMetadata);
            }
            case 112: {
                return IntervalConverter.convertIntervalHourToSecondToString(object, typeMetadata);
            }
            case 113: {
                return IntervalConverter.convertIntervalMinuteToSecondToString(object, typeMetadata);
            }
            case 2003: {
                IArray iArray = (IArray)object;
                return iArray.getStringRepresentation();
            }
        }
        return object.toString();
    }

    public static Time toTime(DataWrapper dataWrapper, TypeMetadata typeMetadata, IWarningListener iWarningListener) throws IncorrectTypeException, SQLException {
        return TypeConverter.convertToTime(dataWrapper, null, typeMetadata, iWarningListener, true);
    }

    public static Time toTime(DataWrapper dataWrapper, Calendar calendar, TypeMetadata typeMetadata, IWarningListener iWarningListener) throws IncorrectTypeException, SQLException {
        Object object;
        Time time = TypeConverter.convertToTime(dataWrapper, calendar, typeMetadata, iWarningListener, true);
        if (!(null == time || (object = dataWrapper.getObject()) instanceof TimeTz || object instanceof TimestampTz || time instanceof TimeTz || object instanceof String)) {
            time = CalendarSetter.getTime(time, calendar);
        }
        return time;
    }

    public static Timestamp toTimestamp(DataWrapper dataWrapper, TypeMetadata typeMetadata, IWarningListener iWarningListener) throws IncorrectTypeException, SQLException {
        return TypeConverter.convertToTimestamp(dataWrapper, null, typeMetadata, iWarningListener);
    }

    public static Timestamp toTimestamp(DataWrapper dataWrapper, Calendar calendar, TypeMetadata typeMetadata, IWarningListener iWarningListener) throws IncorrectTypeException, SQLException {
        Timestamp timestamp = TypeConverter.convertToTimestamp(dataWrapper, calendar, typeMetadata, iWarningListener);
        if (null != timestamp) {
            Object object = dataWrapper.getObject();
            if (!(object instanceof TimeTz || object instanceof TimestampTz || timestamp instanceof TimestampTz || object instanceof String)) {
                timestamp = CalendarSetter.getTimestamp(timestamp, calendar);
            }
            if (object instanceof Time) {
                int n = timestamp.getNanos();
                Calendar calendar2 = Calendar.getInstance();
                calendar2.setTimeInMillis(timestamp.getTime());
                calendar2.set(1, 1970);
                calendar2.set(2, 0);
                calendar2.set(5, 1);
                calendar2.set(14, 0);
                timestamp = new Timestamp(calendar2.getTimeInMillis());
                timestamp.setNanos(n);
            }
        }
        return timestamp;
    }

    @Deprecated
    public static DataWrapper toType(DataWrapper dataWrapper, int n, IWarningListener iWarningListener) throws SQLException, IncorrectTypeException {
        try {
            TypeMetadata typeMetadata = TypeMetadata.createTypeMetadata(n);
            return TypeConverter.toType(dataWrapper, typeMetadata, iWarningListener);
        }
        catch (ErrorException errorException) {
            throw ExceptionConverter.getInstance().toSQLException(errorException, iWarningListener);
        }
    }

    @Deprecated
    public static DataWrapper toType(DataWrapper dataWrapper, Object object, int n, IWarningListener iWarningListener) throws SQLException, IncorrectTypeException {
        return TypeConverter.toType(dataWrapper, object, n, iWarningListener, null);
    }

    public static DataWrapper toType(DataWrapper dataWrapper, Object object, int n, IWarningListener iWarningListener, IConnection iConnection) throws SQLException, IncorrectTypeException {
        try {
            Object object2;
            int n2 = TypeConverter.getSqlType(object);
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            boolean bl = false;
            switch (n2) {
                case -10: 
                case -9: 
                case -8: 
                case -1: 
                case 1: 
                case 12: {
                    if (!TypeUtilities.isIntegerType(n) && !TypeUtilities.isExactNumericType(n)) break;
                    bl = true;
                    break;
                }
                case -11: 
                case -7: 
                case -6: 
                case -4: 
                case -3: 
                case -2: 
                case 0: 
                case 16: 
                case 91: 
                case 92: 
                case 93: 
                case 2002: 
                case 2003: {
                    break;
                }
                case -5: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    bl = true;
                    break;
                }
                case 2: 
                case 3: {
                    n3 = ((BigDecimal)object).precision();
                    n4 = ((BigDecimal)object).scale();
                    object2 = TypeConverter.setPrecScale((BigDecimal)object, (short)n3, (short)n4);
                    n3 = ((BigDecimal)object2).precision();
                    n4 = ((BigDecimal)object2).scale();
                    bl = true;
                    break;
                }
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: {
                    n5 = 2;
                }
            }
            object2 = TypeMetadata.createTypeMetadata(n, (short)n3, (short)n4, n5, bl);
            return TypeConverter.toType(dataWrapper, (TypeMetadata)object2, iWarningListener, iConnection);
        }
        catch (ErrorException errorException) {
            throw ExceptionConverter.getInstance().toSQLException(errorException, iWarningListener);
        }
    }

    @Deprecated
    public static DataWrapper toType(DataWrapper dataWrapper, TypeMetadata typeMetadata, IWarningListener iWarningListener) throws SQLException, IncorrectTypeException {
        return TypeConverter.toType(dataWrapper, typeMetadata, iWarningListener, null);
    }

    public static DataWrapper toType(DataWrapper dataWrapper, TypeMetadata typeMetadata, IWarningListener iWarningListener, IConnection iConnection) throws SQLException, IncorrectTypeException {
        short s = typeMetadata.getType();
        DataWrapper dataWrapper2 = new DataWrapper();
        switch (s) {
            case -6: {
                if (typeMetadata.isSigned()) {
                    dataWrapper2.setTinyInt(TypeConverter.toByte(dataWrapper, iWarningListener));
                    break;
                }
                short s2 = TypeConverter.toShort(dataWrapper, iWarningListener);
                s2 = (short)((s2 % 256 + 256) % 256);
                dataWrapper2.setTinyInt(s2);
                break;
            }
            case 5: {
                if (typeMetadata.isSigned()) {
                    dataWrapper2.setSmallInt(TypeConverter.toShort(dataWrapper, iWarningListener));
                    break;
                }
                int n = TypeConverter.toInt(dataWrapper, iWarningListener);
                n = (n % 65536 + 65536) % 65536;
                dataWrapper2.setSmallInt(n);
                break;
            }
            case 4: {
                if (typeMetadata.isSigned()) {
                    dataWrapper2.setInteger(TypeConverter.toInt(dataWrapper, iWarningListener));
                    break;
                }
                long l = TypeConverter.toLong(dataWrapper, iWarningListener);
                l = (l % 0x100000000L + 0x100000000L) % 0x100000000L;
                dataWrapper2.setInteger(l);
                break;
            }
            case -5: {
                if (typeMetadata.isSigned()) {
                    dataWrapper2.setBigInt(TypeConverter.toLong(dataWrapper, iWarningListener));
                    break;
                }
                BigInteger bigInteger = TypeConverter.toBigInteger(dataWrapper, iWarningListener);
                bigInteger = bigInteger.mod(TWO_TO_64);
                dataWrapper2.setBigInt(bigInteger);
                break;
            }
            case 7: {
                dataWrapper2.setReal(TypeConverter.toFloat(dataWrapper, iWarningListener));
                break;
            }
            case 6: {
                dataWrapper2.setFloat(TypeConverter.toDouble(dataWrapper, iWarningListener));
                break;
            }
            case 8: {
                dataWrapper2.setDouble(TypeConverter.toDouble(dataWrapper, iWarningListener));
                break;
            }
            case 3: {
                BigDecimal bigDecimal = TypeConverter.toBigDecimal(dataWrapper, typeMetadata, iWarningListener);
                dataWrapper2.setDecimal(bigDecimal);
                break;
            }
            case 2: {
                BigDecimal bigDecimal = TypeConverter.toBigDecimal(dataWrapper, typeMetadata, iWarningListener);
                dataWrapper2.setNumeric(bigDecimal);
                break;
            }
            case -7: {
                dataWrapper2.setBit(TypeConverter.toBoolean(dataWrapper, iWarningListener));
                break;
            }
            case 16: {
                dataWrapper2.setBoolean(TypeConverter.toBoolean(dataWrapper, iWarningListener));
                break;
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                dataWrapper2.setData(s, TypeConverter.toString(dataWrapper, typeMetadata));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                dataWrapper2.setData(s, TypeConverter.toBytes(dataWrapper));
                break;
            }
            case 91: {
                dataWrapper2.setDate(TypeConverter.toDate(dataWrapper, iWarningListener));
                break;
            }
            case 92: {
                dataWrapper2.setTime(TypeConverter.toTime(dataWrapper, typeMetadata, iWarningListener));
                break;
            }
            case 93: {
                dataWrapper2.setTimestamp(TypeConverter.toTimestamp(dataWrapper, typeMetadata, iWarningListener));
                break;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                dataWrapper2.setInterval(TypeConverter.toInterval(dataWrapper, typeMetadata, iWarningListener));
                break;
            }
            case -11: {
                dataWrapper2.setGuid(TypeConverter.toGUID(dataWrapper, iWarningListener));
                break;
            }
            case 2003: {
                dataWrapper2.setArray(dataWrapper.getArray());
                break;
            }
            case 2002: {
                if (dataWrapper.getObject() instanceof Struct) {
                    dataWrapper2.setData(2002, dataWrapper.getObject());
                    break;
                }
                throw new IncorrectTypeException();
            }
            case 2004: {
                if (iConnection == null) {
                    throw new RuntimeException("NULL parentConnection passed when converting to BLOB.");
                }
                dataWrapper2.setBlob(TypeConverter.toBlob(dataWrapper, iConnection, iWarningListener));
                break;
            }
            case 2005: {
                if (iConnection == null) {
                    throw new RuntimeException("NULL parentConnection passed when converting to CLOB.");
                }
                dataWrapper2.setClob(TypeConverter.toClob(dataWrapper, iConnection, iWarningListener));
                break;
            }
            case 2000: {
                dataWrapper2.setData(2000, dataWrapper.getObject());
                break;
            }
            case 0: {
                if (dataWrapper.isNull()) {
                    dataWrapper2.setNull(s);
                    return dataWrapper2;
                }
            }
            default: {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.UNKNOWN_DATA_TYPE, iWarningListener, ExceptionType.DATA, String.valueOf(s));
            }
        }
        if (dataWrapper.isNull()) {
            dataWrapper2.setNull(s);
        }
        return dataWrapper2;
    }

    private static void addOtherConversion() {
        TYPE_CONVERSION_MAP.put(1111, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 5419872955240700190L;
            {
                this.add(1111);
                this.add(12);
                this.add(2000);
                this.add(2012);
            }
        });
    }

    private static void addArrayConversions() {
        TYPE_CONVERSION_MAP.put(2003, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = -5808381603173623432L;
            {
                this.add(2003);
                this.add(2000);
            }
        });
    }

    private static void addBigDecimalConversions() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(){
            private static final long serialVersionUID = 1577877504986853963L;
            {
                this.add(-6);
                this.add(5);
                this.add(4);
                this.add(-5);
                this.add(7);
                this.add(6);
                this.add(8);
                this.add(3);
                this.add(2);
                this.add(-7);
                this.add(16);
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        };
        TYPE_CONVERSION_MAP.put(3, (List<Integer>)arrayList);
        TYPE_CONVERSION_MAP.put(2, (List<Integer>)arrayList);
    }

    private static void addBlobConversions() {
        TYPE_CONVERSION_MAP.put(2004, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = -7731683182785746359L;
            {
                this.add(-2);
                this.add(-3);
                this.add(-4);
                this.add(2004);
                this.add(2000);
            }
        });
    }

    private static void addBooleanConversions() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(){
            private static final long serialVersionUID = 2301839103144606467L;
            {
                this.add(-6);
                this.add(5);
                this.add(4);
                this.add(-5);
                this.add(7);
                this.add(6);
                this.add(8);
                this.add(3);
                this.add(2);
                this.add(-7);
                this.add(16);
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        };
        TYPE_CONVERSION_MAP.put(-7, (List<Integer>)arrayList);
        TYPE_CONVERSION_MAP.put(16, (List<Integer>)arrayList);
    }

    private static void addByteArrayConversions() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(){
            private static final long serialVersionUID = -1114162276767314579L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(-2);
                this.add(-3);
                this.add(-4);
                this.add(2000);
                this.add(2004);
            }
        };
        TYPE_CONVERSION_MAP.put(-2, (List<Integer>)arrayList);
        TYPE_CONVERSION_MAP.put(-3, (List<Integer>)arrayList);
        TYPE_CONVERSION_MAP.put(-4, (List<Integer>)arrayList);
    }

    private static void addByteConversions() {
        TYPE_CONVERSION_MAP.put(-6, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = -6519746940765096630L;
            {
                this.add(-6);
                this.add(5);
                this.add(4);
                this.add(-5);
                this.add(7);
                this.add(6);
                this.add(8);
                this.add(3);
                this.add(2);
                this.add(-7);
                this.add(16);
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addClobConversions() {
        TYPE_CONVERSION_MAP.put(2005, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = -6716762231938641114L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2005);
                this.add(2000);
            }
        });
    }

    private static void addDatalinkConversions() {
        TYPE_CONVERSION_MAP.put(70, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 6722890534148572228L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(70);
                this.add(2000);
            }
        });
    }

    private static void addDateConversions() {
        TYPE_CONVERSION_MAP.put(91, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = -8309432154352550135L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(91);
                this.add(93);
                this.add(2000);
            }
        });
    }

    private static void addDoubleConversions() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(){
            private static final long serialVersionUID = 195745121961923503L;
            {
                this.add(-6);
                this.add(5);
                this.add(4);
                this.add(-5);
                this.add(7);
                this.add(6);
                this.add(8);
                this.add(3);
                this.add(2);
                this.add(-7);
                this.add(16);
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        };
        TYPE_CONVERSION_MAP.put(6, (List<Integer>)arrayList);
        TYPE_CONVERSION_MAP.put(8, (List<Integer>)arrayList);
    }

    private static void addFloatConversions() {
        TYPE_CONVERSION_MAP.put(7, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 5643763617643704580L;
            {
                this.add(-6);
                this.add(5);
                this.add(4);
                this.add(-5);
                this.add(7);
                this.add(6);
                this.add(8);
                this.add(3);
                this.add(2);
                this.add(-7);
                this.add(16);
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addGUIDConversions() {
        TYPE_CONVERSION_MAP.put(-11, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 5643763617823704580L;
            {
                this.add(-11);
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addIntegerConversions() {
        TYPE_CONVERSION_MAP.put(4, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 8345823480060895785L;
            {
                this.add(-6);
                this.add(5);
                this.add(4);
                this.add(-5);
                this.add(7);
                this.add(6);
                this.add(8);
                this.add(3);
                this.add(2);
                this.add(-7);
                this.add(16);
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addIntervalDayConversions() {
        TYPE_CONVERSION_MAP.put(103, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 4866030494371585298L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addIntervalDayToHourConversions() {
        TYPE_CONVERSION_MAP.put(108, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = -1674137461171786776L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addIntervalDayToMinuteConversions() {
        TYPE_CONVERSION_MAP.put(109, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 1604160148277244646L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addIntervalDayToSecondConversions() {
        TYPE_CONVERSION_MAP.put(110, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 7503758923848687080L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addIntervalHourConversions() {
        TYPE_CONVERSION_MAP.put(104, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = -5527798794271899424L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addIntervalHourToMinuteConversions() {
        TYPE_CONVERSION_MAP.put(111, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 4369576614259490766L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addIntervalHourToSecondConversions() {
        TYPE_CONVERSION_MAP.put(112, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = -2680238796369792914L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addIntervalMinuteConversions() {
        TYPE_CONVERSION_MAP.put(105, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = -3933329123374503084L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addIntervalMinuteToSecondConversions() {
        TYPE_CONVERSION_MAP.put(113, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 8410562587770552421L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addIntervalMonthConversions() {
        TYPE_CONVERSION_MAP.put(102, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = -4032100586168037610L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addIntervalSecondConversions() {
        TYPE_CONVERSION_MAP.put(106, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 7482252078605327034L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addIntervalYearConversions() {
        TYPE_CONVERSION_MAP.put(101, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 3319575356233198861L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addIntervalYearToMonthConversions() {
        TYPE_CONVERSION_MAP.put(107, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = -9112026322270541556L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addLongConversions() {
        TYPE_CONVERSION_MAP.put(-5, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 360724167690817441L;
            {
                this.add(-6);
                this.add(5);
                this.add(4);
                this.add(-5);
                this.add(7);
                this.add(6);
                this.add(8);
                this.add(3);
                this.add(2);
                this.add(-7);
                this.add(16);
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addObjectConversions() {
        TYPE_CONVERSION_MAP.put(2000, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 5419872955240700190L;
            {
                this.add(2000);
            }
        });
    }

    private static void addRefConversions() {
        TYPE_CONVERSION_MAP.put(2006, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = -6712233574615351824L;
            {
                this.add(2006);
                this.add(2000);
            }
        });
    }

    private static void addShortConversions() {
        TYPE_CONVERSION_MAP.put(5, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 6565711157919530708L;
            {
                this.add(-6);
                this.add(5);
                this.add(4);
                this.add(-5);
                this.add(7);
                this.add(6);
                this.add(8);
                this.add(3);
                this.add(2);
                this.add(-7);
                this.add(16);
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addStringConversions() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(){
            private static final long serialVersionUID = 8390603353416789286L;
            {
                this.add(-6);
                this.add(5);
                this.add(4);
                this.add(-5);
                this.add(7);
                this.add(6);
                this.add(8);
                this.add(3);
                this.add(2);
                this.add(-7);
                this.add(16);
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(91);
                this.add(92);
                this.add(93);
                this.add(2005);
                this.add(2000);
                this.add(-8);
                this.add(-9);
                this.add(-10);
                this.add(103);
                this.add(108);
                this.add(109);
                this.add(110);
                this.add(104);
                this.add(111);
                this.add(112);
                this.add(105);
                this.add(113);
                this.add(102);
                this.add(106);
                this.add(101);
                this.add(107);
                this.add(-11);
            }
        };
        TYPE_CONVERSION_MAP.put(1, (List<Integer>)arrayList);
        TYPE_CONVERSION_MAP.put(12, (List<Integer>)arrayList);
        TYPE_CONVERSION_MAP.put(-1, (List<Integer>)arrayList);
        TYPE_CONVERSION_MAP.put(-8, (List<Integer>)arrayList);
        TYPE_CONVERSION_MAP.put(-9, (List<Integer>)arrayList);
        TYPE_CONVERSION_MAP.put(-10, (List<Integer>)arrayList);
    }

    private static void addStructConversions() {
        TYPE_CONVERSION_MAP.put(2002, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 5758877648898297886L;
            {
                this.add(2002);
                this.add(2000);
            }
        });
    }

    private static void addTimeConversions() {
        TYPE_CONVERSION_MAP.put(92, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = -6865504919287790919L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(92);
                this.add(93);
                this.add(2000);
            }
        });
    }

    private static void addTimestampConversions() {
        TYPE_CONVERSION_MAP.put(93, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 2573081359751242726L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(91);
                this.add(92);
                this.add(93);
                this.add(2000);
            }
        });
    }

    private static boolean canConvertFrom(Map<Integer, List<Integer>> map, int n, int n2) {
        List<Integer> list = map.get(n);
        if (null == list) {
            return false;
        }
        return list.contains(n2);
    }

    private static boolean canConvertFrom(Map<Integer, List<Integer>> map, DataWrapper dataWrapper, int n) {
        int n2 = dataWrapper.getType();
        if (2000 == n2) {
            n2 = TypeConverter.getSqlType(dataWrapper.getObject());
        } else if (0 == n2 && dataWrapper.isNull()) {
            return true;
        }
        return TypeConverter.canConvertFrom(map, n2, n);
    }

    private static Date convertToDate(DataWrapper dataWrapper, Calendar calendar, IWarningListener iWarningListener) throws IncorrectTypeException, SQLException {
        int n = dataWrapper.getType();
        if (91 == n) {
            if (dataWrapper.isNull()) {
                return null;
            }
            return (Date)dataWrapper.getObject();
        }
        if (!TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, dataWrapper, 91)) {
            throw new IncorrectTypeException();
        }
        if (dataWrapper.isNull()) {
            return null;
        }
        try {
            switch (n) {
                case 93: {
                    Object object = dataWrapper.getObject();
                    if (object instanceof TimestampTz) {
                        TimestampTz timestampTz = (TimestampTz)object;
                        Calendar calendar2 = timestampTz.getTimezoneCalendar();
                        calendar2.clear();
                        calendar2.setTimeInMillis(timestampTz.getTime());
                        calendar2.set(11, 0);
                        calendar2.set(12, 0);
                        calendar2.set(13, 0);
                        calendar2.set(14, 0);
                        return new Date(calendar2.getTimeInMillis());
                    }
                    return new Date(dataWrapper.getTimestamp().getTime());
                }
            }
            if (null == calendar) {
                calendar = Calendar.getInstance();
            }
            String string = TypeConverter.toString(dataWrapper, null);
            int n2 = string.indexOf(58);
            Date date = null;
            if (-1 != n2) {
                date = new Date(StringConverter.parseTimestamp(string, new GregorianCalendar(null == calendar ? TimeZone.getDefault() : calendar.getTimeZone())).getTime());
            } else {
                date = StringConverter.parseDate(string, new GregorianCalendar(null == calendar ? TimeZone.getDefault() : calendar.getTimeZone()));
                if (null == date) {
                    throw new IllegalArgumentException();
                }
            }
            calendar.clear();
            calendar.setTimeInMillis(date.getTime());
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return new Date(calendar.getTimeInMillis());
        }
        catch (Throwable throwable) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, iWarningListener, ExceptionType.DATA, TypeNames.getTypeName(91));
        }
    }

    private static Time convertToTime(DataWrapper dataWrapper, Calendar calendar, TypeMetadata typeMetadata, IWarningListener iWarningListener, boolean bl) throws IncorrectTypeException, SQLException {
        int n = dataWrapper.getType();
        if (92 == n) {
            if (dataWrapper.isNull()) {
                return null;
            }
            return dataWrapper.getTime();
        }
        if (!TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, dataWrapper, 92)) {
            throw new IncorrectTypeException();
        }
        if (dataWrapper.isNull()) {
            return null;
        }
        try {
            Date date;
            String string;
            int n2;
            switch (n) {
                case 91: {
                    Date date2 = dataWrapper.getDate();
                    if (bl) {
                        Calendar calendar2 = Calendar.getInstance();
                        calendar2.setTimeInMillis(date2.getTime());
                        calendar2.set(1970, 0, 1);
                        return new Time(calendar2.getTimeInMillis());
                    }
                    return new Time(date2.getTime());
                }
                case 93: {
                    TimestampTz timestampTz = dataWrapper.getTimestampTz();
                    if (bl) {
                        Calendar calendar3 = timestampTz.getTimezoneCalendar();
                        calendar3.clear();
                        calendar3.setTimeInMillis(timestampTz.getTime());
                        calendar3.set(1970, 0, 1);
                        return new Time(calendar3.getTimeInMillis());
                    }
                    return new Time(timestampTz.getTime());
                }
            }
            if (null == calendar) {
                calendar = Calendar.getInstance();
            }
            if (-1 != (n2 = (string = TypeConverter.toString(dataWrapper, typeMetadata).trim()).indexOf(32)) && null != (date = StringConverter.parseDate(string.substring(0, n2), new GregorianCalendar(null == calendar ? TimeZone.getDefault() : calendar.getTimeZone())))) {
                string = string.substring(n2 + 1);
            }
            int n3 = string.length();
            int n4 = string.indexOf(46);
            int n5 = string.indexOf(32);
            if (-1 == n5 && -1 == (n5 = string.indexOf(43))) {
                n5 = string.indexOf(45);
            }
            int n6 = -1 == n4 ? (-1 == n5 ? n3 : n5) : n4;
            Time time = StringConverter.parseTime(string.substring(0, n6), new GregorianCalendar(null == calendar ? TimeZone.getDefault() : calendar.getTimeZone()));
            if (n6 != n3) {
                if (0 < n4) {
                    int n7 = 3;
                    int n8 = n3;
                    if (n5 > 0) {
                        n8 = n5;
                    }
                    if (n4 + 3 >= n8) {
                        n7 = n8 - n4 - 1;
                    }
                    if (0 == n7) {
                        throw new IllegalArgumentException();
                    }
                    int n9 = StringConverter.parseInt(string, n4 + 1, n4 + n7 + 1);
                    while (n7++ < 3) {
                        n9 *= 10;
                    }
                    time.setTime(time.getTime() + (long)n9);
                }
                if (0 < n5) {
                    time = TypeConverter.convertToTimeTz(time, string.substring(n5, n3));
                }
            }
            calendar.clear();
            calendar.setTimeInMillis(time.getTime());
            if (bl) {
                calendar.set(1970, 0, 1);
            }
            return new Time(calendar.getTimeInMillis());
        }
        catch (Throwable throwable) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, iWarningListener, ExceptionType.DATA, TypeNames.getTypeName(92));
        }
    }

    private static Timestamp convertToTimestamp(DataWrapper dataWrapper, Calendar calendar, TypeMetadata typeMetadata, IWarningListener iWarningListener) throws IncorrectTypeException, SQLException {
        int n = dataWrapper.getType();
        if (93 == n) {
            if (dataWrapper.isNull()) {
                return null;
            }
            return dataWrapper.getTimestamp();
        }
        if (!TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, dataWrapper, 93)) {
            throw new IncorrectTypeException();
        }
        if (dataWrapper.isNull()) {
            return null;
        }
        try {
            switch (n) {
                case 91: {
                    return new Timestamp(dataWrapper.getDate().getTime());
                }
                case 92: {
                    return new Timestamp(dataWrapper.getTime().getTime());
                }
                case -10: 
                case -9: 
                case -8: 
                case -1: 
                case 1: 
                case 12: {
                    String string = (String)dataWrapper.getObject();
                    boolean bl = string.contains("-");
                    boolean bl2 = string.contains(":");
                    if (bl && bl2) {
                        return StringConverter.parseTimestamp(string, new GregorianCalendar(null == calendar ? TimeZone.getDefault() : calendar.getTimeZone()));
                    }
                    if (bl) {
                        Date date = StringConverter.parseDate(string, new GregorianCalendar(null == calendar ? TimeZone.getDefault() : calendar.getTimeZone()));
                        if (null == date) {
                            throw new IllegalArgumentException();
                        }
                        return new Timestamp(date.getTime());
                    }
                    if (bl2) {
                        Time time = TypeConverter.convertToTime(dataWrapper, calendar, typeMetadata, iWarningListener, false);
                        if (time instanceof TimeTz) {
                            time = ((TimeTz)time).getAdjustedTime();
                        }
                        Timestamp timestamp = new Timestamp(time.getTime());
                        int n2 = string.indexOf(46);
                        if (-1 != n2) {
                            int n3;
                            int n4 = string.length();
                            int n5 = n2;
                            while (++n5 < n4 && (n3 = string.charAt(n5)) >= 48 && n3 <= 57) {
                            }
                            n3 = n5 - n2 - 1;
                            if (n3 <= 3) {
                                return timestamp;
                            }
                            if (n3 > 9) {
                                throw new IllegalArgumentException();
                            }
                            int n6 = StringConverter.parseInt(string, n2 + 1, n5);
                            timestamp.setNanos(n6 *= StringConverter.s_fractionalMultiplier[n3]);
                        }
                        return timestamp;
                    }
                    throw new IllegalArgumentException();
                }
            }
            String string = TypeConverter.toString(dataWrapper, typeMetadata);
            return StringConverter.parseTimestamp(string, new GregorianCalendar(null == calendar ? TimeZone.getDefault() : calendar.getTimeZone()));
        }
        catch (Throwable throwable) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, iWarningListener, ExceptionType.DATA, TypeNames.getTypeName(93));
        }
    }

    private static TimeTz convertToTimeTz(Time time, String string) {
        String string2 = string.trim();
        if (!Character.isLetter(string2.charAt(0))) {
            if (Character.isDigit(string2.charAt(0))) {
                string2 = "+" + string2;
            }
            string2 = "GMT" + string2;
        }
        TimeZone timeZone = TimeZone.getTimeZone(string2);
        Calendar calendar = Calendar.getInstance(timeZone);
        time = CalendarSetter.getTime(time, calendar);
        return new TimeTz(time, calendar);
    }

    private static void initializeClassToTypeMap() {
        CLASS_TO_TYPE_MAP.put(BigDecimal.class, 3);
        CLASS_TO_TYPE_MAP.put(BigInteger.class, -5);
        CLASS_TO_TYPE_MAP.put(byte[].class, -2);
        CLASS_TO_TYPE_MAP.put(Byte.class, -6);
        CLASS_TO_TYPE_MAP.put(ByteArrayInputStream.class, -2);
        CLASS_TO_TYPE_MAP.put(Boolean.class, -7);
        CLASS_TO_TYPE_MAP.put(Date.class, 91);
        CLASS_TO_TYPE_MAP.put(Double.class, 8);
        CLASS_TO_TYPE_MAP.put(Float.class, 7);
        CLASS_TO_TYPE_MAP.put(Integer.class, 4);
        CLASS_TO_TYPE_MAP.put(Long.class, -5);
        CLASS_TO_TYPE_MAP.put(Short.class, 5);
        CLASS_TO_TYPE_MAP.put(String.class, 1);
        CLASS_TO_TYPE_MAP.put(StringReader.class, 1);
        CLASS_TO_TYPE_MAP.put(Time.class, 92);
        CLASS_TO_TYPE_MAP.put(Timestamp.class, 93);
        CLASS_TO_TYPE_MAP.put(UUID.class, -11);
        CLASS_TO_TYPE_MAP.put(java.util.Date.class, 93);
        CLASS_TO_TYPE_MAP.put(Calendar.class, 93);
    }

    private static String normalizeInfinityOrNaN(String string) {
        String string2 = NORMALIZE_DOUBLE_OR_FLOAT_MAP.get(string.toUpperCase());
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    private static BigDecimal rescaleBigDecimal(BigDecimal bigDecimal, int n, IWarningListener iWarningListener) {
        int n2 = bigDecimal.scale();
        if (n2 == n) {
            return bigDecimal;
        }
        BigDecimal bigDecimal2 = bigDecimal.setScale(n, 4);
        if (0 != bigDecimal.compareTo(bigDecimal2)) {
            iWarningListener.postWarning(new Warning(WarningCode.FRACTIONAL_TRUNCATION, 1, JDBCMessageKey.WARN_FRACTIONAL_TRUNC.name()));
        }
        return bigDecimal2;
    }

    private static void addPairsToNormalDoubleOrFloatMap() {
        NORMALIZE_DOUBLE_OR_FLOAT_MAP.put("INF", "Infinity");
        NORMALIZE_DOUBLE_OR_FLOAT_MAP.put("+INF", "+Infinity");
        NORMALIZE_DOUBLE_OR_FLOAT_MAP.put("-INF", "-Infinity");
        NORMALIZE_DOUBLE_OR_FLOAT_MAP.put("INFINITY", "Infinity");
        NORMALIZE_DOUBLE_OR_FLOAT_MAP.put("+INFINITY", "+Infinity");
        NORMALIZE_DOUBLE_OR_FLOAT_MAP.put("-INFINITY", "-Infinity");
        NORMALIZE_DOUBLE_OR_FLOAT_MAP.put("NAN", "NaN");
        NORMALIZE_DOUBLE_OR_FLOAT_MAP.put("+NAN", "NaN");
        NORMALIZE_DOUBLE_OR_FLOAT_MAP.put("-NAN", "NaN");
    }

    private static long getZeroTimeAD(Calendar calendar) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(null == calendar ? TimeZone.getDefault() : calendar.getTimeZone());
        gregorianCalendar.clear();
        gregorianCalendar.set(1, 0, 1, 0, 0, 0);
        return gregorianCalendar.getTimeInMillis();
    }

    public static BigDecimal setPrecScale(BigDecimal bigDecimal, short s, short s2) {
        int n;
        if (s < 1 || s2 > s || s2 < 0) {
            throw new IllegalArgumentException("Invalid precision scale");
        }
        Pair<Short, Short> pair = TypeConverter.calculateSQLPrecisionScale(bigDecimal);
        int n2 = pair.key() - pair.value();
        if (n2 > (n = s - s2)) {
            if (bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
                throw new IllegalArgumentException("Invalid precision scale");
            }
            throw new IllegalArgumentException("Invalid precision scale");
        }
        if (pair.value() <= s2) {
            return bigDecimal;
        }
        BigDecimal bigDecimal2 = bigDecimal.setScale((int)s2, RoundingMode.DOWN);
        return bigDecimal2;
    }

    public static Pair<Short, Short> calculateSQLPrecisionScale(BigDecimal bigDecimal) {
        int n;
        if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
            return new Pair<Short, Short>((short)1, (short)0);
        }
        int n2 = bigDecimal.scale() < 0 ? 0 : bigDecimal.scale();
        int n3 = n = bigDecimal.scale() < 0 ? bigDecimal.precision() - bigDecimal.scale() : bigDecimal.precision();
        if (0 > n || Short.MAX_VALUE < n) {
            throw new IllegalArgumentException("Invalid precision scale");
        }
        if (Short.MAX_VALUE < n2) {
            n2 = Short.MAX_VALUE;
        }
        return new Pair<Short, Short>((short)n, (short)n2);
    }

    public static String dateToStringLargeYear(Date date) {
        int n = date.getYear() + 1900;
        int n2 = date.getMonth() + 1;
        int n3 = date.getDate();
        char[] cArray = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '-', '0', '0', '-', '0', '0'};
        int n4 = 5;
        if (n > 99999999) {
            n4 = 0;
            cArray[0] = (char)(48 + n / 100000000 % 10);
            cArray[1] = (char)(48 + n / 10000000 % 10);
            cArray[2] = (char)(48 + n / 1000000 % 10);
            cArray[3] = (char)(48 + n / 100000 % 10);
            cArray[4] = (char)(48 + n / 10000 % 10);
            cArray[5] = (char)(48 + n / 1000 % 10);
        } else if (n > 9999999) {
            n4 = 1;
            cArray[1] = (char)(48 + n / 10000000 % 10);
            cArray[2] = (char)(48 + n / 1000000 % 10);
            cArray[3] = (char)(48 + n / 100000 % 10);
            cArray[4] = (char)(48 + n / 10000 % 10);
            cArray[5] = (char)(48 + n / 1000 % 10);
        } else if (n > 999999) {
            n4 = 2;
            cArray[2] = (char)(48 + n / 1000000 % 10);
            cArray[3] = (char)(48 + n / 100000 % 10);
            cArray[4] = (char)(48 + n / 10000 % 10);
            cArray[5] = (char)(48 + n / 1000 % 10);
        } else if (n > 99999) {
            n4 = 3;
            cArray[3] = (char)(48 + n / 100000 % 10);
            cArray[4] = (char)(48 + n / 10000 % 10);
            cArray[5] = (char)(48 + n / 1000 % 10);
        } else if (n > 9999) {
            n4 = 4;
            cArray[4] = (char)(48 + n / 10000 % 10);
            cArray[5] = (char)(48 + n / 1000 % 10);
        } else {
            cArray[5] = (char)(48 + n / 1000);
        }
        cArray[6] = (char)(48 + n / 100 % 10);
        cArray[7] = (char)(48 + n / 10 % 10);
        cArray[8] = (char)(48 + n % 10);
        cArray[10] = (char)(48 + n2 / 10);
        cArray[11] = (char)(48 + n2 % 10);
        cArray[13] = (char)(48 + n3 / 10);
        cArray[14] = (char)(48 + n3 % 10);
        if (date.getTime() < TypeConverter.getZeroTimeAD(Calendar.getInstance())) {
            return '-' + new String(cArray, n4, 15 - n4);
        }
        return new String(cArray, n4, 15 - n4);
    }

    public static Object[] convertToObjectArray(Object object) throws IncorrectTypeException {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == null) {
            throw new IncorrectTypeException();
        }
        if (clazz.isPrimitive()) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                arrayList.add(Array.get(object, i));
            }
            return arrayList.toArray();
        }
        return (Object[])object;
    }

    static {
        CLASS_TO_TYPE_MAP = new HashMap();
        TypeConverter.initializeClassToTypeMap();
        TYPE_CONVERSION_MAP = new HashMap<Integer, List<Integer>>();
        NORMALIZE_DOUBLE_OR_FLOAT_MAP = new HashMap<String, String>();
        TypeConverter.addByteConversions();
        TypeConverter.addShortConversions();
        TypeConverter.addIntegerConversions();
        TypeConverter.addLongConversions();
        TypeConverter.addFloatConversions();
        TypeConverter.addDoubleConversions();
        TypeConverter.addBigDecimalConversions();
        TypeConverter.addBooleanConversions();
        TypeConverter.addStringConversions();
        TypeConverter.addByteArrayConversions();
        TypeConverter.addDateConversions();
        TypeConverter.addTimeConversions();
        TypeConverter.addTimestampConversions();
        TypeConverter.addGUIDConversions();
        TypeConverter.addClobConversions();
        TypeConverter.addBlobConversions();
        TypeConverter.addRefConversions();
        TypeConverter.addDatalinkConversions();
        TypeConverter.addArrayConversions();
        TypeConverter.addStructConversions();
        TypeConverter.addObjectConversions();
        TypeConverter.addIntervalDayConversions();
        TypeConverter.addIntervalDayToHourConversions();
        TypeConverter.addIntervalDayToMinuteConversions();
        TypeConverter.addIntervalDayToSecondConversions();
        TypeConverter.addIntervalHourConversions();
        TypeConverter.addIntervalHourToMinuteConversions();
        TypeConverter.addIntervalHourToSecondConversions();
        TypeConverter.addIntervalMinuteConversions();
        TypeConverter.addIntervalMinuteToSecondConversions();
        TypeConverter.addIntervalMonthConversions();
        TypeConverter.addIntervalSecondConversions();
        TypeConverter.addIntervalYearConversions();
        TypeConverter.addIntervalYearToMonthConversions();
        TypeConverter.addPairsToNormalDoubleOrFloatMap();
        TypeConverter.addOtherConversion();
        TWO_TO_64 = new BigInteger("18446744073709551616");
        STREAM_FROM_CONVERSION_MAP = new HashMap<Integer, List<Integer>>(){
            private static final long serialVersionUID = 131682938025320073L;
            {
                this.put(1, new ArrayList<Integer>(){
                    private static final long serialVersionUID = 7240274558857187054L;
                    {
                        this.add(-1);
                    }
                });
                this.put(12, new ArrayList<Integer>(){
                    private static final long serialVersionUID = 2714265807427510204L;
                    {
                        this.add(-1);
                    }
                });
                this.put(-1, new ArrayList<Integer>(){
                    private static final long serialVersionUID = 224991913801084918L;
                    {
                        this.add(-1);
                    }
                });
                this.put(-2, new ArrayList<Integer>(){
                    private static final long serialVersionUID = -3032857584866793994L;
                    {
                        this.add(-1);
                        this.add(-4);
                    }
                });
                this.put(-8, new ArrayList<Integer>(){
                    private static final long serialVersionUID = 7240274558826187054L;
                    {
                        this.add(-1);
                    }
                });
                this.put(-9, new ArrayList<Integer>(){
                    private static final long serialVersionUID = 2714265991427510204L;
                    {
                        this.add(-1);
                    }
                });
                this.put(-10, new ArrayList<Integer>(){
                    private static final long serialVersionUID = 226991913301084918L;
                    {
                        this.add(-1);
                    }
                });
                this.put(-3, new ArrayList<Integer>(){
                    private static final long serialVersionUID = 7317673487611447914L;
                    {
                        this.add(-1);
                        this.add(-4);
                    }
                });
                this.put(-4, new ArrayList<Integer>(){
                    private static final long serialVersionUID = 3254144638476462886L;
                    {
                        this.add(-1);
                        this.add(-4);
                    }
                });
            }
        };
        STREAM_TO_CONVERSION_MAP = new HashMap<Integer, List<Integer>>(){
            private static final long serialVersionUID = 3124019339494993466L;
            {
                this.put(1, new ArrayList<Integer>(){
                    private static final long serialVersionUID = 6484643743691109517L;
                    {
                        this.add(1);
                        this.add(12);
                        this.add(-1);
                        this.add(-8);
                        this.add(-9);
                        this.add(-10);
                    }
                });
                this.put(12, new ArrayList<Integer>(){
                    private static final long serialVersionUID = 6484643743691109517L;
                    {
                        this.add(1);
                        this.add(12);
                        this.add(-1);
                        this.add(-8);
                        this.add(-9);
                        this.add(-10);
                    }
                });
                this.put(-1, new ArrayList<Integer>(){
                    private static final long serialVersionUID = 6484643743691109517L;
                    {
                        this.add(1);
                        this.add(12);
                        this.add(-1);
                        this.add(-8);
                        this.add(-9);
                        this.add(-10);
                    }
                });
                this.put(-8, new ArrayList<Integer>(){
                    private static final long serialVersionUID = 6484643743691109517L;
                    {
                        this.add(1);
                        this.add(12);
                        this.add(-1);
                        this.add(-8);
                        this.add(-9);
                        this.add(-10);
                    }
                });
                this.put(-9, new ArrayList<Integer>(){
                    private static final long serialVersionUID = 6484643743691109517L;
                    {
                        this.add(1);
                        this.add(12);
                        this.add(-1);
                        this.add(-8);
                        this.add(-9);
                        this.add(-10);
                    }
                });
                this.put(-10, new ArrayList<Integer>(){
                    private static final long serialVersionUID = 6484643743691109517L;
                    {
                        this.add(1);
                        this.add(12);
                        this.add(-1);
                        this.add(-8);
                        this.add(-9);
                        this.add(-10);
                    }
                });
                this.put(-2, new ArrayList<Integer>(){
                    private static final long serialVersionUID = -8069855771950595180L;
                    {
                        this.add(-2);
                        this.add(-3);
                        this.add(-4);
                    }
                });
                this.put(-3, new ArrayList<Integer>(){
                    private static final long serialVersionUID = -8069855771950595180L;
                    {
                        this.add(-2);
                        this.add(-3);
                        this.add(-4);
                    }
                });
                this.put(-4, new ArrayList<Integer>(){
                    private static final long serialVersionUID = -8069855771950595180L;
                    {
                        this.add(-2);
                        this.add(-3);
                        this.add(-4);
                    }
                });
            }
        };
        s_hexits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

