/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.dsi.dataengine.filters;

import com.cloudera.hiveserver2.dsi.dataengine.filters.IFilter;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.cloudera.hiveserver2.dsi.exceptions.IncorrectTypeException;

public class IdentifierFilter
implements IFilter {
    private MetadataSourceColumnTag m_columnTag;
    private String m_value = null;

    public IdentifierFilter(MetadataSourceColumnTag metadataSourceColumnTag, String string, String string2) {
        this.m_columnTag = metadataSourceColumnTag;
        if (null != string) {
            int n;
            boolean bl = false;
            int n2 = -1;
            if (null != string2 && 0 < string2.length()) {
                n2 = string.indexOf(string2);
            }
            if (-1 != n2 && -1 != (n = string.indexOf(string2, n2 + 1))) {
                bl = true;
                this.m_value = string.substring(n2, n);
            }
            if (!bl) {
                this.m_value = string.trim();
            }
        }
    }

    @Override
    public boolean filter(DataWrapper dataWrapper) {
        if (null == this.m_value) {
            return true;
        }
        if (dataWrapper.isNull()) {
            return false;
        }
        try {
            switch (dataWrapper.getType()) {
                case -8: 
                case 1: {
                    return this.m_value.equalsIgnoreCase(dataWrapper.getChar());
                }
                case -9: 
                case 12: {
                    return this.m_value.equalsIgnoreCase(dataWrapper.getVarChar());
                }
                case -10: 
                case -1: {
                    return this.m_value.equalsIgnoreCase(dataWrapper.getLongVarChar());
                }
                case 5: {
                    return this.m_value.equals(Integer.toString(dataWrapper.getSmallInt()));
                }
            }
        }
        catch (IncorrectTypeException incorrectTypeException) {
            // empty catch block
        }
        assert (false);
        return false;
    }

    @Override
    public MetadataSourceColumnTag getColumnTag() {
        return this.m_columnTag;
    }
}

