/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.hivecommon.api;

import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TBinaryColumn;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TBoolColumn;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TByteColumn;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TColumn;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TDoubleColumn;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TI16Column;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TI32Column;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TI64Column;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TStringColumn;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.DSITypeUtilities;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.hiveserver2.dsi.exceptions.IncorrectTypeException;
import com.cloudera.hiveserver2.hivecommon.HiveJDBCSettings;
import com.cloudera.hiveserver2.hivecommon.api.HS2Buffer;
import com.cloudera.hiveserver2.hivecommon.api.HiveOperationContext;
import com.cloudera.hiveserver2.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hiveserver2.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.hiveserver2.support.ILogger;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HS2v6Buffer
extends HS2Buffer {
    private static final byte[] BITMASK_TO_CELL_MAP = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};
    private HiveOperationContext m_context;
    private List<DataWrapper[]> m_rows;
    private Iterator<DataWrapper[]> m_rowIter;
    private DataWrapper[] m_currRow;
    private List<Object[]> m_rowsOfObjects;
    private Object[] m_currRowObjects;
    private Iterator<Object[]> m_rowObjectIter;
    private int m_currRowParsedInBuffer = 0;

    public HS2v6Buffer(ILogger iLogger, HiveJDBCSettings hiveJDBCSettings, HiveOperationContext hiveOperationContext) {
        super(iLogger, hiveJDBCSettings);
        this.m_context = hiveOperationContext;
    }

    @Override
    public Object[] getCurrentRowObjectArray() {
        return this.m_currRowObjects;
    }

    @Override
    public boolean getData(int n, long l, long l2, DataWrapper dataWrapper, int n2, short s, String string, HiveJDBCSettings hiveJDBCSettings) throws ErrorException {
        if (null == this.m_currRow) {
            throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_RESULTSET_DATA_RETRIEVING_ERR.name(), new String[]{"Cannot get data from an empty row set."});
        }
        DataWrapper dataWrapper2 = this.m_currRow[n];
        if (dataWrapper2.isNull()) {
            dataWrapper.copyData(dataWrapper2);
            return false;
        }
        switch (s) {
            case -2: 
            case 1: 
            case 12: {
                if (0L == l && -1L == l2) {
                    dataWrapper.copyData(dataWrapper2);
                    return false;
                }
                try {
                    if (-2 == s) {
                        return DSITypeUtilities.outputBinary(dataWrapper2.getBinary(), dataWrapper, l, l2);
                    }
                    if (12 == s) {
                        return DSITypeUtilities.outputVarCharStringData(dataWrapper2.getVarChar(), dataWrapper, l, l2);
                    }
                    return DSITypeUtilities.outputVarCharStringData(dataWrapper2.getChar(), dataWrapper, l, l2);
                }
                catch (IncorrectTypeException incorrectTypeException) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_RESULTSET_DATA_RETRIEVING_ERR.name(), new String[]{"Incorrect data type."});
                    errorException.initCause(incorrectTypeException);
                    throw errorException;
                }
            }
            case -6: 
            case -5: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 16: 
            case 91: 
            case 93: {
                dataWrapper.copyData(dataWrapper2);
                return false;
            }
        }
        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_RESULTSET_DATA_RETRIEVING_ERR.name(), new String[]{"Data Type May Not Supported"});
        throw errorException;
    }

    @Override
    public DataWrapper getDataWrapper(int n) throws ErrorException {
        if (null == this.m_currRow) {
            throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_RESULTSET_DATA_RETRIEVING_ERR.name(), new String[]{"Cannot get DataWrapper from an empty row set."});
        }
        return this.m_currRow[n];
    }

    @Override
    public List<Integer> getIntColumn(int n) {
        return this.getHiveServer2Buffer().getResults().getColumns().get(n).getI32Val().getValues();
    }

    @Override
    public int getNumColumns() {
        return this.getHiveServer2Buffer().getResults().getColumnsSize();
    }

    @Override
    public String getString(int n, int n2) {
        TStringColumn tStringColumn = this.getHiveServer2Buffer().getResults().getColumns().get(n2).getStringVal();
        if (HS2v6Buffer.checkIfNull(n, tStringColumn.getNulls())) {
            return null;
        }
        return tStringColumn.getValues().get(n);
    }

    @Override
    public List<String> getStringColumn(int n) {
        return this.getHiveServer2Buffer().getResults().getColumns().get(n).getStringVal().getValues();
    }

    @Override
    public void parseRow(int n) throws ErrorException {
        if (this.m_currRowParsedInBuffer != n) {
            if (this.m_currRowParsedInBuffer + 1 != n) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), "Only Forward-only cursor is supported. Current row parsed in buffer: " + this.m_currRowParsedInBuffer + ", next row index: " + n);
                throw errorException;
            }
        } else {
            return;
        }
        this.m_currRowParsedInBuffer = n;
        this.m_currRow = this.m_rowIter.next();
        this.m_currRowObjects = this.m_rowObjectIter.next();
    }

    @Override
    public void setNumRows() throws ErrorException {
        if (null != this.getHiveServer2Buffer().getResults()) {
            TColumn tColumn;
            List<TColumn> list = this.getHiveServer2Buffer().getResults().getColumns();
            if (null == list) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), "Thrift column information request error");
                throw errorException;
            }
            this.m_numRows = 0 == list.size() ? 0 : ((tColumn = list.get(0)).isSetBinaryVal() ? tColumn.getBinaryVal().getValuesSize() : (tColumn.isSetBoolVal() ? tColumn.getBoolVal().getValuesSize() : (tColumn.isSetByteVal() ? tColumn.getByteVal().getValuesSize() : (tColumn.isSetDoubleVal() ? tColumn.getDoubleVal().getValuesSize() : (tColumn.isSetI16Val() ? tColumn.getI16Val().getValuesSize() : (tColumn.isSetI32Val() ? tColumn.getI32Val().getValuesSize() : (tColumn.isSetI64Val() ? tColumn.getI64Val().getValuesSize() : tColumn.getStringVal().getValuesSize())))))));
        } else {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), "Thrift column information request error");
            throw errorException;
        }
    }

    @Override
    protected void handleInitializeBuffer() throws ErrorException {
        int n;
        int n2 = this.getNumColumns();
        this.m_currRowParsedInBuffer = 0;
        this.m_rows = new ArrayList<DataWrapper[]>();
        for (n = 0; n < this.m_numRows; ++n) {
            this.m_rows.add(new DataWrapper[n2]);
        }
        this.m_rowIter = this.m_rows.iterator();
        this.m_currRow = null;
        this.m_rowsOfObjects = new ArrayList<Object[]>();
        for (n = 0; n < this.m_numRows; ++n) {
            this.m_rowsOfObjects.add(new Object[n2]);
        }
        this.m_rowObjectIter = this.m_rowsOfObjects.iterator();
        this.m_currRowObjects = null;
        if (0 == this.m_numRows) {
            return;
        }
        if (null == this.m_context.m_columnTypes) {
            this.deriveColumnTypes();
        }
        block18: for (n = 0; n < n2; ++n) {
            short s = this.m_context.m_columnTypes[n];
            TColumn tColumn = this.getHiveServer2Buffer().getResults().getColumns().get(n);
            switch (s) {
                case -2: {
                    DataWrapper dataWrapper;
                    int n3;
                    Serializable serializable = tColumn.getBinaryVal();
                    List<Object> list = ((TBinaryColumn)serializable).getValues();
                    byte[] byArray = ((TBinaryColumn)serializable).getNulls();
                    int n4 = list.size();
                    for (n3 = 0; n4 > n3; ++n3) {
                        dataWrapper = new DataWrapper();
                        if (HS2v6Buffer.checkIfNull(n3, byArray)) {
                            dataWrapper.setNull(s);
                        } else {
                            dataWrapper.setBinary(((ByteBuffer)list.get(n3)).array());
                        }
                        this.m_rows.get((int)n3)[n] = dataWrapper;
                        HS2v6Buffer.setObject(dataWrapper, this.m_rowsOfObjects, n3, n);
                    }
                    continue block18;
                }
                case 12: {
                    DataWrapper dataWrapper;
                    int n3;
                    Serializable serializable = tColumn.getStringVal();
                    List<Object> list = ((TStringColumn)serializable).getValues();
                    byte[] byArray = ((TStringColumn)serializable).getNulls();
                    int n4 = list.size();
                    for (n3 = 0; n4 > n3; ++n3) {
                        dataWrapper = new DataWrapper();
                        if (HS2v6Buffer.checkIfNull(n3, byArray)) {
                            dataWrapper.setNull(s);
                        } else {
                            dataWrapper.setVarChar((String)list.get(n3));
                        }
                        this.m_rows.get((int)n3)[n] = dataWrapper;
                        HS2v6Buffer.setObject(dataWrapper, this.m_rowsOfObjects, n3, n);
                    }
                    continue block18;
                }
                case 1: {
                    DataWrapper dataWrapper;
                    int n3;
                    Serializable serializable = tColumn.getStringVal();
                    List<Object> list = ((TStringColumn)serializable).getValues();
                    byte[] byArray = ((TStringColumn)serializable).getNulls();
                    int n4 = list.size();
                    for (n3 = 0; n4 > n3; ++n3) {
                        dataWrapper = new DataWrapper();
                        if (HS2v6Buffer.checkIfNull(n3, byArray)) {
                            dataWrapper.setNull(s);
                        } else {
                            dataWrapper.setChar((String)list.get(n3));
                        }
                        this.m_rows.get((int)n3)[n] = dataWrapper;
                        HS2v6Buffer.setObject(dataWrapper, this.m_rowsOfObjects, n3, n);
                    }
                    continue block18;
                }
                case 16: {
                    DataWrapper dataWrapper;
                    int n3;
                    Serializable serializable;
                    if (this.m_settings.m_platformVersionUtils.hasIssueWithNullTypeData(this.m_settings.m_serverVersion) && ((TColumn._Fields)tColumn.getSetField()).getFieldName().equals("stringVal")) {
                        serializable = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_RESULTSET_DATA_RETRIEVING_ERR.name(), new String[]{"Incorrect data type returned from server."});
                        throw serializable;
                    }
                    serializable = tColumn.getBoolVal();
                    List<Object> list = ((TBoolColumn)serializable).getValues();
                    byte[] byArray = ((TBoolColumn)serializable).getNulls();
                    int n4 = list.size();
                    for (n3 = 0; n4 > n3; ++n3) {
                        dataWrapper = new DataWrapper();
                        if (HS2v6Buffer.checkIfNull(n3, byArray)) {
                            dataWrapper.setNull(s);
                        } else {
                            dataWrapper.setBoolean((Boolean)list.get(n3));
                        }
                        this.m_rows.get((int)n3)[n] = dataWrapper;
                        HS2v6Buffer.setObject(dataWrapper, this.m_rowsOfObjects, n3, n);
                    }
                    continue block18;
                }
                case -6: {
                    DataWrapper dataWrapper;
                    int n3;
                    Serializable serializable = tColumn.getByteVal();
                    List<Object> list = ((TByteColumn)serializable).getValues();
                    byte[] byArray = ((TByteColumn)serializable).getNulls();
                    int n4 = list.size();
                    for (n3 = 0; n4 > n3; ++n3) {
                        dataWrapper = new DataWrapper();
                        if (HS2v6Buffer.checkIfNull(n3, byArray)) {
                            dataWrapper.setNull(s);
                        } else {
                            dataWrapper.setTinyInt(((Byte)list.get(n3)).byteValue());
                        }
                        this.m_rows.get((int)n3)[n] = dataWrapper;
                        HS2v6Buffer.setObject(dataWrapper, this.m_rowsOfObjects, n3, n);
                    }
                    continue block18;
                }
                case 5: {
                    DataWrapper dataWrapper;
                    int n3;
                    int n4;
                    byte[] byArray;
                    List<Object> list;
                    Serializable serializable;
                    if (tColumn.isSetI16Val()) {
                        serializable = tColumn.getI16Val();
                        list = ((TI16Column)serializable).getValues();
                        byArray = ((TI16Column)serializable).getNulls();
                        n4 = list.size();
                        for (n3 = 0; n4 > n3; ++n3) {
                            dataWrapper = new DataWrapper();
                            if (HS2v6Buffer.checkIfNull(n3, byArray)) {
                                dataWrapper.setNull(s);
                            } else {
                                dataWrapper.setSmallInt(((Short)list.get(n3)).shortValue());
                            }
                            this.m_rows.get((int)n3)[n] = dataWrapper;
                            HS2v6Buffer.setObject(dataWrapper, this.m_rowsOfObjects, n3, n);
                        }
                        continue block18;
                    }
                    serializable = tColumn.getI32Val();
                    list = ((TI32Column)serializable).getValues();
                    byArray = ((TI32Column)serializable).getNulls();
                    n4 = list.size();
                    for (n3 = 0; n4 > n3; ++n3) {
                        dataWrapper = new DataWrapper();
                        if (HS2v6Buffer.checkIfNull(n3, byArray)) {
                            dataWrapper.setNull(s);
                        } else {
                            dataWrapper.setSmallInt((Integer)list.get(n3));
                        }
                        this.m_rows.get((int)n3)[n] = dataWrapper;
                        HS2v6Buffer.setObject(dataWrapper, this.m_rowsOfObjects, n3, n);
                    }
                    continue block18;
                }
                case 4: {
                    DataWrapper dataWrapper;
                    int n3;
                    Serializable serializable = tColumn.getI32Val();
                    List<Object> list = ((TI32Column)serializable).getValues();
                    byte[] byArray = ((TI32Column)serializable).getNulls();
                    int n4 = list.size();
                    for (n3 = 0; n4 > n3; ++n3) {
                        dataWrapper = new DataWrapper();
                        if (HS2v6Buffer.checkIfNull(n3, byArray)) {
                            dataWrapper.setNull(s);
                        } else if (this.m_settings.m_isStoreIntegerAsLong) {
                            dataWrapper.setInteger(((Integer)list.get(n3)).intValue());
                        } else {
                            try {
                                dataWrapper.setData(4, list.get(n3));
                            }
                            catch (IncorrectTypeException incorrectTypeException) {
                                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_RESULTSET_DATA_RETRIEVING_ERR.name(), new String[]{"Unable to set data for an integer value."});
                                errorException.initCause(incorrectTypeException);
                                throw errorException;
                            }
                        }
                        this.m_rows.get((int)n3)[n] = dataWrapper;
                        HS2v6Buffer.setObject(dataWrapper, this.m_rowsOfObjects, n3, n);
                    }
                    continue block18;
                }
                case -5: {
                    DataWrapper dataWrapper;
                    int n3;
                    Serializable serializable = tColumn.getI64Val();
                    List<Object> list = ((TI64Column)serializable).getValues();
                    byte[] byArray = ((TI64Column)serializable).getNulls();
                    int n4 = list.size();
                    for (n3 = 0; n4 > n3; ++n3) {
                        dataWrapper = new DataWrapper();
                        if (HS2v6Buffer.checkIfNull(n3, byArray)) {
                            dataWrapper.setNull(s);
                        } else {
                            dataWrapper.setBigInt((Long)list.get(n3));
                        }
                        this.m_rows.get((int)n3)[n] = dataWrapper;
                        HS2v6Buffer.setObject(dataWrapper, this.m_rowsOfObjects, n3, n);
                    }
                    continue block18;
                }
                case 7: 
                case 8: {
                    DataWrapper dataWrapper;
                    int n3;
                    Serializable serializable = tColumn.getDoubleVal();
                    List<Object> list = ((TDoubleColumn)serializable).getValues();
                    byte[] byArray = ((TDoubleColumn)serializable).getNulls();
                    int n4 = list.size();
                    for (n3 = 0; n4 > n3; ++n3) {
                        dataWrapper = new DataWrapper();
                        if (HS2v6Buffer.checkIfNull(n3, byArray)) {
                            dataWrapper.setNull(s);
                        } else if (7 == s) {
                            dataWrapper.setReal(((Double)list.get(n3)).floatValue());
                        } else {
                            dataWrapper.setDouble((Double)list.get(n3));
                        }
                        this.m_rows.get((int)n3)[n] = dataWrapper;
                        HS2v6Buffer.setObject(dataWrapper, this.m_rowsOfObjects, n3, n);
                    }
                    continue block18;
                }
                case 93: {
                    DataWrapper dataWrapper;
                    int n3;
                    Serializable serializable = tColumn.getStringVal();
                    List<Object> list = ((TStringColumn)serializable).getValues();
                    byte[] byArray = ((TStringColumn)serializable).getNulls();
                    int n4 = list.size();
                    for (n3 = 0; n4 > n3; ++n3) {
                        dataWrapper = new DataWrapper();
                        if (HS2v6Buffer.checkIfNull(n3, byArray)) {
                            dataWrapper.setNull(s);
                        } else {
                            dataWrapper.setTimestamp(this.convertTimestamp((String)list.get(n3)));
                        }
                        this.m_rows.get((int)n3)[n] = dataWrapper;
                        HS2v6Buffer.setObject(dataWrapper, this.m_rowsOfObjects, n3, n);
                    }
                    continue block18;
                }
                case 3: {
                    DataWrapper dataWrapper;
                    int n3;
                    Serializable serializable = tColumn.getStringVal();
                    List<Object> list = ((TStringColumn)serializable).getValues();
                    byte[] byArray = ((TStringColumn)serializable).getNulls();
                    int n4 = list.size();
                    for (n3 = 0; n4 > n3; ++n3) {
                        dataWrapper = new DataWrapper();
                        if (HS2v6Buffer.checkIfNull(n3, byArray)) {
                            dataWrapper.setNull(s);
                        } else {
                            dataWrapper.setDecimal(new BigDecimal((String)list.get(n3)));
                        }
                        this.m_rows.get((int)n3)[n] = dataWrapper;
                        HS2v6Buffer.setObject(dataWrapper, this.m_rowsOfObjects, n3, n);
                    }
                    continue block18;
                }
                case 91: {
                    DataWrapper dataWrapper;
                    int n3;
                    Serializable serializable = tColumn.getStringVal();
                    List<Object> list = ((TStringColumn)serializable).getValues();
                    byte[] byArray = ((TStringColumn)serializable).getNulls();
                    int n4 = list.size();
                    for (n3 = 0; n4 > n3; ++n3) {
                        dataWrapper = new DataWrapper();
                        if (HS2v6Buffer.checkIfNull(n3, byArray)) {
                            dataWrapper.setNull(s);
                        } else {
                            dataWrapper.setDate(Date.valueOf((String)list.get(n3)));
                        }
                        this.m_rows.get((int)n3)[n] = dataWrapper;
                        HS2v6Buffer.setObject(dataWrapper, this.m_rowsOfObjects, n3, n);
                    }
                    continue block18;
                }
                default: {
                    Serializable serializable = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_RESULTSET_DATA_RETRIEVING_ERR.name(), new String[]{"Unsupported data type in the row set."});
                    throw serializable;
                }
            }
        }
        this.m_currRow = this.m_rowIter.next();
        this.m_currRowObjects = this.m_rowObjectIter.next();
    }

    private static boolean checkIfNull(int n, byte[] byArray) {
        int n2 = n / 8;
        int n3 = n % 8;
        return HS2v6Buffer.checkIfNull(n2, n3, byArray);
    }

    private static boolean checkIfNull(int n, int n2, byte[] byArray) {
        if (n >= byArray.length) {
            return false;
        }
        return (byArray[n] & BITMASK_TO_CELL_MAP[n2]) != 0;
    }

    private void deriveColumnTypes() {
        List<TColumn> list = this.getHiveServer2Buffer().getResults().getColumns();
        int n = list.size();
        this.m_context.m_columnTypes = new short[n];
        for (int i = 0; n > i; ++i) {
            TColumn tColumn = list.get(i);
            this.m_context.m_columnTypes[i] = tColumn.isSetBinaryVal() ? -2 : (tColumn.isSetBoolVal() ? 16 : (tColumn.isSetByteVal() ? -6 : (tColumn.isSetDoubleVal() ? 8 : (tColumn.isSetI16Val() ? 5 : (tColumn.isSetI32Val() ? 4 : (tColumn.isSetI64Val() ? -5 : 12))))));
        }
    }
}

