/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.hivecommon.api;

import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TFetchResultsResp;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.DSITypeUtilities;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.hiveserver2.dsi.exceptions.IncorrectTypeException;
import com.cloudera.hiveserver2.hivecommon.HiveJDBCSettings;
import com.cloudera.hiveserver2.hivecommon.api.HS2Buffer;
import com.cloudera.hiveserver2.hivecommon.api.HiveOperationContext;
import com.cloudera.hiveserver2.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hiveserver2.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.hiveserver2.support.ILogger;
import com.cloudera.hiveserver2.support.LogUtilities;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MaterializedHS2Buffer
extends HS2Buffer {
    private HS2Buffer m_wrappedHS2Buffer;
    private HiveOperationContext m_context;
    private List<DataWrapper[]> m_rows;
    private Iterator<DataWrapper[]> m_rowIter;
    private DataWrapper[] m_currRow;
    private List<Object[]> m_rowsOfObjects;
    private Iterator<Object[]> m_rowObjectIter;
    private Object[] m_currRowObjects;
    private int m_currRowParsedInBuffer = 0;
    private boolean m_isMaterialized = false;

    MaterializedHS2Buffer(ILogger iLogger, HiveJDBCSettings hiveJDBCSettings, HS2Buffer hS2Buffer, HiveOperationContext hiveOperationContext) {
        super(iLogger, hiveJDBCSettings);
        this.m_context = hiveOperationContext;
        this.m_wrappedHS2Buffer = hS2Buffer;
    }

    @Override
    public Object[] getCurrentRowObjectArray() {
        return this.m_currRowObjects;
    }

    @Override
    public boolean getData(int n, long l, long l2, DataWrapper dataWrapper, int n2, short s, String string, HiveJDBCSettings hiveJDBCSettings) throws ErrorException {
        if (!this.m_isMaterialized) {
            return this.m_wrappedHS2Buffer.getData(n, l, l2, dataWrapper, n2, s, string, hiveJDBCSettings);
        }
        if (null == this.m_currRow) {
            throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_RESULTSET_DATA_RETRIEVING_ERR.name(), new String[]{"Cannot get data from an empty row set."});
        }
        DataWrapper dataWrapper2 = this.m_currRow[n];
        if (dataWrapper2.isNull()) {
            dataWrapper.copyData(dataWrapper2);
            return false;
        }
        switch (s) {
            case -2: 
            case 1: 
            case 12: {
                if (0L == l && -1L == l2) {
                    dataWrapper.copyData(dataWrapper2);
                    return false;
                }
                try {
                    if (-2 == s) {
                        return DSITypeUtilities.outputBinary(dataWrapper2.getBinary(), dataWrapper, l, l2);
                    }
                    if (12 == s) {
                        return DSITypeUtilities.outputVarCharStringData(dataWrapper2.getVarChar(), dataWrapper, l, l2);
                    }
                    return DSITypeUtilities.outputVarCharStringData(dataWrapper2.getChar(), dataWrapper, l, l2);
                }
                catch (IncorrectTypeException incorrectTypeException) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_RESULTSET_DATA_RETRIEVING_ERR.name(), new String[]{"Incorrect data type."});
                    errorException.initCause(incorrectTypeException);
                    throw errorException;
                }
            }
            case -6: 
            case -5: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 16: 
            case 91: 
            case 93: {
                dataWrapper.copyData(dataWrapper2);
                return false;
            }
        }
        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_RESULTSET_DATA_RETRIEVING_ERR.name(), new String[]{"Data Type May Not Supported"});
        throw errorException;
    }

    @Override
    public DataWrapper getDataWrapper(int n) throws ErrorException {
        if (!this.m_isMaterialized) {
            return this.m_wrappedHS2Buffer.getDataWrapper(n);
        }
        if (null == this.m_currRow) {
            throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_RESULTSET_DATA_RETRIEVING_ERR.name(), new String[]{"Cannot get DataWrapper from an empty row set."});
        }
        return this.m_currRow[n];
    }

    @Override
    public Integer getInt(int n, int n2) {
        return this.m_wrappedHS2Buffer.getInt(n, n2);
    }

    @Override
    public TFetchResultsResp getHiveServer2Buffer() {
        return this.m_wrappedHS2Buffer.getHiveServer2Buffer();
    }

    @Override
    public List<Integer> getIntColumn(int n) {
        return this.m_wrappedHS2Buffer.getIntColumn(n);
    }

    @Override
    public int getNumColumns() {
        return this.m_wrappedHS2Buffer.getNumColumns();
    }

    @Override
    public int getNumRowsInBuffer() {
        return this.m_wrappedHS2Buffer.getNumRowsInBuffer();
    }

    @Override
    public String getString(int n, int n2) {
        return this.m_wrappedHS2Buffer.getString(n, n2);
    }

    @Override
    public List<String> getStringColumn(int n) {
        return this.m_wrappedHS2Buffer.getStringColumn(n);
    }

    @Override
    public boolean isGetNextBuffer(int n) throws ErrorException {
        if (!this.m_isMaterialized) {
            return this.m_wrappedHS2Buffer.isGetNextBuffer(n);
        }
        return n >= this.m_numRows;
    }

    @Override
    public void parseRow(int n) throws ErrorException {
        if (!this.m_isMaterialized) {
            this.m_wrappedHS2Buffer.parseRow(n);
            return;
        }
        if (this.m_currRowParsedInBuffer != n) {
            if (this.m_currRowParsedInBuffer + 1 != n) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), "Only Forward-only cursor is supported. Current row parsed in buffer: " + this.m_currRowParsedInBuffer + ", next row index: " + n);
                throw errorException;
            }
        } else {
            return;
        }
        this.m_currRowParsedInBuffer = n;
        this.m_currRow = this.m_rowIter.next();
        this.m_currRowObjects = this.m_rowObjectIter.next();
    }

    @Override
    public void setHiveServer2Buffer(TFetchResultsResp tFetchResultsResp) {
        this.m_wrappedHS2Buffer.setHiveServer2Buffer(tFetchResultsResp);
        this.m_isBufferInitialized = false;
    }

    @Override
    protected void handleInitializeBuffer() throws ErrorException {
        int n;
        this.m_wrappedHS2Buffer.handleInitializeBuffer();
        int n2 = this.getNumColumns();
        this.m_currRowParsedInBuffer = 0;
        this.m_isMaterialized = false;
        this.m_rows = new ArrayList<DataWrapper[]>();
        for (n = 0; n < this.m_numRows; ++n) {
            this.m_rows.add(new DataWrapper[n2]);
        }
        this.m_rowIter = this.m_rows.iterator();
        this.m_currRow = null;
        this.m_rowsOfObjects = new ArrayList<Object[]>();
        for (n = 0; n < this.m_numRows; ++n) {
            this.m_rowsOfObjects.add(new Object[n2]);
        }
        this.m_rowObjectIter = this.m_rowsOfObjects.iterator();
        this.m_currRowObjects = null;
        if (null == this.m_context.m_columnTypes) {
            LogUtilities.logDebug("Column types not available. Unable to materalize the DataWrappers", this.m_logger);
            return;
        }
        if (0 == this.m_numRows) {
            LogUtilities.logDebug("The buffer doesn't contain any rows. No need to materialize any DataWrappers.", this.m_logger);
            return;
        }
        n = 0;
        do {
            if (0 < n) {
                this.m_wrappedHS2Buffer.parseRow(n);
            }
            for (int i = 0; i < n2; ++i) {
                DataWrapper dataWrapper = new DataWrapper();
                this.m_wrappedHS2Buffer.getData(i, 0L, -1L, dataWrapper, n, this.m_context.m_columnTypes[i], this.m_context.m_operation, this.m_settings);
                this.m_rows.get((int)n)[i] = dataWrapper;
                MaterializedHS2Buffer.setObject(dataWrapper, this.m_rowsOfObjects, n, i);
            }
        } while (!this.m_wrappedHS2Buffer.isGetNextBuffer(++n));
        this.m_currRow = this.m_rowIter.next();
        this.m_currRowObjects = this.m_rowObjectIter.next();
        this.m_isMaterialized = true;
    }

    @Override
    public void setNumRows() throws ErrorException {
        this.m_wrappedHS2Buffer.setNumRows();
        this.m_numRows = this.m_wrappedHS2Buffer.getNumRowsInBuffer();
    }
}

