/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.hivecommon.dataengine;

import com.cloudera.hiveserver2.dsi.dataengine.utilities.DSITypeUtilities;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.MetadataSourceID;
import com.cloudera.hiveserver2.hivecommon.HiveJDBCSettings;
import com.cloudera.hiveserver2.hivecommon.api.HS2Client;
import com.cloudera.hiveserver2.hivecommon.api.HiveExecutionContext;
import com.cloudera.hiveserver2.hivecommon.api.IHiveClient;
import com.cloudera.hiveserver2.hivecommon.core.HiveJDBCCommonConnection;
import com.cloudera.hiveserver2.hivecommon.core.HiveJDBCStatement;
import com.cloudera.hiveserver2.hivecommon.dataengine.HiveJDBCResultSet;
import com.cloudera.hiveserver2.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.hiveserver2.jdbc.utils.HivePkFkAPINotSupportedException;
import com.cloudera.hiveserver2.support.ILogger;
import com.cloudera.hiveserver2.support.LogUtilities;
import com.cloudera.hiveserver2.support.Warning;
import com.cloudera.hiveserver2.support.WarningCode;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import com.cloudera.hiveserver2.utilities.MetaDataFactory;
import java.util.ArrayList;

public class HivePrimaryKeysForeignKeysResult
extends HiveJDBCResultSet {
    public MetadataSourceID m_metadataSourceId;
    public HiveJDBCSettings m_settings;
    public boolean m_isPkFkSupported;
    public ArrayList<String> m_filterValues;
    public static final int PK_TABLE_CATALOG_NAME_COLUMN = 0;
    public static final int FK_TABLE_CATALOG_NAME_COLUMN = 4;

    public HivePrimaryKeysForeignKeysResult(HiveExecutionContext hiveExecutionContext, IHiveClient iHiveClient, HiveJDBCStatement hiveJDBCStatement, HiveJDBCCommonConnection hiveJDBCCommonConnection, ILogger iLogger, boolean bl, boolean bl2, MetadataSourceID metadataSourceID, HiveJDBCSettings hiveJDBCSettings, ArrayList<String> arrayList) throws ErrorException {
        block6: {
            super(hiveExecutionContext, iHiveClient, hiveJDBCStatement, hiveJDBCCommonConnection, iLogger, bl, bl2);
            this.m_isPkFkSupported = false;
            this.m_metadataSourceId = metadataSourceID;
            this.m_settings = hiveJDBCSettings;
            this.m_filterValues = arrayList;
            if (this.m_client instanceof HS2Client) {
                this.m_isPkFkSupported = ((HS2Client)this.m_client).IsSupportPrimaryKeysForeignKeys();
            }
            if (this.m_isPkFkSupported && hiveJDBCSettings.m_enablePKFK.booleanValue()) {
                try {
                    if (MetadataSourceID.PRIMARY_KEYS == this.m_metadataSourceId) {
                        this.m_context = ((HS2Client)this.m_client).GetPrimaryKeys(this.m_filterValues, hiveJDBCStatement);
                        this.setupCatalogColumns((ArrayList)MetaDataFactory.createPrimaryKeysMetaData());
                        break block6;
                    }
                    this.m_context = ((HS2Client)this.m_client).GetForeignKeys(this.m_filterValues, hiveJDBCStatement);
                    this.setupCatalogColumns((ArrayList)MetaDataFactory.createForeignKeysMetaData());
                }
                catch (HivePkFkAPINotSupportedException hivePkFkAPINotSupportedException) {
                    this.m_client.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.UNSUPPORTED_OPERATION_ERR.name(), new String[]{hivePkFkAPINotSupportedException.getMessage()}));
                    hiveJDBCSettings.m_enablePKFK = false;
                    this.m_hasMoreRows = false;
                }
            } else {
                this.m_hasMoreRows = false;
            }
        }
    }

    @Override
    public boolean getData(int n, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (0 == n || 4 == n && this.m_metadataSourceId == MetadataSourceID.FOREIGN_KEYS) {
            DSITypeUtilities.outputVarCharStringData(this.m_settings.m_catalog, dataWrapper, l, l2);
        }
        return super.getData(n, l, l2, dataWrapper);
    }

    @Override
    public boolean moveToNextRow() throws ErrorException {
        if (!this.m_context.m_isExecutionComplete && this.m_settings.m_enablePKFK.booleanValue() && this.m_client instanceof HS2Client) {
            ((HS2Client)this.m_client).pollForOperationCompletion(this.m_context);
        }
        return super.moveToNextRow();
    }
}

