/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.hivecommon.dataengine.metadata;

import com.cloudera.hiveserver2.dsi.dataengine.interfaces.IMetadataSource;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.DSITypeUtilities;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.cloudera.hiveserver2.hivecommon.api.IHiveClient;
import com.cloudera.hiveserver2.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hiveserver2.hivecommon.core.HiveJDBCStatement;
import com.cloudera.hiveserver2.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.hiveserver2.support.ILogger;
import com.cloudera.hiveserver2.support.LogUtilities;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.util.List;

public class HiveJDBCCatalogOnlyMetadataSource
implements IMetadataSource {
    private ILogger m_logger;
    private boolean m_hasStartedFetch = false;
    private final IHiveClient<?> m_hiveClient;
    private List<String> m_catalogs;
    private HiveJDBCStatement m_statement;
    private int m_currentIndex = -1;

    public HiveJDBCCatalogOnlyMetadataSource(ILogger iLogger, IHiveClient iHiveClient, HiveJDBCStatement hiveJDBCStatement) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, iLogger);
        this.m_logger = iLogger;
        this.m_hiveClient = iHiveClient;
        this.m_catalogs = null;
        this.m_statement = hiveJDBCStatement;
        this.initCatalog();
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.closeCursor();
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_hasStartedFetch = false;
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_catalogs.get(this.m_currentIndex), dataWrapper, l, l2);
            }
        }
        throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.METADATA_COLUMN_NOT_FOUND.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return !this.m_hasStartedFetch;
    }

    private void initCatalog() throws ErrorException {
        if (this.m_catalogs == null) {
            try {
                this.m_catalogs = this.m_hiveClient.getCatalogs(this.m_statement);
            }
            catch (Exception exception) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_METADATA_CATALOG_ERR.name(), "Metadata Initialization Error");
                errorException.initCause(exception);
                throw errorException;
            }
        }
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_currentIndex >= this.m_catalogs.size() - 1) {
            return false;
        }
        ++this.m_currentIndex;
        if (!this.m_hasStartedFetch) {
            this.m_hasStartedFetch = true;
        }
        return true;
    }
}

