/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.aeprocessor.aebuilder.statement;

import com.cloudera.hiveserver2.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.AEUtils;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aebuilder.AEBuilderBase;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aebuilder.AEBuilderCheck;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aebuilder.bool.AEBooleanExprBuilder;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aebuilder.relation.AERelationalExprBuilder;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aebuilder.relation.AETableNameBuilder;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aebuilder.value.AEColumnReferenceBuilder;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aebuilder.value.AEValueExprBuilder;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.bool.AEBooleanTrue;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.relation.AETable;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.statement.AEDelete;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.statement.AEInsert;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.statement.AEInsertDefaults;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.statement.AERowCountStatement;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.statement.AESetClause;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.statement.AESetClauseList;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.statement.AEUpdate;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.statement.IAEStatement;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.cloudera.hiveserver2.sqlengine.dsiext.dataengine.OpenTableType;
import com.cloudera.hiveserver2.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.cloudera.hiveserver2.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver2.sqlengine.parser.parsetree.IPTNode;
import com.cloudera.hiveserver2.sqlengine.parser.parsetree.PTFlagNode;
import com.cloudera.hiveserver2.sqlengine.parser.parsetree.PTIdentifierNode;
import com.cloudera.hiveserver2.sqlengine.parser.parsetree.PTListNode;
import com.cloudera.hiveserver2.sqlengine.parser.parsetree.PTNonterminalNode;
import com.cloudera.hiveserver2.sqlengine.parser.type.PTFlagType;
import com.cloudera.hiveserver2.sqlengine.parser.type.PTListType;
import com.cloudera.hiveserver2.sqlengine.parser.type.PTNonterminalType;
import com.cloudera.hiveserver2.sqlengine.parser.type.PTPositionalType;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AEDmlStatementBuilder
extends AEBuilderBase<IAEStatement> {
    public AEDmlStatementBuilder(AEQueryScope aEQueryScope) {
        super(aEQueryScope);
    }

    @Override
    public IAEStatement visit(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        switch (pTNonterminalNode.getNonterminalType()) {
            case INSERT_STATEMENT: {
                return this.buildInsertStmt(pTNonterminalNode);
            }
            case UPDATE_STATEMENT_SEARCHED: 
            case UPSERT_STATEMENT: {
                return this.buildUpdateStmt(pTNonterminalNode);
            }
            case DELETE_STATEMENT_SEARCHED: {
                return this.buildDeleteStmt(pTNonterminalNode);
            }
        }
        throw SQLEngineExceptionFactory.invalidParseTreeException();
    }

    private AEDelete buildDeleteStmt(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        AEBooleanExpr aEBooleanExpr;
        AEBuilderCheck.checkThat(pTNonterminalNode, AEBuilderCheck.is(AEBuilderCheck.nonTerminal(PTNonterminalType.DELETE_STATEMENT_SEARCHED).withExactChildren(PTPositionalType.TABLE_NAME, AEBuilderCheck.nonTerminal(PTNonterminalType.TABLE_NAME), PTPositionalType.SEARCH_COND, AEBuilderCheck.optional(AEBuilderCheck.nonTerminal(PTNonterminalType.WHERE_CLAUSE)))));
        AEQueryScope aEQueryScope = this.getQueryScope();
        AEUtils.checkReadOnly(aEQueryScope.getDataEngine().getContext(), "DELETE");
        aEQueryScope.setOpenTableType(OpenTableType.READ_WRITE);
        aEQueryScope.setCurrentClause(AEQueryScope.ClauseType.NONE);
        AETable aETable = new AETableNameBuilder(aEQueryScope).visit((PTNonterminalNode)pTNonterminalNode.getChild(PTPositionalType.TABLE_NAME));
        aEQueryScope.addTableSymbol(aETable);
        IPTNode iPTNode = pTNonterminalNode.getChild(PTPositionalType.SEARCH_COND);
        if (iPTNode.isEmptyNode()) {
            aEBooleanExpr = new AEBooleanTrue();
        } else {
            PTNonterminalNode pTNonterminalNode2 = (PTNonterminalNode)iPTNode;
            IPTNode iPTNode2 = pTNonterminalNode2.getChild(PTPositionalType.SEARCH_COND);
            if (null == iPTNode2) {
                throw SQLEngineExceptionFactory.invalidParseTreeException();
            }
            aEQueryScope.setCurrentClause(AEQueryScope.ClauseType.WHERE);
            aEBooleanExpr = (AEBooleanExpr)new AEBooleanExprBuilder(aEQueryScope).build(iPTNode2);
        }
        return new AEDelete(aETable, aEBooleanExpr);
    }

    private AERowCountStatement buildInsertStmt(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        IAENode iAENode2;
        AEBuilderCheck.checkThat(pTNonterminalNode, AEBuilderCheck.is(AEBuilderCheck.nonTerminal(PTNonterminalType.INSERT_STATEMENT).withExactChildren(PTPositionalType.TABLE_NAME, AEBuilderCheck.nonTerminal(PTNonterminalType.TABLE_NAME), PTPositionalType.INSERT_LIST, AEBuilderCheck.eitherOf(AEBuilderCheck.nonTerminal(PTNonterminalType.INSERT_LIST), AEBuilderCheck.flagNode(PTFlagType.DEFAULT, new PTFlagType[0])))));
        AEQueryScope aEQueryScope = this.getQueryScope();
        AEUtils.checkReadOnly(aEQueryScope.getDataEngine().getContext(), "INSERT");
        aEQueryScope.setOpenTableType(OpenTableType.READ_WRITE);
        aEQueryScope.setCurrentClause(AEQueryScope.ClauseType.NONE);
        AETable aETable = new AETableNameBuilder(aEQueryScope).visit((PTNonterminalNode)pTNonterminalNode.getChild(PTPositionalType.TABLE_NAME));
        aEQueryScope.addTableSymbol(aETable);
        IPTNode iPTNode = pTNonterminalNode.getChild(PTPositionalType.INSERT_LIST);
        if (iPTNode instanceof PTFlagNode) {
            return new AEInsertDefaults(aETable);
        }
        PTNonterminalNode pTNonterminalNode2 = (PTNonterminalNode)iPTNode;
        AEBuilderCheck.checkThat(pTNonterminalNode2, AEBuilderCheck.is(AEBuilderCheck.nonTerminal(PTNonterminalType.INSERT_LIST)).withExactChildren(PTPositionalType.COLUMN_LIST, AEBuilderCheck.optionalList(PTListType.COLUMN_NAME_LIST), PTPositionalType.QUERY_EXPRESSION, AEBuilderCheck.anything()));
        IPTNode iPTNode2 = pTNonterminalNode2.getChild(PTPositionalType.COLUMN_LIST);
        AEValueExprList aEValueExprList = AEDmlStatementBuilder.buildColumnList(iPTNode2, aEQueryScope);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(aEValueExprList.getNumChildren());
        for (IAENode iAENode2 : aEValueExprList) {
            arrayList.add(((AEColumnReference)iAENode2).getColumnNum());
        }
        List<IColumn> list = arrayList.isEmpty() ? aETable.createResultSetColumns() : aETable.createResultSetColumns(arrayList);
        iAENode2 = this.buildInsertTableValues(pTNonterminalNode2.getChild(PTPositionalType.QUERY_EXPRESSION), list);
        SqlDataEngineContext sqlDataEngineContext = aEQueryScope.getDataEngine().getContext();
        return new AEInsert(aETable, aEValueExprList, (AERelationalExpr)iAENode2, sqlDataEngineContext);
    }

    private AERelationalExpr buildInsertTableValues(IPTNode iPTNode, List<IColumn> list) throws ErrorException {
        PTListNode pTListNode;
        AEQueryScope aEQueryScope = new AEQueryScope(this.getQueryScope().getDataEngine());
        aEQueryScope.setOpenTableType(OpenTableType.READ_ONLY);
        aEQueryScope.setCurrentClause(AEQueryScope.ClauseType.NONE);
        AERelationalExprBuilder aERelationalExprBuilder = new AERelationalExprBuilder(aEQueryScope, true);
        if (iPTNode instanceof PTListNode && PTListType.TABLE_VALUE_LIST == (pTListNode = (PTListNode)iPTNode).getListType()) {
            return aERelationalExprBuilder.buildTableValueList(pTListNode, list);
        }
        return (AERelationalExpr)aERelationalExprBuilder.build(iPTNode);
    }

    private AEUpdate buildUpdateStmt(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        AEBooleanExpr aEBooleanExpr;
        AEBuilderCheck.checkThat(pTNonterminalNode, AEBuilderCheck.eitherOf(AEBuilderCheck.nonTerminal(PTNonterminalType.UPDATE_STATEMENT_SEARCHED), AEBuilderCheck.nonTerminal(PTNonterminalType.UPSERT_STATEMENT)));
        AEBuilderCheck.checkThat(pTNonterminalNode, AEBuilderCheck.is(AEBuilderCheck.nonTerminal().withExactChildren(PTPositionalType.TABLE_NAME, AEBuilderCheck.nonTerminal(PTNonterminalType.TABLE_NAME), PTPositionalType.SET_CLAUSE_LIST, AEBuilderCheck.list(PTListType.SET_CLAUSE_LIST), PTPositionalType.SEARCH_COND, AEBuilderCheck.optional(AEBuilderCheck.nonTerminal(PTNonterminalType.WHERE_CLAUSE)))));
        AEQueryScope aEQueryScope = this.getQueryScope();
        AEUtils.checkReadOnly(aEQueryScope.getDataEngine().getContext(), "UPDATE");
        aEQueryScope.setOpenTableType(OpenTableType.READ_WRITE);
        aEQueryScope.setCurrentClause(AEQueryScope.ClauseType.NONE);
        AETable aETable = new AETableNameBuilder(aEQueryScope).visit((PTNonterminalNode)pTNonterminalNode.getChild(PTPositionalType.TABLE_NAME));
        aEQueryScope.addTableSymbol(aETable);
        AESetClauseList aESetClauseList = AEDmlStatementBuilder.buildSetClauseList(pTNonterminalNode.getChild(PTPositionalType.SET_CLAUSE_LIST), aEQueryScope);
        IPTNode iPTNode = pTNonterminalNode.getChild(PTPositionalType.SEARCH_COND);
        if (iPTNode.isEmptyNode()) {
            aEBooleanExpr = new AEBooleanTrue();
        } else {
            PTNonterminalNode pTNonterminalNode2 = (PTNonterminalNode)iPTNode;
            IPTNode iPTNode2 = pTNonterminalNode2.getChild(PTPositionalType.SEARCH_COND);
            if (null == iPTNode2) {
                throw SQLEngineExceptionFactory.invalidParseTreeException();
            }
            aEQueryScope.setCurrentClause(AEQueryScope.ClauseType.WHERE);
            aEBooleanExpr = (AEBooleanExpr)new AEBooleanExprBuilder(aEQueryScope).build(iPTNode2);
        }
        if (pTNonterminalNode.getNonterminalType() == PTNonterminalType.UPSERT_STATEMENT) {
            return new AEUpdate(aETable, aESetClauseList, aEBooleanExpr, true);
        }
        return new AEUpdate(aETable, aESetClauseList, aEBooleanExpr, false);
    }

    private static AEValueExprList buildColumnList(IPTNode iPTNode, AEQueryScope aEQueryScope) throws ErrorException {
        AEValueExprList aEValueExprList = new AEValueExprList();
        if (iPTNode.isEmptyNode()) {
            return aEValueExprList;
        }
        if (!(iPTNode instanceof PTListNode)) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        PTListNode pTListNode = (PTListNode)iPTNode;
        assert (PTListType.COLUMN_NAME_LIST == pTListNode.getListType());
        assert (0 < pTListNode.numChildren());
        AEColumnReferenceBuilder aEColumnReferenceBuilder = new AEColumnReferenceBuilder(aEQueryScope);
        Iterator<IPTNode> iterator = pTListNode.getChildItr();
        while (iterator.hasNext()) {
            IPTNode iPTNode2 = iterator.next();
            if (!(iPTNode2 instanceof PTIdentifierNode)) {
                throw SQLEngineExceptionFactory.invalidParseTreeException();
            }
            aEValueExprList.addNode(aEColumnReferenceBuilder.visit((PTIdentifierNode)iPTNode2));
        }
        return aEValueExprList;
    }

    private static AESetClause buildSetClause(PTNonterminalNode pTNonterminalNode, AEValueExprBuilder aEValueExprBuilder, AEColumnReferenceBuilder aEColumnReferenceBuilder) throws ErrorException {
        if (PTNonterminalType.SET_CLAUSE != pTNonterminalNode.getNonterminalType()) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        IPTNode iPTNode = pTNonterminalNode.getChild(PTPositionalType.COLUMN_NAME);
        IPTNode iPTNode2 = pTNonterminalNode.getChild(PTPositionalType.VALUE_EXPRESSION);
        if (!(iPTNode instanceof PTIdentifierNode) || null == iPTNode2) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        AEColumnReference aEColumnReference = (AEColumnReference)aEColumnReferenceBuilder.build(iPTNode);
        AEValueExpr aEValueExpr = (AEValueExpr)aEValueExprBuilder.build(iPTNode2);
        return new AESetClause(aEColumnReference, aEValueExpr);
    }

    private static AESetClauseList buildSetClauseList(IPTNode iPTNode, AEQueryScope aEQueryScope) throws ErrorException {
        AESetClauseList aESetClauseList = new AESetClauseList();
        if (!iPTNode.isEmptyNode()) {
            PTListNode pTListNode = (PTListNode)iPTNode;
            AEValueExprBuilder aEValueExprBuilder = new AEValueExprBuilder(aEQueryScope);
            AEColumnReferenceBuilder aEColumnReferenceBuilder = new AEColumnReferenceBuilder(aEQueryScope);
            Iterator<IPTNode> iterator = pTListNode.getChildItr();
            while (iterator.hasNext()) {
                IPTNode iPTNode2 = iterator.next();
                if (!(iPTNode2 instanceof PTNonterminalNode)) {
                    throw SQLEngineExceptionFactory.invalidParseTreeException();
                }
                aESetClauseList.addNode(AEDmlStatementBuilder.buildSetClause((PTNonterminalNode)iPTNode2, aEValueExprBuilder, aEColumnReferenceBuilder));
            }
        }
        return aESetClauseList;
    }
}

