/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.executor.etree;

import com.cloudera.hiveserver2.sqlengine.dsiext.dataengine.mem.MemoryManager;
import com.cloudera.hiveserver2.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver2.sqlengine.executor.etree.IETNode;
import com.cloudera.hiveserver2.sqlengine.executor.etree.IETResource;
import com.cloudera.hiveserver2.sqlengine.executor.etree.IMemManagerAgent;
import com.cloudera.hiveserver2.sqlengine.executor.etree.IMemoryConsumer;
import com.cloudera.hiveserver2.sqlengine.executor.etree.util.ETWalker;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class ETMemoryManager
implements IETResource {
    private ArrayList<IMemoryConsumer> m_consumers = new ArrayList();
    private HashMap<IMemManagerAgent, IMemoryConsumer> m_agentMap = new HashMap();
    private HashSet<IMemoryConsumer> m_unregistered = new HashSet();
    private int m_allocationId = -1;
    private long m_available = 0L;
    private int m_nextAssignIndex = -1;

    public static ETMemoryManager createMemoryManager(IETNode iETNode) {
        final ETMemoryManager eTMemoryManager = new ETMemoryManager();
        ETWalker.Action<Void> action = new ETWalker.Action<Void>(){

            @Override
            public void act(IETNode iETNode) {
                if (iETNode instanceof IMemoryConsumer) {
                    IMemoryConsumer iMemoryConsumer = (IMemoryConsumer)((Object)iETNode);
                    eTMemoryManager.addConsumer(iMemoryConsumer);
                }
            }

            @Override
            public Void getResult() {
                return null;
            }
        };
        ETWalker.walk(iETNode, action);
        eTMemoryManager.m_nextAssignIndex = eTMemoryManager.m_consumers.size() - 1;
        eTMemoryManager.m_allocationId = MemoryManager.getInstance().createUsageId();
        return eTMemoryManager;
    }

    private ETMemoryManager() {
    }

    private void addConsumer(IMemoryConsumer iMemoryConsumer) {
        MemManagerAgent memManagerAgent = new MemManagerAgent();
        iMemoryConsumer.registerManagerAgent(memManagerAgent);
        this.m_agentMap.put(memManagerAgent, iMemoryConsumer);
        this.m_consumers.add(iMemoryConsumer);
        this.m_unregistered.add(iMemoryConsumer);
    }

    @Override
    public void allocate() throws ErrorException {
        if (this.m_unregistered.size() != this.m_consumers.size()) {
            throw new IllegalStateException("Memory consumer is not unregistered on re-allocation.");
        }
        if (this.m_consumers.size() == 0) {
            return;
        }
        long l = 0L;
        for (IMemoryConsumer iMemoryConsumer : this.m_consumers) {
            l += iMemoryConsumer.getRequiredMemory();
        }
        if (!MemoryManager.getInstance().reserve(this.m_allocationId, l)) {
            throw SQLEngineExceptionFactory.failedToAllocateMemory("" + this.m_allocationId);
        }
        this.m_available = MemoryManager.getInstance().allocateMax(this.m_allocationId);
        long l2 = (this.m_available - l) / (long)this.m_consumers.size();
        for (IMemoryConsumer iMemoryConsumer : this.m_consumers) {
            long l3;
            long l4 = iMemoryConsumer.assign(l3 = l2 + iMemoryConsumer.getRequiredMemory());
            if (l4 > l3) {
                throw new IllegalArgumentException("Logic error from memory consumer implementation.");
            }
            this.m_available -= l4;
        }
        this.assignExtra(new IMemoryConsumer[0]);
        this.m_unregistered.clear();
    }

    @Override
    public void free() {
        MemoryManager.getInstance().free(this.m_allocationId);
        this.m_allocationId = -1;
        this.m_available = 0L;
    }

    private void assignExtra(IMemoryConsumer ... iMemoryConsumerArray) {
        if (this.m_available <= 0L) {
            return;
        }
        for (int i = 0; i < this.m_consumers.size() && this.m_available > 0L; ++i) {
            IMemoryConsumer iMemoryConsumer = this.m_consumers.get(this.m_nextAssignIndex);
            if (this.m_unregistered.contains(iMemoryConsumer)) continue;
            boolean bl = false;
            for (IMemoryConsumer iMemoryConsumer2 : iMemoryConsumerArray) {
                if (iMemoryConsumer2 != iMemoryConsumer) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            long l = iMemoryConsumer.assign(this.m_available);
            if (l > this.m_available) {
                throw new IllegalArgumentException("Logic error from memory consumer implementation.");
            }
            this.m_available -= l;
            --this.m_nextAssignIndex;
            if (this.m_nextAssignIndex >= 0) continue;
            this.m_nextAssignIndex = this.m_consumers.size() - 1;
        }
    }

    private class MemManagerAgent
    implements IMemManagerAgent {
        private MemManagerAgent() {
        }

        @Override
        public void recycleMemory(long l) {
            if (l < 0L) {
                throw new IllegalArgumentException(" Invalid amount to recycle: " + l);
            }
            if (l != 0L) {
                ETMemoryManager.this.m_available = ETMemoryManager.this.m_available + l;
                ETMemoryManager.this.assignExtra(new IMemoryConsumer[]{(IMemoryConsumer)ETMemoryManager.this.m_agentMap.get(this)});
            }
        }

        @Override
        public void unregisterConsumer() {
            ETMemoryManager.this.m_unregistered.add(ETMemoryManager.this.m_agentMap.get(this));
        }

        @Override
        public long require(long l, long l2) {
            if (ETMemoryManager.this.m_unregistered.contains(ETMemoryManager.this.m_agentMap.get(this))) {
                throw new IllegalArgumentException("Memory required from unregistered consumer.");
            }
            if (l < 0L || l > l2) {
                throw new IllegalArgumentException("Invalid request: (" + l + ", " + l2 + ").");
            }
            if (ETMemoryManager.this.m_available >= l) {
                if (ETMemoryManager.this.m_available > l2) {
                    ETMemoryManager.this.m_available = ETMemoryManager.this.m_available - l2;
                    return l2;
                }
                long l3 = ETMemoryManager.this.m_available;
                ETMemoryManager.this.m_available = 0L;
                return l3;
            }
            long l4 = 0L;
            l -= ETMemoryManager.this.m_available;
            l2 -= ETMemoryManager.this.m_available;
            while (l2 >= l) {
                if (MemoryManager.getInstance().allocate(ETMemoryManager.this.m_allocationId, l2)) {
                    l4 = l2;
                    break;
                }
                if (l2 == l) break;
                if ((l2 = (l2 - l) / 2L + l) >= l + 256L) continue;
                l2 = l;
            }
            if (l4 == 0L) {
                return -1L;
            }
            ETMemoryManager.this.m_available = 0L;
            return l4 += ETMemoryManager.this.m_available;
        }
    }
}

