/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.executor.etree.value.aggregatefn;

import com.cloudera.hiveserver2.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver2.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.aggregatefn.AbstractAggregatorFactory;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.aggregatefn.IAggregator;
import com.cloudera.hiveserver2.support.IWarningListener;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;

abstract class AbstractAggregator
implements IAggregator {
    protected IWarningListener m_listener = null;
    private final AbstractAggregatorFactory m_factory;
    private IAggregator.IUpdateParameters m_params;

    protected AbstractAggregator(AbstractAggregatorFactory abstractAggregatorFactory) {
        this.m_factory = abstractAggregatorFactory;
    }

    @Override
    public final void update(IAggregator.IUpdateParameters iUpdateParameters) throws ErrorException {
        this.m_params = iUpdateParameters;
        this.update();
    }

    @Override
    public final long getMemorySize(ColumnSizeCalculator.JavaSize javaSize) {
        return (long)(javaSize.getObjectShellSize() + 2 * javaSize.getObjectRefSize()) + this.getMemoryUsage();
    }

    @Override
    public void registerWarningListener(IWarningListener iWarningListener) {
        this.m_listener = iWarningListener;
    }

    protected abstract void update() throws ErrorException;

    protected abstract long getMemoryUsage();

    protected ISqlDataWrapper getArgumentData(int n) throws ErrorException {
        return this.m_params.getData(n);
    }

    protected ISqlDataWrapper getArgumentData(int n, long l, long l2) throws ErrorException {
        return this.m_params.getData(n, l, l2);
    }

    protected IColumn getInputMetadata(int n) {
        return this.m_factory.getInputMetadata(n);
    }

    protected IColumn getResultMetadata() {
        return this.m_factory.getResultMetadata();
    }

    protected AbstractAggregatorFactory getFactory() {
        return this.m_factory;
    }
}

