/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar;

import com.cloudera.hiveserver2.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver2.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.hiveserver2.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.util.List;

public final class ETPowerFn
extends ETScalarFn {
    public ETPowerFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        assert (2 == list.size() && 2 == list2.size());
        assert (list2.get(0).getTypeMetadata().getType() == 8);
        assert (list2.get(1).getTypeMetadata().isIntegerType());
        assert (iColumn.getTypeMetadata().getType() == 8);
    }

    @Override
    public String getLogString() {
        return "ETPowerFn";
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0);
        if (iSqlDataWrapper.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        ISqlDataWrapper iSqlDataWrapper2 = this.getArgumentData(1);
        if (iSqlDataWrapper2.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        eTDataRequest.getData().setDouble(Math.pow(iSqlDataWrapper.getDouble(), iSqlDataWrapper2.getInteger()));
        return false;
    }
}

