/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar;

import com.cloudera.hiveserver2.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.TimestampTz;
import com.cloudera.hiveserver2.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver2.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.hiveserver2.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;

public final class ETTimestampAddFn
extends ETScalarFn {
    private static final int MILLIS_PER_SECOND = 1000;
    private static final int FRACTIONS_PER_MILLI = 1000000;
    private static final int FRACTIONS_PER_SECOND = 1000000000;

    public ETTimestampAddFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        assert (3 == this.getNumChildren());
        assert (list2.get(0).getTypeMetadata().isCharacterType());
        assert (-5 == list2.get(1).getTypeMetadata().getType());
        assert (93 == list2.get(2).getTypeMetadata().getType());
    }

    @Override
    public String getLogString() {
        return "ETTimestampAddFn";
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        Timestamp timestamp;
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(2);
        if (iSqlDataWrapper.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        Timestamp timestamp2 = iSqlDataWrapper.getTimestamp();
        ISqlDataWrapper iSqlDataWrapper2 = this.getArgumentData(1);
        if (iSqlDataWrapper2.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        long l = iSqlDataWrapper2.getBigInt().longValue();
        ISqlDataWrapper iSqlDataWrapper3 = this.getArgumentData(0);
        String string = iSqlDataWrapper3.getChar();
        if (string.equalsIgnoreCase("SQL_TSI_FRAC_SECOND")) {
            long l2 = (long)timestamp2.getNanos() + l;
            long l3 = l2 / 1000000000L * 1000L;
            if (l2 < 0L) {
                if (l2 % 1000000000L != 0L) {
                    l3 -= 1000L;
                }
                l2 -= l3 * 1000000L;
            } else if (l2 >= 1000000000L) {
                l2 %= 1000000000L;
            }
            if (l3 != 0L) {
                long l4;
                long l5 = timestamp2.getTime();
                if ((l3 & l5 & ((l4 = l3 + l5) ^ 0xFFFFFFFFFFFFFFFFL) | (l3 ^ 0xFFFFFFFFFFFFFFFFL) & (l5 ^ 0xFFFFFFFFFFFFFFFFL) & l4) < 0L) {
                    throw SQLEngineExceptionFactory.datetimeArithOverflowException();
                }
                timestamp = new Timestamp(l4);
            } else {
                timestamp = new Timestamp(timestamp2.getTime());
            }
            timestamp.setNanos((int)l2);
        } else {
            Calendar calendar = timestamp2 instanceof TimestampTz ? ((TimestampTz)timestamp2).getTimezoneCalendar() : new GregorianCalendar();
            calendar.setTime(timestamp2);
            int n = 14;
            if (string.equalsIgnoreCase("SQL_TSI_DAY")) {
                n = 5;
            } else if (string.equalsIgnoreCase("SQL_TSI_HOUR")) {
                n = 10;
            } else if (string.equalsIgnoreCase("SQL_TSI_MINUTE")) {
                n = 12;
            } else if (string.equalsIgnoreCase("SQL_TSI_SECOND")) {
                n = 13;
            } else if (string.equalsIgnoreCase("SQL_TSI_MONTH")) {
                n = 2;
            } else if (string.equalsIgnoreCase("SQL_TSI_QUARTER")) {
                n = 2;
                if (l > 0x2AAAAAAAL) {
                    throw SQLEngineExceptionFactory.datetimeArithOverflowException();
                }
                l *= 3L;
            } else if (string.equalsIgnoreCase("SQL_TSI_WEEK")) {
                n = 4;
            } else if (string.equalsIgnoreCase("SQL_TSI_YEAR")) {
                n = 1;
            } else {
                throw SQLEngineExceptionFactory.invalidScalarFunctionDataException("TIMESTAMPADD", 1);
            }
            if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                throw SQLEngineExceptionFactory.datetimeArithOverflowException();
            }
            calendar.add(n, (int)l);
            timestamp = new Timestamp(calendar.getTimeInMillis());
            timestamp.setNanos(timestamp2.getNanos());
        }
        eTDataRequest.getData().setTimestamp(timestamp);
        return false;
    }
}

