/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.apache.thrift.transport.sasl;

import com.cloudera.hive.jdbc42.internal.apache.thrift.transport.sasl.TSaslNegotiationException;
import java.util.HashMap;
import java.util.Map;

public enum NegotiationStatus {
    START(1),
    OK(2),
    BAD(3),
    ERROR(4),
    COMPLETE(5);

    private static final Map<Byte, NegotiationStatus> reverseMap;
    private final byte value;

    private NegotiationStatus(byte val) {
        this.value = val;
    }

    public byte getValue() {
        return this.value;
    }

    public static NegotiationStatus byValue(byte val) throws TSaslNegotiationException {
        if (!reverseMap.containsKey(val)) {
            throw new TSaslNegotiationException(TSaslNegotiationException.ErrorType.PROTOCOL_ERROR, "Invalid status " + val);
        }
        return reverseMap.get(val);
    }

    static {
        reverseMap = new HashMap<Byte, NegotiationStatus>();
        for (NegotiationStatus s : NegotiationStatus.values()) {
            reverseMap.put(s.getValue(), s);
        }
    }
}

