/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.apache.zookeeper;

import com.cloudera.hive.jdbc42.internal.apache.jute.BinaryInputArchive;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.ClientCnxn;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.client.ZKClientConfig;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.common.Time;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.compat.ProtocolManager;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.proto.ConnectResponse;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.ByteBufferInputStream;
import com.cloudera.hive.jdbc42.internal.slf4j.Logger;
import com.cloudera.hive.jdbc42.internal.slf4j.LoggerFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicLong;

abstract class ClientCnxnSocket {
    private static final Logger LOG = LoggerFactory.getLogger(ClientCnxnSocket.class);
    private final ProtocolManager protocolManager = new ProtocolManager();
    protected boolean initialized;
    protected final ByteBuffer lenBuffer;
    protected ByteBuffer incomingBuffer = this.lenBuffer = ByteBuffer.allocateDirect(4);
    protected final AtomicLong sentCount = new AtomicLong(0L);
    protected final AtomicLong recvCount = new AtomicLong(0L);
    protected long lastHeard;
    protected long lastSend;
    protected long now;
    protected ClientCnxn.SendThread sendThread;
    protected LinkedBlockingDeque<ClientCnxn.Packet> outgoingQueue;
    protected ZKClientConfig clientConfig;
    private int packetLen = 1048575;
    protected long sessionId;

    ClientCnxnSocket() {
    }

    void introduce(ClientCnxn.SendThread sendThread, long sessionId, LinkedBlockingDeque<ClientCnxn.Packet> outgoingQueue) {
        this.sendThread = sendThread;
        this.sessionId = sessionId;
        this.outgoingQueue = outgoingQueue;
    }

    void updateNow() {
        this.now = Time.currentElapsedTime();
    }

    int getIdleRecv() {
        return (int)(this.now - this.lastHeard);
    }

    int getIdleSend() {
        return (int)(this.now - this.lastSend);
    }

    long getSentCount() {
        return this.sentCount.get();
    }

    long getRecvCount() {
        return this.recvCount.get();
    }

    void updateLastHeard() {
        this.lastHeard = this.now;
    }

    void updateLastSend() {
        this.lastSend = this.now;
    }

    void updateLastSendAndHeard() {
        this.lastSend = this.now;
        this.lastHeard = this.now;
    }

    void readLength() throws IOException {
        int len = this.incomingBuffer.getInt();
        if (len < 0 || len > this.packetLen) {
            throw new IOException("Packet len " + len + " is out of range!");
        }
        this.incomingBuffer = ByteBuffer.allocate(len);
    }

    void readConnectResult() throws IOException {
        if (LOG.isTraceEnabled()) {
            StringBuilder buf = new StringBuilder("0x[");
            for (byte b : this.incomingBuffer.array()) {
                buf.append(Integer.toHexString(b)).append(",");
            }
            buf.append("]");
            if (LOG.isTraceEnabled()) {
                LOG.trace("readConnectResult {} {}", (Object)this.incomingBuffer.remaining(), (Object)buf);
            }
        }
        ByteBufferInputStream bbis = new ByteBufferInputStream(this.incomingBuffer);
        BinaryInputArchive bbia = BinaryInputArchive.getArchive(bbis);
        ConnectResponse conRsp = this.protocolManager.deserializeConnectResponse(bbia);
        if (!this.protocolManager.isReadonlyAvailable()) {
            LOG.warn("Connected to an old server; r-o mode will be unavailable");
        }
        this.sessionId = conRsp.getSessionId();
        this.sendThread.onConnected(conRsp.getTimeOut(), this.sessionId, conRsp.getPasswd(), conRsp.getReadOnly());
    }

    abstract boolean isConnected();

    abstract void connect(InetSocketAddress var1) throws IOException;

    abstract SocketAddress getRemoteSocketAddress();

    abstract SocketAddress getLocalSocketAddress();

    abstract void cleanup();

    abstract void packetAdded();

    abstract void onClosing();

    abstract void saslCompleted();

    abstract void connectionPrimed();

    abstract void doTransport(int var1, Queue<ClientCnxn.Packet> var2, ClientCnxn var3) throws IOException, InterruptedException;

    abstract void testableCloseSocket() throws IOException;

    abstract void close();

    abstract void sendPacket(ClientCnxn.Packet var1) throws IOException;

    protected void initProperties() throws IOException {
        try {
            this.packetLen = this.clientConfig.getInt("jute.maxbuffer", 1048575);
            LOG.info("{} value is {} Bytes", (Object)"jute.maxbuffer", (Object)this.packetLen);
        }
        catch (NumberFormatException e) {
            String msg = MessageFormat.format("Configured value {0} for property {1} can not be parsed to int", this.clientConfig.getProperty("jute.maxbuffer"), "jute.maxbuffer");
            LOG.error(msg);
            throw new IOException(msg);
        }
    }
}

