/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli;

import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.AddAuthCommand;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.AddWatchCommand;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.CliCommand;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.CloseCommand;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.CreateCommand;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.DelQuotaCommand;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.DeleteAllCommand;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.DeleteCommand;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.GetAclCommand;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.GetAllChildrenNumberCommand;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.GetCommand;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.GetConfigCommand;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.GetEphemeralsCommand;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.ListQuotaCommand;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.LsCommand;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.ReconfigCommand;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.RemoveWatchesCommand;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.SetAclCommand;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.SetCommand;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.SetQuotaCommand;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.StatCommand;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.SyncCommand;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.VersionCommand;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.WhoAmICommand;
import java.util.function.Supplier;

public class CommandFactory {
    public static CliCommand getInstance(Command command) {
        return command.getInstance();
    }

    public static enum Command {
        CLOSE(CloseCommand::new),
        CREATE(CreateCommand::new),
        DELETE(DeleteCommand::new),
        DELETE_ALL(DeleteAllCommand::new),
        SET(SetCommand::new),
        GET(GetCommand::new),
        LS(LsCommand::new),
        GET_ACL(GetAclCommand::new),
        SET_ACL(SetAclCommand::new),
        STAT(StatCommand::new),
        SYNC(SyncCommand::new),
        SET_QUOTA(SetQuotaCommand::new),
        LIST_QUOTA(ListQuotaCommand::new),
        DEL_QUOTA(DelQuotaCommand::new),
        ADD_AUTH(AddAuthCommand::new),
        RECONFIG(ReconfigCommand::new),
        GET_CONFIG(GetConfigCommand::new),
        REMOVE_WATCHES(RemoveWatchesCommand::new),
        GET_EPHEMERALS(GetEphemeralsCommand::new),
        GET_ALL_CHILDREN_NUMBER(GetAllChildrenNumberCommand::new),
        VERSION(VersionCommand::new),
        ADD_WATCH(AddWatchCommand::new),
        WHO_AM_I(WhoAmICommand::new);

        private Supplier<? extends CliCommand> instantiator;

        private CliCommand getInstance() {
            return this.instantiator.get();
        }

        private Command(Supplier<? extends CliCommand> instantiator) {
            this.instantiator = instantiator;
        }
    }
}

