/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.apache.zookeeper.server;

import com.cloudera.hive.jdbc42.internal.apache.jute.Record;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.KeeperException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.common.Time;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.data.Id;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.metrics.Summary;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.metrics.SummarySet;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.RequestRecord;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.ServerCnxn;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.persistence.Util;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.quorum.LearnerHandler;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.util.AuthUtil;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.txn.TxnDigest;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.txn.TxnHeader;
import com.cloudera.hive.jdbc42.internal.slf4j.Logger;
import com.cloudera.hive.jdbc42.internal.slf4j.LoggerFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Supplier;

public class Request {
    private static final Logger LOG = LoggerFactory.getLogger(Request.class);
    public static final Request requestOfDeath = new Request(null, 0L, 0, 0, null, null);
    private static volatile boolean staleConnectionCheck = Boolean.parseBoolean(System.getProperty("zookeeper.request_stale_connection_check", "true"));
    private static volatile boolean staleLatencyCheck = Boolean.parseBoolean(System.getProperty("zookeeper.request_stale_latency_check", "false"));
    public final long sessionId;
    public final int cxid;
    public final int type;
    private final RequestRecord request;
    public final ServerCnxn cnxn;
    private TxnHeader hdr;
    private Record txn;
    public long zxid = -1L;
    public final List<Id> authInfo;
    public final long createTime = Time.currentElapsedTime();
    public long prepQueueStartTime = -1L;
    public long prepStartTime = -1L;
    public long commitProcQueueStartTime = -1L;
    public long commitRecvTime = -1L;
    public long syncQueueStartTime;
    public long requestThrottleQueueTime;
    private Object owner;
    private KeeperException e;
    public QuorumVerifier qv = null;
    private TxnDigest txnDigest;
    private boolean isThrottledFlag = false;
    private boolean isLocalSession = false;
    private int largeRequestSize = -1;

    public Request(ServerCnxn cnxn, long sessionId, int xid, int type, RequestRecord request, List<Id> authInfo) {
        this.cnxn = cnxn;
        this.sessionId = sessionId;
        this.cxid = xid;
        this.type = type;
        this.request = request;
        this.authInfo = authInfo;
    }

    public Request(long sessionId, int xid, int type, TxnHeader hdr, Record txn, long zxid) {
        this.sessionId = sessionId;
        this.cxid = xid;
        this.type = type;
        this.hdr = hdr;
        this.txn = txn;
        this.zxid = zxid;
        this.request = null;
        this.cnxn = null;
        this.authInfo = null;
    }

    public Request(TxnHeader hdr, Record txn, TxnDigest digest) {
        this.sessionId = hdr.getClientId();
        this.cxid = hdr.getCxid();
        this.type = hdr.getType();
        this.hdr = hdr;
        this.txn = txn;
        this.zxid = hdr.getZxid();
        this.request = null;
        this.cnxn = null;
        this.authInfo = null;
        this.txnDigest = digest;
    }

    public <T extends Record> T readRequestRecord(Supplier<T> constructor) throws IOException {
        if (this.request != null) {
            return this.request.readRecord(constructor);
        }
        throw new IOException(new NullPointerException("request"));
    }

    public <T extends Record> T readRequestRecordNoException(Supplier<T> constructor) {
        try {
            return this.readRequestRecord(constructor);
        }
        catch (IOException e) {
            return null;
        }
    }

    public byte[] readRequestBytes() {
        if (this.request != null) {
            return this.request.readBytes();
        }
        return null;
    }

    public String requestDigest() {
        if (this.request != null) {
            byte[] payload;
            StringBuilder sb = new StringBuilder();
            for (byte b : payload = this.request.readBytes()) {
                sb.append(String.format("%02x", 0xFF & b));
            }
            return sb.toString();
        }
        return "request buffer is null";
    }

    public boolean isThrottled() {
        return this.isThrottledFlag;
    }

    public void setIsThrottled(boolean val) {
        this.isThrottledFlag = val;
    }

    public boolean isThrottlable() {
        return this.type != 11 && this.type != -11 && this.type != -10;
    }

    public byte[] getSerializeData() {
        if (this.hdr == null) {
            return null;
        }
        try {
            return Util.marshallTxnEntry(this.hdr, this.txn, this.txnDigest);
        }
        catch (IOException e) {
            LOG.error("This really should be impossible.", e);
            return new byte[32];
        }
    }

    public boolean isLocalSession() {
        return this.isLocalSession;
    }

    public void setLocalSession(boolean isLocalSession) {
        this.isLocalSession = isLocalSession;
    }

    public void setLargeRequestSize(int size) {
        this.largeRequestSize = size;
    }

    public int getLargeRequestSize() {
        return this.largeRequestSize;
    }

    public Object getOwner() {
        return this.owner;
    }

    public void setOwner(Object owner) {
        this.owner = owner;
    }

    public TxnHeader getHdr() {
        return this.hdr;
    }

    public void setHdr(TxnHeader hdr) {
        this.hdr = hdr;
    }

    public Record getTxn() {
        return this.txn;
    }

    public void setTxn(Record txn) {
        this.txn = txn;
    }

    public ServerCnxn getConnection() {
        return this.cnxn;
    }

    public static boolean getStaleLatencyCheck() {
        return staleLatencyCheck;
    }

    public static void setStaleLatencyCheck(boolean check) {
        staleLatencyCheck = check;
    }

    public static boolean getStaleConnectionCheck() {
        return staleConnectionCheck;
    }

    public static void setStaleConnectionCheck(boolean check) {
        staleConnectionCheck = check;
    }

    public boolean isStale() {
        if (this.cnxn == null) {
            return false;
        }
        if (this.type == -11) {
            return false;
        }
        if (staleConnectionCheck && (this.cnxn.isStale() || this.cnxn.isInvalid())) {
            return true;
        }
        if (staleLatencyCheck) {
            long currentTime = Time.currentElapsedTime();
            return currentTime - this.createTime > (long)this.cnxn.getSessionTimeout();
        }
        return false;
    }

    public boolean mustDrop() {
        return this.cnxn != null && this.cnxn.isInvalid();
    }

    static boolean isValid(int type) {
        switch (type) {
            case 0: 
            case 13: {
                return false;
            }
            case -11: 
            case -10: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                return true;
            }
        }
        return false;
    }

    public boolean isQuorum() {
        switch (this.type) {
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 22: 
            case 103: 
            case 104: 
            case 107: {
                return false;
            }
            case -1: 
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: {
                return true;
            }
            case -11: 
            case -10: {
                return !this.isLocalSession;
            }
        }
        return false;
    }

    public static String op2String(int op) {
        switch (op) {
            case 0: {
                return "notification";
            }
            case 1: {
                return "create";
            }
            case 2: {
                return "delete";
            }
            case 3: {
                return "exists";
            }
            case 4: {
                return "getData";
            }
            case 5: {
                return "setData";
            }
            case 6: {
                return "getACL";
            }
            case 7: {
                return "setACL";
            }
            case 8: {
                return "getChildren";
            }
            case 9: {
                return "sync";
            }
            case 11: {
                return "ping";
            }
            case 12: {
                return "getChildren2";
            }
            case 13: {
                return "check";
            }
            case 14: {
                return "multi";
            }
            case 15: {
                return "create2";
            }
            case 16: {
                return "reconfig";
            }
            case 17: {
                return "checkWatches";
            }
            case 18: {
                return "removeWatches";
            }
            case 19: {
                return "createContainer";
            }
            case 20: {
                return "deleteContainer";
            }
            case 21: {
                return "createTTL";
            }
            case 22: {
                return "multiRead";
            }
            case 100: {
                return "auth";
            }
            case 101: {
                return "setWatches";
            }
            case 105: {
                return "setWatches2";
            }
            case 106: {
                return "addWatch";
            }
            case 102: {
                return "sasl";
            }
            case 103: {
                return "getEphemerals";
            }
            case 104: {
                return "getAllChildrenNumber";
            }
            case -10: {
                return "createSession";
            }
            case -11: {
                return "closeSession";
            }
            case -1: {
                return "error";
            }
            case 107: {
                return "whoAmI";
            }
        }
        return "unknown " + op;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("sessionid:0x").append(Long.toHexString(this.sessionId)).append(" type:").append(Request.op2String(this.type)).append(" cxid:0x").append(Long.toHexString(this.cxid)).append(" zxid:0x").append(Long.toHexString(this.hdr == null ? -2L : this.hdr.getZxid())).append(" txntype:").append(this.hdr == null ? "unknown" : "" + this.hdr.getType());
        String path = "n/a";
        if (this.type != -10 && this.type != 101 && this.type != 105 && this.type != -11 && this.request != null) {
            try {
                ByteBuffer buf;
                int pathLen;
                byte[] bytes = this.request.readBytes();
                if (bytes != null && bytes.length >= 4 && (pathLen = (buf = ByteBuffer.wrap(bytes)).getInt()) >= 0 && pathLen < 4096 && buf.remaining() >= pathLen) {
                    byte[] b = new byte[pathLen];
                    buf.get(b);
                    path = new String(b, StandardCharsets.UTF_8);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        sb.append(" reqpath:").append(path);
        return sb.toString();
    }

    public void setException(KeeperException e) {
        this.e = e;
    }

    public KeeperException getException() {
        return this.e;
    }

    public void logLatency(Summary metric) {
        this.logLatency(metric, Time.currentWallTime());
    }

    public void logLatency(Summary metric, long currentTime) {
        long latency;
        if (this.hdr != null && (latency = currentTime - this.hdr.getTime()) >= 0L) {
            metric.add(latency);
        }
    }

    public void logLatency(SummarySet metric, String key, long currentTime) {
        long latency;
        if (this.hdr != null && (latency = currentTime - this.hdr.getTime()) >= 0L) {
            metric.add(key, latency);
        }
    }

    public void logLatency(SummarySet metric, String key) {
        this.logLatency(metric, key, Time.currentWallTime());
    }

    public String getUsersForAudit() {
        return AuthUtil.getUsers(this.authInfo);
    }

    public TxnDigest getTxnDigest() {
        return this.txnDigest;
    }

    public void setTxnDigest(TxnDigest txnDigest) {
        this.txnDigest = txnDigest;
    }

    public boolean isFromLearner() {
        return this.owner instanceof LearnerHandler;
    }
}

