/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.hivecommon;

import com.cloudera.hive.jdbc42.internal.apache.http.HttpResponse;
import com.cloudera.hive.jdbc42.internal.apache.http.HttpVersion;
import com.cloudera.hive.jdbc42.internal.apache.http.entity.BasicHttpEntity;
import com.cloudera.hive.jdbc42.internal.apache.http.impl.DefaultHttpResponseFactory;
import com.cloudera.hive.jdbc42.internal.apache.http.message.BasicHeader;
import com.cloudera.hive.jdbc42.internal.apache.http.message.BasicStatusLine;
import com.cloudera.hiveserver1.hivecommon.WholeNumberIntervalList;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;

public class HttpErrorEmulationSettings {
    private static final String DEFAULT_HTTP_ERROR_MESSAGE = "Simba Hadoop JDBC Drivers Emulated Error Message";
    public ArrayList<HttpErrors> m_httpErrorsList;
    public int m_apiIndex = 0;

    public void addHttpErrors(String string, int n) {
        if (null == this.m_httpErrorsList) {
            this.m_httpErrorsList = new ArrayList();
        }
        this.m_httpErrorsList.add(new HttpErrors(string, n, DEFAULT_HTTP_ERROR_MESSAGE));
    }

    public boolean addHttpErrors(String string, int n, String string2) {
        if (null == this.m_httpErrorsList) {
            this.m_httpErrorsList = new ArrayList();
        }
        this.m_httpErrorsList.add(new HttpErrors(string, n, string2));
        return false;
    }

    public boolean shouldEmulateError() {
        for (HttpErrors httpErrors : this.m_httpErrorsList) {
            if (!httpErrors.IsNumberInIntervals(this.m_apiIndex)) continue;
            return true;
        }
        return false;
    }

    public HttpResponse populateEmulatedHttpResponse() {
        DefaultHttpResponseFactory defaultHttpResponseFactory = new DefaultHttpResponseFactory();
        int n = -1;
        String string = "";
        for (HttpErrors object2 : this.m_httpErrorsList) {
            if (!object2.IsNumberInIntervals(this.m_apiIndex)) continue;
            n = object2.m_httpErrorCode;
            string = object2.m_httpErrorMessage;
            break;
        }
        HttpResponse httpResponse = defaultHttpResponseFactory.newHttpResponse(new BasicStatusLine(HttpVersion.HTTP_1_1, n, string), null);
        if (429 == n) {
            httpResponse.addHeader(new BasicHeader("Retry-After", "1"));
        } else if (503 == n) {
            httpResponse.addHeader(new BasicHeader("Retry-After", "10"));
        }
        BasicHttpEntity basicHttpEntity = new BasicHttpEntity();
        basicHttpEntity.setContent(new ByteArrayInputStream(string.getBytes()));
        httpResponse.setEntity(basicHttpEntity);
        return httpResponse;
    }

    public static class HttpErrors
    extends WholeNumberIntervalList {
        public int m_httpErrorCode;
        public String m_httpErrorMessage;

        public HttpErrors(String string, int n, String string2) {
            this.m_httpErrorCode = n;
            this.m_httpErrorMessage = string2;
            this.InitializeIntervalList(string);
        }
    }
}

