/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.hivecommon.jdbc42;

import com.cloudera.hiveserver1.dsi.dataengine.utilities.ExecutionResult;
import com.cloudera.hiveserver1.hivecommon.HiveJDBCSettings;
import com.cloudera.hiveserver1.hivecommon.core.HiveJDBCStatement;
import com.cloudera.hiveserver1.hivecommon.core.IHadoopStatement;
import com.cloudera.hiveserver1.hivecommon.core.QueryProfile;
import com.cloudera.hiveserver1.hivecommon.dataengine.HiveJDBCDSIExtQueryExecutor;
import com.cloudera.hiveserver1.hivecommon.dataengine.HiveJDBCNativeQueryExecutor;
import com.cloudera.hiveserver1.hivecommon.dataengine.HiveJDBCResultSet;
import com.cloudera.hiveserver1.hivecommon.jdbc42.Hive42ForwardMaterializedResultSet;
import com.cloudera.hiveserver1.hivecommon.jdbc42.Hive42ForwardResultSet;
import com.cloudera.hiveserver1.jdbc.common.SConnection;
import com.cloudera.hiveserver1.jdbc.common.SStatement;
import com.cloudera.hiveserver1.jdbc.jdbc42.S42Statement;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public class Hive42Statement
extends S42Statement
implements IHadoopStatement {
    private HiveJDBCSettings m_settings;

    public Hive42Statement(HiveJDBCStatement hiveJDBCStatement, SConnection sConnection, int n) throws SQLException {
        super(hiveJDBCStatement, sConnection, n);
        this.m_settings = hiveJDBCStatement.getSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws SQLException {
        super.cancel();
        Object object = this.m_cancelLock;
        synchronized (object) {
            if (this.m_statement instanceof HiveJDBCStatement && this.m_isInCancelableFunction) {
                ((HiveJDBCStatement)this.m_statement).cancel();
            }
        }
    }

    @Override
    public synchronized boolean execute(String string) throws SQLException {
        if (this.m_statement instanceof HiveJDBCStatement) {
            ((HiveJDBCStatement)this.m_statement).setExecuteMethodType(HiveJDBCStatement.ExecuteMethodType.EXECUTE);
        }
        return super.execute(string);
    }

    @Override
    public synchronized long executeAnyUpdate(String string) throws SQLException {
        if (this.m_statement instanceof HiveJDBCStatement) {
            ((HiveJDBCStatement)this.m_statement).setExecuteMethodType(HiveJDBCStatement.ExecuteMethodType.EXECUTE_UPDATE);
        }
        return super.executeAnyUpdate(string);
    }

    @Override
    public synchronized ResultSet executeAsync(String string) throws SQLException {
        this.setAsyncExecution(true);
        return super.executeQuery(string);
    }

    @Override
    public synchronized ResultSet executeQuery(String string) throws SQLException {
        this.setAsyncExecution(false);
        if (this.m_statement instanceof HiveJDBCStatement) {
            ((HiveJDBCStatement)this.m_statement).setExecuteMethodType(HiveJDBCStatement.ExecuteMethodType.EXECUTE_QUERY);
        }
        return super.executeQuery(string);
    }

    public boolean getAsyncExecution() {
        return ((HiveJDBCStatement)this.m_statement).getAsyncExecution();
    }

    public void setAsyncExecution(boolean bl) {
        ((HiveJDBCStatement)this.m_statement).setAsyncExecution(bl);
    }

    @Override
    protected ResultSet createResultSet(ExecutionResult executionResult) throws SQLException {
        ResultSet resultSet = null;
        if (this.m_settings.m_isEnableDataWrapperMaterialization && executionResult.getResult() instanceof HiveJDBCResultSet) {
            resultSet = new Hive42ForwardMaterializedResultSet(this, (HiveJDBCResultSet)executionResult.getResult(), this.m_logger, this.m_settings);
        } else if (this.getAsyncExecution() && executionResult.getResult() instanceof HiveJDBCResultSet) {
            resultSet = new Hive42ForwardResultSet((SStatement)this, (HiveJDBCResultSet)executionResult.getResult(), this.m_logger);
            resultSet.setFetchSize(this.getFetchSize());
        } else {
            resultSet = super.createResultSet(executionResult);
        }
        return resultSet;
    }

    @Override
    public String getYarnATSGuid() {
        if (null != this.m_queryExecutor && this.m_queryExecutor instanceof HiveJDBCDSIExtQueryExecutor) {
            return ((HiveJDBCDSIExtQueryExecutor)this.m_queryExecutor).getYarnATSGuid();
        }
        return null;
    }

    @Override
    public List<String> getQueryLog(boolean bl, int n) throws ErrorException {
        if (null != this.m_queryExecutor) {
            if (this.m_queryExecutor instanceof HiveJDBCDSIExtQueryExecutor) {
                return ((HiveJDBCDSIExtQueryExecutor)this.m_queryExecutor).getQueryLog(bl, n);
            }
            if (this.m_queryExecutor instanceof HiveJDBCNativeQueryExecutor) {
                return ((HiveJDBCNativeQueryExecutor)this.m_queryExecutor).getQueryLog(bl, n);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public boolean hasMoreLogs() {
        if (null != this.m_queryExecutor) {
            if (this.m_queryExecutor instanceof HiveJDBCDSIExtQueryExecutor) {
                return ((HiveJDBCDSIExtQueryExecutor)this.m_queryExecutor).hasMoreLogs();
            }
            if (this.m_queryExecutor instanceof HiveJDBCNativeQueryExecutor) {
                return ((HiveJDBCNativeQueryExecutor)this.m_queryExecutor).hasMoreLogs();
            }
        }
        return true;
    }

    @Override
    public QueryProfile getQueryProfile() {
        HiveJDBCStatement hiveJDBCStatement = (HiveJDBCStatement)this.m_statement;
        return new QueryProfile(hiveJDBCStatement.m_queryIds, hiveJDBCStatement.m_opTypes);
    }
}

