/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.aeprocessor.aebuilder;

import com.cloudera.hiveserver1.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver1.sqlengine.parser.parsetree.IPTNode;
import com.cloudera.hiveserver1.sqlengine.parser.parsetree.PTEmptyNode;
import com.cloudera.hiveserver1.sqlengine.parser.parsetree.PTFlagNode;
import com.cloudera.hiveserver1.sqlengine.parser.parsetree.PTIdentifierNode;
import com.cloudera.hiveserver1.sqlengine.parser.parsetree.PTListNode;
import com.cloudera.hiveserver1.sqlengine.parser.parsetree.PTLiteralNode;
import com.cloudera.hiveserver1.sqlengine.parser.parsetree.PTNonterminalNode;
import com.cloudera.hiveserver1.sqlengine.parser.type.PTFlagType;
import com.cloudera.hiveserver1.sqlengine.parser.type.PTListType;
import com.cloudera.hiveserver1.sqlengine.parser.type.PTLiteralType;
import com.cloudera.hiveserver1.sqlengine.parser.type.PTNonterminalType;
import com.cloudera.hiveserver1.sqlengine.parser.type.PTPositionalType;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;

public class AEBuilderCheck {
    private AEBuilderCheck() {
        throw new UnsupportedOperationException("Cannot instantiate AEBuilderCheck.");
    }

    public static void checkThat(IPTNode iPTNode, ParseTreeMatcher parseTreeMatcher) throws ErrorException {
        if (!parseTreeMatcher.matches(iPTNode)) {
            throw parseTreeMatcher.generateException();
        }
    }

    public static <T extends ParseTreeMatcher> T is(T t) {
        return t;
    }

    public static ParseTreeMatcher allOf(final Collection<ParseTreeMatcher> collection) {
        return new BaseParseTreeMatcher(){

            @Override
            public boolean matches(IPTNode iPTNode) {
                for (ParseTreeMatcher parseTreeMatcher : collection) {
                    if (parseTreeMatcher.matches(iPTNode)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static ParseTreeMatcher allOf(ParseTreeMatcher parseTreeMatcher, ParseTreeMatcher parseTreeMatcher2) {
        return AEBuilderCheck.allOf(Arrays.asList(parseTreeMatcher, parseTreeMatcher2));
    }

    public static ParseTreeMatcher allOf(ParseTreeMatcher parseTreeMatcher, ParseTreeMatcher parseTreeMatcher2, ParseTreeMatcher parseTreeMatcher3) {
        return AEBuilderCheck.allOf(Arrays.asList(parseTreeMatcher, parseTreeMatcher2, parseTreeMatcher3));
    }

    public static ParseTreeMatcher anyOf(final Collection<ParseTreeMatcher> collection) {
        return new BaseParseTreeMatcher(){

            @Override
            public boolean matches(IPTNode iPTNode) {
                for (ParseTreeMatcher parseTreeMatcher : collection) {
                    if (!parseTreeMatcher.matches(iPTNode)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static ParseTreeMatcher anyOf(ParseTreeMatcher parseTreeMatcher, ParseTreeMatcher parseTreeMatcher2) {
        return AEBuilderCheck.anyOf(Arrays.asList(parseTreeMatcher, parseTreeMatcher2));
    }

    public static ParseTreeMatcher anyOf(ParseTreeMatcher parseTreeMatcher, ParseTreeMatcher parseTreeMatcher2, ParseTreeMatcher parseTreeMatcher3) {
        return AEBuilderCheck.anyOf(Arrays.asList(parseTreeMatcher, parseTreeMatcher2, parseTreeMatcher3));
    }

    public static ParseTreeMatcher anything() {
        return new BaseParseTreeMatcher(){

            @Override
            public boolean matches(IPTNode iPTNode) {
                return true;
            }
        };
    }

    public static Both both(ParseTreeMatcher parseTreeMatcher) {
        return new Both(parseTreeMatcher);
    }

    public static ParseTreeMatcher bothOf(ParseTreeMatcher parseTreeMatcher, ParseTreeMatcher parseTreeMatcher2) {
        return AEBuilderCheck.both(parseTreeMatcher).and(parseTreeMatcher2);
    }

    public static Either either(ParseTreeMatcher parseTreeMatcher) {
        return new Either(parseTreeMatcher);
    }

    public static ParseTreeMatcher eitherOf(ParseTreeMatcher parseTreeMatcher, ParseTreeMatcher parseTreeMatcher2) {
        return new Either(parseTreeMatcher).or(parseTreeMatcher2);
    }

    public static ParseTreeMatcher empty() {
        return AEBuilderCheck.instanceOf(PTEmptyNode.class);
    }

    public static ParseTreeMatcher flagNode() {
        return AEBuilderCheck.instanceOf(PTFlagNode.class);
    }

    public static ParseTreeMatcher flagNode(PTFlagType pTFlagType, PTFlagType ... pTFlagTypeArray) {
        final EnumSet<PTFlagType[]> enumSet = EnumSet.of(pTFlagType, pTFlagTypeArray);
        return AEBuilderCheck.bothOf(AEBuilderCheck.instanceOf(PTFlagNode.class), new BaseParseTreeMatcher(){

            @Override
            public boolean matches(IPTNode iPTNode) {
                return enumSet.contains((Object)((PTFlagNode)iPTNode).getFlagType());
            }
        });
    }

    public static ParseTreeMatcher hasListChildren(final ParseTreeMatcher parseTreeMatcher) {
        return new BaseParseTreeMatcher(){

            @Override
            public boolean matches(IPTNode iPTNode) {
                if (!(iPTNode instanceof PTListNode)) {
                    return false;
                }
                PTListNode pTListNode = (PTListNode)iPTNode;
                Iterator<IPTNode> iterator = pTListNode.getChildItr();
                while (iterator.hasNext()) {
                    if (parseTreeMatcher.matches(iterator.next())) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static ParseTreeMatcher hasChildren(Map<PTPositionalType, ParseTreeMatcher> map) {
        final Map<PTPositionalType, ParseTreeMatcher> map2 = map;
        return new BaseParseTreeMatcher(){

            @Override
            public boolean matches(IPTNode iPTNode) {
                if (!(iPTNode instanceof PTNonterminalNode)) {
                    return false;
                }
                PTNonterminalNode pTNonterminalNode = (PTNonterminalNode)iPTNode;
                if (!pTNonterminalNode.getAllPositionalTypes().containsAll(map2.keySet())) {
                    return false;
                }
                for (Map.Entry entry : map2.entrySet()) {
                    if (((ParseTreeMatcher)entry.getValue()).matches(pTNonterminalNode.getChild((PTPositionalType)((Object)entry.getKey())))) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static ParseTreeMatcher hasExactChildren(Map<PTPositionalType, ParseTreeMatcher> map) {
        final Map<PTPositionalType, ParseTreeMatcher> map2 = map;
        return new BaseParseTreeMatcher(){

            @Override
            public boolean matches(IPTNode iPTNode) {
                if (!(iPTNode instanceof PTNonterminalNode)) {
                    return false;
                }
                PTNonterminalNode pTNonterminalNode = (PTNonterminalNode)iPTNode;
                if (!pTNonterminalNode.getAllPositionalTypes().equals(map2.keySet())) {
                    return false;
                }
                for (Map.Entry entry : map2.entrySet()) {
                    if (((ParseTreeMatcher)entry.getValue()).matches(pTNonterminalNode.getChild((PTPositionalType)((Object)entry.getKey())))) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static ParseTreeMatcher instanceOf(Class<? extends IPTNode> clazz) {
        final Class<? extends IPTNode> clazz2 = clazz;
        return new BaseParseTreeMatcher(){

            @Override
            public boolean matches(IPTNode iPTNode) {
                return clazz2.isInstance(iPTNode);
            }
        };
    }

    public static ParseTreeMatcher identifier() {
        return AEBuilderCheck.instanceOf(PTIdentifierNode.class);
    }

    public static ListMatcher list() {
        return new ListMatcher();
    }

    public static ListTypeMatcher list(PTListType pTListType) {
        return new ListTypeMatcher(pTListType);
    }

    public static ParseTreeMatcher literal() {
        return AEBuilderCheck.instanceOf(PTLiteralNode.class);
    }

    public static ParseTreeMatcher literal(final PTLiteralType pTLiteralType) {
        return new BaseParseTreeMatcher(){

            @Override
            public boolean matches(IPTNode iPTNode) {
                return iPTNode instanceof PTLiteralNode && ((PTLiteralNode)iPTNode).getLiteralType() == pTLiteralType;
            }
        };
    }

    public static ParseTreeMatcher nonEmpty() {
        return AEBuilderCheck.not(AEBuilderCheck.empty());
    }

    private static ParseTreeMatcher not(final ParseTreeMatcher parseTreeMatcher) {
        return new BaseParseTreeMatcher(){

            @Override
            public boolean matches(IPTNode iPTNode) {
                return !parseTreeMatcher.matches(iPTNode);
            }
        };
    }

    public static NonterminalMatcher nonTerminal() {
        return new NonterminalMatcher();
    }

    public static NonterminalTypeMatcher nonTerminal(PTNonterminalType pTNonterminalType) {
        return new NonterminalTypeMatcher(pTNonterminalType);
    }

    public static ParseTreeMatcher optional(ParseTreeMatcher parseTreeMatcher) {
        return AEBuilderCheck.either(AEBuilderCheck.empty()).or(parseTreeMatcher);
    }

    public static ParseTreeMatcher optionalIdentifier() {
        return AEBuilderCheck.optional(AEBuilderCheck.identifier());
    }

    public static ParseTreeMatcher optionalList() {
        return AEBuilderCheck.optional(AEBuilderCheck.list());
    }

    public static ParseTreeMatcher optionalList(PTListType pTListType) {
        return AEBuilderCheck.optional(AEBuilderCheck.list(pTListType));
    }

    public static ErrorException generateInvalidParseException() {
        ErrorException errorException = SQLEngineExceptionFactory.invalidParseTreeException();
        return errorException;
    }

    private static abstract class NonterminalBaseMatcher
    extends BaseParseTreeMatcher {
        private NonterminalBaseMatcher() {
        }

        public ParseTreeMatcher withNoChildren() {
            return AEBuilderCheck.both(this).and(AEBuilderCheck.hasExactChildren(Collections.emptyMap()));
        }

        public ParseTreeMatcher withChildren(PTPositionalType pTPositionalType, ParseTreeMatcher parseTreeMatcher) {
            EnumMap<PTPositionalType, ParseTreeMatcher> enumMap = new EnumMap<PTPositionalType, ParseTreeMatcher>(PTPositionalType.class);
            enumMap.put(pTPositionalType, parseTreeMatcher);
            return AEBuilderCheck.both(this).and(AEBuilderCheck.hasChildren(enumMap));
        }

        public ParseTreeMatcher withChildren(PTPositionalType pTPositionalType, ParseTreeMatcher parseTreeMatcher, PTPositionalType pTPositionalType2, ParseTreeMatcher parseTreeMatcher2) {
            EnumMap<PTPositionalType, ParseTreeMatcher> enumMap = new EnumMap<PTPositionalType, ParseTreeMatcher>(PTPositionalType.class);
            enumMap.put(pTPositionalType, parseTreeMatcher);
            enumMap.put(pTPositionalType2, parseTreeMatcher2);
            return AEBuilderCheck.both(this).and(AEBuilderCheck.hasChildren(enumMap));
        }

        public ParseTreeMatcher withChildren(PTPositionalType pTPositionalType, ParseTreeMatcher parseTreeMatcher, PTPositionalType pTPositionalType2, ParseTreeMatcher parseTreeMatcher2, PTPositionalType pTPositionalType3, ParseTreeMatcher parseTreeMatcher3) {
            EnumMap<PTPositionalType, ParseTreeMatcher> enumMap = new EnumMap<PTPositionalType, ParseTreeMatcher>(PTPositionalType.class);
            enumMap.put(pTPositionalType, parseTreeMatcher);
            enumMap.put(pTPositionalType2, parseTreeMatcher2);
            enumMap.put(pTPositionalType3, parseTreeMatcher3);
            return AEBuilderCheck.both(this).and(AEBuilderCheck.hasChildren(enumMap));
        }

        public ParseTreeMatcher withExactChildren(PTPositionalType pTPositionalType, ParseTreeMatcher parseTreeMatcher) {
            EnumMap<PTPositionalType, ParseTreeMatcher> enumMap = new EnumMap<PTPositionalType, ParseTreeMatcher>(PTPositionalType.class);
            enumMap.put(pTPositionalType, parseTreeMatcher);
            return AEBuilderCheck.both(this).and(AEBuilderCheck.hasExactChildren(enumMap));
        }

        public ParseTreeMatcher withExactChildren(PTPositionalType pTPositionalType, ParseTreeMatcher parseTreeMatcher, PTPositionalType pTPositionalType2, ParseTreeMatcher parseTreeMatcher2) {
            EnumMap<PTPositionalType, ParseTreeMatcher> enumMap = new EnumMap<PTPositionalType, ParseTreeMatcher>(PTPositionalType.class);
            enumMap.put(pTPositionalType, parseTreeMatcher);
            enumMap.put(pTPositionalType2, parseTreeMatcher2);
            return AEBuilderCheck.both(this).and(AEBuilderCheck.hasExactChildren(enumMap));
        }

        public ParseTreeMatcher withExactChildren(PTPositionalType pTPositionalType, ParseTreeMatcher parseTreeMatcher, PTPositionalType pTPositionalType2, ParseTreeMatcher parseTreeMatcher2, PTPositionalType pTPositionalType3, ParseTreeMatcher parseTreeMatcher3) {
            EnumMap<PTPositionalType, ParseTreeMatcher> enumMap = new EnumMap<PTPositionalType, ParseTreeMatcher>(PTPositionalType.class);
            enumMap.put(pTPositionalType, parseTreeMatcher);
            enumMap.put(pTPositionalType2, parseTreeMatcher2);
            enumMap.put(pTPositionalType3, parseTreeMatcher3);
            return AEBuilderCheck.both(this).and(AEBuilderCheck.hasExactChildren(enumMap));
        }

        public ParseTreeMatcher withExactChildren(PTPositionalType pTPositionalType, ParseTreeMatcher parseTreeMatcher, PTPositionalType pTPositionalType2, ParseTreeMatcher parseTreeMatcher2, PTPositionalType pTPositionalType3, ParseTreeMatcher parseTreeMatcher3, PTPositionalType pTPositionalType4, ParseTreeMatcher parseTreeMatcher4) {
            EnumMap<PTPositionalType, ParseTreeMatcher> enumMap = new EnumMap<PTPositionalType, ParseTreeMatcher>(PTPositionalType.class);
            enumMap.put(pTPositionalType, parseTreeMatcher);
            enumMap.put(pTPositionalType2, parseTreeMatcher2);
            enumMap.put(pTPositionalType3, parseTreeMatcher3);
            enumMap.put(pTPositionalType4, parseTreeMatcher4);
            return AEBuilderCheck.both(this).and(AEBuilderCheck.hasExactChildren(enumMap));
        }
    }

    private static abstract class ListBaseMatcher
    extends BaseParseTreeMatcher {
        private ListBaseMatcher() {
        }

        public ParseTreeMatcher withChildren(ParseTreeMatcher parseTreeMatcher) {
            return AEBuilderCheck.both(this).and(AEBuilderCheck.hasListChildren(parseTreeMatcher));
        }
    }

    public static class ListTypeMatcher
    extends ListBaseMatcher {
        private final PTListType m_type;

        public ListTypeMatcher(PTListType pTListType) {
            this.m_type = pTListType;
        }

        @Override
        public boolean matches(IPTNode iPTNode) {
            return iPTNode instanceof PTListNode && ((PTListNode)iPTNode).getListType() == this.m_type;
        }
    }

    public static class ListMatcher
    extends ListBaseMatcher {
        @Override
        public boolean matches(IPTNode iPTNode) {
            return iPTNode instanceof PTListNode;
        }

        public ParseTreeMatcher withType(PTListType pTListType) {
            return new ListTypeMatcher(pTListType);
        }
    }

    public static class NonterminalTypeMatcher
    extends NonterminalBaseMatcher {
        private final PTNonterminalType m_type;

        public NonterminalTypeMatcher(PTNonterminalType pTNonterminalType) {
            this.m_type = pTNonterminalType;
        }

        @Override
        public boolean matches(IPTNode iPTNode) {
            return iPTNode instanceof PTNonterminalNode && ((PTNonterminalNode)iPTNode).getNonterminalType() == this.m_type;
        }
    }

    public static class NonterminalMatcher
    extends NonterminalBaseMatcher {
        @Override
        public boolean matches(IPTNode iPTNode) {
            return iPTNode instanceof PTNonterminalNode;
        }

        public NonterminalTypeMatcher withType(PTNonterminalType pTNonterminalType) {
            return new NonterminalTypeMatcher(pTNonterminalType);
        }
    }

    public static class Either {
        private final ParseTreeMatcher m_matcher;

        public Either(ParseTreeMatcher parseTreeMatcher) {
            this.m_matcher = parseTreeMatcher;
        }

        public ParseTreeMatcher or(final ParseTreeMatcher parseTreeMatcher) {
            return new BaseParseTreeMatcher(){

                @Override
                public boolean matches(IPTNode iPTNode) {
                    return m_matcher.matches(iPTNode) || parseTreeMatcher.matches(iPTNode);
                }
            };
        }
    }

    public static class Both {
        private final ParseTreeMatcher m_matcher;

        public Both(ParseTreeMatcher parseTreeMatcher) {
            this.m_matcher = parseTreeMatcher;
        }

        public ParseTreeMatcher and(final ParseTreeMatcher parseTreeMatcher) {
            return new BaseParseTreeMatcher(){

                @Override
                public boolean matches(IPTNode iPTNode) {
                    return m_matcher.matches(iPTNode) && parseTreeMatcher.matches(iPTNode);
                }
            };
        }
    }

    public static abstract class BaseParseTreeMatcher
    implements ParseTreeMatcher {
        @Override
        public abstract boolean matches(IPTNode var1);

        @Override
        public ErrorException generateException() {
            return AEBuilderCheck.generateInvalidParseException();
        }
    }

    public static interface ParseTreeMatcher {
        public boolean matches(IPTNode var1);

        public ErrorException generateException();
    }
}

