/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.dsiext.dataengine;

import com.cloudera.hiveserver1.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.hiveserver1.dsi.exceptions.IncorrectTypeException;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.relation.AETable;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.relation.AETop;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AELiteral;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AEParameter;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.cloudera.hiveserver1.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.cloudera.hiveserver1.sqlengine.dsiext.dataengine.ITopHandler;
import com.cloudera.hiveserver1.support.IWarningListener;
import com.cloudera.hiveserver1.support.conv.CharConverter;
import com.cloudera.hiveserver1.support.conv.ConversionResult;
import java.math.BigInteger;

public abstract class DSIExtAbstractTopHandler
implements ITopHandler {
    public DSIExtAbstractTopHandler(IWarningListener iWarningListener) {
    }

    @Override
    public DSIExtJResultSet passdown(AETop aETop) {
        assert (aETop.getOperand() instanceof AETable);
        assert (!aETop.isPercent());
        AEValueExpr aEValueExpr = aETop.getSelectLimitExpr();
        if (aEValueExpr instanceof AELiteral) {
            long l = this.strToLong(((AELiteral)aEValueExpr).getStringValue());
            if (0L <= l) {
                return this.passdownTopN(((AETable)aETop.getOperand()).getTable(), l);
            }
        } else if (aEValueExpr instanceof AEParameter) {
            long l;
            DataWrapper dataWrapper = ((AEParameter)aEValueExpr).getInputData();
            if (dataWrapper.isNull()) {
                return null;
            }
            try {
                switch (dataWrapper.getType()) {
                    case -5: {
                        BigInteger bigInteger = dataWrapper.getBigInt();
                        if (bigInteger.compareTo(new BigInteger(String.valueOf(Long.MAX_VALUE))) > 0 || bigInteger.compareTo(BigInteger.ZERO) < 0) {
                            return null;
                        }
                        l = bigInteger.longValue();
                        break;
                    }
                    case -6: 
                    case 4: 
                    case 5: {
                        l = this.getIntegralData(dataWrapper);
                        break;
                    }
                    case -10: 
                    case -9: 
                    case -8: 
                    case -1: 
                    case 1: 
                    case 12: {
                        l = this.strToLong(this.getStringData(dataWrapper));
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            catch (IncorrectTypeException incorrectTypeException) {
                return null;
            }
            if (0L <= l) {
                return this.passdownTopN(((AETable)aETop.getOperand()).getTable(), l);
            }
        }
        return null;
    }

    protected abstract DSIExtJResultSet passdownTopN(DSIExtJResultSet var1, long var2);

    private long strToLong(String string) {
        ConversionResult conversionResult = new ConversionResult();
        long l = CharConverter.toInteger(string, conversionResult, false);
        if (ConversionResult.TypeConversionState.SUCCESS != conversionResult.getState()) {
            return -1L;
        }
        return l;
    }

    private long getIntegralData(DataWrapper dataWrapper) throws IncorrectTypeException {
        switch (dataWrapper.getType()) {
            case 4: {
                return dataWrapper.getInteger();
            }
            case 5: {
                return dataWrapper.getSmallInt().intValue();
            }
            case -6: {
                return dataWrapper.getTinyInt().shortValue();
            }
        }
        throw new IllegalArgumentException(String.format("Logic error: type %d not char-type", dataWrapper.getType()));
    }

    private String getStringData(DataWrapper dataWrapper) throws IncorrectTypeException {
        switch (dataWrapper.getType()) {
            case -8: 
            case 1: {
                return dataWrapper.getChar();
            }
            case -10: 
            case -1: {
                return dataWrapper.getLongVarChar();
            }
            case -9: 
            case 12: {
                return dataWrapper.getVarChar();
            }
        }
        throw new IllegalArgumentException(String.format("Logic error: type %d not char-type", dataWrapper.getType()));
    }
}

