/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.executor.etree.value.scalar;

import com.cloudera.hiveserver1.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver1.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.hiveserver1.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.hiveserver1.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.hiveserver1.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.cloudera.hiveserver1.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.hiveserver1.support.Warning;
import com.cloudera.hiveserver1.support.WarningCode;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.util.List;

public class ETConcatFn
extends ETScalarFn {
    private final long m_columnLength;

    public ETConcatFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        assert (2 == this.getNumChildren());
        assert (list2.get(0).getTypeMetadata().isCharacterType());
        assert (list2.get(1).getTypeMetadata().isCharacterType());
        assert (iColumn.getTypeMetadata().isCharacterType());
        this.m_columnLength = iColumn.getColumnLength();
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        long l;
        long l2 = eTDataRequest.getOffset();
        long l3 = eTDataRequest.getMaxSize();
        boolean bl = -1L == l3;
        long l4 = this.m_columnLength * 2L;
        if (!bl && l4 - l3 > l2) {
            l4 = l3 + l2;
        }
        assert (l4 >= 0L) : "Overflow.";
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0, 0L, l4);
        if (iSqlDataWrapper.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        long l5 = l2 / 2L;
        String string = iSqlDataWrapper.getChar();
        long l6 = string.length();
        if (l5 >= l6) {
            string = "";
            l = 2L * (l5 - l6);
        } else {
            string = string.substring((int)l5);
            l = 0L;
            l4 -= l6 * 2L;
        }
        ISqlDataWrapper iSqlDataWrapper2 = this.getArgumentData(1, l, l4);
        if (iSqlDataWrapper2.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        String string2 = 0 == string.length() ? iSqlDataWrapper2.getChar() : string.concat(iSqlDataWrapper2.getChar());
        eTDataRequest.getData().setChar(string2);
        if (0L == l4 && this.hasMoreData(0) || this.hasMoreData(1)) {
            if (this.m_columnLength - (long)string2.length() > l5) {
                return true;
            }
            this.getWarningListener().postWarning(new Warning(WarningCode.STRING_RIGHT_TRUNCATION_WARNING, 7, SQLEngineMessageKey.STRING_RIGHT_TRUNCATION.name(), -1L, -1));
        }
        return false;
    }
}

