/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.executor.etree.value.scalar;

import com.cloudera.hiveserver1.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver1.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.hiveserver1.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.hiveserver1.sqlengine.executor.etree.IETNode;
import com.cloudera.hiveserver1.sqlengine.executor.etree.IETNodeVisitor;
import com.cloudera.hiveserver1.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;

public abstract class ETScalarFn
extends ETValueExpr {
    private ETDataRequest[] m_argRequests;
    private ETValueExpr[] m_args;
    private IColumn m_resultMeta;
    private BitSet m_argumentHasMoreData = new BitSet();

    protected ETScalarFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        if (list.size() != list2.size()) {
            throw new IllegalArgumentException(String.format("Number of metadata does not match number of arguments: number of argument metadata: %d, number of arguments: %d", list2.size(), list.size()));
        }
        this.m_resultMeta = iColumn;
        int n = list2.size();
        this.m_argRequests = new ETDataRequest[n];
        this.m_args = new ETValueExpr[n];
        Iterator<IColumn> iterator = list2.iterator();
        Iterator<ETValueExpr> iterator2 = list.iterator();
        for (int i = 0; i < this.m_args.length; ++i) {
            this.m_argRequests[i] = new ETDataRequest(iterator.next());
            this.m_args[i] = iterator2.next();
        }
    }

    @Override
    public void close(boolean bl) {
        for (ETValueExpr eTValueExpr : this.m_args) {
            eTValueExpr.close(bl);
        }
    }

    @Override
    public boolean isOpen() {
        for (ETValueExpr eTValueExpr : this.m_args) {
            if (eTValueExpr.isOpen()) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public int getNumChildren() {
        return this.m_args.length;
    }

    @Override
    public void open() throws ErrorException {
        for (ETValueExpr eTValueExpr : this.m_args) {
            eTValueExpr.open();
        }
    }

    @Override
    public abstract boolean retrieveData(ETDataRequest var1) throws ErrorException;

    @Override
    protected IETNode getChild(int n) throws IndexOutOfBoundsException {
        if (n >= this.m_args.length || n < 0) {
            throw new IndexOutOfBoundsException("invalid index: " + n);
        }
        return this.m_args[n];
    }

    protected ISqlDataWrapper getArgumentData(int n) throws ErrorException {
        if (n < 0 || n > this.m_argRequests.length) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        this.m_argRequests[n].setOffset(0L);
        this.m_argRequests[n].setMaxBytes(-1L);
        boolean bl = this.m_args[n].retrieveData(this.m_argRequests[n]);
        this.m_argumentHasMoreData.set(n, bl);
        return this.m_argRequests[n].getData();
    }

    protected ISqlDataWrapper getArgumentData(int n, long l, long l2) throws ErrorException {
        if (n < 0 || n > this.m_argRequests.length) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        this.m_argRequests[n].setOffset(l);
        this.m_argRequests[n].setMaxBytes(l2);
        boolean bl = this.m_args[n].retrieveData(this.m_argRequests[n]);
        this.m_argumentHasMoreData.set(n, bl);
        return this.m_argRequests[n].getData();
    }

    protected IColumn getInputMetadata(int n) {
        if (n < 0 || n > this.m_argRequests.length) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        return this.m_argRequests[n].getColumn();
    }

    protected IColumn getResultMetadata() {
        return this.m_resultMeta;
    }

    protected final boolean hasMoreData(int n) {
        return this.m_argumentHasMoreData.get(n);
    }
}

