/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.executor.etree.value.scalar;

import com.cloudera.hiveserver1.dsi.dataengine.utilities.TimestampTz;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class ETSqlTimestamp {
    private static final int MONTHS_PER_YEAR = 12;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_DAY = 86400;
    private static final int DAYS_PER_WEEK = 7;
    private static final int MONTHS_PER_QUARTER = 3;
    private static final int FRACTIONS_PER_SECOND = 1000000000;
    private final int m_year;
    private final int m_month;
    private final int m_day;
    private final int m_hour;
    private final int m_minute;
    private final int m_second;
    private final int m_fraction;

    public ETSqlTimestamp(Timestamp timestamp) {
        Calendar calendar = timestamp instanceof TimestampTz ? ((TimestampTz)timestamp).getTimezoneCalendar() : new GregorianCalendar();
        calendar.setTime(timestamp);
        this.m_year = calendar.get(1);
        this.m_month = calendar.get(2) + 1;
        this.m_day = calendar.get(5);
        this.m_hour = calendar.get(11);
        this.m_minute = calendar.get(12);
        this.m_second = calendar.get(13);
        this.m_fraction = timestamp.getNanos();
    }

    public long DiffInSeconds(ETSqlTimestamp eTSqlTimestamp) {
        long l = 0L;
        l += eTSqlTimestamp.GetDayDifference(this) * 86400L;
        l += (long)((eTSqlTimestamp.m_hour - this.m_hour) * 3600);
        l += (long)((eTSqlTimestamp.m_minute - this.m_minute) * 60);
        return l += (long)(eTSqlTimestamp.m_second - this.m_second);
    }

    public long DiffInFractionalSeconds(ETSqlTimestamp eTSqlTimestamp) {
        long l = this.DiffInSeconds(eTSqlTimestamp);
        l *= 1000000000L;
        return l += (long)(eTSqlTimestamp.m_fraction - this.m_fraction);
    }

    public long DiffInMinutes(ETSqlTimestamp eTSqlTimestamp) {
        long l = this.DiffInSeconds(eTSqlTimestamp);
        return l /= 60L;
    }

    public long DiffInHours(ETSqlTimestamp eTSqlTimestamp) {
        long l = this.DiffInSeconds(eTSqlTimestamp);
        return l /= 3600L;
    }

    public long DiffInDays(ETSqlTimestamp eTSqlTimestamp) {
        long l = this.dayDiffHelper(eTSqlTimestamp);
        return l;
    }

    public long DiffInWeeks(ETSqlTimestamp eTSqlTimestamp) {
        long l = this.dayDiffHelper(eTSqlTimestamp) / 7L;
        return l;
    }

    public long DiffInMonths(ETSqlTimestamp eTSqlTimestamp) {
        long l = eTSqlTimestamp.m_year - this.m_year;
        if (0 > eTSqlTimestamp.m_year && 0 < this.m_year || 0 < eTSqlTimestamp.m_year && 0 > this.m_year) {
            if (0L > l) {
                ++l;
            } else if (0L < l) {
                --l;
            }
        }
        l *= 12L;
        COMPARE_RESULT cOMPARE_RESULT = this.CompareAsTupleDayToFractionalSecond(eTSqlTimestamp);
        if ((l += (long)(eTSqlTimestamp.m_month - this.m_month)) > 0L && COMPARE_RESULT.LESS == cOMPARE_RESULT) {
            --l;
        } else if (l < 0L && COMPARE_RESULT.GREATER == cOMPARE_RESULT) {
            ++l;
        }
        return l;
    }

    public long DiffInQuarters(ETSqlTimestamp eTSqlTimestamp) {
        long l = this.DiffInMonths(eTSqlTimestamp);
        return l /= 3L;
    }

    public long DiffInYears(ETSqlTimestamp eTSqlTimestamp) {
        long l = 0L;
        l += (long)(eTSqlTimestamp.m_year - this.m_year);
        if (0 < eTSqlTimestamp.m_year && 0 > this.m_year || 0 > eTSqlTimestamp.m_year && 0 < this.m_year) {
            if (l > 0L) {
                --l;
            } else if (l < 0L) {
                ++l;
            }
        }
        COMPARE_RESULT cOMPARE_RESULT = this.CompareAsTupleMonthToFractionalSecond(eTSqlTimestamp);
        if (l > 0L && COMPARE_RESULT.LESS == cOMPARE_RESULT) {
            --l;
        } else if (l < 0L && COMPARE_RESULT.GREATER == cOMPARE_RESULT) {
            ++l;
        }
        return l;
    }

    private COMPARE_RESULT CompareAsTupleHourToFractionalSecond(ETSqlTimestamp eTSqlTimestamp) {
        if (this.m_hour < eTSqlTimestamp.m_hour) {
            return COMPARE_RESULT.GREATER;
        }
        if (this.m_hour > eTSqlTimestamp.m_hour) {
            return COMPARE_RESULT.LESS;
        }
        if (this.m_minute < eTSqlTimestamp.m_minute) {
            return COMPARE_RESULT.GREATER;
        }
        if (this.m_minute > eTSqlTimestamp.m_minute) {
            return COMPARE_RESULT.LESS;
        }
        if (this.m_second < eTSqlTimestamp.m_second) {
            return COMPARE_RESULT.GREATER;
        }
        if (this.m_second > eTSqlTimestamp.m_second) {
            return COMPARE_RESULT.LESS;
        }
        if (this.m_fraction < eTSqlTimestamp.m_fraction) {
            return COMPARE_RESULT.GREATER;
        }
        if (this.m_fraction > eTSqlTimestamp.m_fraction) {
            return COMPARE_RESULT.LESS;
        }
        return COMPARE_RESULT.EQUAL;
    }

    private COMPARE_RESULT CompareAsTupleDayToFractionalSecond(ETSqlTimestamp eTSqlTimestamp) {
        if (this.m_day < eTSqlTimestamp.m_day) {
            return COMPARE_RESULT.GREATER;
        }
        if (this.m_day > eTSqlTimestamp.m_day) {
            return COMPARE_RESULT.LESS;
        }
        return this.CompareAsTupleHourToFractionalSecond(eTSqlTimestamp);
    }

    private COMPARE_RESULT CompareAsTupleMonthToFractionalSecond(ETSqlTimestamp eTSqlTimestamp) {
        if (this.m_month < eTSqlTimestamp.m_month) {
            return COMPARE_RESULT.GREATER;
        }
        if (this.m_month > eTSqlTimestamp.m_month) {
            return COMPARE_RESULT.LESS;
        }
        return this.CompareAsTupleDayToFractionalSecond(eTSqlTimestamp);
    }

    private long dayDiffHelper(ETSqlTimestamp eTSqlTimestamp) {
        long l = eTSqlTimestamp.GetDayDifference(this);
        COMPARE_RESULT cOMPARE_RESULT = this.CompareAsTupleHourToFractionalSecond(eTSqlTimestamp);
        if (l > 0L && COMPARE_RESULT.LESS == cOMPARE_RESULT) {
            --l;
        } else if (l < 0L && COMPARE_RESULT.GREATER == cOMPARE_RESULT) {
            ++l;
        }
        return l;
    }

    private long GetDayDifference(ETSqlTimestamp eTSqlTimestamp) {
        return this.GetDays() - eTSqlTimestamp.GetDays();
    }

    private long GetDays() {
        int n;
        int n2 = this.m_year;
        if (0 > n2) {
            ++n2;
        }
        int n3 = (n2 - 1900) * 365 + 2;
        int n4 = 1;
        if (1900 <= this.m_year) {
            for (n = this.m_year; 1900 < n; n -= n4) {
                if (!ETSqlTimestamp.IsLeapYear(n - 1)) continue;
                ++n3;
                n4 = 4;
            }
        } else {
            for (n = this.m_year; 1900 > n; n += n4) {
                if (ETSqlTimestamp.IsLeapYear(n)) {
                    --n3;
                    n4 = 4;
                }
                if (n >= 0 || n + n4 < 0) continue;
                ++n;
            }
        }
        if (ETSqlTimestamp.IsLeapYear(this.m_year)) {
            short[] sArray = new short[]{0, 0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
            n3 += sArray[this.m_month];
        } else {
            short[] sArray = new short[]{0, 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
            n3 += sArray[this.m_month];
        }
        return n3 += this.m_day - 1;
    }

    private static boolean IsLeapYear(int n) {
        if (n <= 0) {
            ++n;
        }
        if (0 == n % 4) {
            if (0 == n % 100) {
                return 0 == n % 400;
            }
            return true;
        }
        return false;
    }

    static enum COMPARE_RESULT {
        EQUAL,
        LESS,
        GREATER;

    }
}

