/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.utilities;

import com.cloudera.hiveserver1.sqlengine.parser.parsetree.IPTNode;
import com.cloudera.hiveserver1.sqlengine.parser.parsetree.IPTVisitor;
import com.cloudera.hiveserver1.sqlengine.parser.parsetree.PTDefaultParameterNode;
import com.cloudera.hiveserver1.sqlengine.parser.parsetree.PTDynamicParameterNode;
import com.cloudera.hiveserver1.sqlengine.parser.parsetree.PTEmptyNode;
import com.cloudera.hiveserver1.sqlengine.parser.parsetree.PTFlagNode;
import com.cloudera.hiveserver1.sqlengine.parser.parsetree.PTIdentifierNode;
import com.cloudera.hiveserver1.sqlengine.parser.parsetree.PTListNode;
import com.cloudera.hiveserver1.sqlengine.parser.parsetree.PTLiteralNode;
import com.cloudera.hiveserver1.sqlengine.parser.parsetree.PTNonterminalNode;
import com.cloudera.hiveserver1.sqlengine.parser.parsetree.PTWalker;
import com.cloudera.hiveserver1.sqlengine.parser.type.PTPositionalType;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Stack;

public class PTStringLogger {
    public static void writePTLogString(IPTNode iPTNode, OutputStream outputStream) {
        try {
            PTWalker.walkPreorderDepthFirst(iPTNode, new PTLogVisitor(outputStream));
        }
        catch (ErrorException errorException) {
            throw new IllegalStateException(errorException);
        }
    }

    private static class PTLogVisitor
    implements IPTVisitor<Void> {
        private static final String INDENT_STRING = "    ";
        private Stack<Integer> m_indentStack = new Stack();
        private PrintWriter m_printWriter;
        private Stack<String> m_childTypeStack;

        public PTLogVisitor(OutputStream outputStream) {
            this.m_indentStack.push(0);
            this.m_printWriter = new PrintWriter(outputStream, true);
            this.m_childTypeStack = new Stack();
        }

        @Override
        public Void visit(PTEmptyNode pTEmptyNode) {
            this.writeString(pTEmptyNode.toString(), 0);
            return null;
        }

        @Override
        public Void visit(PTIdentifierNode pTIdentifierNode) {
            this.writeString(pTIdentifierNode.toString(), 0);
            return null;
        }

        @Override
        public Void visit(PTFlagNode pTFlagNode) {
            this.writeString(pTFlagNode.toString(), 0);
            return null;
        }

        @Override
        public Void visit(PTLiteralNode pTLiteralNode) {
            this.writeString(pTLiteralNode.toString(), 0);
            return null;
        }

        @Override
        public Void visit(PTDynamicParameterNode pTDynamicParameterNode) {
            this.writeString(pTDynamicParameterNode.toString(), 0);
            return null;
        }

        @Override
        public Void visit(PTDefaultParameterNode pTDefaultParameterNode) {
            this.writeString(pTDefaultParameterNode.toString(), 0);
            return null;
        }

        @Override
        public Void visit(PTNonterminalNode pTNonterminalNode) {
            this.writeString(pTNonterminalNode.toString(), pTNonterminalNode.numChildren());
            PTPositionalType[] pTPositionalTypeArray = pTNonterminalNode.getAllPositionalTypes().toArray(new PTPositionalType[0]);
            for (int i = pTPositionalTypeArray.length - 1; i >= 0; --i) {
                this.m_childTypeStack.push(pTPositionalTypeArray[i].name());
            }
            return null;
        }

        @Override
        public Void visit(PTListNode pTListNode) {
            this.writeString(pTListNode.toString(), pTListNode.numChildren());
            for (int i = pTListNode.numChildren() - 1; i >= 0; --i) {
                this.m_childTypeStack.push("" + i);
            }
            return null;
        }

        private void writeString(String string, int n) {
            int n2 = this.m_indentStack.pop();
            int n3 = n2 + 1;
            while (n > 0) {
                this.m_indentStack.push(n3);
                --n;
            }
            StringBuilder stringBuilder = new StringBuilder(1000);
            while (n2 > 0) {
                stringBuilder.append(INDENT_STRING);
                --n2;
            }
            if (!this.m_childTypeStack.isEmpty()) {
                stringBuilder.append(this.m_childTypeStack.pop());
                stringBuilder.append(": ");
            }
            stringBuilder.append(string);
            this.m_printWriter.println(stringBuilder.toString());
        }
    }
}

