/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.support;

import com.cloudera.hiveserver1.support.exceptions.DiagState;
import java.util.EnumMap;
import java.util.Map;

public enum WarningCode {
    GENERAL_WARNING(DiagState.DIAG_GENERAL_WARNING),
    CURSOR_OPERATION_CONFLICT(DiagState.DIAG_CURSOR_OPER_CONFLICT),
    DISCONNECT_ERROR(DiagState.DIAG_DISCONNECT_ERR),
    NULL_VALUE_ELIMINATED_IN_SET_FUNCTION(DiagState.DIAG_NULL_VAL_ELIM_IN_SET_FUNC),
    STRING_RIGHT_TRUNCATION_WARNING(DiagState.DIAG_STR_RIGHT_TRUNC_WARNING),
    PRIVILEGE_NOT_REVOKED(DiagState.DIAG_PRIVILEGE_NOT_REVOKED),
    PRIVILEGE_NOT_GRANTED(DiagState.DIAG_PRIVILEGE_NOT_GRANTED),
    INVALID_CONNECTION_STRING_ATTRIBUTE(DiagState.DIAG_INVALID_CONN_STR_ATTR),
    ERROR_IN_ROW(DiagState.DIAG_ERR_IN_ROW),
    OPTIONAL_VALUE_CHANGED(DiagState.DIAG_OPT_VAL_CHANGED),
    CANCEL_TREATED_AS_CLOSE(DiagState.DIAG_CANCEL_TREATED_AS_CLOSE),
    FETCH_BEFORE_FIRST_ROWSET_RETURNED(DiagState.DIAG_FETCH_BEFORE_FIRST_ROWSET_RETURNED),
    FRACTIONAL_TRUNCATION(DiagState.DIAG_FRACTIONAL_TRUNC),
    UNUSED(DiagState.DIAG_ERR_SAVING_FILE_DSN),
    INVALID_KEYWORD(DiagState.DIAG_INVALID_KEYWORD);

    private static final Map<DiagState, WarningCode> s_diagStateToWarningCode;
    private final DiagState m_diagState;

    static WarningCode getWarningCode(DiagState diagState) {
        WarningCode warningCode = s_diagStateToWarningCode.get((Object)diagState);
        return warningCode != null ? warningCode : GENERAL_WARNING;
    }

    private WarningCode(DiagState diagState) {
        this.m_diagState = diagState;
    }

    static {
        s_diagStateToWarningCode = new EnumMap<DiagState, WarningCode>(DiagState.class);
        for (WarningCode warningCode : WarningCode.values()) {
            s_diagStateToWarningCode.put(warningCode.m_diagState, warningCode);
        }
    }
}

