/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.support.channels;

import com.cloudera.hiveserver1.support.ArgValidator;
import com.cloudera.hiveserver1.support.ILogger;
import com.cloudera.hiveserver1.support.LogLevel;
import com.cloudera.hiveserver1.support.LogUtilities;
import com.cloudera.hiveserver1.support.channels.ISocketChannelReadCallback;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import com.cloudera.hiveserver1.support.exceptions.ExceptionBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractSocketChannel
implements Closeable {
    protected static final ExceptionBuilder EXCEPTION_BUILDER = new ExceptionBuilder(8);
    protected static final int SERVER_CLOSED_CONNECTION = -1;
    protected final SocketChannel m_internal;
    protected final ILogger m_log;
    private final AtomicBoolean m_closed = new AtomicBoolean(false);
    private String m_channelID;
    protected final ISocketChannelReadCallback m_readCallback;

    public AbstractSocketChannel(SocketChannel socketChannel, ISocketChannelReadCallback iSocketChannelReadCallback, ILogger iLogger) throws ErrorException {
        this.m_internal = socketChannel;
        this.m_readCallback = iSocketChannelReadCallback;
        this.m_log = iLogger;
        this.m_channelID = this.m_internal.socket().toString();
        if (LogUtilities.shouldLogLevel(LogLevel.DEBUG, this.m_log)) {
            LogUtilities.logDebug("Created channel " + this.getChannelID(), this.m_log);
        }
    }

    public SocketChannel getSocketChannel() {
        return this.m_internal;
    }

    public abstract int getReadBufferCapacity();

    @Override
    public void close() {
        block5: {
            LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
            try {
                if (this.m_closed.getAndSet(true)) break block5;
                try {
                    if (LogUtilities.shouldLogLevel(LogLevel.DEBUG, this.m_log)) {
                        LogUtilities.logDebug("Closing channel " + this.getChannelID(), this.m_log);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_internal.close();
            }
            catch (IOException iOException) {
                LogUtilities.logFatal(iOException, this.m_log);
            }
        }
    }

    public boolean isClosed() {
        LogUtilities.logTrace("The socket is closed: " + this.m_closed.toString(), this.m_log);
        return this.m_closed.get();
    }

    public void setChannelID(String string) {
        LogUtilities.logFunctionEntrance(this.m_log, string);
        ArgValidator.checkParameterNonNull(string, "channelID");
        LogUtilities.logDebug(String.format("Changing channel ID from '%s' to '%s'", this.m_channelID, string), this.m_log);
        this.m_channelID = string;
    }

    public String getChannelID() {
        return this.m_channelID;
    }

    public abstract boolean write(ByteBuffer var1) throws ErrorException;

    public abstract boolean write(ByteBuffer[] var1, int var2, int var3) throws ErrorException;

    public abstract void read() throws ErrorException;

    public boolean arrayHasRemaining(ByteBuffer[] byteBufferArray, int n) {
        return this.arrayHasRemaining(byteBufferArray, 0, n);
    }

    public boolean arrayHasRemaining(ByteBuffer[] byteBufferArray, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (!byteBufferArray[i].hasRemaining()) continue;
            return true;
        }
        return false;
    }

    protected void readCallback(ByteBuffer byteBuffer) throws ErrorException {
        byteBuffer.flip();
        byteBuffer.rewind();
        this.m_readCallback.read(byteBuffer);
    }
}

