/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.hivecommon.utils.kerberos;

import com.cloudera.hive.jdbc42.internal.apache.http.HttpException;
import com.cloudera.hive.jdbc42.internal.apache.http.HttpRequest;
import com.cloudera.hive.jdbc42.internal.apache.http.HttpRequestInterceptor;
import com.cloudera.hive.jdbc42.internal.apache.http.protocol.HttpContext;
import com.cloudera.hiveserver2.hivecommon.api.HiveServerHttpPrivilegedAction;
import java.io.IOException;
import javax.security.auth.Subject;

public class KerberosHttpInterceptor
implements HttpRequestInterceptor {
    private Subject m_kerberosSubject;
    HiveServerHttpPrivilegedAction m_action;

    public KerberosHttpInterceptor(String string, String string2, Subject subject) {
        this.m_kerberosSubject = subject;
        this.m_action = new HiveServerHttpPrivilegedAction(string + "@" + string2);
    }

    @Override
    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        try {
            this.addHttpAuthHeader(httpRequest);
        }
        catch (Exception exception) {
            throw new HttpException(exception.getMessage(), exception);
        }
    }

    protected void addHttpAuthHeader(HttpRequest httpRequest) throws Exception {
        if (null == this.m_kerberosSubject) {
            this.m_action.run();
        } else {
            Subject.doAs(this.m_kerberosSubject, this.m_action);
        }
        httpRequest.addHeader("Authorization", "Negotiate " + this.m_action.getKerberosTokenString());
    }
}

