/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.aeprocessor.aebuilder;

import com.cloudera.hiveserver2.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.AEColumnInfo;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.AEQColumnName;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.AEQTableName;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.relation.AENamedRelationalExpr;
import com.cloudera.hiveserver2.sqlengine.exceptions.SQLEngineException;
import com.cloudera.hiveserver2.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.hiveserver2.support.exceptions.DiagState;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.util.AbstractList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class AESymbolTable {
    private final boolean m_isCaseSensitive;
    private final Map<String, AENamedRelationalExpr> m_symbols = new LinkedHashMap<String, AENamedRelationalExpr>();

    AESymbolTable(boolean bl) {
        this.m_isCaseSensitive = bl;
    }

    public boolean isCaseSensitive() {
        return this.m_isCaseSensitive;
    }

    public AEColumnInfo findColumn(AEQColumnName aEQColumnName) throws ErrorException {
        if (aEQColumnName.hasQualifier()) {
            return this.findUniqueQualifiedColumn(aEQColumnName);
        }
        AEColumnInfo aEColumnInfo = null;
        for (AENamedRelationalExpr aENamedRelationalExpr : this.m_symbols.values()) {
            AEColumnInfo aEColumnInfo2 = this.findColumn(aENamedRelationalExpr, aEQColumnName.getColName());
            if (null == aEColumnInfo2) continue;
            if (null != aEColumnInfo) {
                throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.COLUMN_REF_NOT_UNIQUE.name(), new String[]{aEQColumnName.toString()});
            }
            aEColumnInfo = aEColumnInfo2;
        }
        return aEColumnInfo;
    }

    public void addTable(AENamedRelationalExpr aENamedRelationalExpr) throws ErrorException {
        String string = aENamedRelationalExpr.getTableName();
        if (this.hasSymbol(aENamedRelationalExpr.getTableName())) {
            throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.TABLE_NAME_NOT_UNIQUE.name(), new String[]{string});
        }
        HashSet<String> hashSet = new HashSet<String>(aENamedRelationalExpr.getColumnCount());
        for (int i = 0; i < aENamedRelationalExpr.getColumnCount(); ++i) {
            IColumn iColumn = aENamedRelationalExpr.getColumn(i);
            if (0 == iColumn.getName().length()) {
                throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.COLUMN_NAME_NOT_SPECIFIED.name(), new String[]{String.valueOf(i + 1), aENamedRelationalExpr.getTableName()});
            }
            if (hashSet.add(this.canonical(iColumn.getName()))) continue;
            throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.COLUMN_NAME_DUPLICATED.name(), new String[]{iColumn.getName(), aENamedRelationalExpr.getTableName()});
        }
        this.m_symbols.put(this.canonical(string), aENamedRelationalExpr);
    }

    public boolean hasSymbol(String string) {
        return this.m_symbols.containsKey(this.canonical(string));
    }

    public int size() {
        return this.m_symbols.size();
    }

    public Iterator<AEColumnInfo> getColumnItr() {
        final Iterator<AENamedRelationalExpr> iterator = this.m_symbols.values().iterator();
        return new Iterator<AEColumnInfo>(){
            private final Iterator<AENamedRelationalExpr> m_source;
            private Iterator<AEColumnInfo> m_current;
            private boolean m_finished;
            {
                this.m_source = iterator;
                this.m_finished = !this.m_source.hasNext();
                this.m_current = this.m_finished ? null : AESymbolTable.iteratorFromNamedRelationalExpr(this.m_source.next());
            }

            @Override
            public boolean hasNext() {
                if (this.m_finished) {
                    return false;
                }
                while (!this.m_current.hasNext()) {
                    if (!this.m_source.hasNext()) {
                        this.m_finished = true;
                        return false;
                    }
                    this.m_current = AESymbolTable.iteratorFromNamedRelationalExpr(this.m_source.next());
                }
                return true;
            }

            @Override
            public AEColumnInfo next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.m_current.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove() not supported.");
            }
        };
    }

    public Iterator<AEColumnInfo> getColumnItr(AEQTableName aEQTableName) throws SQLEngineException {
        AENamedRelationalExpr aENamedRelationalExpr = this.findTable(aEQTableName);
        if (null != aENamedRelationalExpr) {
            return AESymbolTable.iteratorFromNamedRelationalExpr(aENamedRelationalExpr);
        }
        throw new SQLEngineException(DiagState.DIAG_BASE_TABLE_OR_VIEW_MISSING, SQLEngineMessageKey.TABLE_NOT_FOUND.name(), new String[]{aEQTableName.toString()});
    }

    private String canonical(String string) {
        return this.isCaseSensitive() ? string : string.toUpperCase();
    }

    private AEColumnInfo findColumn(AENamedRelationalExpr aENamedRelationalExpr, String string) {
        int n = aENamedRelationalExpr.findColumn(string, this.isCaseSensitive());
        if (0 <= n) {
            return new AEColumnInfo(aENamedRelationalExpr, n, false);
        }
        return null;
    }

    private AEColumnInfo findUniqueQualifiedColumn(AEQColumnName aEQColumnName) throws ErrorException {
        assert (aEQColumnName.hasQualifier());
        AEColumnInfo aEColumnInfo = null;
        AENamedRelationalExpr aENamedRelationalExpr = this.findTable(aEQColumnName.getQTable());
        if (null != aENamedRelationalExpr && null == (aEColumnInfo = this.findColumn(aENamedRelationalExpr, aEQColumnName.getColName()))) {
            throw new SQLEngineException(DiagState.DIAG_COLUMN_MISSING, SQLEngineMessageKey.COLUMN_NOT_FOUND.name(), new String[]{aEQColumnName.toString()});
        }
        return aEColumnInfo;
    }

    private AENamedRelationalExpr findTable(AEQTableName aEQTableName) {
        AENamedRelationalExpr aENamedRelationalExpr = this.m_symbols.get(this.canonical(aEQTableName.getTableName()));
        if (null != aENamedRelationalExpr && aENamedRelationalExpr.matchesName(aEQTableName, this.isCaseSensitive())) {
            return aENamedRelationalExpr;
        }
        return null;
    }

    private static Iterator<AEColumnInfo> iteratorFromNamedRelationalExpr(final AENamedRelationalExpr aENamedRelationalExpr) {
        return new AbstractList<AEColumnInfo>(){

            @Override
            public AEColumnInfo get(int n) {
                return new AEColumnInfo(aENamedRelationalExpr, n, false);
            }

            @Override
            public int size() {
                return aENamedRelationalExpr.getColumnCount();
            }
        }.iterator();
    }
}

