/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.aeprocessor.aebuilder.statement;

import com.cloudera.hiveserver2.sqlengine.aeprocessor.aebuilder.AEBuilderBase;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aebuilder.statement.AEDdlStatementBuilder;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aebuilder.statement.AEDmlStatementBuilder;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aebuilder.statement.AEProcedureCallBuilder;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aebuilder.statement.AEQueryBuilder;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.statement.IAEStatement;
import com.cloudera.hiveserver2.sqlengine.dsiext.dataengine.SqlDataEngine;
import com.cloudera.hiveserver2.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver2.sqlengine.parser.parsetree.PTNonterminalNode;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;

public class AEStatementBuilder
extends AEBuilderBase<IAEStatement> {
    public AEStatementBuilder(SqlDataEngine sqlDataEngine) throws ErrorException {
        super(new AEQueryScope(sqlDataEngine));
    }

    @Override
    public IAEStatement visit(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        switch (pTNonterminalNode.getNonterminalType()) {
            case SELECT_STATEMENT: 
            case TOP_LEVEL_SELECT_STATEMENT: 
            case UNION: 
            case UNION_ALL: 
            case EXCEPT: 
            case EXCEPT_ALL: {
                return this.buildQuery(pTNonterminalNode);
            }
            case CREATE_TABLE_STATEMENT: 
            case DROP_TABLE_STATEMENT: {
                return this.buildDDLStatement(pTNonterminalNode);
            }
            case INSERT_STATEMENT: 
            case UPDATE_STATEMENT_SEARCHED: 
            case DELETE_STATEMENT_SEARCHED: 
            case UPSERT_STATEMENT: {
                return this.buildDmlStatement(pTNonterminalNode);
            }
            case PROCEDURE_CALL: {
                IAEStatement iAEStatement = this.buildProcedureCall(pTNonterminalNode);
                iAEStatement.reprocessMetadata();
                return iAEStatement;
            }
        }
        throw SQLEngineExceptionFactory.featureNotImplementedException(String.valueOf((Object)pTNonterminalNode.getNonterminalType()));
    }

    private IAEStatement buildDDLStatement(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        return (IAEStatement)new AEDdlStatementBuilder(this.getQueryScope()).build(pTNonterminalNode);
    }

    private IAEStatement buildQuery(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        return (IAEStatement)new AEQueryBuilder(this.getQueryScope()).build(pTNonterminalNode);
    }

    private IAEStatement buildDmlStatement(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        return (IAEStatement)new AEDmlStatementBuilder(this.getQueryScope()).build(pTNonterminalNode);
    }

    private IAEStatement buildProcedureCall(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        return (IAEStatement)new AEProcedureCallBuilder(this.getQueryScope()).build(pTNonterminalNode);
    }
}

