/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.executor.conversions;

import com.cloudera.hiveserver2.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.TypeUtilities;
import com.cloudera.hiveserver2.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver2.sqlengine.executor.conversions.ISqlConverter;
import com.cloudera.hiveserver2.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.hiveserver2.support.conv.ConversionResult;
import com.cloudera.hiveserver2.support.conv.IntegralConverter;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class SqlIntegralConverter
implements ISqlConverter {
    private final IColumn m_sourceMetadata;
    private final IColumn m_targetMetadata;
    private final short m_targetType;

    public SqlIntegralConverter(IColumn iColumn, IColumn iColumn2) {
        assert (iColumn.getTypeMetadata().isIntegerType() || iColumn.getTypeMetadata().isBooleanType());
        this.m_sourceMetadata = iColumn;
        this.m_targetMetadata = iColumn2;
        this.m_targetType = this.m_targetMetadata.getTypeMetadata().getType();
    }

    @Override
    public ConversionResult convert(ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2) throws ErrorException {
        ConversionResult conversionResult = new ConversionResult();
        if (-5 == this.m_sourceMetadata.getTypeMetadata().getType()) {
            this.convertBigInt(iSqlDataWrapper, iSqlDataWrapper2, conversionResult);
        } else if (this.m_sourceMetadata.getTypeMetadata().isBooleanType()) {
            this.convertBool(iSqlDataWrapper, iSqlDataWrapper2, conversionResult);
        } else {
            this.convertInteger(iSqlDataWrapper, iSqlDataWrapper2, conversionResult);
        }
        return conversionResult;
    }

    private void convertBool(ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2, ConversionResult conversionResult) throws ErrorException {
        if (iSqlDataWrapper.isNull()) {
            iSqlDataWrapper2.setNull();
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
            return;
        }
        boolean bl = iSqlDataWrapper.getBoolean();
        switch (this.m_targetType) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                String string = null;
                string = 16 == this.m_sourceMetadata.getTypeMetadata().getType() ? IntegralConverter.booleanToChar(bl, this.m_targetMetadata.getColumnLength(), conversionResult) : IntegralConverter.bitToChar(bl, this.m_targetMetadata.getColumnLength(), conversionResult);
                iSqlDataWrapper2.setChar(string);
                break;
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = IntegralConverter.toBigDecimal(bl, this.m_targetMetadata.getTypeMetadata().getPrecision(), this.m_targetMetadata.getTypeMetadata().getScale(), conversionResult);
                iSqlDataWrapper2.setExactNumber(bigDecimal);
                break;
            }
            default: {
                throw SQLEngineExceptionFactory.conversionNotSupported(TypeUtilities.sqlTypeToString((short)iSqlDataWrapper.getType()), TypeUtilities.sqlTypeToString(this.m_targetType));
            }
        }
    }

    private void convertInteger(ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2, ConversionResult conversionResult) throws ErrorException {
        if (iSqlDataWrapper.isNull()) {
            iSqlDataWrapper2.setNull();
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
            return;
        }
        long l = iSqlDataWrapper.getInteger();
        switch (this.m_targetType) {
            case -5: {
                BigInteger bigInteger = IntegralConverter.toBigInt(l, this.m_targetMetadata.getTypeMetadata().isSigned(), conversionResult);
                iSqlDataWrapper2.setBigInt(bigInteger);
                break;
            }
            case 4: {
                long l2 = IntegralConverter.toInteger(l, this.m_targetMetadata.getTypeMetadata().isSigned(), conversionResult);
                iSqlDataWrapper2.setInteger(l2);
                break;
            }
            case 5: {
                int n = IntegralConverter.toSmallInt(l, this.m_targetMetadata.getTypeMetadata().isSigned(), conversionResult);
                iSqlDataWrapper2.setSmallInt(n);
                break;
            }
            case -6: {
                short s = IntegralConverter.toTinyInt(l, this.m_targetMetadata.getTypeMetadata().isSigned(), conversionResult);
                iSqlDataWrapper2.setTinyInt(s);
                break;
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                String string = IntegralConverter.toChar(l, this.m_targetMetadata.getColumnLength(), conversionResult);
                iSqlDataWrapper2.setChar(string);
                break;
            }
            case -7: 
            case 16: {
                boolean bl = IntegralConverter.toBit(l, conversionResult);
                iSqlDataWrapper2.setBoolean(bl);
                break;
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = IntegralConverter.toBigDecimal(l, this.m_targetMetadata.getTypeMetadata().getPrecision(), this.m_targetMetadata.getTypeMetadata().getScale(), conversionResult);
                iSqlDataWrapper2.setExactNumber(bigDecimal);
                break;
            }
            case 7: {
                float f = IntegralConverter.toFloat(l, conversionResult);
                iSqlDataWrapper2.setReal(f);
                break;
            }
            default: {
                throw SQLEngineExceptionFactory.conversionNotSupported(TypeUtilities.sqlTypeToString((short)iSqlDataWrapper.getType()), TypeUtilities.sqlTypeToString(this.m_targetType));
            }
        }
    }

    private void convertBigInt(ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2, ConversionResult conversionResult) throws ErrorException {
        if (iSqlDataWrapper.isNull()) {
            iSqlDataWrapper2.setNull();
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
            return;
        }
        BigInteger bigInteger = iSqlDataWrapper.getBigInt();
        switch (this.m_targetType) {
            case -5: {
                BigInteger bigInteger2 = IntegralConverter.toBigInt(bigInteger, this.m_targetMetadata.getTypeMetadata().isSigned(), conversionResult);
                iSqlDataWrapper2.setBigInt(bigInteger2);
                break;
            }
            case 4: {
                long l = IntegralConverter.toInteger(bigInteger, this.m_targetMetadata.getTypeMetadata().isSigned(), conversionResult);
                iSqlDataWrapper2.setInteger(l);
                break;
            }
            case 5: {
                int n = IntegralConverter.toSmallInt(bigInteger, this.m_targetMetadata.getTypeMetadata().isSigned(), conversionResult);
                iSqlDataWrapper2.setSmallInt(n);
                break;
            }
            case -6: {
                short s = IntegralConverter.toTinyInt(bigInteger, this.m_targetMetadata.getTypeMetadata().isSigned(), conversionResult);
                iSqlDataWrapper2.setTinyInt(s);
                break;
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                String string = IntegralConverter.toChar(bigInteger, this.m_targetMetadata.getColumnLength(), conversionResult);
                iSqlDataWrapper2.setChar(string);
                break;
            }
            case -7: 
            case 16: {
                boolean bl = IntegralConverter.toBit(bigInteger, conversionResult);
                iSqlDataWrapper2.setBoolean(bl);
                break;
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = IntegralConverter.toBigDecimal(bigInteger, this.m_targetMetadata.getTypeMetadata().getPrecision(), this.m_targetMetadata.getTypeMetadata().getScale(), conversionResult);
                iSqlDataWrapper2.setExactNumber(bigDecimal);
                break;
            }
            case 6: 
            case 8: {
                double d = IntegralConverter.toDouble(bigInteger, conversionResult);
                iSqlDataWrapper2.setDouble(d);
                break;
            }
            case 7: {
                float f = IntegralConverter.toFloat(bigInteger, conversionResult);
                iSqlDataWrapper2.setReal(f);
                break;
            }
            default: {
                throw SQLEngineExceptionFactory.conversionNotSupported(TypeUtilities.sqlTypeToString((short)iSqlDataWrapper.getType()), TypeUtilities.sqlTypeToString(this.m_targetType));
            }
        }
    }
}

