/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.utilities.conversion;

import com.cloudera.hiveserver2.dsi.core.impl.DSIDriverSingleton;
import com.cloudera.hiveserver2.dsi.core.interfaces.IDriver;
import com.cloudera.hiveserver2.dsi.core.utilities.Variant;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.DSIMonthSpan;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.DSITimeSpan;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.hiveserver2.dsi.exceptions.InvalidArgumentException;
import com.cloudera.hiveserver2.exceptions.JDBCMessageBuilder;
import com.cloudera.hiveserver2.exceptions.JDBCMessageKey;
import com.cloudera.hiveserver2.support.IWarningListener;
import com.cloudera.hiveserver2.support.Warning;
import com.cloudera.hiveserver2.support.WarningCode;

public class IntervalConverter {
    private static final char DAY_HOUR_SEPARATOR = ' ';
    private static final char HOUR_MINUTE_SECOND_SEPARATOR = ':';
    private static final char SECOND_FRACTION_SEPARATOR = '.';
    private static final char YEAR_MONTH_SEPARATOR = '-';
    private static final char MINUS_SIGN = '-';
    private static final char ZERO_DIGIT = '0';
    private static final int INTERVAL_LEADING_PRECISION = 9;
    private static final short INTERVAL_FRACTIONAL_PRECISION = 9;
    private static boolean s_isLeadingFieldPadded;
    static final String[] ZERO_BUFFER;
    private static final int MONTHS_PER_YEAR = 12;
    private static final int HOURS_PER_DAY = 24;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int MINUTES_PER_DAY = 1440;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_DAY = 86400;

    public static String convertIntervalDayToHourToString(Object object, TypeMetadata typeMetadata) {
        DSITimeSpan dSITimeSpan = (DSITimeSpan)object;
        StringBuilder stringBuilder = new StringBuilder(16);
        IntervalConverter.formatLeadingField(stringBuilder, dSITimeSpan.getDay(), dSITimeSpan.isNegative(), typeMetadata.isIntervalType() ? (long)typeMetadata.getIntervalPrecision() : 9L);
        stringBuilder.append(' ');
        int n = dSITimeSpan.getHour();
        stringBuilder.append((char)(48 + n / 10));
        stringBuilder.append((char)(48 + n % 10));
        return stringBuilder.toString();
    }

    public static String convertIntervalDayToMinuteToString(Object object, TypeMetadata typeMetadata) {
        DSITimeSpan dSITimeSpan = (DSITimeSpan)object;
        StringBuilder stringBuilder = new StringBuilder(19);
        IntervalConverter.formatLeadingField(stringBuilder, dSITimeSpan.getDay(), dSITimeSpan.isNegative(), typeMetadata.isIntervalType() ? (long)typeMetadata.getIntervalPrecision() : 9L);
        stringBuilder.append(' ');
        int n = dSITimeSpan.getHour();
        stringBuilder.append((char)(48 + n / 10));
        stringBuilder.append((char)(48 + n % 10));
        stringBuilder.append(':');
        int n2 = dSITimeSpan.getMinute();
        stringBuilder.append((char)(48 + n2 / 10));
        stringBuilder.append((char)(48 + n2 % 10));
        return stringBuilder.toString();
    }

    public static String convertIntervalDayToSecondToString(Object object, TypeMetadata typeMetadata) {
        DSITimeSpan dSITimeSpan = (DSITimeSpan)object;
        StringBuilder stringBuilder = new StringBuilder(30);
        IntervalConverter.formatLeadingField(stringBuilder, dSITimeSpan.getDay(), dSITimeSpan.isNegative(), typeMetadata.isIntervalType() ? (long)typeMetadata.getIntervalPrecision() : 9L);
        stringBuilder.append(' ');
        int n = dSITimeSpan.getHour();
        stringBuilder.append((char)(48 + n / 10));
        stringBuilder.append((char)(48 + n % 10));
        stringBuilder.append(':');
        int n2 = dSITimeSpan.getMinute();
        stringBuilder.append((char)(48 + n2 / 10));
        stringBuilder.append((char)(48 + n2 % 10));
        stringBuilder.append(':');
        int n3 = dSITimeSpan.getSecond();
        stringBuilder.append((char)(48 + n3 / 10));
        stringBuilder.append((char)(48 + n3 % 10));
        IntervalConverter.formatFractionField(stringBuilder, dSITimeSpan.getFraction(), typeMetadata.isIntervalType() ? (short)typeMetadata.getPrecision() : (short)9);
        return stringBuilder.toString();
    }

    public static String convertIntervalDayToString(Object object, TypeMetadata typeMetadata) {
        DSITimeSpan dSITimeSpan = (DSITimeSpan)object;
        StringBuilder stringBuilder = new StringBuilder(10);
        IntervalConverter.formatLeadingField(stringBuilder, dSITimeSpan.getDay(), dSITimeSpan.isNegative(), typeMetadata.isIntervalType() ? (long)typeMetadata.getIntervalPrecision() : 9L);
        return stringBuilder.toString();
    }

    public static String convertIntervalHourToMinuteToString(Object object, TypeMetadata typeMetadata) {
        DSITimeSpan dSITimeSpan = (DSITimeSpan)object;
        StringBuilder stringBuilder = new StringBuilder(13);
        IntervalConverter.formatLeadingField(stringBuilder, dSITimeSpan.getHour(), dSITimeSpan.isNegative(), typeMetadata.isIntervalType() ? (long)typeMetadata.getIntervalPrecision() : 9L);
        stringBuilder.append(':');
        int n = dSITimeSpan.getMinute();
        stringBuilder.append((char)(48 + n / 10));
        stringBuilder.append((char)(48 + n % 10));
        return stringBuilder.toString();
    }

    public static String convertIntervalHourToSecondToString(Object object, TypeMetadata typeMetadata) {
        DSITimeSpan dSITimeSpan = (DSITimeSpan)object;
        StringBuilder stringBuilder = new StringBuilder(26);
        IntervalConverter.formatLeadingField(stringBuilder, dSITimeSpan.getHour(), dSITimeSpan.isNegative(), typeMetadata.isIntervalType() ? (long)typeMetadata.getIntervalPrecision() : 9L);
        stringBuilder.append(':');
        int n = dSITimeSpan.getMinute();
        stringBuilder.append((char)(48 + n / 10));
        stringBuilder.append((char)(48 + n % 10));
        stringBuilder.append(':');
        int n2 = dSITimeSpan.getSecond();
        stringBuilder.append((char)(48 + n2 / 10));
        stringBuilder.append((char)(48 + n2 % 10));
        IntervalConverter.formatFractionField(stringBuilder, dSITimeSpan.getFraction(), typeMetadata.isIntervalType() ? (short)typeMetadata.getPrecision() : (short)9);
        return stringBuilder.toString();
    }

    public static String convertIntervalHourToString(Object object, TypeMetadata typeMetadata) {
        DSITimeSpan dSITimeSpan = (DSITimeSpan)object;
        StringBuilder stringBuilder = new StringBuilder(10);
        IntervalConverter.formatLeadingField(stringBuilder, dSITimeSpan.getHour(), dSITimeSpan.isNegative(), typeMetadata.isIntervalType() ? (long)typeMetadata.getIntervalPrecision() : 9L);
        return stringBuilder.toString();
    }

    public static String convertIntervalMinuteToSecondToString(Object object, TypeMetadata typeMetadata) {
        DSITimeSpan dSITimeSpan = (DSITimeSpan)object;
        StringBuilder stringBuilder = new StringBuilder(22);
        IntervalConverter.formatLeadingField(stringBuilder, dSITimeSpan.getMinute(), dSITimeSpan.isNegative(), typeMetadata.isIntervalType() ? (long)typeMetadata.getIntervalPrecision() : 9L);
        stringBuilder.append(':');
        int n = dSITimeSpan.getSecond();
        stringBuilder.append((char)(48 + n / 10));
        stringBuilder.append((char)(48 + n % 10));
        IntervalConverter.formatFractionField(stringBuilder, dSITimeSpan.getFraction(), typeMetadata.isIntervalType() ? (short)typeMetadata.getPrecision() : (short)9);
        return stringBuilder.toString();
    }

    public static String convertIntervalMinuteToString(Object object, TypeMetadata typeMetadata) {
        DSITimeSpan dSITimeSpan = (DSITimeSpan)object;
        StringBuilder stringBuilder = new StringBuilder(10);
        IntervalConverter.formatLeadingField(stringBuilder, dSITimeSpan.getMinute(), dSITimeSpan.isNegative(), typeMetadata.isIntervalType() ? (long)typeMetadata.getIntervalPrecision() : 9L);
        return stringBuilder.toString();
    }

    public static String convertIntervalMonthToString(Object object, TypeMetadata typeMetadata) {
        DSIMonthSpan dSIMonthSpan = (DSIMonthSpan)object;
        StringBuilder stringBuilder = new StringBuilder(10);
        IntervalConverter.formatLeadingField(stringBuilder, dSIMonthSpan.getMonth(), dSIMonthSpan.isNegative(), typeMetadata.isIntervalType() ? (long)typeMetadata.getIntervalPrecision() : 9L);
        return stringBuilder.toString();
    }

    public static String convertIntervalSecondToString(Object object, TypeMetadata typeMetadata) {
        DSITimeSpan dSITimeSpan = (DSITimeSpan)object;
        StringBuilder stringBuilder = new StringBuilder(20);
        IntervalConverter.formatLeadingField(stringBuilder, dSITimeSpan.getSecond(), dSITimeSpan.isNegative(), typeMetadata.isIntervalType() ? (long)typeMetadata.getIntervalPrecision() : 9L);
        IntervalConverter.formatFractionField(stringBuilder, dSITimeSpan.getFraction(), typeMetadata.isIntervalType() ? (short)typeMetadata.getPrecision() : (short)9);
        return stringBuilder.toString();
    }

    public static String convertIntervalToString(Object object, TypeMetadata typeMetadata) {
        String string = null;
        switch (typeMetadata.getType()) {
            case 103: {
                string = IntervalConverter.convertIntervalDayToString(object, typeMetadata);
                break;
            }
            case 108: {
                string = IntervalConverter.convertIntervalDayToHourToString(object, typeMetadata);
                break;
            }
            case 109: {
                string = IntervalConverter.convertIntervalDayToMinuteToString(object, typeMetadata);
                break;
            }
            case 110: {
                string = IntervalConverter.convertIntervalDayToSecondToString(object, typeMetadata);
                break;
            }
            case 104: {
                string = IntervalConverter.convertIntervalHourToString(object, typeMetadata);
                break;
            }
            case 111: {
                string = IntervalConverter.convertIntervalHourToMinuteToString(object, typeMetadata);
                break;
            }
            case 112: {
                string = IntervalConverter.convertIntervalHourToSecondToString(object, typeMetadata);
                break;
            }
            case 105: {
                string = IntervalConverter.convertIntervalMinuteToString(object, typeMetadata);
                break;
            }
            case 113: {
                string = IntervalConverter.convertIntervalMinuteToSecondToString(object, typeMetadata);
                break;
            }
            case 102: {
                string = IntervalConverter.convertIntervalMonthToString(object, typeMetadata);
                break;
            }
            case 106: {
                string = IntervalConverter.convertIntervalSecondToString(object, typeMetadata);
                break;
            }
            case 101: {
                string = IntervalConverter.convertIntervalYearToString(object, typeMetadata);
                break;
            }
            case 107: {
                string = IntervalConverter.convertIntervalYearToMonthToString(object, typeMetadata);
                break;
            }
            default: {
                throw new InvalidArgumentException(1, JDBCMessageKey.INVALID_INTERVAL_DATA_TYPE.name(), null);
            }
        }
        return string;
    }

    public static String convertIntervalYearToMonthToString(Object object, TypeMetadata typeMetadata) {
        DSIMonthSpan dSIMonthSpan = (DSIMonthSpan)object;
        StringBuilder stringBuilder = new StringBuilder(13);
        IntervalConverter.formatLeadingField(stringBuilder, dSIMonthSpan.getYear(), dSIMonthSpan.isNegative(), typeMetadata.isIntervalType() ? (long)typeMetadata.getIntervalPrecision() : 9L);
        stringBuilder.append('-');
        int n = dSIMonthSpan.getMonth();
        stringBuilder.append((char)(48 + n / 10));
        stringBuilder.append((char)(48 + n % 10));
        return stringBuilder.toString();
    }

    public static String convertIntervalYearToString(Object object, TypeMetadata typeMetadata) {
        DSIMonthSpan dSIMonthSpan = (DSIMonthSpan)object;
        StringBuilder stringBuilder = new StringBuilder(10);
        IntervalConverter.formatLeadingField(stringBuilder, dSIMonthSpan.getYear(), dSIMonthSpan.isNegative(), typeMetadata.isIntervalType() ? (long)typeMetadata.getIntervalPrecision() : 9L);
        return stringBuilder.toString();
    }

    public static Object convertStringToInterval(String string, TypeMetadata typeMetadata, IWarningListener iWarningListener) {
        string = string.trim();
        switch (typeMetadata.getType()) {
            case 102: {
                return IntervalConverter.stringToIntervalMonth(string, typeMetadata, iWarningListener);
            }
            case 101: {
                return IntervalConverter.stringToIntervalYear(string, typeMetadata, iWarningListener);
            }
            case 107: {
                return IntervalConverter.stringToIntervalYearMonth(string, typeMetadata, iWarningListener);
            }
            case 103: {
                return IntervalConverter.stringToIntervalDay(string, typeMetadata, iWarningListener);
            }
            case 108: {
                return IntervalConverter.stringToIntervalDayToHour(string, typeMetadata, iWarningListener);
            }
            case 109: {
                return IntervalConverter.stringToIntervalDayToMinute(string, typeMetadata, iWarningListener);
            }
            case 110: {
                return IntervalConverter.stringToIntervalDayToSecond(string, typeMetadata, iWarningListener);
            }
            case 104: {
                return IntervalConverter.stringToIntervalHour(string, typeMetadata, iWarningListener);
            }
            case 111: {
                return IntervalConverter.stringToIntervalHourToMinute(string, typeMetadata, iWarningListener);
            }
            case 112: {
                return IntervalConverter.stringToIntervalHourToSecond(string, typeMetadata, iWarningListener);
            }
            case 105: {
                return IntervalConverter.stringToIntervalMinute(string, typeMetadata, iWarningListener);
            }
            case 113: {
                return IntervalConverter.stringToIntervalMinuteToSecond(string, typeMetadata, iWarningListener);
            }
            case 106: {
                return IntervalConverter.stringToIntervalSecond(string, typeMetadata, iWarningListener);
            }
        }
        throw new InvalidArgumentException(1, JDBCMessageKey.INVALID_INTERVAL_DATA_TYPE.name(), null);
    }

    private static void checkLeadingField(int n, int n2) {
        int n3 = 0;
        if (n < 100000) {
            n3 = n < 100 ? (n < 10 ? 1 : 2) : (n < 1000 ? 3 : (n < 10000 ? 4 : 5));
        } else if (n < 10000000) {
            n3 = n < 1000000 ? 6 : 7;
        } else {
            int n4 = n < 100000000 ? 8 : (n3 = n < 1000000000 ? 9 : 10);
        }
        if (n3 > n2) {
            throw new InvalidArgumentException(1, JDBCMessageKey.INTERVAL_FIELD_OVERFLOW.name(), null);
        }
    }

    private static IllegalArgumentException createException(JDBCMessageKey jDBCMessageKey, String string, IWarningListener iWarningListener) {
        return new IllegalArgumentException(JDBCMessageBuilder.getMessage(jDBCMessageKey, iWarningListener, string));
    }

    private static void formatFractionField(StringBuilder stringBuilder, int n, short n2) {
        if (0 < n2) {
            stringBuilder.append('.');
            int n3 = n2;
            StringBuilder stringBuilder2 = new StringBuilder("000000000");
            while (n3 > 0) {
                stringBuilder2.setCharAt(--n3, (char)(48 + n % 10));
                n /= 10;
            }
            if (n > 0) {
                throw new InvalidArgumentException(1, JDBCMessageKey.INTERVAL_FIELD_OVERFLOW.name(), null);
            }
            stringBuilder.append(stringBuilder2.substring(0, n2));
        }
    }

    private static void formatLeadingField(StringBuilder stringBuilder, int n, boolean bl, long l) {
        if (bl) {
            stringBuilder.append('-');
        }
        if (s_isLeadingFieldPadded) {
            String string = Integer.toString(n);
            stringBuilder.append(ZERO_BUFFER[(int)l - string.length()]);
            stringBuilder.append(string);
        } else {
            stringBuilder.append(n);
        }
    }

    private static int getFractionField(String string, short s, IWarningListener iWarningListener) {
        int n = 0;
        if (0 < s) {
            int n2 = string.length();
            if (n2 == s) {
                n = Integer.valueOf(string);
            } else if (n2 > s) {
                n = Integer.valueOf(string.substring(0, s));
                if (0 != Integer.valueOf(string.substring(s))) {
                    iWarningListener.postWarning(new Warning(WarningCode.FRACTIONAL_TRUNCATION, 1, JDBCMessageKey.WARN_FRACTIONAL_TRUNC.name()));
                }
            } else {
                int n3 = s - n2;
                n = Integer.valueOf(string);
                while (n3-- > 0) {
                    n *= 10;
                }
            }
        }
        return n;
    }

    private static DaySecondValue stringToDaySecondValue(String string, TypeMetadata typeMetadata, IWarningListener iWarningListener, JDBCMessageKey jDBCMessageKey) {
        if (0 == string.length()) {
            throw IntervalConverter.createException(jDBCMessageKey, string, iWarningListener);
        }
        DaySecondValue daySecondValue = new DaySecondValue();
        int n = 0;
        int n2 = string.length();
        if ('-' == string.charAt(0)) {
            daySecondValue.m_isNegative = true;
            ++n;
        }
        while (n < n2 && Character.isDigit(string.charAt(n))) {
            ++n;
        }
        int n3 = n;
        IntervalFieldType intervalFieldType = IntervalFieldType.DAY;
        if (n < n2) {
            switch (string.charAt(n)) {
                case ' ': {
                    intervalFieldType = IntervalFieldType.DAY;
                    break;
                }
                case ':': {
                    ++n;
                    while (n < n2 && Character.isDigit(string.charAt(n))) {
                        ++n;
                    }
                    if (n < n2 && '.' == string.charAt(n)) {
                        intervalFieldType = IntervalFieldType.MINUTE;
                        break;
                    }
                    intervalFieldType = IntervalFieldType.HOUR;
                    break;
                }
                case '.': {
                    intervalFieldType = IntervalFieldType.SECOND;
                    break;
                }
                default: {
                    throw IntervalConverter.createException(jDBCMessageKey, string, iWarningListener);
                }
            }
        }
        boolean bl = false;
        int n4 = n = daySecondValue.m_isNegative ? 1 : 0;
        while (n < n2) {
            daySecondValue.m_numFields = (short)(daySecondValue.m_numFields + 1);
            switch (intervalFieldType) {
                case DAY: {
                    daySecondValue.m_day = Integer.valueOf(string.substring(n, n3));
                    bl = true;
                    intervalFieldType = IntervalFieldType.HOUR;
                    n = n3;
                    if (n == n2 || ' ' == string.charAt(n)) break;
                    throw IntervalConverter.createException(jDBCMessageKey, string, iWarningListener);
                }
                case HOUR: {
                    if (bl) {
                        daySecondValue.m_hour = Integer.valueOf(string.substring(n, n + 2));
                        n += 2;
                    } else {
                        daySecondValue.m_hour = Integer.valueOf(string.substring(n, n3));
                        bl = true;
                        n = n3;
                    }
                    intervalFieldType = IntervalFieldType.MINUTE;
                    if (n == n2 || ':' == string.charAt(n)) break;
                    throw IntervalConverter.createException(jDBCMessageKey, string, iWarningListener);
                }
                case MINUTE: {
                    if (bl) {
                        daySecondValue.m_minute = Integer.valueOf(string.substring(n, n + 2));
                        n += 2;
                    } else {
                        daySecondValue.m_minute = Integer.valueOf(string.substring(n, n3));
                        bl = true;
                        n = n3;
                    }
                    intervalFieldType = IntervalFieldType.SECOND;
                    if (n == n2 || ':' == string.charAt(n)) break;
                    throw IntervalConverter.createException(jDBCMessageKey, string, iWarningListener);
                }
                case SECOND: {
                    if (bl) {
                        daySecondValue.m_second = Integer.valueOf(string.substring(n, n + 2));
                        n += 2;
                    } else {
                        daySecondValue.m_second = Integer.valueOf(string.substring(n, n3));
                        bl = true;
                        n = n3;
                    }
                    intervalFieldType = IntervalFieldType.FRACTION;
                    if (n == n2 || '.' == string.charAt(n)) break;
                    throw IntervalConverter.createException(jDBCMessageKey, string, iWarningListener);
                }
                case FRACTION: {
                    if (!bl) {
                        throw IntervalConverter.createException(jDBCMessageKey, string, iWarningListener);
                    }
                    daySecondValue.m_fraction = IntervalConverter.getFractionField(string.substring(n), typeMetadata.getPrecision(), iWarningListener);
                    return daySecondValue;
                }
                default: {
                    throw IntervalConverter.createException(jDBCMessageKey, string, iWarningListener);
                }
            }
            ++n;
        }
        return daySecondValue;
    }

    private static DSITimeSpan stringToIntervalDay(String string, TypeMetadata typeMetadata, IWarningListener iWarningListener) {
        DaySecondValue daySecondValue = IntervalConverter.stringToDaySecondValue(string, typeMetadata, iWarningListener, JDBCMessageKey.INVALID_INTERVAL_DAY_FORMAT);
        int n = daySecondValue.m_day + daySecondValue.m_hour / 24 + daySecondValue.m_minute / 1440 + daySecondValue.m_second / 86400;
        DSITimeSpan dSITimeSpan = new DSITimeSpan(103, n, 0, 0, 0, 0, daySecondValue.m_isNegative);
        if (0 != daySecondValue.m_hour % 24 || 0 != daySecondValue.m_minute % 1440 || 0 != daySecondValue.m_second % 86400 || 0 != daySecondValue.m_fraction) {
            iWarningListener.postWarning(new Warning(WarningCode.FRACTIONAL_TRUNCATION, 1, JDBCMessageKey.WARN_FRACTIONAL_TRUNC.name()));
        }
        IntervalConverter.checkLeadingField(dSITimeSpan.getDay(), typeMetadata.getIntervalPrecision());
        return dSITimeSpan;
    }

    private static DSITimeSpan stringToIntervalDayToHour(String string, TypeMetadata typeMetadata, IWarningListener iWarningListener) {
        DaySecondValue daySecondValue = IntervalConverter.stringToDaySecondValue(string, typeMetadata, iWarningListener, JDBCMessageKey.INVALID_INTERVAL_DAY_HOUR_FORMAT);
        int n = daySecondValue.m_hour + daySecondValue.m_minute / 60 + daySecondValue.m_second / 3600;
        DSITimeSpan dSITimeSpan = new DSITimeSpan(108, daySecondValue.m_day + n / 24, n % 24, 0, 0, 0, daySecondValue.m_isNegative);
        if (0 != daySecondValue.m_minute % 60 || 0 != daySecondValue.m_second % 3600 || 0 != daySecondValue.m_fraction) {
            iWarningListener.postWarning(new Warning(WarningCode.FRACTIONAL_TRUNCATION, 1, JDBCMessageKey.WARN_FRACTIONAL_TRUNC.name()));
        }
        IntervalConverter.checkLeadingField(dSITimeSpan.getDay(), typeMetadata.getIntervalPrecision());
        return dSITimeSpan;
    }

    private static DSITimeSpan stringToIntervalDayToMinute(String string, TypeMetadata typeMetadata, IWarningListener iWarningListener) {
        DaySecondValue daySecondValue = IntervalConverter.stringToDaySecondValue(string, typeMetadata, iWarningListener, JDBCMessageKey.INVALID_INTERVAL_DAY_MINUTE_FORMAT);
        int n = daySecondValue.m_minute + daySecondValue.m_second / 60;
        int n2 = n % 60;
        n = daySecondValue.m_hour + n / 60;
        DSITimeSpan dSITimeSpan = new DSITimeSpan(109, daySecondValue.m_day + n / 24, n % 24, n2, 0, 0, daySecondValue.m_isNegative);
        if (0 != daySecondValue.m_second % 60 || 0 != daySecondValue.m_fraction) {
            iWarningListener.postWarning(new Warning(WarningCode.FRACTIONAL_TRUNCATION, 1, JDBCMessageKey.WARN_FRACTIONAL_TRUNC.name()));
        }
        IntervalConverter.checkLeadingField(dSITimeSpan.getDay(), typeMetadata.getIntervalPrecision());
        return dSITimeSpan;
    }

    private static DSITimeSpan stringToIntervalDayToSecond(String string, TypeMetadata typeMetadata, IWarningListener iWarningListener) {
        DaySecondValue daySecondValue = IntervalConverter.stringToDaySecondValue(string, typeMetadata, iWarningListener, JDBCMessageKey.INVALID_INTERVAL_DAY_SECOND_FORMAT);
        IntervalConverter.checkLeadingField(daySecondValue.m_day, typeMetadata.getIntervalPrecision());
        int n = daySecondValue.m_minute + daySecondValue.m_second / 60;
        int n2 = n % 60;
        n = daySecondValue.m_hour + n / 60;
        return new DSITimeSpan(110, daySecondValue.m_day + n / 24, n % 24, n2, daySecondValue.m_second % 60, daySecondValue.m_fraction, daySecondValue.m_isNegative);
    }

    private static DSITimeSpan stringToIntervalHour(String string, TypeMetadata typeMetadata, IWarningListener iWarningListener) {
        DaySecondValue daySecondValue = IntervalConverter.stringToDaySecondValue(string, typeMetadata, iWarningListener, JDBCMessageKey.INVALID_INTERVAL_HOUR_FORMAT);
        DSITimeSpan dSITimeSpan = null;
        if (1 == daySecondValue.m_numFields) {
            dSITimeSpan = new DSITimeSpan(104, 0, daySecondValue.m_day, 0, 0, 0, daySecondValue.m_isNegative);
        } else {
            int n = daySecondValue.m_day * 24 + daySecondValue.m_hour + daySecondValue.m_minute / 60 + daySecondValue.m_second / 60;
            dSITimeSpan = new DSITimeSpan(104, 0, n, 0, 0, 0, daySecondValue.m_isNegative);
            if (0 != daySecondValue.m_minute % 60 || 0 != daySecondValue.m_second % 60 || 0 != daySecondValue.m_fraction) {
                iWarningListener.postWarning(new Warning(WarningCode.FRACTIONAL_TRUNCATION, 1, JDBCMessageKey.WARN_FRACTIONAL_TRUNC.name()));
            }
        }
        IntervalConverter.checkLeadingField(dSITimeSpan.getHour(), typeMetadata.getIntervalPrecision());
        return dSITimeSpan;
    }

    private static DSITimeSpan stringToIntervalHourToMinute(String string, TypeMetadata typeMetadata, IWarningListener iWarningListener) {
        DaySecondValue daySecondValue = IntervalConverter.stringToDaySecondValue(string, typeMetadata, iWarningListener, JDBCMessageKey.INVALID_INTERVAL_HOUR_MINUTE_FORMAT);
        DSITimeSpan dSITimeSpan = null;
        if (1 == daySecondValue.m_numFields) {
            dSITimeSpan = new DSITimeSpan(111, 0, daySecondValue.m_day, 0, 0, 0, daySecondValue.m_isNegative);
        } else {
            int n = daySecondValue.m_minute + daySecondValue.m_second / 60;
            dSITimeSpan = new DSITimeSpan(111, 0, daySecondValue.m_day * 24 + daySecondValue.m_hour + n / 60, n % 60, 0, 0, daySecondValue.m_isNegative);
            if (0 != daySecondValue.m_second % 60 || 0 != daySecondValue.m_fraction) {
                iWarningListener.postWarning(new Warning(WarningCode.FRACTIONAL_TRUNCATION, 1, JDBCMessageKey.WARN_FRACTIONAL_TRUNC.name()));
            }
        }
        IntervalConverter.checkLeadingField(dSITimeSpan.getHour(), typeMetadata.getIntervalPrecision());
        return dSITimeSpan;
    }

    private static DSITimeSpan stringToIntervalHourToSecond(String string, TypeMetadata typeMetadata, IWarningListener iWarningListener) {
        DaySecondValue daySecondValue = IntervalConverter.stringToDaySecondValue(string, typeMetadata, iWarningListener, JDBCMessageKey.INVALID_INTERVAL_HOUR_SECOND_FORMAT);
        DSITimeSpan dSITimeSpan = null;
        if (1 == daySecondValue.m_numFields) {
            dSITimeSpan = new DSITimeSpan(112, 0, daySecondValue.m_day, 0, 0, 0, daySecondValue.m_isNegative);
        } else {
            int n = daySecondValue.m_minute + daySecondValue.m_second / 60;
            dSITimeSpan = new DSITimeSpan(112, 0, daySecondValue.m_day * 24 + daySecondValue.m_hour + n / 60, n % 60, daySecondValue.m_second % 60, daySecondValue.m_fraction, daySecondValue.m_isNegative);
        }
        IntervalConverter.checkLeadingField(dSITimeSpan.getHour(), typeMetadata.getIntervalPrecision());
        return dSITimeSpan;
    }

    private static DSITimeSpan stringToIntervalMinute(String string, TypeMetadata typeMetadata, IWarningListener iWarningListener) {
        DaySecondValue daySecondValue = IntervalConverter.stringToDaySecondValue(string, typeMetadata, iWarningListener, JDBCMessageKey.INVALID_INTERVAL_MINUTE_FORMAT);
        DSITimeSpan dSITimeSpan = null;
        if (1 == daySecondValue.m_numFields) {
            dSITimeSpan = new DSITimeSpan(105, 0, 0, daySecondValue.m_day, 0, 0, daySecondValue.m_isNegative);
        } else {
            int n = daySecondValue.m_day * 1440 + daySecondValue.m_hour * 60 + daySecondValue.m_minute + daySecondValue.m_second / 60;
            dSITimeSpan = new DSITimeSpan(105, 0, 0, n, 0, 0, daySecondValue.m_isNegative);
            if (0 != daySecondValue.m_second % 60 || 0 != daySecondValue.m_fraction) {
                iWarningListener.postWarning(new Warning(WarningCode.FRACTIONAL_TRUNCATION, 1, JDBCMessageKey.WARN_FRACTIONAL_TRUNC.name()));
            }
        }
        IntervalConverter.checkLeadingField(dSITimeSpan.getMinute(), typeMetadata.getIntervalPrecision());
        return dSITimeSpan;
    }

    private static DSITimeSpan stringToIntervalMinuteToSecond(String string, TypeMetadata typeMetadata, IWarningListener iWarningListener) {
        DaySecondValue daySecondValue = IntervalConverter.stringToDaySecondValue(string, typeMetadata, iWarningListener, JDBCMessageKey.INVALID_INTERVAL_MINUTE_SECOND_FORMAT);
        DSITimeSpan dSITimeSpan = null;
        if (1 == daySecondValue.m_numFields) {
            dSITimeSpan = new DSITimeSpan(113, 0, 0, daySecondValue.m_day, 0, 0, daySecondValue.m_isNegative);
        } else if (2 == daySecondValue.m_numFields && 0 == daySecondValue.m_day && 0 == daySecondValue.m_second && 0 == daySecondValue.m_fraction) {
            dSITimeSpan = new DSITimeSpan(113, 0, 0, daySecondValue.m_hour + daySecondValue.m_minute / 60, daySecondValue.m_minute % 60, 0, daySecondValue.m_isNegative);
        } else {
            int n = daySecondValue.m_day * 1440 + daySecondValue.m_hour * 60 + daySecondValue.m_minute + daySecondValue.m_second / 60;
            dSITimeSpan = new DSITimeSpan(113, 0, 0, n, daySecondValue.m_second % 60, daySecondValue.m_fraction, daySecondValue.m_isNegative);
        }
        IntervalConverter.checkLeadingField(dSITimeSpan.getMinute(), typeMetadata.getIntervalPrecision());
        return dSITimeSpan;
    }

    private static DSIMonthSpan stringToIntervalMonth(String string, TypeMetadata typeMetadata, IWarningListener iWarningListener) {
        YearMonthValue yearMonthValue = IntervalConverter.stringToYearMonthValue(string, JDBCMessageKey.INVALID_INTERVAL_MONTH_FORMAT, iWarningListener);
        DSIMonthSpan dSIMonthSpan = null;
        dSIMonthSpan = 1 == yearMonthValue.m_numFields ? new DSIMonthSpan(102, 0, yearMonthValue.m_first, yearMonthValue.m_isNegative) : new DSIMonthSpan(102, 0, yearMonthValue.m_first * 12 + yearMonthValue.m_second, yearMonthValue.m_isNegative);
        IntervalConverter.checkLeadingField(dSIMonthSpan.getMonth(), typeMetadata.getIntervalPrecision());
        return dSIMonthSpan;
    }

    private static DSITimeSpan stringToIntervalSecond(String string, TypeMetadata typeMetadata, IWarningListener iWarningListener) {
        DaySecondValue daySecondValue = IntervalConverter.stringToDaySecondValue(string, typeMetadata, iWarningListener, JDBCMessageKey.INVALID_INTERVAL_SECOND_FORMAT);
        DSITimeSpan dSITimeSpan = null;
        if (1 == daySecondValue.m_numFields) {
            dSITimeSpan = new DSITimeSpan(106, 0, 0, 0, daySecondValue.m_day, 0, daySecondValue.m_isNegative);
        } else if (2 == daySecondValue.m_numFields && 0 == daySecondValue.m_day && 0 == daySecondValue.m_second && 0 == daySecondValue.m_fraction) {
            dSITimeSpan = new DSITimeSpan(106, 0, 0, 0, daySecondValue.m_hour * 60 + daySecondValue.m_minute, 0, daySecondValue.m_isNegative);
        } else {
            int n = daySecondValue.m_day * 86400 + daySecondValue.m_hour * 3600 + daySecondValue.m_minute * 60 + daySecondValue.m_second;
            dSITimeSpan = new DSITimeSpan(106, 0, 0, 0, n, daySecondValue.m_fraction, daySecondValue.m_isNegative);
        }
        IntervalConverter.checkLeadingField(dSITimeSpan.getSecond(), typeMetadata.getIntervalPrecision());
        return dSITimeSpan;
    }

    private static DSIMonthSpan stringToIntervalYear(String string, TypeMetadata typeMetadata, IWarningListener iWarningListener) {
        YearMonthValue yearMonthValue = IntervalConverter.stringToYearMonthValue(string, JDBCMessageKey.INVALID_INTERVAL_YEAR_FORMAT, iWarningListener);
        DSIMonthSpan dSIMonthSpan = null;
        if (1 == yearMonthValue.m_numFields) {
            dSIMonthSpan = new DSIMonthSpan(101, yearMonthValue.m_first, 0, yearMonthValue.m_isNegative);
        } else {
            if (0 != yearMonthValue.m_second % 12) {
                iWarningListener.postWarning(new Warning(WarningCode.FRACTIONAL_TRUNCATION, 1, JDBCMessageKey.WARN_FRACTIONAL_TRUNC.name()));
            }
            dSIMonthSpan = new DSIMonthSpan(101, yearMonthValue.m_first + yearMonthValue.m_second / 12, 0, yearMonthValue.m_isNegative);
        }
        IntervalConverter.checkLeadingField(dSIMonthSpan.getYear(), typeMetadata.getIntervalPrecision());
        return dSIMonthSpan;
    }

    private static DSIMonthSpan stringToIntervalYearMonth(String string, TypeMetadata typeMetadata, IWarningListener iWarningListener) {
        YearMonthValue yearMonthValue = IntervalConverter.stringToYearMonthValue(string, JDBCMessageKey.INVALID_INTERVAL_YEAR_MONTH_FORMAT, iWarningListener);
        IntervalConverter.checkLeadingField(yearMonthValue.m_first, typeMetadata.getIntervalPrecision());
        return new DSIMonthSpan(107, yearMonthValue.m_first, yearMonthValue.m_second, yearMonthValue.m_isNegative);
    }

    private static YearMonthValue stringToYearMonthValue(String string, JDBCMessageKey jDBCMessageKey, IWarningListener iWarningListener) {
        if (0 == string.length()) {
            throw IntervalConverter.createException(jDBCMessageKey, string, iWarningListener);
        }
        YearMonthValue yearMonthValue = new YearMonthValue();
        boolean bl = yearMonthValue.m_isNegative = '-' == string.charAt(0);
        if (yearMonthValue.m_isNegative) {
            string = string.substring(1);
        }
        int n = string.lastIndexOf(45);
        try {
            if (-1 == n) {
                yearMonthValue.m_first = Integer.parseInt(string);
                yearMonthValue.m_numFields = 1;
            } else {
                yearMonthValue.m_first = Integer.parseInt(string.substring(0, n));
                yearMonthValue.m_second = Integer.parseInt(string.substring(n + 1));
                yearMonthValue.m_numFields = (short)2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw IntervalConverter.createException(jDBCMessageKey, string, iWarningListener);
        }
        return yearMonthValue;
    }

    static {
        IDriver iDriver = DSIDriverSingleton.getInstance();
        try {
            Variant variant = iDriver.getProperty(21);
            s_isLeadingFieldPadded = 1L == variant.getLong();
        }
        catch (Exception exception) {
            s_isLeadingFieldPadded = false;
        }
        ZERO_BUFFER = new String[]{"", "0", "00", "000", "0000", "00000", "000000", "0000000", "00000000", "000000000", "0000000000"};
    }

    private static class YearMonthValue {
        public int m_first;
        public int m_second;
        public short m_numFields;
        public boolean m_isNegative;

        private YearMonthValue() {
        }
    }

    private static enum IntervalFieldType {
        DAY,
        HOUR,
        MINUTE,
        SECOND,
        FRACTION;

    }

    private static class DaySecondValue {
        public int m_day;
        public int m_hour;
        public int m_minute;
        public int m_second;
        public int m_fraction;
        public short m_numFields;
        public boolean m_isNegative;

        private DaySecondValue() {
        }
    }
}

