/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.async;

import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.Level;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.Filter;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.LogEvent;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.async.AsyncLoggerConfigDelegate;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.async.AsyncQueueFullMessageUtil;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.async.EventRoute;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.config.AppenderRef;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.config.Configuration;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.config.LoggerConfig;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.config.Property;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.config.plugins.Plugin;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.config.plugins.PluginAttribute;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.config.plugins.PluginElement;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.jmx.RingBufferAdmin;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.util.Booleans;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.spi.AbstractLogger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

@Plugin(name="AsyncLogger", category="Core", printObject=true)
public class AsyncLoggerConfig
extends LoggerConfig {
    private static final ThreadLocal<Boolean> ASYNC_LOGGER_ENTERED = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final AsyncLoggerConfigDelegate delegate;

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newAsyncBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    protected AsyncLoggerConfig(String name, List<AppenderRef> appenders, Filter filter, Level level, boolean additive, Property[] properties, Configuration config, boolean includeLocation) {
        super(name, appenders, filter, level, additive, properties, config, includeLocation);
        this.delegate = config.getAsyncLoggerConfigDelegate();
        this.delegate.setLogEventFactory(this.getLogEventFactory());
    }

    AsyncLoggerConfigDelegate getAsyncLoggerConfigDelegate() {
        return this.delegate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void log(LogEvent event, LoggerConfig.LoggerConfigPredicate predicate) {
        if (predicate == LoggerConfig.LoggerConfigPredicate.ALL && ASYNC_LOGGER_ENTERED.get() == Boolean.FALSE && this.hasAppenders()) {
            ASYNC_LOGGER_ENTERED.set(Boolean.TRUE);
            try {
                if (this.isFiltered(event)) return;
                this.processLogEvent(event, LoggerConfig.LoggerConfigPredicate.SYNCHRONOUS_ONLY);
                this.logToAsyncDelegate(event);
                return;
            }
            finally {
                ASYNC_LOGGER_ENTERED.set(Boolean.FALSE);
            }
        } else {
            super.log(event, predicate);
        }
    }

    @Override
    protected void callAppenders(LogEvent event) {
        super.callAppenders(event);
    }

    private void logToAsyncDelegate(LogEvent event) {
        this.populateLazilyInitializedFields(event);
        if (!this.delegate.tryEnqueue(event, this)) {
            this.handleQueueFull(event);
        }
    }

    private void handleQueueFull(LogEvent event) {
        if (AbstractLogger.getRecursionDepth() > 1) {
            AsyncQueueFullMessageUtil.logWarningToStatusLogger();
            this.logToAsyncLoggerConfigsOnCurrentThread(event);
        } else {
            EventRoute eventRoute = this.delegate.getEventRoute(event.getLevel());
            eventRoute.logMessage(this, event);
        }
    }

    private void populateLazilyInitializedFields(LogEvent event) {
        event.getSource();
        event.getThreadId();
        event.getThreadName();
        event.getThreadPriority();
    }

    void logInBackgroundThread(LogEvent event) {
        this.delegate.enqueueEvent(event, this);
    }

    void logToAsyncLoggerConfigsOnCurrentThread(LogEvent event) {
        this.processLogEvent(event, LoggerConfig.LoggerConfigPredicate.ASYNCHRONOUS_ONLY);
    }

    private String displayName() {
        return "".equals(this.getName()) ? "root" : this.getName();
    }

    @Override
    public void start() {
        LOGGER.trace("AsyncLoggerConfig[{}] starting...", (Object)this.displayName());
        super.start();
    }

    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        super.stop(timeout, timeUnit, false);
        LOGGER.trace("AsyncLoggerConfig[{}] stopping...", (Object)this.displayName());
        this.setStopped();
        return true;
    }

    public RingBufferAdmin createRingBufferAdmin(String contextName) {
        return this.delegate.createRingBufferAdmin(contextName, this.getName());
    }

    @Deprecated
    public static LoggerConfig createLogger(String additivity, String levelName, String loggerName, String includeLocation, AppenderRef[] refs, Property[] properties, Configuration config, Filter filter) {
        Level level;
        if (loggerName == null) {
            LOGGER.error("Loggers cannot be configured without a name");
            return null;
        }
        List<AppenderRef> appenderRefs = Arrays.asList(refs);
        try {
            level = Level.toLevel(levelName, Level.ERROR);
        }
        catch (Exception ex) {
            LOGGER.error("Invalid Log level specified: {}. Defaulting to Error", (Object)levelName);
            level = Level.ERROR;
        }
        String name = loggerName.equals("root") ? "" : loggerName;
        boolean additive = Booleans.parseBoolean(additivity, true);
        return new AsyncLoggerConfig(name, appenderRefs, filter, level, additive, properties, config, AsyncLoggerConfig.shouldIncludeLocation(includeLocation));
    }

    @Deprecated
    @SuppressFBWarnings(value={"HSM_HIDING_METHOD"})
    public static LoggerConfig createLogger(@PluginAttribute(value="additivity", defaultBoolean=true) boolean additivity, @PluginAttribute(value="level") Level level, @Required(message="Loggers cannot be configured without a name") @PluginAttribute(value="name") String loggerName, @PluginAttribute(value="includeLocation") String includeLocation, @PluginElement(value="AppenderRef") AppenderRef[] refs, @PluginElement(value="Properties") Property[] properties, @PluginConfiguration Configuration config, @PluginElement(value="Filter") Filter filter) {
        String name = loggerName.equals("root") ? "" : loggerName;
        return new AsyncLoggerConfig(name, Arrays.asList(refs), filter, level, additivity, properties, config, AsyncLoggerConfig.shouldIncludeLocation(includeLocation));
    }

    @Deprecated
    @SuppressFBWarnings(value={"HSM_HIDING_METHOD"}, justification="Should be private.")
    protected static boolean includeLocation(String includeLocationConfigValue) {
        return AsyncLoggerConfig.shouldIncludeLocation(includeLocationConfigValue);
    }

    private static boolean shouldIncludeLocation(String includeLocationConfigValue) {
        return Boolean.parseBoolean(includeLocationConfigValue);
    }

    public static class Builder<B extends Builder<B>>
    extends LoggerConfig.Builder<B> {
        @Override
        public LoggerConfig build() {
            String name = this.getLoggerName().equals("root") ? "" : this.getLoggerName();
            LoggerConfig.LevelAndRefs container = AsyncLoggerConfig.getLevelAndRefs(this.getLevel(), this.getRefs(), this.getLevelAndRefs(), this.getConfig());
            return new AsyncLoggerConfig(name, container.refs, this.getFilter(), container.level, this.isAdditivity(), this.getProperties(), this.getConfig(), AsyncLoggerConfig.shouldIncludeLocation(this.getIncludeLocation()));
        }
    }

    @Plugin(name="AsyncRoot", category="Core", printObject=true)
    public static class RootLogger
    extends LoggerConfig {
        @PluginBuilderFactory
        public static <B extends Builder<B>> B newAsyncRootBuilder() {
            return (B)((Builder)new Builder().asBuilder());
        }

        @Deprecated
        public static LoggerConfig createLogger(String additivity, String levelName, String includeLocation, AppenderRef[] refs, Property[] properties, Configuration config, Filter filter) {
            List<AppenderRef> appenderRefs = Arrays.asList(refs);
            Level level = null;
            try {
                level = Level.toLevel(levelName, Level.ERROR);
            }
            catch (Exception ex) {
                LOGGER.error("Invalid Log level specified: {}. Defaulting to Error", (Object)levelName);
                level = Level.ERROR;
            }
            boolean additive = Booleans.parseBoolean(additivity, true);
            return new AsyncLoggerConfig("", appenderRefs, filter, level, additive, properties, config, AsyncLoggerConfig.shouldIncludeLocation(includeLocation));
        }

        @Deprecated
        public static LoggerConfig createLogger(@PluginAttribute(value="additivity") String additivity, @PluginAttribute(value="level") Level level, @PluginAttribute(value="includeLocation") String includeLocation, @PluginElement(value="AppenderRef") AppenderRef[] refs, @PluginElement(value="Properties") Property[] properties, @PluginConfiguration Configuration config, @PluginElement(value="Filter") Filter filter) {
            List<AppenderRef> appenderRefs = Arrays.asList(refs);
            Level actualLevel = level == null ? Level.ERROR : level;
            boolean additive = Booleans.parseBoolean(additivity, true);
            return new AsyncLoggerConfig("", appenderRefs, filter, actualLevel, additive, properties, config, AsyncLoggerConfig.shouldIncludeLocation(includeLocation));
        }

        public static class Builder<B extends Builder<B>>
        extends LoggerConfig.RootLogger.Builder<B> {
            @Override
            public LoggerConfig build() {
                LoggerConfig.LevelAndRefs container = RootLogger.getLevelAndRefs(this.getLevel(), this.getRefs(), this.getLevelAndRefs(), this.getConfig());
                return new AsyncLoggerConfig("", container.refs, this.getFilter(), container.level, this.isAdditivity(), this.getProperties(), this.getConfig(), AsyncLoggerConfig.shouldIncludeLocation(this.getIncludeLocation()));
            }
        }
    }
}

