/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.async;

import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.Logger;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.LoggerContext;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.async.AsyncLogger;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.async.AsyncLoggerDisruptor;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.config.Configuration;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.config.DefaultConfiguration;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.jmx.RingBufferAdmin;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.message.MessageFactory;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.status.StatusLogger;
import java.net.URI;
import java.util.concurrent.TimeUnit;

public class AsyncLoggerContext
extends LoggerContext {
    private final AsyncLoggerDisruptor loggerDisruptor;

    public AsyncLoggerContext(String name) {
        super(name);
        this.loggerDisruptor = new AsyncLoggerDisruptor(name, () -> this.getConfiguration().getAsyncWaitStrategyFactory());
    }

    public AsyncLoggerContext(String name, Object externalContext) {
        super(name, externalContext);
        this.loggerDisruptor = new AsyncLoggerDisruptor(name, () -> this.getConfiguration().getAsyncWaitStrategyFactory());
    }

    public AsyncLoggerContext(String name, Object externalContext, URI configLocn) {
        super(name, externalContext, configLocn);
        this.loggerDisruptor = new AsyncLoggerDisruptor(name, () -> this.getConfiguration().getAsyncWaitStrategyFactory());
    }

    public AsyncLoggerContext(String name, Object externalContext, String configLocn) {
        super(name, externalContext, configLocn);
        this.loggerDisruptor = new AsyncLoggerDisruptor(name, () -> this.getConfiguration().getAsyncWaitStrategyFactory());
    }

    @Override
    protected Logger newInstance(LoggerContext ctx, String name, MessageFactory messageFactory) {
        return new AsyncLogger(ctx, name, messageFactory, this.loggerDisruptor);
    }

    @Override
    public void setName(String name) {
        super.setName("AsyncContext[" + name + "]");
        this.loggerDisruptor.setContextName(name);
    }

    @Override
    public void start() {
        this.loggerDisruptor.start();
        super.start();
    }

    @Override
    public void start(Configuration config) {
        this.maybeStartHelper(config);
        super.start(config);
    }

    private void maybeStartHelper(Configuration config) {
        if (config instanceof DefaultConfiguration) {
            StatusLogger.getLogger().debug("[{}] Not starting Disruptor for DefaultConfiguration.", (Object)this.getName());
        } else {
            this.loggerDisruptor.start();
        }
    }

    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        this.loggerDisruptor.stop(timeout, timeUnit);
        super.stop(timeout, timeUnit);
        return true;
    }

    public RingBufferAdmin createRingBufferAdmin() {
        return this.loggerDisruptor.createRingBufferAdmin(this.getName());
    }

    public void setUseThreadLocals(boolean useThreadLocals) {
        this.loggerDisruptor.setUseThreadLocals(useThreadLocals);
    }
}

