/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.jackson;

import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.Level;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.Marker;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.ThreadContext;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.LogEvent;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.impl.ExtendedStackTraceElement;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.impl.ThrowableProxy;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.jackson.ContextDataAsEntryListDeserializer;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.jackson.ContextDataAsEntryListSerializer;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.jackson.ContextDataDeserializer;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.jackson.ContextDataSerializer;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.jackson.ExtendedStackTraceElementMixIn;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.jackson.InstantMixIn;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.jackson.LevelMixIn;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.jackson.Log4jStackTraceElementDeserializer;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.jackson.LogEventMixIn;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.jackson.MarkerMixIn;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.jackson.MessageSerializer;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.jackson.MutableThreadContextStackDeserializer;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.jackson.ObjectMessageSerializer;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.jackson.StackTraceElementMixIn;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.jackson.ThrowableProxyMixIn;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.jackson.ThrowableProxyWithStacktraceAsStringMixIn;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.jackson.ThrowableProxyWithoutStacktraceMixIn;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.time.Instant;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.message.Message;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.message.ObjectMessage;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.util.StringMap;
import com.cloudera.hive.jdbc42.internal.fasterxml.jackson.databind.Module;
import com.cloudera.hive.jdbc42.internal.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.cloudera.hive.jdbc42.internal.fasterxml.jackson.databind.module.SimpleModule;
import com.cloudera.hive.jdbc42.internal.fasterxml.jackson.databind.module.SimpleSerializers;
import java.util.Collections;

class Initializers {
    Initializers() {
    }

    static class SimpleModuleInitializer {
        SimpleModuleInitializer() {
        }

        void initialize(SimpleModule simpleModule, boolean objectMessageAsJsonObject) {
            simpleModule.addDeserializer(StackTraceElement.class, new Log4jStackTraceElementDeserializer());
            simpleModule.addDeserializer(ThreadContext.ContextStack.class, new MutableThreadContextStackDeserializer());
            if (objectMessageAsJsonObject) {
                simpleModule.addSerializer(ObjectMessage.class, new ObjectMessageSerializer());
            }
            simpleModule.addSerializer(Message.class, new MessageSerializer());
        }
    }

    static class SetupContextInitializer
    extends AbstractInitializer {
        SetupContextInitializer() {
        }

        @Override
        void setupModule(Module.SetupContext context, boolean includeStacktrace, boolean stacktraceAsString) {
            super.setupModule(context, includeStacktrace, stacktraceAsString);
            context.addSerializers(new SimpleSerializers(Collections.singletonList(new ContextDataSerializer())));
            context.addDeserializers(new SimpleDeserializers(Collections.singletonMap(StringMap.class, new ContextDataDeserializer())));
        }
    }

    static class SetupContextAsEntryListInitializer
    extends AbstractInitializer {
        SetupContextAsEntryListInitializer() {
        }

        @Override
        void setupModule(Module.SetupContext context, boolean includeStacktrace, boolean stacktraceAsString) {
            super.setupModule(context, includeStacktrace, stacktraceAsString);
            context.addSerializers(new SimpleSerializers(Collections.singletonList(new ContextDataAsEntryListSerializer())));
            context.addDeserializers(new SimpleDeserializers(Collections.singletonMap(StringMap.class, new ContextDataAsEntryListDeserializer())));
        }
    }

    private static abstract class AbstractInitializer {
        private AbstractInitializer() {
        }

        void setupModule(Module.SetupContext context, boolean includeStacktrace, boolean stacktraceAsString) {
            context.setMixInAnnotations(StackTraceElement.class, StackTraceElementMixIn.class);
            context.setMixInAnnotations(Marker.class, MarkerMixIn.class);
            context.setMixInAnnotations(Level.class, LevelMixIn.class);
            context.setMixInAnnotations(Instant.class, InstantMixIn.class);
            context.setMixInAnnotations(LogEvent.class, LogEventMixIn.class);
            context.setMixInAnnotations(ExtendedStackTraceElement.class, ExtendedStackTraceElementMixIn.class);
            context.setMixInAnnotations(ThrowableProxy.class, includeStacktrace ? (stacktraceAsString ? ThrowableProxyWithStacktraceAsStringMixIn.class : ThrowableProxyMixIn.class) : ThrowableProxyWithoutStacktraceMixIn.class);
        }
    }
}

