/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.jmx;

import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.Level;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.LoggerContext;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.config.AppenderRef;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.config.LoggerConfig;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.jmx.LoggerConfigAdminMBean;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.jmx.Server;
import java.util.List;
import java.util.Objects;
import javax.management.ObjectName;

public class LoggerConfigAdmin
implements LoggerConfigAdminMBean {
    private final LoggerContext loggerContext;
    private final LoggerConfig loggerConfig;
    private final ObjectName objectName;

    public LoggerConfigAdmin(LoggerContext loggerContext, LoggerConfig loggerConfig) {
        this.loggerContext = Objects.requireNonNull(loggerContext, "loggerContext");
        this.loggerConfig = Objects.requireNonNull(loggerConfig, "loggerConfig");
        try {
            String ctxName = Server.escape(loggerContext.getName());
            String configName = Server.escape(loggerConfig.getName());
            String name = String.format("com.cloudera.hive.jdbc42.internal.apache.logging.log4j2:type=%s,component=Loggers,name=%s", ctxName, configName);
            this.objectName = new ObjectName(name);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public String getName() {
        return this.loggerConfig.getName();
    }

    @Override
    public String getLevel() {
        return this.loggerConfig.getLevel().name();
    }

    @Override
    public void setLevel(String level) {
        this.loggerConfig.setLevel(Level.getLevel(level));
        this.loggerContext.updateLoggers();
    }

    @Override
    public boolean isAdditive() {
        return this.loggerConfig.isAdditive();
    }

    @Override
    public void setAdditive(boolean additive) {
        this.loggerConfig.setAdditive(additive);
        this.loggerContext.updateLoggers();
    }

    @Override
    public boolean isIncludeLocation() {
        return this.loggerConfig.isIncludeLocation();
    }

    @Override
    public String getFilter() {
        return String.valueOf(this.loggerConfig.getFilter());
    }

    @Override
    public String[] getAppenderRefs() {
        List<AppenderRef> refs = this.loggerConfig.getAppenderRefs();
        String[] result = new String[refs.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = refs.get(i).getRef();
        }
        return result;
    }
}

