/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli;

import com.cloudera.hive.jdbc42.internal.apache.commons.cli.CommandLine;
import com.cloudera.hive.jdbc42.internal.apache.commons.cli.DefaultParser;
import com.cloudera.hive.jdbc42.internal.apache.commons.cli.Options;
import com.cloudera.hive.jdbc42.internal.apache.commons.cli.ParseException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.KeeperException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.Watcher;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.CliCommand;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.CliParseException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.CliWrapperException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.MalformedPathException;

public class RemoveWatchesCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public RemoveWatchesCommand() {
        super("removewatches", "path [-c|-d|-a] [-l]");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        DefaultParser parser = new DefaultParser();
        try {
            this.cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = this.cl.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliWrapperException, MalformedPathException {
        String path = this.args[1];
        Watcher.WatcherType wtype = Watcher.WatcherType.Any;
        if (this.cl.hasOption("c")) {
            wtype = Watcher.WatcherType.Children;
        } else if (this.cl.hasOption("d")) {
            wtype = Watcher.WatcherType.Data;
        } else if (this.cl.hasOption("p")) {
            wtype = Watcher.WatcherType.Persistent;
        } else if (this.cl.hasOption("r")) {
            wtype = Watcher.WatcherType.PersistentRecursive;
        } else if (this.cl.hasOption("a")) {
            wtype = Watcher.WatcherType.Any;
        }
        boolean local = this.cl.hasOption("l");
        try {
            this.zk.removeAllWatches(path, wtype, local);
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (KeeperException | InterruptedException ex) {
            throw new CliWrapperException(ex);
        }
        return true;
    }

    static {
        options.addOption("c", false, "child watcher type");
        options.addOption("d", false, "data watcher type");
        options.addOption("p", false, "persistent watcher type");
        options.addOption("r", false, "persistent recursive watcher type");
        options.addOption("a", false, "any watcher type");
        options.addOption("l", false, "remove locally when there is no server connection");
    }
}

